/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api;

import com.google.common.base.Throwables;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import oracle.pgql.lang.ir.StatementType;
import oracle.pgx.api.Analyst;
import oracle.pgx.api.CompiledProgram;
import oracle.pgx.api.GmCompilerOptimization;
import oracle.pgx.api.GraphBuilder;
import oracle.pgx.api.GraphBuilderImpl;
import oracle.pgx.api.GraphMetaData;
import oracle.pgx.api.GraphSource;
import oracle.pgx.api.NamedArgumentAnalyst;
import oracle.pgx.api.Namespace;
import oracle.pgx.api.Operation;
import oracle.pgx.api.PgqlResultSet;
import oracle.pgx.api.PgxFuture;
import oracle.pgx.api.PgxGraph;
import oracle.pgx.api.PgxManagedObject;
import oracle.pgx.api.PgxMap;
import oracle.pgx.api.PgxPreparedStatement;
import oracle.pgx.api.Property;
import oracle.pgx.api.ScalarSequence;
import oracle.pgx.api.ScalarSet;
import oracle.pgx.api.ServerInstance;
import oracle.pgx.api.SessionContext;
import oracle.pgx.api.beta.annotation.BetaApi;
import oracle.pgx.api.executionenvironment.ExecutionEnvironment;
import oracle.pgx.api.executionenvironment.ExecutionEnvironmentField;
import oracle.pgx.api.frames.PgxFrame;
import oracle.pgx.api.frames.PgxFrameBuilder;
import oracle.pgx.api.frames.PgxGenericFrameReader;
import oracle.pgx.api.frames.PgxGraphFromFramesCreator;
import oracle.pgx.api.frames.internal.PgxFrameImpl;
import oracle.pgx.api.frames.schema.ColumnDescriptor;
import oracle.pgx.api.internal.CompiledProgramMetaData;
import oracle.pgx.api.internal.Core;
import oracle.pgx.api.internal.FrameMetaData;
import oracle.pgx.api.internal.Graph;
import oracle.pgx.api.internal.PgqlResultSetImpl;
import oracle.pgx.api.internal.PgqlResultSetProxy;
import oracle.pgx.api.internal.PgxPreparedStatementImpl;
import oracle.pgx.api.internal.PreparedStatementProxy;
import oracle.pgx.api.subgraph.GenericSubgraphReader;
import oracle.pgx.api.subgraph.internal.KeystoreLookup;
import oracle.pgx.common.ObjectHolder;
import oracle.pgx.common.PgxId;
import oracle.pgx.common.UserContext;
import oracle.pgx.common.types.CollectionType;
import oracle.pgx.common.types.IdType;
import oracle.pgx.common.types.PropertyType;
import oracle.pgx.common.util.AuthCertUtils;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.common.util.FileUtils;
import oracle.pgx.config.Format;
import oracle.pgx.config.GraphBuilderConfig;
import oracle.pgx.config.GraphConfig;
import oracle.pgx.config.GraphConfigFactory;
import oracle.pgx.config.IdGenerationStrategy;
import oracle.pgx.config.ReadGraphOption;
import oracle.pgx.config.SnapshotsSource;
import oracle.pgx.config.StaticConfig;
import oracle.pgx.config.internal.ConfigUtils;
import oracle.pgx.config.internal.PgqlOption;
import oracle.pgx.loaders.location.FileGraphLocation;
import oracle.pgx.loaders.location.GraphLocation;
import oracle.pgx.loaders.location.PgViewGraphLocation;
import oracle.pgx.vfs.VirtualFileManager;
import oracle.pgx.vfs.VirtualFileManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PgxSession
extends PgxManagedObject {
    public static final long LATEST_SNAPSHOT = -1L;
    private static final Logger LOG = LoggerFactory.getLogger(PgxSession.class);
    private final VirtualFileManager vfm;
    private final ServerInstance instance;
    private final Core core;
    private final SessionContext context;
    private final String source;
    private Long idleTimeoutSecs;
    private Long taskTimeoutSecs;
    private String keystorePath;
    private char[] keystorePassword;

    PgxSession(ServerInstance instance, Core core, SessionContext sessionContext, String source, Long idleTimeout, Long taskTimeout, TimeUnit unit) {
        this.instance = instance;
        this.source = source;
        this.core = core;
        this.context = sessionContext;
        if (idleTimeout != null || taskTimeout != null) {
            assert (unit != null);
            if (idleTimeout != null) {
                this.idleTimeoutSecs = unit.toSeconds(idleTimeout);
            }
            if (taskTimeout != null) {
                this.taskTimeoutSecs = unit.toSeconds(taskTimeout);
            }
        }
        StaticConfig.get().isEnablePluginVersionChecks();
        this.vfm = VirtualFileManagerFactory.getInstance();
    }

    Core getCore() {
        return this.core;
    }

    String getKeystorePath() {
        return this.keystorePath;
    }

    char[] getKeystorePassword() {
        return this.keystorePassword;
    }

    public String getId() {
        return this.context.getSessionId();
    }

    public SessionContext getSessionContext() {
        return this.context;
    }

    public String getSource() {
        return this.source;
    }

    @Override
    public String getName() {
        return this.getId();
    }

    public Long getIdleTimeout() {
        return this.idleTimeoutSecs;
    }

    public Long getTaskTimeout() {
        return this.taskTimeoutSecs;
    }

    public ServerInstance getServerInstance() {
        return this.instance;
    }

    public void registerKeystore(String keystorePath, char[] keystorePassword) {
        boolean isValid = false;
        try {
            isValid = AuthCertUtils.testJksKeystorePassword((String)keystorePath, (char[])keystorePassword);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"INVALID_KEYSTORE_OR_PWD", (Object[])new Object[0]), e);
        }
        if (!isValid) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"INVALID_KEYSTORE_OR_PWD", (Object[])new Object[0]));
        }
        this.keystorePath = keystorePath;
        this.keystorePassword = keystorePassword;
    }

    public Analyst createAnalyst() {
        return new NamedArgumentAnalyst(this);
    }

    public ExecutionEnvironment getExecutionEnvironment() {
        return new ExecutionEnvironment(this, this.core);
    }

    public PgxFrameBuilder createFrameBuilder(List<ColumnDescriptor> schema) throws ExecutionException, InterruptedException {
        return new PgxFrameBuilder(this.context, this.core, schema, fmd -> new PgxFrameImpl(this, this.core, (FrameMetaData)((Object)fmd), this::getKeystorePath, this::getKeystorePassword));
    }

    public PgxFrame createFrame(List<ColumnDescriptor> schema, Map<String, Iterable<?>> columnData, String frameName) throws ExecutionException, InterruptedException {
        return this.createFrameAsync(schema, columnData, frameName).get();
    }

    public PgxFuture<PgxFrame> createFrameAsync(List<ColumnDescriptor> schema, Map<String, Iterable<?>> columnData, String frameName) throws ExecutionException, InterruptedException {
        PgxFrameBuilder builder = this.createFrameBuilder(schema);
        return builder.addRowsAsync(columnData).thenCompose(b -> b.buildAsync(frameName));
    }

    public PgxGenericFrameReader readFrame() {
        return new PgxGenericFrameReader(this, this.core, this::getKeystorePath, this::getKeystorePassword);
    }

    public PgxGraphFromFramesCreator createGraphFromFrames(String graphName) {
        return new PgxGraphFromFramesCreator(this.context, this.core, graphName, gr -> new PgxGraph(this, (Graph)((Object)gr)));
    }

    public PgxFuture<PgxGraph> createGraphFromFramesAsync(String graphName, PgxFrame vertexFrame, PgxFrame edgeFrame) {
        return this.createGraphFromFrames(graphName).vertexProvider("V", vertexFrame).edgeProvider("E", "V", "V", edgeFrame).partitioned(false).createAsync();
    }

    public PgxGraph createGraphFromFrames(String graphName, PgxFrame vertexFrame, PgxFrame edgeFrame) throws InterruptedException, ExecutionException {
        return this.createGraphFromFramesAsync(graphName, vertexFrame, edgeFrame).get();
    }

    public GraphBuilder<Integer> createGraphBuilder(IdGenerationStrategy vertexIdGenerationStrategy, IdGenerationStrategy edgeIdGenerationStrategy) {
        return this.createGraphBuilder(IdType.INTEGER, vertexIdGenerationStrategy, edgeIdGenerationStrategy);
    }

    public <ID extends Comparable<ID>> GraphBuilder<ID> createGraphBuilder(IdType idType, IdGenerationStrategy vertexIdGenerationStrategy, IdGenerationStrategy edgeIdGenerationStrategy) {
        GraphBuilderImpl graphBuilder = new GraphBuilderImpl(this, idType);
        graphBuilder.setConfigParameter(GraphBuilderConfig.Field.VERTEX_ID_GENERATION_STRATEGY, vertexIdGenerationStrategy);
        graphBuilder.setConfigParameter(GraphBuilderConfig.Field.EDGE_ID_GENERATION_STRATEGY, edgeIdGenerationStrategy);
        return graphBuilder;
    }

    public GraphBuilder<Integer> createGraphBuilder() {
        return this.createGraphBuilder(IdType.INTEGER);
    }

    public <ID extends Comparable<ID>> GraphBuilder<ID> createGraphBuilder(IdType idType) {
        GraphBuilderImpl graphBuilder = new GraphBuilderImpl(this, idType);
        graphBuilder.setConfigParameter(GraphBuilderConfig.Field.EDGE_ID_GENERATION_STRATEGY, IdGenerationStrategy.AUTO_GENERATED);
        return graphBuilder;
    }

    @Override
    public PgxFuture<Void> destroyAsync() {
        return this.core.destroySession(this.context);
    }

    public PgxFuture<GraphConfig> describeGraphFileAsync(String path) {
        return this.describeGraphFilesAsync(Collections.singletonList(path));
    }

    public PgxFuture<GraphConfig> describeGraphFileAsync(String path, @Nullable Format format) {
        return this.describeGraphFilesAsync(Collections.singletonList(path), format);
    }

    public PgxFuture<GraphConfig> describeGraphFilesAsync(List<String> filePaths) {
        return this.describeGraphFilesAsync(filePaths, (Format)null);
    }

    public PgxFuture<GraphConfig> describeGraphFilesAsync(List<String> filePaths, @Nullable Format format) {
        if (format != null && (!format.isFileFormat() || format.hasVerticesAndEdgesSeparatedFileFormat())) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"EXPECTED_COMBINED_VERTICES_AND_EDGES_FORMAT_SHORT", (Object[])new Object[]{format}));
        }
        return this.describeGraphAsync((GraphLocation)new FileGraphLocation(filePaths, format));
    }

    public PgxFuture<GraphConfig> describeGraphFilesAsync(String vertexFilePath, String edgeFilePath) {
        return this.describeGraphFilesAsync(vertexFilePath, edgeFilePath, null);
    }

    public PgxFuture<GraphConfig> describeGraphFilesAsync(String vertexFilePath, String edgeFilePath, @Nullable Format format) {
        return this.describeGraphFilesAsync(Collections.singletonList(vertexFilePath), Collections.singletonList(edgeFilePath), format);
    }

    public PgxFuture<GraphConfig> describeGraphFilesAsync(List<String> vertexFilePaths, List<String> edgeFilePaths) {
        return this.describeGraphFilesAsync(vertexFilePaths, edgeFilePaths, null);
    }

    public PgxFuture<GraphConfig> describeGraphFilesAsync(List<String> vertexFilePaths, List<String> edgeFilePaths, @Nullable Format format) {
        if (format != null && !format.hasVerticesAndEdgesSeparatedFileFormat()) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"EXPECTED_SEPARATED_VERTICES_AND_EDGES_FORMAT_SHORT", (Object[])new Object[]{format}));
        }
        return this.describeGraphAsync((GraphLocation)new FileGraphLocation(vertexFilePaths, edgeFilePaths, format));
    }

    public PgxFuture<GraphConfig> describeGraphAsync(GraphLocation location) {
        return this.core.describeGraph(this.context, location);
    }

    public PgxFuture<PgxGraph> readGraphFileAsync(String path) {
        return this.readGraphFilesAsync(Collections.singletonList(path));
    }

    public PgxFuture<PgxGraph> readGraphFileAsync(String path, @Nullable Format format) {
        return this.readGraphFilesAsync(Collections.singletonList(path), format);
    }

    public PgxFuture<PgxGraph> readGraphFileAsync(String path, @Nullable String newGraphName) {
        return this.readGraphFilesAsync(Collections.singletonList(path), newGraphName);
    }

    public PgxFuture<PgxGraph> readGraphFileAsync(String path, @Nullable Format format, @Nullable String newGraphName) {
        return this.readGraphFilesAsync(Collections.singletonList(path), format, newGraphName);
    }

    public PgxFuture<PgxGraph> readGraphFilesAsync(List<String> filePaths) {
        return this.readGraphFilesAsync(filePaths, (Format)null);
    }

    public PgxFuture<PgxGraph> readGraphFilesAsync(List<String> filePaths, @Nullable Format format) {
        return this.readGraphFilesAsync(filePaths, format, null);
    }

    public PgxFuture<PgxGraph> readGraphFilesAsync(List<String> filePaths, @Nullable String newGraphName) {
        return this.readGraphFilesAsync(filePaths, (Format)null, newGraphName);
    }

    public PgxFuture<PgxGraph> readGraphFilesAsync(List<String> filePaths, @Nullable Format format, @Nullable String newGraphName) {
        if (format != null && !format.isFileFormat()) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"EXPECTED_COMBINED_VERTICES_AND_EDGES_FORMAT_SHORT", (Object[])new Object[]{format}));
        }
        return this.readGraphLocationAsync((GraphLocation)new FileGraphLocation(filePaths, format), newGraphName);
    }

    public PgxFuture<PgxGraph> readGraphFilesAsync(String vertexFilePath, String edgeFilePath) {
        return this.readGraphFilesAsync(vertexFilePath, edgeFilePath, (Format)null);
    }

    public PgxFuture<PgxGraph> readGraphFilesAsync(String vertexFilePath, String edgeFilePath, @Nullable Format format) {
        return this.readGraphFilesAsync(vertexFilePath, edgeFilePath, format, null);
    }

    public PgxFuture<PgxGraph> readGraphFilesAsync(String vertexFilePath, String edgeFilePath, @Nullable String newGraphName) {
        return this.readGraphFilesAsync(vertexFilePath, edgeFilePath, null, newGraphName);
    }

    public PgxFuture<PgxGraph> readGraphFilesAsync(String vertexFilePath, String edgeFilePath, @Nullable Format format, @Nullable String newGraphName) {
        return this.readGraphFilesAsync(Collections.singletonList(vertexFilePath), Collections.singletonList(edgeFilePath), format, newGraphName);
    }

    public PgxFuture<PgxGraph> readGraphFilesAsync(List<String> vertexFilePaths, List<String> edgeFilePaths) {
        return this.readGraphFilesAsync(vertexFilePaths, edgeFilePaths, (Format)null);
    }

    public PgxFuture<PgxGraph> readGraphFilesAsync(List<String> vertexFilePaths, List<String> edgeFilePaths, @Nullable Format format) {
        return this.readGraphFilesAsync(vertexFilePaths, edgeFilePaths, format, null);
    }

    public PgxFuture<PgxGraph> readGraphFilesAsync(List<String> vertexFilePaths, List<String> edgeFilePaths, @Nullable String newGraphName) {
        return this.readGraphFilesAsync(vertexFilePaths, edgeFilePaths, null, newGraphName);
    }

    public PgxFuture<PgxGraph> readGraphFilesAsync(List<String> vertexFilePaths, List<String> edgeFilePaths, @Nullable Format format, @Nullable String newGraphName) {
        if (format != null && !format.hasVerticesAndEdgesSeparatedFileFormat()) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"EXPECTED_SEPARATED_VERTICES_AND_EDGES_FORMAT_SHORT", (Object[])new Object[]{format}));
        }
        return this.readGraphLocationAsync((GraphLocation)new FileGraphLocation(vertexFilePaths, edgeFilePaths, format), newGraphName);
    }

    private PgxFuture<PgxGraph> readGraphLocationAsync(GraphLocation location, @Nullable String newGraphName) {
        return this.describeGraphAsync(location).thenCompose(config -> this.readGraphWithPropertiesAsync((GraphConfig)config, newGraphName));
    }

    public PgxFuture<PgxGraph> readGraphWithPropertiesAsync(String path) {
        return this.readGraphWithPropertiesAsync(path, null);
    }

    @BetaApi
    public GenericSubgraphReader readSubgraph() {
        return new GenericSubgraphReader(this, KeystoreLookup.forKeystoreProvider(this::getKeystorePath, this::getKeystorePassword), config -> this.readGraph(0L, TimeUnit.DAYS, false, null, (GraphConfig)config));
    }

    public PgxFuture<PgxGraph> readGraphWithPropertiesAsync(String path, String newGraphName) {
        GraphConfig config;
        try {
            config = (GraphConfig)GraphConfigFactory.forAnyFormat().fromPath(path);
        }
        catch (Throwable th) {
            return PgxFuture.exceptionallyCompletedFuture(th);
        }
        return this.readGraphWithPropertiesAsync(config, newGraphName);
    }

    public PgxFuture<PgxGraph> readGraphWithPropertiesAsync(GraphConfig config) {
        return this.readGraphWithPropertiesAsync(config, null);
    }

    public PgxFuture<PgxGraph> readGraphWithPropertiesAsync(GraphConfig config, @Nullable String newGraphName) {
        return this.readGraphWithPropertiesAsync(config, true, newGraphName);
    }

    public PgxFuture<PgxGraph> readGraphWithPropertiesAsync(GraphConfig config, boolean updateIfNotFresh) {
        return this.readGraphWithPropertiesAsync(config, updateIfNotFresh, null);
    }

    public PgxFuture<PgxGraph> readGraphWithPropertiesAsync(GraphConfig config, boolean updateIfNotFresh, String newGraphName) {
        long maxAge = updateIfNotFresh ? 0L : Long.MAX_VALUE;
        return this.readGraphWithPropertiesAsync(config, maxAge, TimeUnit.DAYS, false, newGraphName);
    }

    public PgxFuture<PgxGraph> readGraphWithPropertiesAsync(GraphConfig config, long maxAge, TimeUnit maxAgeTimeUnit) {
        return this.readGraphWithPropertiesAsync(config, maxAge, maxAgeTimeUnit, false, null);
    }

    public PgxFuture<PgxGraph> readGraphWithPropertiesAsync(GraphConfig config, long maxAge, TimeUnit maxAgeTimeUnit, boolean blockIfFull, String newGraphName) {
        try {
            config = ConfigUtils.createGraphConfigWithCredentials((GraphConfig)config, (String)this.keystorePath, (char[])this.keystorePassword);
        }
        catch (Exception e) {
            return PgxFuture.exceptionallyCompletedFuture(e);
        }
        GraphConfig loadingConfig = config;
        return this.readGraph(maxAge, maxAgeTimeUnit, blockIfFull, newGraphName, loadingConfig);
    }

    private PgxFuture<PgxGraph> readGraph(long maxAge, TimeUnit maxAgeTimeUnit, boolean blockIfFull, String newGraphName, GraphConfig loadingConfig) {
        PgxFuture promise = new PgxFuture();
        return ((PgxFuture)((PgxFuture)this.core.loadGraphWithProperties(this.context, loadingConfig, newGraphName).cancelOn(promise).thenCompose(gr -> {
            if (Objects.equals(SnapshotsSource.CHANGE_SET, loadingConfig.getLoadingOptions().getSnapshotsSource())) {
                LOG.debug("==> change sets as snapshot source. Returning graph loaded by the engine");
                return PgxFuture.completedFuture(gr).cancelOn(promise);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("engine reports latest snapshot is {} milli-seconds old. Max age is {} milli-seconds", (Object)TimeUnit.MILLISECONDS.convert(gr.getAgeMs(), TimeUnit.MILLISECONDS), (Object)TimeUnit.MILLISECONDS.convert(maxAge, maxAgeTimeUnit));
            }
            if (gr.getAgeMs() <= TimeUnit.MILLISECONDS.convert(maxAge, maxAgeTimeUnit)) {
                LOG.debug("==> within range. Return snapshot");
                return PgxFuture.completedFuture(gr).cancelOn(promise);
            }
            LOG.debug("==> try to check out newer snapshot");
            return this.core.refresh(this.context, gr.getGraphId(), blockIfFull).cancelOn(promise);
        })).thenApply(gr -> new PgxGraph(this, (Graph)((Object)gr)))).thenComplete(promise);
    }

    public PgxFuture<PgxGraph> readGraphByNameAsync(String name, GraphSource source) {
        return this.readGraphByNameAsync(name, source, null);
    }

    public PgxFuture<PgxGraph> readGraphByNameAsync(String name, GraphSource source, ReadGraphOption ... options) {
        List<ReadGraphOption> optionsList;
        List<ReadGraphOption> list = optionsList = options == null ? null : Arrays.asList(options);
        if (source == GraphSource.PG_VIEW) {
            PgViewGraphLocation graphLocation = PgViewGraphLocation.fromQualifiedName((String)name, optionsList);
            return this.readGraphLocationAsync((GraphLocation)graphLocation, null);
        }
        throw new IllegalArgumentException(ErrorMessages.getMessage((String)"UNSUPPORTED_GRAPH_SOURCE_TYPE", (Object[])new Object[]{source}));
    }

    public PgxFuture<PgxGraph> readGraphAsOfAsync(GraphConfig config, GraphMetaData metaData) {
        return this.readGraphAsOfAsync(config, metaData, null);
    }

    public PgxFuture<PgxGraph> readGraphAsOfAsync(GraphConfig config, GraphMetaData metaData, String newGraphName) {
        return this.readGraphAsOfAsync(config, metaData.getCreationTimestamp(), newGraphName);
    }

    public PgxFuture<PgxGraph> readGraphAsOfAsync(GraphConfig config, long creationTimestamp) {
        return this.readGraphAsOfAsync(config, creationTimestamp, null);
    }

    public PgxFuture<PgxGraph> readGraphAsOfAsync(GraphConfig config, long creationTimestamp, String newGraphName) {
        return ((PgxFuture)this.core.loadGraphWithProperties(this.context, config, newGraphName).thenCompose(graph -> {
            if (graph.getMetaData().getCreationTimestamp() == creationTimestamp) {
                return PgxFuture.completedFuture(graph);
            }
            return this.core.checkout(this.context, graph.getGraphId(), creationTimestamp);
        })).thenApply(graph -> new PgxGraph(this, (Graph)((Object)graph)));
    }

    public PgxFuture<PgxGraph> getGraphAsync(String name) {
        return this.getGraphAsync(null, name);
    }

    public PgxFuture<PgxGraph> getGraphAsync(Namespace namespace, String name) {
        return this.core.getGraphResultByName(this.context, namespace, name).thenApply(graph -> {
            if (graph == null) {
                return null;
            }
            return new PgxGraph(this, (Graph)((Object)graph));
        });
    }

    private PgxFuture<PgxGraph> getGraphAsync(PgxId id) {
        return this.core.getGraphResult(this.context, id).thenApply(graph -> new PgxGraph(this, (Graph)((Object)graph)));
    }

    @Deprecated
    public PgxFuture<Map<String, PgxGraph>> getGraphsAsync() {
        BinaryOperator merger = (a, b) -> {
            if (a.getMetaData().getCreationTimestamp() > b.getMetaData().getCreationTimestamp()) {
                return a;
            }
            return b;
        };
        return this.core.getGraphs(this.context).thenApply(c -> c.stream().collect(Collectors.toMap(Graph::getGraphName, Function.identity(), merger)).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new PgxGraph(this, (Graph)((Object)((Object)((Object)e.getValue())))))));
    }

    public PgxFuture<List<String>> getGraphsAsync(Namespace namespace) {
        return this.core.getGraphs(this.context, namespace).thenApply(ArrayList::new);
    }

    public PgxFuture<CompiledProgram> compileProgramAsync(String path) {
        return this.compileProgramAsync(path, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PgxFuture<CompiledProgram> compileProgramAsync(String path, boolean overwrite) {
        try (InputStream is = this.vfm.getInputStream(path, UserContext.UNAUTHENTICATED_USER_CONTEXT);){
            PgxFuture<CompiledProgram> pgxFuture = this.compileProgramAsync(is, overwrite);
            return pgxFuture;
        }
        catch (Throwable th) {
            return PgxFuture.exceptionallyCompletedFuture(th);
        }
    }

    public PgxFuture<CompiledProgram> compileProgramAsync(InputStream code) {
        return this.compileProgramAsync(code, false);
    }

    public PgxFuture<CompiledProgram> compileProgramAsync(InputStream code, boolean overwrite) {
        String str;
        try {
            str = FileUtils.toString((InputStream)code);
        }
        catch (Throwable th) {
            return PgxFuture.exceptionallyCompletedFuture(th);
        }
        return this.compileProgramCodeAsync(str, overwrite);
    }

    public PgxFuture<CompiledProgram> compileProgramCodeAsync(String code) {
        return this.compileProgramCodeAsync(code, false);
    }

    public PgxFuture<CompiledProgram> compileProgramCodeAsync(String code, boolean overwrite) {
        return this.compileProgramCodeAsync(code, overwrite, true, Collections.emptyList(), false);
    }

    public PgxFuture<CompiledProgram> compileProgramCodeAsync(String code, boolean overwrite, boolean parallel, List<GmCompilerOptimization> disabledOptimizations, boolean verbose) {
        return this.core.createAnalysis(this.context, code, parallel, disabledOptimizations, verbose, overwrite).thenApply(cr -> {
            if (cr.isSuccess()) {
                return new CompiledProgram(this, cr.getMetaData(), cr.getErrorMessage());
            }
            throw new IllegalArgumentException("Compilation of " + cr.getMetaData().getId() + " failed: " + cr.getErrorMessage());
        });
    }

    public PgxFuture<PgqlResultSet> getPgqlResultSetAsync(String id) {
        ObjectHolder proxyObjectHolder = new ObjectHolder();
        return ((PgxFuture)((PgxFuture)this.core.getPgqlResultSet(this.context, id).thenCompose(proxy -> {
            if (proxy == null) {
                return PgxFuture.completedFuture(null);
            }
            proxyObjectHolder.set(proxy);
            return this.core.getGraphResult(this.context, proxy.getGraphId());
        })).thenApply(gr -> {
            if (gr == null) {
                return null;
            }
            return new PgxGraph(this, (Graph)((Object)gr));
        })).thenApply(graph -> {
            if (graph == null) {
                return null;
            }
            return new PgqlResultSetImpl(this.core, (PgxGraph)graph, this::getKeystorePath, this::getKeystorePassword, (PgqlResultSetProxy)proxyObjectHolder.get());
        });
    }

    public PgxFuture<Set<String>> getAvailableCompiledProgramIdsAsync() {
        return this.core.getAvailableAnalysisIds(this.context);
    }

    public PgxFuture<CompiledProgram> getCompiledProgramAsync(String id) {
        return this.core.getAnalysisMetaData(this.context, id).thenApply(metaData -> new CompiledProgram(this, (CompiledProgramMetaData)((Object)metaData), null));
    }

    public PgxFuture<Deque<GraphMetaData>> getAvailableSnapshotsAsync(PgxGraph graph) {
        return this.core.getAvailableSnapshots(this.context, graph.getId());
    }

    public PgxFuture<Void> setSnapshotAsync(PgxGraph graph, long creationTimestamp) {
        return this.setSnapshotAsync(graph, creationTimestamp, false);
    }

    public PgxFuture<Void> setSnapshotAsync(PgxGraph graph, GraphMetaData metaData) {
        return this.setSnapshotAsync(graph, metaData.getCreationTimestamp());
    }

    public PgxFuture<Void> setSnapshotAsync(PgxGraph graph, GraphMetaData metaData, boolean forceDeleteTransientProperties) {
        return this.setSnapshotAsync(graph, metaData.getCreationTimestamp(), forceDeleteTransientProperties);
    }

    public PgxFuture<Void> setSnapshotAsync(PgxGraph graph, long creationTimestamp, boolean forceDeleteTransientProperties) {
        CompletableFuture promise = forceDeleteTransientProperties || graph.isTransient() ? PgxFuture.completedFuture(null) : ((PgxFuture)graph.getVertexPropertiesAsync().thenCompose(vp -> {
            PgxSession.failCheckoutIfAnyTransientProperties(graph, vp);
            return graph.getEdgePropertiesAsync();
        })).thenAccept(ep -> PgxSession.failCheckoutIfAnyTransientProperties(graph, ep));
        return ((PgxFuture)promise.thenCompose(arg -> this.core.checkout(this.context, graph.getId(), creationTimestamp))).thenApply(gr -> {
            assert (graph.getName().equals(gr.getGraphName()));
            graph.setId(gr.getGraphId());
            graph.setMetaData(gr.getMetaData());
            graph.setTransient(gr.isTransient());
            return null;
        });
    }

    private static void failCheckoutIfAnyTransientProperties(PgxGraph g, Collection<? extends Property<?, ?, ?>> props) {
        for (Property<?, ?, ?> p : props) {
            if (!p.isTransient() || p.isPublished()) continue;
            throw new UnsupportedOperationException(ErrorMessages.getMessage((String)"CANNOT_CHECKOUT_GRAPH_WITH_TRANSIENT_PROPERTIES", (Object[])new Object[]{g.getName(), p.getName()}));
        }
    }

    public PgxFuture<PgqlResultSet> queryPgqlAsync(String pgqlString) {
        return this.queryPgqlAsync(pgqlString, Collections.emptyList());
    }

    private PgxFuture<PgqlResultSet> queryPgqlAsync(String pgqlString, List<PgqlOption> pgqlOptions) {
        pgqlOptions = PgqlOption.getClientPgqlOptionsWithDefaults(pgqlOptions);
        PgxFuture promise = new PgxFuture();
        return ((PgxFuture)this.core.queryPgql(this.context, pgqlString, pgqlOptions).cancelOn(promise).thenCompose(resultSet -> this.getGraphAsync(resultSet.getGraphId()).thenApply(graph -> new PgqlResultSetImpl(this.core, (PgxGraph)graph, this::getKeystorePath, this::getKeystorePassword, (PgqlResultSetProxy)resultSet)))).thenComplete(promise);
    }

    public PgxFuture<PgxPreparedStatement> preparePgqlAsync(String pgqlString) {
        PgxFuture promise = new PgxFuture();
        return ((PgxFuture)this.core.preparePgql(this.context, pgqlString).cancelOn(promise).thenCompose(preparedStatement -> this.getPreparedStatement((PreparedStatementProxy)preparedStatement))).thenComplete(promise);
    }

    private PgxFuture<PgxPreparedStatement> getPreparedStatement(PreparedStatementProxy proxy) {
        if (proxy.getStatementType() != StatementType.SELECT && proxy.getStatementType() != StatementType.GRAPH_MODIFY) {
            return PgxFuture.completedFuture(new PgxPreparedStatementImpl(this.core, null, proxy, this, this::getKeystorePath, this::getKeystorePassword));
        }
        return this.getGraphAsync(proxy.getGraphId()).thenApply(graph -> new PgxPreparedStatementImpl(this.core, (PgxGraph)graph, proxy, this, this::getKeystorePath, this::getKeystorePassword));
    }

    public PgxFuture<PgqlResultSet> executePgqlAsync(String pgqlString) {
        return this.executePgqlAsync(pgqlString, Collections.emptyList());
    }

    private PgxFuture<PgqlResultSet> executePgqlAsync(String pgqlString, List<PgqlOption> pgqlOptions) {
        pgqlOptions = PgqlOption.getClientPgqlOptionsWithDefaults(pgqlOptions);
        return this.core.executePgql(this.context, null, pgqlString, pgqlOptions).thenCompose(resultSet -> {
            if (resultSet == null) {
                return PgxFuture.completedFuture(null);
            }
            if (resultSet.getCreatePropertyGraphConfig() != null) {
                return this.readGraphWithPropertiesAsync(resultSet.getCreatePropertyGraphConfig()).thenApply(graph -> null);
            }
            return this.getGraphAsync(resultSet.getGraphId()).thenApply(graph -> new PgqlResultSetImpl(this.core, (PgxGraph)graph, this::getKeystorePath, this::getKeystorePassword, (PgqlResultSetProxy)resultSet));
        });
    }

    public PgxFuture<Operation> explainPgqlAsync(String pgqlString) {
        PgxFuture promise = new PgxFuture();
        return this.core.explainPgql(this.context, pgqlString).cancelOn(promise).thenComplete(promise);
    }

    public <T> PgxFuture<ScalarSet<T>> createSetAsync(PropertyType contentType, String name) {
        return this.core.createCollection(this.context, CollectionType.SET, contentType, name).thenApply(collectionInfo -> new ScalarSet(this, collectionInfo.getCollectionId(), collectionInfo.getName(), contentType));
    }

    public <T> PgxFuture<ScalarSequence<T>> createSequenceAsync(PropertyType contentType, String name) {
        return this.core.createCollection(this.context, CollectionType.SEQUENCE, contentType, name).thenApply(collectionInfo -> new ScalarSequence(this, collectionInfo.getCollectionId(), collectionInfo.getName(), contentType));
    }

    public <T> PgxFuture<ScalarSet<T>> createSetAsync(PropertyType contentType) {
        return this.createSetAsync(contentType, null);
    }

    public <T> PgxFuture<ScalarSequence<T>> createSequenceAsync(PropertyType contentType) {
        return this.createSequenceAsync(contentType, null);
    }

    public <K, V> PgxFuture<PgxMap<K, V>> createMapAsync(PropertyType keyType, PropertyType valueType, String name) {
        return this.core.createMap(this.context, keyType, valueType, name).thenApply(mapInfo -> new PgxMap(this, keyType, valueType, mapInfo.getId()));
    }

    public <K, V> PgxFuture<PgxMap<K, V>> createMapAsync(PropertyType keyType, PropertyType valueType) {
        return this.createMapAsync(keyType, valueType, null);
    }

    public String toString() {
        return this.toString(PgxSession.entry("ID", this.getId()), PgxSession.entry("source", this.getSource()));
    }

    public GraphConfig describeGraphFile(String path) throws ExecutionException, InterruptedException {
        return this.describeGraphFileAsync(path).get();
    }

    public GraphConfig describeGraphFile(String path, @Nullable Format format) throws ExecutionException, InterruptedException {
        return this.describeGraphFileAsync(path, format).get();
    }

    public GraphConfig describeGraphFiles(List<String> filePaths) throws ExecutionException, InterruptedException {
        return this.describeGraphFilesAsync(filePaths).get();
    }

    public GraphConfig describeGraphFiles(List<String> filePaths, @Nullable Format format) throws ExecutionException, InterruptedException {
        return this.describeGraphFilesAsync(filePaths, format).get();
    }

    public GraphConfig describeGraphFiles(String vertexFilePath, String edgeFilePath) throws ExecutionException, InterruptedException {
        return this.describeGraphFilesAsync(vertexFilePath, edgeFilePath).get();
    }

    public GraphConfig describeGraphFiles(String vertexFilePath, String edgeFilePath, @Nullable Format format) throws ExecutionException, InterruptedException {
        return this.describeGraphFilesAsync(vertexFilePath, edgeFilePath, format).get();
    }

    public GraphConfig describeGraphFiles(List<String> vertexFilePaths, List<String> edgeFilePaths) throws ExecutionException, InterruptedException {
        return this.describeGraphFilesAsync(vertexFilePaths, edgeFilePaths).get();
    }

    public GraphConfig describeGraphFiles(List<String> vertexFilePaths, List<String> edgeFilePaths, @Nullable Format format) throws ExecutionException, InterruptedException {
        return this.describeGraphFilesAsync(vertexFilePaths, edgeFilePaths, format).get();
    }

    public PgxGraph readGraphFile(String path) throws ExecutionException, InterruptedException {
        return this.readGraphFileAsync(path).get();
    }

    public PgxGraph readGraphFile(String path, @Nullable Format format) throws ExecutionException, InterruptedException {
        return this.readGraphFileAsync(path, format).get();
    }

    public PgxGraph readGraphFile(String path, @Nullable String newGraphName) throws ExecutionException, InterruptedException {
        return this.readGraphFileAsync(path, newGraphName).get();
    }

    public PgxGraph readGraphFile(String path, @Nullable Format format, @Nullable String newGraphName) throws ExecutionException, InterruptedException {
        return this.readGraphFileAsync(path, format, newGraphName).get();
    }

    public PgxGraph readGraphFiles(List<String> filePaths) throws ExecutionException, InterruptedException {
        return this.readGraphFilesAsync(filePaths).get();
    }

    public PgxGraph readGraphFiles(List<String> filePaths, @Nullable Format format) throws ExecutionException, InterruptedException {
        return this.readGraphFilesAsync(filePaths, format).get();
    }

    public PgxGraph readGraphFiles(List<String> filePaths, @Nullable String newGraphName) throws ExecutionException, InterruptedException {
        return this.readGraphFilesAsync(filePaths, newGraphName).get();
    }

    public PgxGraph readGraphFiles(List<String> filePaths, @Nullable Format format, @Nullable String newGraphName) throws ExecutionException, InterruptedException {
        return this.readGraphFilesAsync(filePaths, format, newGraphName).get();
    }

    public PgxGraph readGraphFiles(String vertexFilePath, String edgeFilePath) throws ExecutionException, InterruptedException {
        return this.readGraphFilesAsync(vertexFilePath, edgeFilePath).get();
    }

    public PgxGraph readGraphFiles(String vertexFilePath, String edgeFilePath, @Nullable Format format) throws ExecutionException, InterruptedException {
        return this.readGraphFilesAsync(vertexFilePath, edgeFilePath, format).get();
    }

    public PgxGraph readGraphFiles(String vertexFilePath, String edgeFilePath, @Nullable String newGraphName) throws ExecutionException, InterruptedException {
        return this.readGraphFilesAsync(vertexFilePath, edgeFilePath, newGraphName).get();
    }

    public PgxGraph readGraphFiles(String vertexFilePath, String edgeFilePath, @Nullable Format format, @Nullable String newGraphName) throws ExecutionException, InterruptedException {
        return this.readGraphFilesAsync(vertexFilePath, edgeFilePath, format, newGraphName).get();
    }

    public PgxGraph readGraphFiles(List<String> vertexFilePaths, List<String> edgeFilePaths) throws ExecutionException, InterruptedException {
        return this.readGraphFilesAsync(vertexFilePaths, edgeFilePaths).get();
    }

    public PgxGraph readGraphFiles(List<String> vertexFilePaths, List<String> edgeFilePaths, @Nullable Format format) throws ExecutionException, InterruptedException {
        return this.readGraphFilesAsync(vertexFilePaths, edgeFilePaths, format).get();
    }

    public PgxGraph readGraphFiles(List<String> vertexFilePaths, List<String> edgeFilePaths, @Nullable String newGraphName) throws ExecutionException, InterruptedException {
        return this.readGraphFilesAsync(vertexFilePaths, edgeFilePaths, newGraphName).get();
    }

    public PgxGraph readGraphFiles(List<String> vertexFilePaths, List<String> edgeFilePaths, @Nullable Format format, @Nullable String newGraphName) throws ExecutionException, InterruptedException {
        return this.readGraphFilesAsync(vertexFilePaths, edgeFilePaths, format, newGraphName).get();
    }

    public PgxGraph readGraphWithProperties(String path) throws ExecutionException, InterruptedException {
        return this.readGraphWithPropertiesAsync(path, null).get();
    }

    public PgxGraph readGraphWithProperties(String path, String newGraphName) throws ExecutionException, InterruptedException {
        return this.readGraphWithPropertiesAsync(path, newGraphName).get();
    }

    public PgxGraph readGraphWithProperties(GraphConfig config) throws ExecutionException, InterruptedException {
        return this.readGraphWithPropertiesAsync(config).get();
    }

    public PgxGraph readGraphWithProperties(GraphConfig config, String newGraphName) throws ExecutionException, InterruptedException {
        return this.readGraphWithPropertiesAsync(config, newGraphName).get();
    }

    public PgxGraph readGraphWithProperties(GraphConfig config, boolean updateIfNotFresh) throws InterruptedException, ExecutionException {
        return this.readGraphWithPropertiesAsync(config, updateIfNotFresh).get();
    }

    public PgxGraph readGraphWithProperties(GraphConfig config, boolean updateIfNotFresh, String newGraphName) throws InterruptedException, ExecutionException {
        return this.readGraphWithPropertiesAsync(config, updateIfNotFresh, newGraphName).get();
    }

    public PgxGraph readGraphWithProperties(GraphConfig config, long maxAge, TimeUnit maxAgeTimeUnit) throws InterruptedException, ExecutionException {
        return this.readGraphWithPropertiesAsync(config, maxAge, maxAgeTimeUnit).get();
    }

    public PgxGraph readGraphWithProperties(GraphConfig config, long maxAge, TimeUnit maxAgeTimeUnit, boolean blockIfFull, String newGraphName) throws InterruptedException, ExecutionException {
        return this.readGraphWithPropertiesAsync(config, maxAge, maxAgeTimeUnit, blockIfFull, newGraphName).get();
    }

    public PgxGraph readGraphByName(String name, GraphSource source) {
        return this.readGraphByNameAsync(name, source).join();
    }

    public PgxGraph readGraphByName(String name, GraphSource source, ReadGraphOption ... options) {
        return this.readGraphByNameAsync(name, source, options).join();
    }

    public PgxGraph readGraphAsOf(GraphConfig config, GraphMetaData metaData) throws ExecutionException, InterruptedException {
        return this.readGraphAsOfAsync(config, metaData).get();
    }

    public PgxGraph readGraphAsOf(GraphConfig config, GraphMetaData metaData, String newGraphName) throws ExecutionException, InterruptedException {
        return this.readGraphAsOfAsync(config, metaData, newGraphName).get();
    }

    public PgxGraph readGraphAsOf(GraphConfig config, long creationTimestamp) throws ExecutionException, InterruptedException {
        return this.readGraphAsOfAsync(config, creationTimestamp).get();
    }

    public PgxGraph readGraphAsOf(GraphConfig config, long creationTimestamp, String newGraphName) throws ExecutionException, InterruptedException {
        return this.readGraphAsOfAsync(config, creationTimestamp, newGraphName).get();
    }

    public PgxGraph getGraph(String name) throws ExecutionException, InterruptedException {
        return this.getGraphAsync(name).get();
    }

    public PgxGraph getGraph(Namespace namespace, String name) throws ExecutionException, InterruptedException {
        return this.getGraphAsync(namespace, name).get();
    }

    @Deprecated
    public Map<String, PgxGraph> getGraphs() throws ExecutionException, InterruptedException {
        return this.getGraphsAsync().get();
    }

    public List<String> getGraphs(Namespace namespace) throws ExecutionException, InterruptedException {
        return this.getGraphsAsync(namespace).get();
    }

    public Deque<GraphMetaData> getAvailableSnapshots(PgxGraph snapshot) throws InterruptedException, ExecutionException {
        return this.getAvailableSnapshotsAsync(snapshot).get();
    }

    public void setSnapshot(PgxGraph graph, long creationTimestamp) {
        this.setSnapshotAsync(graph, creationTimestamp).join();
    }

    public void setSnapshot(PgxGraph graph, GraphMetaData metaData) {
        this.setSnapshotAsync(graph, metaData).join();
    }

    public void setSnapshot(PgxGraph graph, long creationTimestamp, boolean forceDeleteProperties) {
        this.setSnapshotAsync(graph, creationTimestamp, forceDeleteProperties).join();
    }

    public void setSnapshot(PgxGraph graph, GraphMetaData metaData, boolean forceDeleteProperties) {
        this.setSnapshotAsync(graph, metaData, forceDeleteProperties).join();
    }

    public CompiledProgram compileProgramCode(String code) throws ExecutionException, InterruptedException {
        return this.compileProgramCodeAsync(code).get();
    }

    public CompiledProgram compileProgramCode(String code, boolean overwrite) throws ExecutionException, InterruptedException {
        return this.compileProgramCodeAsync(code, overwrite).get();
    }

    public CompiledProgram compileProgramCode(String code, boolean overwrite, boolean parallel, List<GmCompilerOptimization> disabledOptimizations, boolean verbose) throws ExecutionException, InterruptedException {
        return this.compileProgramCodeAsync(code, overwrite, parallel, disabledOptimizations, verbose).get();
    }

    public CompiledProgram compileProgram(String path) throws ExecutionException, InterruptedException {
        return this.compileProgramAsync(path).get();
    }

    public CompiledProgram compileProgram(String path, boolean overwrite) throws IOException, ExecutionException, InterruptedException {
        return this.compileProgramAsync(path, overwrite).get();
    }

    public CompiledProgram compileProgram(InputStream code) throws ExecutionException, InterruptedException {
        return this.compileProgramAsync(code).get();
    }

    public CompiledProgram compileProgram(InputStream code, boolean overwrite) throws IOException, ExecutionException, InterruptedException {
        return this.compileProgramAsync(code, overwrite).get();
    }

    public Set<String> getAvailableCompiledProgramIds() {
        return this.getAvailableCompiledProgramIdsAsync().join();
    }

    public CompiledProgram getCompiledProgram(String id) {
        return this.getCompiledProgramAsync(id).join();
    }

    public PgqlResultSet getPgqlResultSet(String id) {
        return this.getPgqlResultSetAsync(id).join();
    }

    public PgxPreparedStatement preparePgql(String pgqlString) {
        return this.preparePgqlAsync(pgqlString).join();
    }

    public PgqlResultSet queryPgql(String pgqlString) throws ExecutionException, InterruptedException {
        return this.queryPgql(pgqlString, Collections.emptyList());
    }

    private PgqlResultSet queryPgql(String pgqlString, List<PgqlOption> pgqlOptions) throws ExecutionException, InterruptedException {
        return this.queryPgqlAsync(pgqlString, pgqlOptions).get();
    }

    public Operation explainPgql(String pgqlString) throws ExecutionException, InterruptedException {
        return this.explainPgqlAsync(pgqlString).get();
    }

    public PgqlResultSet executePgql(String pgqlString) throws ExecutionException, InterruptedException {
        return this.executePgql(pgqlString, Collections.emptyList());
    }

    private PgqlResultSet executePgql(String pgqlString, List<PgqlOption> pgqlOptions) throws ExecutionException, InterruptedException {
        return this.executePgqlAsync(pgqlString, pgqlOptions).get();
    }

    public <T> ScalarSet<T> createSet(PropertyType contentType, String name) {
        return this.createSetAsync(contentType, name).join();
    }

    public <T> ScalarSequence<T> createSequence(PropertyType contentType, String name) {
        return this.createSequenceAsync(contentType, name).join();
    }

    public <T> ScalarSet<T> createSet(PropertyType contentType) {
        return this.createSetAsync(contentType).join();
    }

    public <T> ScalarSequence<T> createSequence(PropertyType contentType) {
        return this.createSequenceAsync(contentType).join();
    }

    public <K, V> PgxMap<K, V> createMap(PropertyType keyType, PropertyType valueType, String name) {
        return this.createMapAsync(keyType, valueType, name).join();
    }

    public <K, V> PgxMap<K, V> createMap(PropertyType keyType, PropertyType valueType) {
        return this.createMapAsync(keyType, valueType).join();
    }

    public PgxFuture<List<?>> runConcurrentlyAsync(List<Supplier<PgxFuture<?>>> asyncRequestsSuppliers) {
        return ((PgxFuture)((PgxFuture)this.setAllowMultipleConcurrentTasksAsync(true).thenApply(aVoid -> asyncRequestsSuppliers.stream().map(asyncRequestSupplier -> (PgxFuture)asyncRequestSupplier.get()).collect(Collectors.toList()))).thenCompose(futures -> PgxFuture.allOf(futures).thenApply(aVoid -> futures.stream().map(PgxFuture::join).collect(Collectors.toList())))).handle((result, throwable) -> {
            this.setAllowMultipleConcurrentTasksAsync(false);
            if (throwable != null) {
                Throwables.propagate((Throwable)throwable);
            }
            return result;
        });
    }

    public List<?> runConcurrently(List<Supplier<PgxFuture<?>>> asyncRequest) {
        return this.runConcurrentlyAsync(asyncRequest).join();
    }

    private PgxFuture<Void> setAllowMultipleConcurrentTasksAsync(boolean value) {
        return this.core.updateExecutionEnvironment(this.context, null, ExecutionEnvironmentField.ALLOW_MULTIPLE_CONCURRENT_TASKS, value);
    }
}

