/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import oracle.pgx.api.PgxFuture;
import oracle.pgx.api.PgxGraph;
import oracle.pgx.api.PgxManagedObject;
import oracle.pgx.api.PgxSession;
import oracle.pgx.api.Property;
import oracle.pgx.api.SessionContext;
import oracle.pgx.api.internal.ApiObject;
import oracle.pgx.api.internal.Core;
import oracle.pgx.api.internal.Edge;
import oracle.pgx.api.internal.Entity;
import oracle.pgx.api.internal.Vertex;
import oracle.pgx.common.PartitionedId;
import oracle.pgx.common.types.EntityType;
import oracle.pgx.common.types.IdStrategy;
import oracle.pgx.common.types.IdType;
import oracle.pgx.common.util.ErrorMessages;

public abstract class PgxEntity<ID>
extends ApiObject {
    private final PgxGraph graph;
    private final IdStrategy globalIdStrategy;
    private final PgxSession session;
    private final String tableName;
    private final ID key;
    private final IdType keyType;
    private final EntityType entityType;

    private static IdStrategy getGlobalIdStrategy(PgxGraph g, EntityType entityType) {
        switch (entityType) {
            case VERTEX: {
                return g.getVertexIdStrategy();
            }
            case EDGE: {
                return g.getEdgeIdStrategy();
            }
        }
        throw new IllegalArgumentException(ErrorMessages.getMessage((String)"UNSUPPORTED_ENTITY_TYPE", (Object[])new Object[]{entityType}));
    }

    protected PgxEntity(PgxGraph graph, Entity entity) {
        assert (entity != null);
        assert (entity.getEntityType() != null);
        this.session = graph.getSession();
        this.graph = graph;
        this.globalIdStrategy = PgxEntity.getGlobalIdStrategy(graph, this.getEntityType());
        this.tableName = entity.getTableName();
        this.keyType = entity.getIdType();
        this.key = entity.getKey();
        this.entityType = entity.getEntityType();
    }

    protected PgxEntity(PgxGraph graph, ID id, IdType idType, EntityType entityType) {
        assert (graph != null);
        this.graph = graph;
        this.globalIdStrategy = PgxEntity.getGlobalIdStrategy(graph, this.getEntityType());
        this.session = graph.getSession();
        this.tableName = this.getDefaultTableName(entityType);
        this.keyType = idType;
        this.key = id;
        this.entityType = entityType;
    }

    private String getDefaultTableName(EntityType entityType) {
        switch (entityType) {
            case VERTEX: {
                return "V";
            }
            case EDGE: {
                return "E";
            }
        }
        throw new IllegalArgumentException(ErrorMessages.getMessage((String)"UNSUPPORTED_ENTITY_TYPE", (Object[])new Object[]{entityType}));
    }

    private boolean isFromDefaultTable() {
        switch (this.entityType) {
            case VERTEX: {
                return Objects.equals("V", this.tableName);
            }
            case EDGE: {
                return Objects.equals("E", this.tableName);
            }
        }
        throw new IllegalArgumentException(ErrorMessages.getMessage((String)"UNSUPPORTED_ENTITY_TYPE", (Object[])new Object[]{this.entityType}));
    }

    private Entity createEntity() {
        switch (this.entityType) {
            case VERTEX: {
                return new Vertex(this.graph.getId(), this.tableName, this.keyType, this.key);
            }
            case EDGE: {
                return new Edge(this.graph.getId(), this.tableName, this.keyType, this.key);
            }
        }
        throw new IllegalArgumentException(ErrorMessages.getMessage((String)"UNSUPPORTED_ENTITY_TYPE", (Object[])new Object[]{this.entityType}));
    }

    protected Core getCore() {
        return this.session.getCore();
    }

    protected PgxSession getSession() {
        return this.session;
    }

    protected SessionContext getSessionContext() {
        return this.session.getSessionContext();
    }

    public PgxGraph getGraph() {
        return this.graph;
    }

    public Object serialize() {
        if (this.tableName == null || this.key == null) {
            return null;
        }
        if (this.isFromDefaultTable()) {
            return this.key;
        }
        return this.createEntity();
    }

    abstract EntityType getEntityType();

    public ID getId() {
        if (this.globalIdStrategy == null || this.globalIdStrategy == IdStrategy.NO_IDS) {
            switch (this.getEntityType()) {
                case VERTEX: {
                    throw new IllegalStateException(ErrorMessages.getMessage((String)"GRAPH_MISSING_VERTEX_IDS", (Object[])new Object[0]));
                }
                case EDGE: {
                    throw new IllegalStateException(ErrorMessages.getMessage((String)"GRAPH_MISSING_EDGE_IDS", (Object[])new Object[0]));
                }
            }
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"UNSUPPORTED_ENTITY_TYPE", (Object[])new Object[]{this.entityType}));
        }
        if (this.globalIdStrategy == IdStrategy.PARTITIONED_IDS) {
            switch (this.getEntityType()) {
                case VERTEX: {
                    return (ID)PartitionedId.createPartitionedId((String)this.tableName, (Object[])new Object[]{this.key});
                }
                case EDGE: {
                    throw new UnsupportedOperationException(ErrorMessages.getMessage((String)"UNSUPPORTED_OP_ON_PARTITIONED_IDS", (Object[])new Object[0]));
                }
            }
        }
        return this.key;
    }

    public IdType getType() {
        return this.keyType;
    }

    public <V> PgxFuture<V> getPropertyAsync(String propertyName) {
        return this.getPropAsync(propertyName).thenCompose(prop -> this.getCore().getPropertyValue(this.getSessionContext(), this.graph.getId(), prop.getPropertyId(), this.entityType, this.serialize()).thenApply(propValue -> Property.wrap(propValue.getValue(), propValue.getValueType(), this.graph)));
    }

    public <V> PgxFuture<Void> setPropertyAsync(String propertyName, V value) {
        Map<Object, Object> values = Collections.singletonMap(this.serialize(), PgxManagedObject.unwrap(value));
        return this.getPropAsync(propertyName).thenCompose(prop -> this.getCore().setProperty(this.getSessionContext(), this.graph.getId(), prop.getPropertyId(), this.entityType, values, null));
    }

    protected abstract <V> PgxFuture<? extends Property<ID, ?, V>> getPropAsync(String var1);

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        PgxEntity other = (PgxEntity)obj;
        if (!Objects.equals(this.tableName, other.tableName)) {
            return false;
        }
        if (this.globalIdStrategy == IdStrategy.PARTITIONED_IDS ? !Objects.equals(this.key, other.key) : !Objects.equals(this.getId(), other.getId())) {
            return false;
        }
        if (!Objects.equals(this.getType(), other.getType())) {
            return false;
        }
        return this.graph.equals(other.graph);
    }

    public int hashCode() {
        if (this.globalIdStrategy == IdStrategy.PARTITIONED_IDS) {
            return Objects.hash(this.key, this.tableName);
        }
        return Objects.hash(this.getId(), this.tableName);
    }

    public String toString() {
        if (this.globalIdStrategy == IdStrategy.PARTITIONED_IDS) {
            return this.toString(PgxEntity.entry("provider", this.tableName), PgxEntity.entry("key", this.key), PgxEntity.entry("ID", PartitionedId.createPartitionedId((String)this.tableName, (Object[])new Object[]{this.key})));
        }
        if (this.isFromDefaultTable()) {
            return this.toString(PgxEntity.entry("ID", this.getId()));
        }
        return this.toString(PgxEntity.entry("provider", this.tableName), PgxEntity.entry("ID", this.getId()));
    }

    public <V> V getProperty(String propertyName) throws ExecutionException, InterruptedException {
        return this.getPropertyAsync(propertyName).get();
    }

    public <V> void setProperty(String propertyName, V value) throws ExecutionException, InterruptedException {
        this.setPropertyAsync(propertyName, value).get();
    }
}

