/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import oracle.pgx.api.EdgeProperty;
import oracle.pgx.api.MutationStrategyBuilder;
import oracle.pgx.api.PgxGraph;
import oracle.pgx.api.VertexProperty;
import oracle.pgx.common.PgxId;
import oracle.pgx.common.mutations.PartitionizingStrategy;

public class PartitionizingStrategyBuilder
extends MutationStrategyBuilder<PartitionizingStrategyBuilder> {
    private Map<Set<String>, String> vertexLabelsToTableNameMap = PartitionizingStrategy.VERTEX_LABELS_TO_TABLE_AUTO;
    private Map<String, String> edgeLabelToTableNameMap = PartitionizingStrategy.EDGE_LABEL_TO_TABLE_AUTO;
    private Map<PgxId, Object> vertexPropsToDropIfDefault = Collections.emptyMap();
    private Map<PgxId, Object> edgePropsToDropIfDefault = Collections.emptyMap();
    private String defaultVertexTableName = PartitionizingStrategy.DEFAULT_TABLE_NAME_AUTO_LABEL_BASED;
    private String defaultEdgeTableName = PartitionizingStrategy.DEFAULT_TABLE_NAME_AUTO_LABEL_BASED;
    private boolean generateLabelHistogram = true;
    private boolean generateDegreeCaches = true;
    private boolean preserveEdgeKeys = true;

    public PartitionizingStrategyBuilder(PgxGraph graph) throws ExecutionException, InterruptedException {
        super(graph);
    }

    @Override
    public PartitionizingStrategyBuilder setNewGraphName(String name) {
        this.newGraphName = name;
        return this;
    }

    public PartitionizingStrategyBuilder setVertexLabelsToTableNameMap(Map<Set<String>, String> map) {
        this.vertexLabelsToTableNameMap = map;
        return this;
    }

    public PartitionizingStrategyBuilder setEdgeLabelToTableNameMap(Map<String, String> map) {
        this.edgeLabelToTableNameMap = map;
        return this;
    }

    public PartitionizingStrategyBuilder setVertexPropsToDropIfDefault(Map<VertexProperty<?, ?>, Object> map) {
        this.vertexPropsToDropIfDefault = new HashMap<PgxId, Object>();
        map.forEach((prop, defVal) -> this.vertexPropsToDropIfDefault.put(prop.getPropertyId(), defVal));
        return this;
    }

    public PartitionizingStrategyBuilder setEdgePropsToDropIfDefault(Map<EdgeProperty<?>, Object> map) {
        this.edgePropsToDropIfDefault = new HashMap<PgxId, Object>();
        map.forEach((prop, defVal) -> this.edgePropsToDropIfDefault.put(prop.getPropertyId(), defVal));
        return this;
    }

    public PartitionizingStrategyBuilder setDefaultVertexTableName(String name) {
        this.defaultVertexTableName = name;
        return this;
    }

    public PartitionizingStrategyBuilder setDefaultEdgeTableName(String name) {
        this.defaultEdgeTableName = name;
        return this;
    }

    public PartitionizingStrategyBuilder generateLabelHistogram(boolean doGenerateLabelHistogram) {
        this.generateLabelHistogram = doGenerateLabelHistogram;
        return this;
    }

    public PartitionizingStrategyBuilder generateDegreeCaches(boolean doGenerateDegreeCaches) {
        this.generateDegreeCaches = doGenerateDegreeCaches;
        return this;
    }

    public PartitionizingStrategyBuilder preserveEdgeKeys(boolean doPreserveEdgeKeys) {
        this.preserveEdgeKeys = doPreserveEdgeKeys;
        return this;
    }

    public PartitionizingStrategy build() {
        return new PartitionizingStrategy(this.newGraphName, this.keptVertexProperties, this.keptEdgeProperties, this.vertexLabelsToTableNameMap, this.edgeLabelToTableNameMap, this.vertexPropsToDropIfDefault, this.edgePropsToDropIfDefault, this.defaultVertexTableName, this.defaultEdgeTableName, this.generateLabelHistogram, this.generateDegreeCaches, this.preserveEdgeKeys);
    }
}

