/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api;

import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Objects;
import java.util.stream.Stream;
import oracle.pgx.common.PgxId;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.utils.IdGenerator;

public class Namespace {
    public static final Namespace PUBLIC = new Namespace(IdGenerator.generateIdFromString((String)"public"));
    public static final Namespace PRIVATE = new Namespace(IdGenerator.generateIdFromString((String)"private"));
    private static final Namespace[] PREDEFINED_NAMESPACES = new Namespace[]{PUBLIC, PRIVATE};
    private final PgxId namespaceId;

    private Namespace(String uuid) {
        this(PgxId.fromString((String)uuid));
    }

    private Namespace(PgxId namespaceId) {
        this.namespaceId = namespaceId;
    }

    public static Namespace fromId(PgxId namespaceId) {
        return Stream.of(PREDEFINED_NAMESPACES).filter(ns -> Objects.equals(ns.getNamespaceId(), namespaceId)).findAny().orElseThrow(() -> new IllegalArgumentException(ErrorMessages.getMessage((String)"INVALID_NAMESPACE_ID", (Object[])new Object[0])));
    }

    @JsonValue
    public PgxId getNamespaceId() {
        return this.namespaceId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Namespace namespace = (Namespace)o;
        return Objects.equals(this.namespaceId, namespace.namespaceId);
    }

    public int hashCode() {
        return Objects.hash(this.namespaceId);
    }

    public String toString() {
        return "Namespace(" + this.namespaceId + ')';
    }
}

