/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import oracle.pgx.api.AllPaths;
import oracle.pgx.api.Analyst;
import oracle.pgx.api.BipartiteGraph;
import oracle.pgx.api.EdgeProperty;
import oracle.pgx.api.EdgeSequence;
import oracle.pgx.api.MatrixFactorizationModel;
import oracle.pgx.api.Partition;
import oracle.pgx.api.PgxGraph;
import oracle.pgx.api.PgxMap;
import oracle.pgx.api.PgxPath;
import oracle.pgx.api.PgxSession;
import oracle.pgx.api.PgxVertex;
import oracle.pgx.api.Scalar;
import oracle.pgx.api.VertexProperty;
import oracle.pgx.api.VertexSequence;
import oracle.pgx.api.VertexSet;
import oracle.pgx.api.filter.GraphFilter;
import oracle.pgx.api.filter.VertexFilter;
import oracle.pgx.api.internal.algorithm.arguments.AdamicAdarArguments;
import oracle.pgx.api.internal.algorithm.arguments.Arguments;
import oracle.pgx.api.internal.algorithm.arguments.BellmanFordArguments;
import oracle.pgx.api.internal.algorithm.arguments.BetweennessCentralityArguments;
import oracle.pgx.api.internal.algorithm.arguments.BfsArguments;
import oracle.pgx.api.internal.algorithm.arguments.CenterArguments;
import oracle.pgx.api.internal.algorithm.arguments.ClosenessCentralityArguments;
import oracle.pgx.api.internal.algorithm.arguments.CommunitiesArguments;
import oracle.pgx.api.internal.algorithm.arguments.ConductanceArguments;
import oracle.pgx.api.internal.algorithm.arguments.DefaultPathNaming;
import oracle.pgx.api.internal.algorithm.arguments.DegreeCentralityArguments;
import oracle.pgx.api.internal.algorithm.arguments.DegreeDistributionArguments;
import oracle.pgx.api.internal.algorithm.arguments.DiameterArguments;
import oracle.pgx.api.internal.algorithm.arguments.DijkstraArguments;
import oracle.pgx.api.internal.algorithm.arguments.EigenvectorCentralityArguments;
import oracle.pgx.api.internal.algorithm.arguments.FattestPathArguments;
import oracle.pgx.api.internal.algorithm.arguments.FindCycleArguments;
import oracle.pgx.api.internal.algorithm.arguments.HitsArguments;
import oracle.pgx.api.internal.algorithm.arguments.HopDistArguments;
import oracle.pgx.api.internal.algorithm.arguments.KcoreArguments;
import oracle.pgx.api.internal.algorithm.arguments.LocalClusteringCoefficientArguments;
import oracle.pgx.api.internal.algorithm.arguments.MatrixFactorizationArguments;
import oracle.pgx.api.internal.algorithm.arguments.PagerankArguments;
import oracle.pgx.api.internal.algorithm.arguments.PartitionModularityArguments;
import oracle.pgx.api.internal.algorithm.arguments.PeripheryArguments;
import oracle.pgx.api.internal.algorithm.arguments.PrimArguments;
import oracle.pgx.api.internal.algorithm.arguments.RadiusArguments;
import oracle.pgx.api.internal.algorithm.arguments.ReachabilityArguments;
import oracle.pgx.api.internal.algorithm.arguments.SalsaArguments;
import oracle.pgx.api.internal.algorithm.arguments.SccArguments;
import oracle.pgx.api.internal.algorithm.arguments.TopologicalSortArguments;
import oracle.pgx.api.internal.algorithm.arguments.WccArguments;
import oracle.pgx.api.internal.algorithm.arguments.WhomToFollowArguments;
import oracle.pgx.common.Pair;
import oracle.pgx.common.types.Direction;
import oracle.pgx.common.types.PropertyType;
import oracle.pgx.common.util.ErrorMessages;

public class NamedArgumentAnalyst
extends Analyst {
    public NamedArgumentAnalyst(PgxSession session) {
        super(session);
    }

    public NamedArgumentAnalyst(Analyst analyst) {
        this(analyst.getSession());
    }

    private <T, E extends Enum<E>> T getFromArguments(Map<String, Object> argumentMap, String argumentName, Object defaultValue, Class<E> specificEnumClass) {
        Objects.requireNonNull(specificEnumClass);
        Object value = argumentMap.getOrDefault(argumentName, defaultValue);
        try {
            return (T)Enum.valueOf(specificEnumClass, String.valueOf(value));
        }
        catch (IllegalArgumentException e) {
            String validEnumValues = Arrays.toString(specificEnumClass.getEnumConstants());
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"INVALID_ALGORITHM_VARIANT", (Object[])new Object[]{value, validEnumValues}));
        }
    }

    private <T> T getFromArguments(Map<String, Object> argumentMap, String argumentName, Object defaultValue) {
        return (T)argumentMap.getOrDefault(argumentName, defaultValue);
    }

    private <T> T getFromArguments(Map<String, Object> argumentMap, String argumentName) {
        return this.getFromArguments(argumentMap, argumentName, null);
    }

    private void validateRequiredArguments(String key, Object value) {
        if (value == null) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"PARAMETER_IS_REQUIRED", (Object[])new Object[]{key}));
        }
    }

    private void logInvokation(String algorithmName, List<String> arguments) {
        LOG.info("invoking {} with arguments ({})", (Object)algorithmName, (Object)String.join((CharSequence)", ", arguments));
    }

    private List<String> createInvokationDescription(String ... invokationInfo) {
        return new LinkedList<String>(Arrays.asList(invokationInfo));
    }

    private String wrapUp(String key, String value) {
        return String.join((CharSequence)": ", key, value);
    }

    protected <ID> VertexProperty<ID, Double> pagerank(Map<String, Object> params) throws ExecutionException, InterruptedException {
        PagerankArguments defaults = Arguments.PAGERANK;
        params = defaults.parseArguments(params);
        PgxGraph g = (PgxGraph)this.getFromArguments(params, "graph");
        BigDecimal e = (BigDecimal)this.getFromArguments(params, "error", BigDecimal.valueOf(0.001));
        BigDecimal d = (BigDecimal)this.getFromArguments(params, "dampingFactor", BigDecimal.valueOf(0.85));
        int max = (Integer)this.getFromArguments(params, "maxIterations", 100);
        boolean norm = (Boolean)this.getFromArguments(params, "normalize", false);
        PagerankArguments.PagerankVariant variant = (PagerankArguments.PagerankVariant)((Object)this.getFromArguments(params, "variant", (Object)PagerankArguments.PagerankVariant.DEFAULT, PagerankArguments.PagerankVariant.class));
        EdgeProperty weight = (EdgeProperty)this.getFromArguments(params, "weight");
        PgxVertex vertex = (PgxVertex)this.getFromArguments(params, "vertex");
        VertexSet vertices = (VertexSet)this.getFromArguments(params, "vertices");
        VertexProperty rank = (VertexProperty)this.getFromArguments(params, "pagerank");
        String propertyName = (String)this.getFromArguments(params, "pagerankPropertyName", "");
        this.validateRequiredArguments("graph", g);
        if (variant == PagerankArguments.PagerankVariant.WEIGHTED) {
            this.validateRequiredArguments("weight", weight);
        }
        if (variant == PagerankArguments.PagerankVariant.PERSONALIZED) {
            if (params.containsKey("vertex") && params.containsKey("vertices")) {
                throw new IllegalArgumentException(ErrorMessages.getMessage((String)"ARGUMENT_CANNOT_BE_COMBINED", (Object[])new Object[]{"vertex", "vertices"}));
            }
            if (params.keySet().contains("vertices")) {
                this.validateRequiredArguments("vertices", vertices);
            } else if (params.keySet().contains("vertex")) {
                this.validateRequiredArguments("vertex", vertex);
            } else {
                throw new IllegalArgumentException(ErrorMessages.getMessage((String)"EXCLUSIVE_ARGUMENT_IS_REQUIRED", (Object[])new Object[]{"vertex", "vertices"}));
            }
        }
        if (variant == PagerankArguments.PagerankVariant.PERSONALIZED_WEIGHTED) {
            this.validateRequiredArguments("weight", weight);
            if (params.containsKey("vertex") && params.containsKey("vertices")) {
                throw new IllegalArgumentException(ErrorMessages.getMessage((String)"ARGUMENT_CANNOT_BE_COMBINED", (Object[])new Object[]{"vertex", "vertices"}));
            }
            if (params.keySet().contains("vertices")) {
                this.validateRequiredArguments("vertices", vertices);
            } else if (params.keySet().contains("vertex")) {
                this.validateRequiredArguments("vertex", vertex);
            } else {
                throw new IllegalArgumentException(ErrorMessages.getMessage((String)"EXCLUSIVE_ARGUMENT_IS_REQUIRED", (Object[])new Object[]{"vertex", "vertices"}));
            }
        }
        rank = this.propertyValidation(rank, PropertyType.DOUBLE, g, propertyName, Arguments.PAGERANK.getDefaultName(variant), 0);
        List<String> invokingInfo = this.createInvokationDescription(this.wrapUp("graph", g.getName()), this.wrapUp("error", e.toString()), this.wrapUp("dampingFactor", d.toString()), this.wrapUp("maxIterations", String.valueOf(max)), this.wrapUp("pagerank", rank.getName()));
        switch (variant) {
            case APPROXIMATE: {
                this.logInvokation("pagerank Approximate", invokingInfo);
                return this.pagerankApproximate(g, e, d, max, rank);
            }
            case WEIGHTED: {
                invokingInfo.add(this.wrapUp("weight", weight.getName()));
                this.logInvokation("pagerank Weighted", invokingInfo);
                return this.weightedPagerank(g, e, d, max, norm, (EdgeProperty<Double>)weight, rank);
            }
            case PERSONALIZED: {
                if (params.keySet().contains("vertices")) {
                    invokingInfo.add(this.wrapUp("vertices", vertices.getName()));
                    this.logInvokation("pagerank Personalized", invokingInfo);
                    return this.personalizedPagerank(g, vertices, e, d, max, norm, rank);
                }
                invokingInfo.add(this.wrapUp("vertex", vertex.toString()));
                this.logInvokation("pagerank Personalized", invokingInfo);
                return this.personalizedPagerank(g, vertex, e, d, max, norm, rank);
            }
            case PERSONALIZED_WEIGHTED: {
                invokingInfo.add(this.wrapUp("weight", weight.getName()));
                if (params.keySet().contains("vertices")) {
                    invokingInfo.add(this.wrapUp("vertices", vertices.getName()));
                    this.logInvokation("Personalized Weighted pagerank", invokingInfo);
                    return this.personalizedWeightedPagerank(g, vertices, e, d, max, norm, (EdgeProperty<Double>)weight, rank);
                }
                invokingInfo.add(this.wrapUp("vertex", vertex.toString()));
                this.logInvokation("Personalized Weighted pagerank", invokingInfo);
                return this.personalizedWeightedPagerank(g, vertex, e, d, max, norm, (EdgeProperty<Double>)weight, rank);
            }
        }
        if (weight != null) {
            LOG.info("argument weight will be ignored. Use variation:\"weighted\" to use this arg");
        }
        if (vertices != null) {
            LOG.info("argument vertices will be ignored. Use variation:\"personalized\" to use this arg");
        }
        this.logInvokation("pagerank", invokingInfo);
        return this.pagerank(g, e, d, max, norm, rank);
    }

    protected <ID> VertexProperty<ID, Double> vertexBetweennessCentrality(Map<String, Object> params) throws ExecutionException, InterruptedException {
        BetweennessCentralityArguments defaults = Arguments.BC;
        params = defaults.parseArguments(params);
        PgxGraph g = (PgxGraph)this.getFromArguments(params, "graph");
        BetweennessCentralityArguments.BetweennessCentralityVariant variant = (BetweennessCentralityArguments.BetweennessCentralityVariant)((Object)this.getFromArguments(params, "variant", (Object)BetweennessCentralityArguments.BetweennessCentralityVariant.FULL, BetweennessCentralityArguments.BetweennessCentralityVariant.class));
        VertexProperty bc = (VertexProperty)this.getFromArguments(params, "betweennessCentrality");
        String propertyName = (String)this.getFromArguments(params, "betweennessCentralityPropertyName", "");
        Integer numRandomSeeds = (Integer)this.getFromArguments(params, "numRandomSeeds");
        VertexSet seeds = (VertexSet)this.getFromArguments(params, "seeds");
        this.validateRequiredArguments("graph", g);
        if (variant == BetweennessCentralityArguments.BetweennessCentralityVariant.APPROXIMATE) {
            if (numRandomSeeds != null && seeds != null) {
                throw new IllegalArgumentException(ErrorMessages.getMessage((String)"ARGUMENT_CANNOT_BE_COMBINED", (Object[])new Object[]{"numRandomSeeds", "seeds"}));
            }
            if (numRandomSeeds == null && seeds == null) {
                numRandomSeeds = 5;
            }
        }
        bc = this.propertyValidation(bc, PropertyType.DOUBLE, g, propertyName, Arguments.BC.getDefaultName(variant), 0);
        List<String> invokingInfo = this.createInvokationDescription(this.wrapUp("graph", g.getName()), this.wrapUp("betweennessCentrality", bc.getName()));
        switch (variant) {
            case APPROXIMATE: {
                if (numRandomSeeds != null) {
                    invokingInfo.add(this.wrapUp("numRandomSeeds", numRandomSeeds.toString()));
                    this.logInvokation("betweennessCentrality Approximate", invokingInfo);
                    return this.approximateVertexBetweennessCentrality(g, numRandomSeeds, bc);
                }
                PgxVertex[] vertexArray = new PgxVertex[seeds.size()];
                int i = 0;
                Iterator iterator = seeds.iterator();
                while (iterator.hasNext()) {
                    PgxVertex vertex;
                    vertexArray[i] = vertex = (PgxVertex)iterator.next();
                    ++i;
                }
                invokingInfo.add(this.wrapUp("seeds", seeds.getName()));
                this.logInvokation("betweennessCentrality Approximate", invokingInfo);
                return this.approximateVertexBetweennessCentralityFromSeeds(g, bc, vertexArray);
            }
        }
        if (seeds != null) {
            LOG.info("argument seeds will be ignored. Use variation:\"approximate\" to use this arg");
        }
        if (numRandomSeeds != null) {
            LOG.info("argument numRandomSeeds will be ignored. Use variation:\"approximate\" to use this arg");
        }
        this.logInvokation("betweennessCentrality Approximate", invokingInfo);
        return this.vertexBetweennessCentrality(g, bc);
    }

    protected <ID> VertexProperty<ID, Double> closenessCentrality(Map<String, Object> params) throws ExecutionException, InterruptedException {
        if (params == null) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"PARAMETER_IS_REQUIRED", (Object[])new Object[]{"map"}));
        }
        ClosenessCentralityArguments defaults = Arguments.CC;
        params = defaults.parseArguments(params);
        PgxGraph g = (PgxGraph)this.getFromArguments(params, "graph");
        ClosenessCentralityArguments.ClosenessCentralityVariant variant = (ClosenessCentralityArguments.ClosenessCentralityVariant)((Object)this.getFromArguments(params, "variant", (Object)ClosenessCentralityArguments.ClosenessCentralityVariant.DEFAULT, ClosenessCentralityArguments.ClosenessCentralityVariant.class));
        VertexProperty cc = (VertexProperty)this.getFromArguments(params, "closenessCentrality");
        String propertyName = (String)this.getFromArguments(params, "closenessCentralityPropertyName", "");
        EdgeProperty cost = (EdgeProperty)this.getFromArguments(params, "cost");
        this.validateRequiredArguments("graph", g);
        if (variant == ClosenessCentralityArguments.ClosenessCentralityVariant.WEIGHTED) {
            this.validateRequiredArguments("cost", cost);
        }
        cc = this.propertyValidation(cc, PropertyType.DOUBLE, g, propertyName, Arguments.CC.getDefaultName(variant), 0);
        List<String> invokingInfo = this.createInvokationDescription(this.wrapUp("graph", g.getName()), this.wrapUp("closenessCentrality", cc.getName()));
        switch (variant) {
            case WEIGHTED: {
                invokingInfo.add(this.wrapUp("cost", cost.getName()));
                this.logInvokation("ClosenessCentrality", invokingInfo);
                return this.closenessCentralityDoubleLength(g, cost, cc);
            }
        }
        if (cost != null) {
            LOG.info("argument cost will be ignored. Use variation:\"weighted\" to use this arg");
        }
        this.logInvokation("ClosenessCentrality", invokingInfo);
        return this.closenessCentralityUnitLength(g, cc);
    }

    protected <ID> Pair<VertexProperty<ID, Double>, VertexProperty<ID, Double>> hits(Map<String, Object> params) throws ExecutionException, InterruptedException {
        HitsArguments defaults = Arguments.HITS;
        params = defaults.parseArguments(params);
        PgxGraph g = (PgxGraph)this.getFromArguments(params, "graph");
        Integer max = (Integer)this.getFromArguments(params, "max");
        VertexProperty auth = (VertexProperty)this.getFromArguments(params, "authority");
        VertexProperty hubs = (VertexProperty)this.getFromArguments(params, "hubs");
        String propertyAuthName = (String)this.getFromArguments(params, "authorityPropertyName", "");
        String propertyHubsName = (String)this.getFromArguments(params, "hubsPropertyName", "");
        this.validateRequiredArguments("graph", g);
        if (max == null) {
            max = 100;
        }
        auth = this.propertyValidation(auth, PropertyType.DOUBLE, g, propertyAuthName, "authority", 0);
        hubs = this.propertyValidation(hubs, PropertyType.DOUBLE, g, propertyHubsName, "hubs", 0);
        List<String> invokingInfo = this.createInvokationDescription(this.wrapUp("graph", g.getName()), this.wrapUp("max", max.toString()), this.wrapUp("auth", auth.getName()), this.wrapUp("hubs", hubs.getName()));
        this.logInvokation("hits", invokingInfo);
        return this.hits(g, max, auth, hubs);
    }

    protected <ID> VertexProperty<ID, Double> eigenvectorCentrality(Map<String, Object> params) throws ExecutionException, InterruptedException {
        EigenvectorCentralityArguments defaults = Arguments.EIGEN_VECTOR;
        params = defaults.parseArguments(params);
        PgxGraph g = (PgxGraph)this.getFromArguments(params, "graph");
        int max = (Integer)this.getFromArguments(params, "maxIterations", 100);
        BigDecimal maxDiff = (BigDecimal)this.getFromArguments(params, "maxDifference", BigDecimal.valueOf(0.001));
        boolean useL2Norm = (Boolean)this.getFromArguments(params, "useL2Norm", false);
        boolean useInEdge = (Boolean)this.getFromArguments(params, "useInEdge", false);
        VertexProperty ec = (VertexProperty)this.getFromArguments(params, "eigenvectorCentrality");
        String propertyName = (String)this.getFromArguments(params, "eigenvectorCentralityPropertyName", "");
        this.validateRequiredArguments("graph", g);
        ec = this.propertyValidation(ec, PropertyType.DOUBLE, g, propertyName, "eigenvector", 0);
        List<String> invokingInfo = this.createInvokationDescription(this.wrapUp("graph", g.getName()), this.wrapUp("maxIterations", String.valueOf(max)), this.wrapUp("maxDifference", maxDiff.toString()), this.wrapUp("useL2Norm", String.valueOf(useL2Norm)), this.wrapUp("useInEdge", String.valueOf(useInEdge)), this.wrapUp("eigenvenctorCentrality", ec.getName()));
        this.logInvokation("eigenVenctor Centrality", invokingInfo);
        return this.eigenvectorCentrality(g, max, maxDiff, useL2Norm, useInEdge, ec);
    }

    protected <ID> VertexProperty<ID, Integer> degreeCentrality(Map<String, Object> params) throws ExecutionException, InterruptedException {
        DegreeCentralityArguments defaults = Arguments.DEGREE_CENTRALITY;
        params = defaults.parseArguments(params);
        PgxGraph g = (PgxGraph)this.getFromArguments(params, "graph");
        Direction direction = (Direction)this.getFromArguments(params, "direction", Direction.BOTH, Direction.class);
        VertexProperty dc = (VertexProperty)this.getFromArguments(params, "degreeCentrality");
        String propertyName = (String)this.getFromArguments(params, "degreeCentralityPropertyName", "");
        this.validateRequiredArguments("graph", g);
        dc = this.propertyValidation(dc, PropertyType.INTEGER, g, propertyName, Arguments.DEGREE_CENTRALITY.getDefaultName(direction), 0);
        List<String> invokingInfo = this.createInvokationDescription(this.wrapUp("graph", g.getName()), this.wrapUp("degreeCentrality", dc.getName()));
        switch (direction) {
            case INCOMING: {
                this.logInvokation("inDegree Centrality", invokingInfo);
                return this.inDegreeCentrality(g, dc);
            }
            case OUTGOING: {
                this.logInvokation("outDegree Centrality", invokingInfo);
                return this.outDegreeCentrality(g, dc);
            }
        }
        this.logInvokation("degree Centrality", invokingInfo);
        return this.degreeCentrality(g, dc);
    }

    protected EdgeProperty<Double> adamicAdarCounting(Map<String, Object> params) throws ExecutionException, InterruptedException {
        AdamicAdarArguments defaults = Arguments.ADAMIC_ADAR;
        params = defaults.parseArguments(params);
        PgxGraph g = (PgxGraph)this.getFromArguments(params, "graph");
        EdgeProperty<Double> aa = (EdgeProperty<Double>)this.getFromArguments(params, "adamicAdar");
        String propertyName = (String)this.getFromArguments(params, "adamicAdarPropertyName", "");
        this.validateRequiredArguments("graph", g);
        if (aa != null && !propertyName.isEmpty()) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"ARGUMENT_CANNOT_BE_COMBINED", (Object[])new Object[]{"outName", "edgeProperty"}));
        }
        if (aa == null) {
            if (propertyName.isEmpty()) {
                propertyName = "adamic_adar";
            }
            aa = g.createEdgeProperty(PropertyType.DOUBLE, 0, propertyName, false);
        }
        List<String> invokingInfo = this.createInvokationDescription(this.wrapUp("graph", g.getName()), this.wrapUp("adamicAdar", aa.getName()));
        this.logInvokation("adamicAdar", invokingInfo);
        return this.adamicAdarCounting(g, aa);
    }

    protected <ID> Partition<ID> communities(Map<String, Object> params) throws ExecutionException, InterruptedException {
        if (params == null) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"PARAMETER_IS_REQUIRED", (Object[])new Object[]{"map"}));
        }
        CommunitiesArguments defaults = Arguments.COMMUNITIES;
        params = defaults.parseArguments(params);
        PgxGraph g = (PgxGraph)this.getFromArguments(params, "graph");
        BigDecimal tau = (BigDecimal)this.getFromArguments(params, "tau", BigDecimal.valueOf(0.15));
        BigDecimal tol = (BigDecimal)this.getFromArguments(params, "tol", BigDecimal.valueOf(1.0E-4));
        int maxIterations = (Integer)this.getFromArguments(params, "maxIterations", 100);
        CommunitiesArguments.CommunitiesVariant variant = (CommunitiesArguments.CommunitiesVariant)((Object)this.getFromArguments(params, "variant", (Object)CommunitiesArguments.CommunitiesVariant.CONDUCTANCE_MINIMIZATION, CommunitiesArguments.CommunitiesVariant.class));
        VertexProperty rank = (VertexProperty)this.getFromArguments(params, "rank");
        EdgeProperty weight = (EdgeProperty)this.getFromArguments(params, "weight");
        VertexProperty partitionDistribution = (VertexProperty)this.getFromArguments(params, "partitionDistribution");
        String propertyName = (String)this.getFromArguments(params, "communitiesPartitionName", "");
        this.validateRequiredArguments("graph", g);
        if (variant == CommunitiesArguments.CommunitiesVariant.INFOMAP) {
            this.validateRequiredArguments("rank", rank);
            this.validateRequiredArguments("weight", weight);
        }
        partitionDistribution = this.propertyValidation(partitionDistribution, PropertyType.LONG, g, propertyName, Arguments.COMMUNITIES.getDefaultName(variant), 0);
        List<String> invokingInfo = this.createInvokationDescription(this.wrapUp("graph", g.getName()), this.wrapUp("maxIterations", String.valueOf(maxIterations)), this.wrapUp("partitionDistribution", partitionDistribution.getName()));
        switch (variant) {
            case LABEL_PROPAGATION: {
                this.logInvokation("labelPropagation", invokingInfo);
                return this.communitiesLabelPropagation(g, maxIterations, partitionDistribution);
            }
            case INFOMAP: {
                invokingInfo.add(this.wrapUp("rank", rank.getName()));
                invokingInfo.add(this.wrapUp("weight", weight.getName()));
                invokingInfo.add(this.wrapUp("tau", tau.toString()));
                invokingInfo.add(this.wrapUp("tol", tol.toString()));
                this.logInvokation("infomap", invokingInfo);
                return this.communitiesInfomap(g, rank, (EdgeProperty<Double>)weight, tau, tol, maxIterations, partitionDistribution);
            }
        }
        this.logInvokation("conductanceMinimization", invokingInfo);
        return this.communitiesConductanceMinimization(g, maxIterations, partitionDistribution);
    }

    protected <ID> Scalar<Double> conductance(Map<String, Object> params) throws ExecutionException, InterruptedException {
        ConductanceArguments defaults = Arguments.CONDUCTANCE;
        params = defaults.parseArguments(params);
        PgxGraph g = (PgxGraph)this.getFromArguments(params, "graph");
        Partition partition = (Partition)this.getFromArguments(params, "partition");
        Long value = params.getOrDefault("partitionIndex", null);
        Long partitionIndex = value = value != null ? Long.valueOf(String.valueOf(value)) : value;
        Scalar<Double> conductance = (Scalar<Double>)this.getFromArguments(params, "conductance");
        Scalar minConductance = (Scalar)this.getFromArguments(params, "minConductance");
        String conductanceName = (String)this.getFromArguments(params, "conductanceScalarName", "");
        this.validateRequiredArguments("graph", g);
        this.validateRequiredArguments("partition", partition);
        if (partitionIndex == null && minConductance == null) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"PARAMETER_IS_REQUIRED_WHEN", (Object[])new Object[]{"minConductance", "partitionIndex is not a parameter (is null)"}));
        }
        conductance = this.scalarValidation(conductance, PropertyType.DOUBLE, g, conductanceName, Arguments.CONDUCTANCE.getDefaultConductanceName(partitionIndex));
        List<String> invokingInfo = this.createInvokationDescription(this.wrapUp("graph", g.getName()), this.wrapUp("partition", partition.toString()), this.wrapUp("conductance", conductance.getName()));
        if (partitionIndex == null) {
            invokingInfo.add(this.wrapUp("minConductance", minConductance.getName()));
            this.logInvokation("partitionConductance", invokingInfo);
            return (Scalar)this.partitionConductance(g, partition, conductance, minConductance).getFirst();
        }
        if (minConductance != null) {
            LOG.info("argument minConductance will be ignored. Do not use partitionIndex if you want to use minConductance");
        }
        invokingInfo.add(this.wrapUp("partitionIndex", partitionIndex.toString()));
        this.logInvokation("conductance", invokingInfo);
        return this.conductance(g, partition, partitionIndex, conductance);
    }

    protected <ID> Scalar<Double> partitionModularity(Map<String, Object> params) throws ExecutionException, InterruptedException {
        PartitionModularityArguments defaults = Arguments.PARTITION_MODULARITY;
        params = defaults.parseArguments(params);
        PgxGraph g = (PgxGraph)this.getFromArguments(params, "graph");
        Partition partition = (Partition)this.getFromArguments(params, "partition");
        Scalar<Double> modularity = (Scalar<Double>)this.getFromArguments(params, "modularity");
        String modularityName = (String)this.getFromArguments(params, "modularityScalarName", "");
        this.validateRequiredArguments("graph", g);
        this.validateRequiredArguments("partition", partition);
        modularity = this.scalarValidation(modularity, PropertyType.DOUBLE, g, modularityName, PartitionModularityArguments.DEFAULT_NAME);
        List<String> invokingInfo = this.createInvokationDescription(this.wrapUp("graph", g.getName()), this.wrapUp("partition", partition.toString()), this.wrapUp("modularity", modularity.getName()));
        this.logInvokation("partitionModularity", invokingInfo);
        return this.partitionModularity(g, partition, modularity);
    }

    protected <ID> Partition<ID> scc(Map<String, Object> params) throws ExecutionException, InterruptedException {
        if (params == null) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"PARAMETER_IS_REQUIRED", (Object[])new Object[]{"map"}));
        }
        SccArguments defaults = Arguments.SCC;
        params = defaults.parseArguments(params);
        PgxGraph g = (PgxGraph)this.getFromArguments(params, "graph");
        SccArguments.SccVariant variant = (SccArguments.SccVariant)((Object)this.getFromArguments(params, "variant", (Object)SccArguments.SccVariant.DEFAULT, SccArguments.SccVariant.class));
        VertexProperty partitionDistribution = (VertexProperty)this.getFromArguments(params, "partitionDistribution");
        String propertyName = (String)this.getFromArguments(params, "partitionDistributionName", "");
        this.validateRequiredArguments("graph", g);
        partitionDistribution = this.propertyValidation(partitionDistribution, PropertyType.LONG, g, propertyName, Arguments.SCC.getDefaultName(variant), 0);
        List<String> invokingInfo = this.createInvokationDescription(this.wrapUp("graph", g.getName()), this.wrapUp("partitionDistribution", partitionDistribution.getName()));
        switch (variant) {
            case TARJAN: {
                this.logInvokation("tarjan", invokingInfo);
                return this.sccKosaraju(g, partitionDistribution);
            }
        }
        this.logInvokation("kosaraju", invokingInfo);
        return this.sccKosaraju(g, partitionDistribution);
    }

    protected <ID> Partition<ID> wcc(Map<String, Object> params) throws ExecutionException, InterruptedException {
        WccArguments defaults = Arguments.WCC;
        params = defaults.parseArguments(params);
        PgxGraph g = (PgxGraph)this.getFromArguments(params, "graph");
        VertexProperty partitionDistribution = (VertexProperty)this.getFromArguments(params, "partitionDistribution");
        String propertyName = (String)this.getFromArguments(params, "partitionDistributionName", "");
        this.validateRequiredArguments("graph", g);
        partitionDistribution = this.propertyValidation(partitionDistribution, PropertyType.LONG, g, propertyName, "wcc", 0);
        List<String> invokingInfo = this.createInvokationDescription(this.wrapUp("graph", g.getName()), this.wrapUp("partitionDistribution", partitionDistribution.getName()));
        this.logInvokation("wcc", invokingInfo);
        return this.wcc(g, partitionDistribution);
    }

    protected <ID> VertexProperty<ID, Double> salsa(Map<String, Object> params) throws ExecutionException, InterruptedException {
        SalsaArguments defaults = Arguments.SALSA;
        params = defaults.parseArguments(params);
        BipartiteGraph g = (BipartiteGraph)this.getFromArguments(params, "graph");
        SalsaArguments.SalsaVariant variant = (SalsaArguments.SalsaVariant)((Object)this.getFromArguments(params, "variant", (Object)SalsaArguments.SalsaVariant.DEFAULT, SalsaArguments.SalsaVariant.class));
        VertexSet vertices = (VertexSet)this.getFromArguments(params, "vertices");
        PgxVertex vertex = (PgxVertex)this.getFromArguments(params, "vertex");
        BigDecimal d = (BigDecimal)this.getFromArguments(params, "dampingFactor");
        int maxIterations = (Integer)this.getFromArguments(params, "maxIterations", 100);
        BigDecimal maxDiff = (BigDecimal)this.getFromArguments(params, "maxDifference", BigDecimal.valueOf(0.001));
        VertexProperty salsaRank = (VertexProperty)this.getFromArguments(params, "salsaRank");
        String propertyName = (String)this.getFromArguments(params, "salsaRankPropertyName", "");
        this.validateRequiredArguments("graph", g);
        if (variant == SalsaArguments.SalsaVariant.PERSONALIZED) {
            if (d == null) {
                d = BigDecimal.valueOf(0.85);
            }
            if (params.containsKey("vertex") && params.containsKey("vertices")) {
                throw new IllegalArgumentException(ErrorMessages.getMessage((String)"ARGUMENT_CANNOT_BE_COMBINED", (Object[])new Object[]{"vertex", "vertices"}));
            }
            if (params.keySet().contains("vertices")) {
                this.validateRequiredArguments("vertices", vertices);
            } else if (params.keySet().contains("vertex")) {
                this.validateRequiredArguments("vertex", vertex);
            } else {
                throw new IllegalArgumentException(ErrorMessages.getMessage((String)"EXCLUSIVE_ARGUMENT_IS_REQUIRED", (Object[])new Object[]{"vertex", "vertices"}));
            }
        }
        salsaRank = this.propertyValidation(salsaRank, PropertyType.DOUBLE, g, propertyName, Arguments.SALSA.getDefaultName(variant), 0);
        List<String> invokingInfo = this.createInvokationDescription(this.wrapUp("graph", g.getName()), this.wrapUp("maxDiff", maxDiff.toString()), this.wrapUp("maxIterations", String.valueOf(maxIterations)), this.wrapUp("salsaRank", salsaRank.getName()));
        switch (variant) {
            case PERSONALIZED: {
                if (vertices != null) {
                    invokingInfo.add(this.wrapUp("vertices", vertices.getName()));
                    this.logInvokation("salsa personalized", invokingInfo);
                    return this.personalizedSalsa(g, vertices, d, maxIterations, maxDiff, salsaRank);
                }
                invokingInfo.add(this.wrapUp("vertex", vertex.toString()));
                this.logInvokation("salsa personalized", invokingInfo);
                return this.personalizedSalsa(g, vertex, d, maxIterations, maxDiff, salsaRank);
            }
        }
        if (d != null) {
            LOG.info("argument \"damping factor\" will be ignored. Use variation:\"personalized\" to use this arg");
        }
        if (vertices != null) {
            LOG.info("argument vertices will be ignored. Use variation:\"personalized\" to use this arg");
        }
        if (vertex != null) {
            LOG.info("argument vertex will be ignored. Use variation:\"personalized\" to use this arg");
        }
        this.logInvokation("salsa", invokingInfo);
        return this.salsa(g, maxDiff, maxIterations, salsaRank);
    }

    protected <ID> Pair<VertexSequence<ID>, VertexSequence<ID>> whomToFollow(Map<String, Object> params) throws ExecutionException, InterruptedException {
        WhomToFollowArguments defaults = Arguments.WTF;
        params = defaults.parseArguments(params);
        PgxGraph g = (PgxGraph)this.getFromArguments(params, "graph");
        PgxVertex vertex = (PgxVertex)this.getFromArguments(params, "vertex");
        int topK = (Integer)this.getFromArguments(params, "topK", 100);
        int sizeCircleOfTrust = (Integer)this.getFromArguments(params, "sizeCircleOfTrust", 500);
        int maxIter = (Integer)this.getFromArguments(params, "maxIterations", 100);
        BigDecimal tol = (BigDecimal)this.getFromArguments(params, "tolerance", BigDecimal.valueOf(0.001));
        BigDecimal dampingFactor = (BigDecimal)this.getFromArguments(params, "dampingFactor", BigDecimal.valueOf(0.85));
        int salsaMaxIter = (Integer)this.getFromArguments(params, "salsaMaxIterations", 100);
        BigDecimal salsaTol = (BigDecimal)this.getFromArguments(params, "salsaTolerance", BigDecimal.valueOf(0.001));
        VertexSequence<ID> hubs = (VertexSequence<ID>)this.getFromArguments(params, "hubs");
        VertexSequence<ID> authorities = (VertexSequence<ID>)this.getFromArguments(params, "authorities");
        String hubsName = (String)this.getFromArguments(params, "hubsSequenceName", "");
        String authoritiesName = (String)this.getFromArguments(params, "authoritiesSequenceName", "");
        this.validateRequiredArguments("graph", g);
        this.validateRequiredArguments("vertex", vertex);
        hubs = this.vertexSequenceValidation(hubs, g, hubsName, WhomToFollowArguments.NAME_HUBS);
        authorities = this.vertexSequenceValidation(authorities, g, authoritiesName, WhomToFollowArguments.NAME_AUTHORITIES);
        List<String> invokingInfo = this.createInvokationDescription(this.wrapUp("graph", g.getName()), this.wrapUp("vertex", vertex.toString()), this.wrapUp("topK", String.valueOf(topK)), this.wrapUp("sizeCircleOfTrust", String.valueOf(sizeCircleOfTrust)), this.wrapUp("maxIterations", String.valueOf(maxIter)), this.wrapUp("tolerance", String.valueOf(tol)), this.wrapUp("dampingFactor", String.valueOf(dampingFactor)), this.wrapUp("salsaMaxIterations", String.valueOf(salsaMaxIter)), this.wrapUp("salsaTolerance", String.valueOf(salsaTol)), this.wrapUp("hubs", hubs.getName()), this.wrapUp("authorities", authorities.getName()));
        this.logInvokation("whom to follow", invokingInfo);
        return this.whomToFollow(g, vertex, topK, sizeCircleOfTrust, maxIter, tol, dampingFactor, salsaMaxIter, salsaTol, hubs, authorities);
    }

    protected <ID> MatrixFactorizationModel<ID> matrixFactorizationGradientDescent(Map<String, Object> params) throws ExecutionException, InterruptedException {
        MatrixFactorizationArguments defaults = Arguments.MATRIX_FACTORIZATION;
        params = defaults.parseArguments(params);
        BipartiteGraph g = (BipartiteGraph)this.getFromArguments(params, "graph");
        EdgeProperty weight = (EdgeProperty)this.getFromArguments(params, "weight");
        BigDecimal learningRate = (BigDecimal)this.getFromArguments(params, "learningRate", BigDecimal.valueOf(0.1));
        BigDecimal changePerStep = (BigDecimal)this.getFromArguments(params, "changePerStep", BigDecimal.valueOf(0.9));
        BigDecimal lambda = (BigDecimal)this.getFromArguments(params, "lambda", BigDecimal.valueOf(0.1));
        int maxStep = (Integer)this.getFromArguments(params, "maxStep", 100);
        int vectorLength = (Integer)this.getFromArguments(params, "vectorLength", -1);
        VertexProperty features = (VertexProperty)this.getFromArguments(params, "features");
        String featuresName = (String)this.getFromArguments(params, "featuresModelName", "");
        this.validateRequiredArguments("graph", g);
        this.validateRequiredArguments("weight", weight);
        if (vectorLength != -1 && features != null) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"ARGUMENT_CANNOT_BE_COMBINED", (Object[])new Object[]{"vectorLength", "features"}));
        }
        if (vectorLength == -1) {
            vectorLength = 20;
        }
        features = this.propertyValidation(features, PropertyType.DOUBLE, g, featuresName, "matrix_factorization", vectorLength);
        List<String> invokingInfo = this.createInvokationDescription(this.wrapUp("graph", g.getName()), this.wrapUp("weight", weight.getName()), this.wrapUp("learningRate", learningRate.toString()), this.wrapUp("changePerStep", changePerStep.toString()), this.wrapUp("lambda", lambda.toString()), this.wrapUp("maxStep", String.valueOf(maxStep)), this.wrapUp("vectorLength", String.valueOf(vectorLength)), this.wrapUp("features", features.getName()));
        this.logInvokation("matrix Factorization", invokingInfo);
        return this.matrixFactorizationGradientDescent(g, (EdgeProperty<Double>)weight, learningRate, changePerStep, lambda, maxStep, vectorLength, features);
    }

    protected <ID> AllPaths<ID> fattestPath(Map<String, Object> params) throws ExecutionException, InterruptedException {
        FattestPathArguments defaults = Arguments.FATTEST_PATH;
        params = defaults.parseArguments(params);
        PgxGraph g = (PgxGraph)this.getFromArguments(params, "graph");
        PgxVertex root = (PgxVertex)this.getFromArguments(params, "root");
        EdgeProperty capacity = (EdgeProperty)this.getFromArguments(params, "capacity");
        VertexProperty distance = (VertexProperty)this.getFromArguments(params, "distance");
        VertexProperty parent = (VertexProperty)this.getFromArguments(params, "parent");
        VertexProperty parentEdge = (VertexProperty)this.getFromArguments(params, "parentEdge");
        String distanceName = (String)this.getFromArguments(params, "distancePropertyName", "");
        String parentName = (String)this.getFromArguments(params, "parentPropertyName", "");
        String parentEdgeName = (String)this.getFromArguments(params, "parentEdgePropertyName", "");
        this.validateRequiredArguments("graph", g);
        this.validateRequiredArguments("root", root);
        this.validateRequiredArguments("capacity", capacity);
        distance = this.propertyValidation(distance, PropertyType.DOUBLE, g, distanceName, "fattest_path_distance", 0);
        parent = this.propertyValidation(parent, PropertyType.VERTEX, g, parentName, "fattest_path_parent", 0);
        parentEdge = this.propertyValidation(parentEdge, PropertyType.EDGE, g, parentEdgeName, "fattest_path_parent_edge", 0);
        List<String> invokingInfo = this.createInvokationDescription(this.wrapUp("graph", g.getName()), this.wrapUp("root", root.toString()), this.wrapUp("capacity", capacity.getName()), this.wrapUp("distance", distance.getName()), this.wrapUp("parent", parent.getName()), this.wrapUp("parentEdge", parentEdge.getName()));
        this.logInvokation("fattest path", invokingInfo);
        return this.fattestPath(g, root, (EdgeProperty<Double>)capacity, distance, parent, parentEdge);
    }

    protected <ID> PgxPath<ID> shortestPathDijkstra(Map<String, Object> params) throws ExecutionException, InterruptedException {
        DijkstraArguments defaults = Arguments.DIJKSTRA;
        params = defaults.parseArguments(params);
        PgxGraph g = (PgxGraph)this.getFromArguments(params, "graph");
        PgxVertex source = (PgxVertex)this.getFromArguments(params, "source");
        PgxVertex dst = (PgxVertex)this.getFromArguments(params, "dst");
        EdgeProperty cost = (EdgeProperty)this.getFromArguments(params, "cost");
        DijkstraArguments.DijkstraVariant variant = (DijkstraArguments.DijkstraVariant)((Object)this.getFromArguments(params, "variant", (Object)DijkstraArguments.DijkstraVariant.BIDIRECTIONAL, DijkstraArguments.DijkstraVariant.class));
        VertexProperty parent = (VertexProperty)this.getFromArguments(params, "parent");
        VertexProperty parentEdge = (VertexProperty)this.getFromArguments(params, "parentEdge");
        String parentName = (String)this.getFromArguments(params, "parentPropertyName", "");
        String parentEdgeName = (String)this.getFromArguments(params, "parentEdgePropertyName", "");
        GraphFilter filterExpr = (GraphFilter)this.getFromArguments(params, "filterExpression");
        this.validateRequiredArguments("graph", g);
        this.validateRequiredArguments("source", source);
        this.validateRequiredArguments("dst", dst);
        this.validateRequiredArguments("cost", cost);
        DefaultPathNaming pathNames = Arguments.DIJKSTRA.getDefaultName(variant);
        parent = this.propertyValidation(parent, PropertyType.VERTEX, g, parentName, pathNames.parentName, 0);
        parentEdge = this.propertyValidation(parentEdge, PropertyType.EDGE, g, parentEdgeName, pathNames.parentEdgeName, 0);
        List<String> invokingInfo = this.createInvokationDescription(this.wrapUp("graph", g.getName()), this.wrapUp("source", source.toString()), this.wrapUp("dst", dst.toString()), this.wrapUp("cost", cost.getName()), this.wrapUp("parent", parent.getName()), this.wrapUp("parentEdge", parentEdge.getName()));
        switch (variant) {
            case CLASSICAL: {
                if (filterExpr == null) {
                    this.logInvokation("dijkstra", invokingInfo);
                    return this.shortestPathDijkstra(g, source, dst, (EdgeProperty<Double>)cost, parent, parentEdge);
                }
                invokingInfo.add(this.wrapUp("filterExpression", filterExpr.toString()));
                this.logInvokation("dijkstra filtered", invokingInfo);
                return this.shortestPathFilteredDijkstra(g, source, dst, (EdgeProperty<Double>)cost, filterExpr, parent, parentEdge);
            }
        }
        if (filterExpr == null) {
            this.logInvokation("dijkstra bidirectional", invokingInfo);
            return this.shortestPathDijkstraBidirectional(g, source, dst, (EdgeProperty<Double>)cost, parent, parentEdge);
        }
        invokingInfo.add(this.wrapUp("filterExpression", filterExpr.toString()));
        this.logInvokation("dijkstra bidirectional filtered", invokingInfo);
        return this.shortestPathFilteredDijkstraBidirectional(g, source, dst, (EdgeProperty<Double>)cost, filterExpr, parent, parentEdge);
    }

    protected <ID> AllPaths<ID> shortestPathBellmanFord(Map<String, Object> params) throws ExecutionException, InterruptedException {
        BellmanFordArguments defaults = Arguments.BELLMAN_FORD;
        params = defaults.parseArguments(params);
        PgxGraph g = (PgxGraph)this.getFromArguments(params, "graph");
        PgxVertex source = (PgxVertex)this.getFromArguments(params, "source");
        EdgeProperty cost = (EdgeProperty)this.getFromArguments(params, "cost");
        Arguments.TraversalDirection traversalDirection = (Arguments.TraversalDirection)((Object)this.getFromArguments(params, "traversalDirection", (Object)Arguments.TraversalDirection.FORWARD, Arguments.TraversalDirection.class));
        VertexProperty distance = (VertexProperty)this.getFromArguments(params, "distance");
        VertexProperty parent = (VertexProperty)this.getFromArguments(params, "parent");
        VertexProperty parentEdge = (VertexProperty)this.getFromArguments(params, "parentEdge");
        String distanceName = (String)this.getFromArguments(params, "distancePropertyName", "");
        String parentName = (String)this.getFromArguments(params, "parentPropertyName", "");
        String parentEdgeName = (String)this.getFromArguments(params, "parentEdgePropertyName", "");
        this.validateRequiredArguments("graph", g);
        this.validateRequiredArguments("source", source);
        this.validateRequiredArguments("cost", cost);
        DefaultPathNaming pathNames = Arguments.BELLMAN_FORD.getDefaultName(traversalDirection);
        distance = this.propertyValidation(distance, PropertyType.DOUBLE, g, distanceName, pathNames.distance, 0);
        parent = this.propertyValidation(parent, PropertyType.VERTEX, g, parentName, pathNames.parentName, 0);
        parentEdge = this.propertyValidation(parentEdge, PropertyType.EDGE, g, parentEdgeName, pathNames.parentEdgeName, 0);
        List<String> invokingInfo = this.createInvokationDescription(this.wrapUp("graph", g.getName()), this.wrapUp("source", source.toString()), this.wrapUp("cost", cost.getName()), this.wrapUp("distance", distance.getName()), this.wrapUp("parent", parent.getName()), this.wrapUp("parentEdge", parentEdge.getName()));
        switch (traversalDirection) {
            case REVERSE: {
                this.logInvokation("bellman ford reverse", invokingInfo);
                return this.shortestPathBellmanFordReverse(g, source, (EdgeProperty<Double>)cost, distance, parent, parentEdge);
            }
        }
        this.logInvokation("bellman ford", invokingInfo);
        return this.shortestPathBellmanFord(g, source, (EdgeProperty<Double>)cost, distance, parent, parentEdge);
    }

    protected <ID> AllPaths<ID> shortestPathHopDist(Map<String, Object> params) throws ExecutionException, InterruptedException {
        HopDistArguments defaults = Arguments.HOP_DIST;
        params = defaults.parseArguments(params);
        PgxGraph g = (PgxGraph)this.getFromArguments(params, "graph");
        PgxVertex source = (PgxVertex)this.getFromArguments(params, "source");
        Arguments.TraversalDirection traversalDirection = (Arguments.TraversalDirection)((Object)this.getFromArguments(params, "traversalDirection", (Object)Arguments.TraversalDirection.FORWARD, Arguments.TraversalDirection.class));
        VertexProperty distance = (VertexProperty)this.getFromArguments(params, "distance");
        VertexProperty parent = (VertexProperty)this.getFromArguments(params, "parent");
        VertexProperty parentEdge = (VertexProperty)this.getFromArguments(params, "parentEdge");
        String distanceName = (String)this.getFromArguments(params, "distancePropertyName", "");
        String parentName = (String)this.getFromArguments(params, "parentPropertyName", "");
        String parentEdgeName = (String)this.getFromArguments(params, "parentEdgePropertyName", "");
        this.validateRequiredArguments("graph", g);
        this.validateRequiredArguments("source", source);
        DefaultPathNaming pathNames = Arguments.HOP_DIST.getDefaultName(traversalDirection);
        distance = this.propertyValidation(distance, PropertyType.DOUBLE, g, distanceName, pathNames.distance, 0);
        parent = this.propertyValidation(parent, PropertyType.VERTEX, g, parentName, pathNames.parentName, 0);
        parentEdge = this.propertyValidation(parentEdge, PropertyType.EDGE, g, parentEdgeName, pathNames.parentEdgeName, 0);
        List<String> invokingInfo = this.createInvokationDescription(this.wrapUp("graph", g.getName()), this.wrapUp("source", source.toString()), this.wrapUp("distance", distance.getName()), this.wrapUp("parent", parent.getName()), this.wrapUp("parentEdge", parentEdge.getName()));
        switch (traversalDirection) {
            case REVERSE: {
                this.logInvokation("hop dist reverse", invokingInfo);
                return this.shortestPathHopDist(g, source, distance, parent, parentEdge);
            }
        }
        this.logInvokation("hop dist", invokingInfo);
        return this.shortestPathHopDistReverse(g, source, distance, parent, parentEdge);
    }

    protected <ID> Pair<Scalar<Long>, VertexProperty<ID, Long>> kcore(Map<String, Object> params) throws ExecutionException, InterruptedException {
        KcoreArguments defaults = Arguments.KCORE;
        params = defaults.parseArguments(params);
        PgxGraph g = (PgxGraph)this.getFromArguments(params, "graph");
        int minCore = (Integer)this.getFromArguments(params, "minCore", 0);
        int maxCore = (Integer)this.getFromArguments(params, "maxCore", Integer.MAX_VALUE);
        Scalar<Long> maxKCore = (Scalar<Long>)this.getFromArguments(params, "maxKCore");
        VertexProperty kcore = (VertexProperty)this.getFromArguments(params, "kcore");
        String maxKCoreName = (String)this.getFromArguments(params, "maxKCoreScalarName", "");
        String kcoreName = (String)this.getFromArguments(params, "kcorePropertyName", "");
        this.validateRequiredArguments("graph", g);
        kcore = this.propertyValidation(kcore, PropertyType.LONG, g, kcoreName, KcoreArguments.KCORE_NAME, 0);
        maxKCore = this.scalarValidation(maxKCore, PropertyType.LONG, g, maxKCoreName, KcoreArguments.MAX_KCORE_NAME);
        List<String> invokingInfo = this.createInvokationDescription(this.wrapUp("graph", g.getName()), this.wrapUp("minCore", String.valueOf(minCore)), this.wrapUp("maxCore", String.valueOf(maxCore)), this.wrapUp("maxKCore", maxKCore.getName()), this.wrapUp("kcore", kcore.getName()));
        this.logInvokation("kcore", invokingInfo);
        return this.kcore(g, minCore, maxCore, maxKCore, kcore);
    }

    protected <ID> Pair<Scalar<Integer>, VertexProperty<ID, Integer>> diameter(Map<String, Object> params) throws ExecutionException, InterruptedException {
        DiameterArguments defaults = Arguments.DIAMETER;
        params = defaults.parseArguments(params);
        PgxGraph g = (PgxGraph)this.getFromArguments(params, "graph");
        Scalar<Integer> diameter = (Scalar<Integer>)this.getFromArguments(params, "diameter");
        VertexProperty eccentricity = (VertexProperty)this.getFromArguments(params, "eccentricity");
        String diameterName = (String)this.getFromArguments(params, "diameterScalarName", "");
        String eccentricityName = (String)this.getFromArguments(params, "eccentricityPropertyName", "");
        this.validateRequiredArguments("graph", g);
        eccentricity = this.propertyValidation(eccentricity, PropertyType.INTEGER, g, eccentricityName, "eccentricity", 0);
        diameter = this.scalarValidation(diameter, PropertyType.INTEGER, g, diameterName, DiameterArguments.DIAMETER_NAME);
        List<String> invokingInfo = this.createInvokationDescription(this.wrapUp("graph", g.getName()), this.wrapUp("diameter", diameter.getName()), this.wrapUp("eccentricity", eccentricity.getName()));
        this.logInvokation("diameter", invokingInfo);
        return this.diameter(g, diameter, eccentricity);
    }

    protected <ID> Pair<Scalar<Integer>, VertexProperty<ID, Integer>> radius(Map<String, Object> params) throws ExecutionException, InterruptedException {
        RadiusArguments defaults = Arguments.RADIUS;
        params = defaults.parseArguments(params);
        PgxGraph g = (PgxGraph)this.getFromArguments(params, "graph");
        Scalar<Integer> radius = (Scalar<Integer>)this.getFromArguments(params, "radius");
        VertexProperty eccentricity = (VertexProperty)this.getFromArguments(params, "eccentricity");
        String radiusName = (String)this.getFromArguments(params, "radiusScalarName", "");
        String eccentricityName = (String)this.getFromArguments(params, "eccentricityPropertyName", "");
        this.validateRequiredArguments("graph", g);
        eccentricity = this.propertyValidation(eccentricity, PropertyType.INTEGER, g, eccentricityName, "eccentricity", 0);
        radius = this.scalarValidation(radius, PropertyType.INTEGER, g, radiusName, RadiusArguments.RADIUS_NAME);
        List<String> invokingInfo = this.createInvokationDescription(this.wrapUp("graph", g.getName()), this.wrapUp("radius", radius.getName()), this.wrapUp("eccentricity", eccentricity.getName()));
        this.logInvokation("radius", invokingInfo);
        return this.radius(g, radius, eccentricity);
    }

    protected <ID> VertexSet<ID> periphery(Map<String, Object> params) throws ExecutionException, InterruptedException {
        PeripheryArguments defaults = Arguments.PERIPHERY;
        params = defaults.parseArguments(params);
        PgxGraph g = (PgxGraph)this.getFromArguments(params, "graph");
        VertexSet<ID> periphery = (VertexSet<ID>)this.getFromArguments(params, "periphery");
        String peripheryName = (String)this.getFromArguments(params, "peripherySetName", "");
        this.validateRequiredArguments("graph", g);
        periphery = this.vertexSetValidation(periphery, g, peripheryName, PeripheryArguments.PERIPHERY_NAME);
        List<String> invokingInfo = this.createInvokationDescription(this.wrapUp("graph", g.getName()), this.wrapUp("periphery", periphery.getName()));
        this.logInvokation("periphery", invokingInfo);
        return this.periphery(g, periphery);
    }

    protected <ID> VertexSet<ID> center(Map<String, Object> params) throws ExecutionException, InterruptedException {
        CenterArguments defaults = Arguments.CENTER;
        params = defaults.parseArguments(params);
        PgxGraph g = (PgxGraph)this.getFromArguments(params, "graph");
        VertexSet<ID> center = (VertexSet<ID>)this.getFromArguments(params, "center");
        String centerName = (String)this.getFromArguments(params, "centerSetName", "");
        this.validateRequiredArguments("graph", g);
        center = this.vertexSetValidation(center, g, centerName, CenterArguments.CENTER_NAME);
        List<String> invokingInfo = this.createInvokationDescription(this.wrapUp("graph", g.getName()), this.wrapUp("center", center.getName()));
        this.logInvokation("center", invokingInfo);
        return this.center(g, center);
    }

    protected <ID> VertexProperty<ID, Double> localClusteringCoefficient(Map<String, Object> params) throws ExecutionException, InterruptedException {
        LocalClusteringCoefficientArguments defaults = Arguments.LOCAL_CLUSTERING_COEFFICIENT;
        params = defaults.parseArguments(params);
        PgxGraph g = (PgxGraph)this.getFromArguments(params, "graph");
        VertexProperty lcc = (VertexProperty)this.getFromArguments(params, "localClusteringCoefficient");
        String lccName = (String)this.getFromArguments(params, "localClusteringCoefficientPropertyName", "");
        this.validateRequiredArguments("graph", g);
        lcc = this.propertyValidation(lcc, PropertyType.DOUBLE, g, lccName, "lcc", 0);
        List<String> invokingInfo = this.createInvokationDescription(this.wrapUp("graph", g.getName()), this.wrapUp("localClusteringCoefficient", lcc.getName()));
        this.logInvokation("localClusteringCoefficient", invokingInfo);
        return this.localClusteringCoefficient(g, lcc);
    }

    protected <ID> PgxPath<ID> findCycle(Map<String, Object> params) throws ExecutionException, InterruptedException {
        FindCycleArguments defaults = Arguments.FIND_CYCLE;
        params = defaults.parseArguments(params);
        PgxGraph g = (PgxGraph)this.getFromArguments(params, "graph");
        VertexSequence<ID> nodeSeq = (VertexSequence<ID>)this.getFromArguments(params, "nodeSequence");
        String nodeSeqName = (String)this.getFromArguments(params, "nodeSequenceName", "");
        EdgeSequence edgeSeq = (EdgeSequence)this.getFromArguments(params, "edgeSequence");
        String edgeSeqName = (String)this.getFromArguments(params, "edgeSequenceName", "");
        Object value = params.getOrDefault("vertex", null);
        PgxVertex vertex = value instanceof PgxVertex ? (PgxVertex)value : null;
        this.validateRequiredArguments("graph", g);
        nodeSeq = this.vertexSequenceValidation(nodeSeq, g, nodeSeqName, FindCycleArguments.DEFAULT_NODE_SEQUENCE_NAME);
        edgeSeq = this.edgeSequenceValidation(edgeSeq, g, edgeSeqName, FindCycleArguments.DEFAULT_EDGE_SEQUENCE_NAME);
        List<String> invokingInfo = this.createInvokationDescription(this.wrapUp("graph", g.getName()), this.wrapUp("nodeSeq", nodeSeq.getName()), this.wrapUp("edgeSeq", edgeSeq.getName()));
        if (vertex != null) {
            invokingInfo.add(this.wrapUp("vertex", vertex.toString()));
            this.logInvokation("findCycle", invokingInfo);
            return this.findCycle(g, vertex, nodeSeq, edgeSeq);
        }
        this.logInvokation("findCycle", invokingInfo);
        return this.findCycle(g, nodeSeq, edgeSeq);
    }

    protected <ID> Integer reachability(Map<String, Object> params) throws ExecutionException, InterruptedException {
        ReachabilityArguments defaults = Arguments.REACHABILITY;
        params = defaults.parseArguments(params);
        PgxGraph g = (PgxGraph)this.getFromArguments(params, "graph");
        PgxVertex source = (PgxVertex)this.getFromArguments(params, "source");
        PgxVertex dest = (PgxVertex)this.getFromArguments(params, "dest");
        Integer maxHops = (Integer)this.getFromArguments(params, "maxHops");
        Boolean ignoreEdgeDirection = (Boolean)this.getFromArguments(params, "ignoreEdgeDirection");
        this.validateRequiredArguments("graph", g);
        this.validateRequiredArguments("source", source);
        this.validateRequiredArguments("dest", dest);
        this.validateRequiredArguments("maxHops", maxHops);
        this.validateRequiredArguments("ignoreEdgeDirection", ignoreEdgeDirection);
        List<String> invokingInfo = this.createInvokationDescription(this.wrapUp("graph", g.getName()), this.wrapUp("source", source.toString()), this.wrapUp("dest", dest.toString()), this.wrapUp("maxHops", maxHops.toString()), this.wrapUp("ignoreEdgeDirection", ignoreEdgeDirection.toString()));
        this.logInvokation("reachability", invokingInfo);
        return this.reachability(g, source, dest, maxHops, ignoreEdgeDirection);
    }

    protected <ID> VertexProperty<ID, Integer> topologicalSort(Map<String, Object> params) throws ExecutionException, InterruptedException {
        TopologicalSortArguments defaults = Arguments.TOPOLOGICAL_SORT;
        params = defaults.parseArguments(params);
        PgxGraph g = (PgxGraph)this.getFromArguments(params, "graph");
        VertexSet source = (VertexSet)this.getFromArguments(params, "source");
        VertexProperty topoOrder = (VertexProperty)this.getFromArguments(params, "topoOrder");
        String topoOrderName = (String)this.getFromArguments(params, "topoOrderPropertyName", "");
        TopologicalSortArguments.TopologicalSortVariant variant = (TopologicalSortArguments.TopologicalSortVariant)((Object)this.getFromArguments(params, "variant", (Object)TopologicalSortArguments.TopologicalSortVariant.DEFAULT, TopologicalSortArguments.TopologicalSortVariant.class));
        this.validateRequiredArguments("graph", g);
        if (variant == TopologicalSortArguments.TopologicalSortVariant.SCHEDULE) {
            this.validateRequiredArguments("source", source);
        }
        topoOrder = this.propertyValidation(topoOrder, PropertyType.INTEGER, g, topoOrderName, Arguments.TOPOLOGICAL_SORT.getDefaultName(variant), 0);
        List<String> invokingInfo = this.createInvokationDescription(this.wrapUp("graph", g.getName()), this.wrapUp("topologicalSort", topoOrder.getName()));
        switch (variant) {
            case SCHEDULE: {
                invokingInfo.add(this.wrapUp("source", source.getName()));
                this.logInvokation("topological Schedule", invokingInfo);
                return this.topologicalSchedule(g, source, topoOrder);
            }
        }
        if (source != null) {
            LOG.info("argument source will be ignored. Use variant:\"SCHEDULE\" to use this arg");
        }
        this.logInvokation("topologicalSort", invokingInfo);
        return this.topologicalSort(g, topoOrder);
    }

    protected PgxMap<Integer, Long> degreeDistribution(Map<String, Object> params) throws ExecutionException, InterruptedException {
        DegreeDistributionArguments defaults = Arguments.DEGREE_DISTRIBUTION;
        params = defaults.parseArguments(params);
        PgxGraph g = (PgxGraph)this.getFromArguments(params, "graph");
        Direction degree = (Direction)this.getFromArguments(params, "degree", Direction.INCOMING, Direction.class);
        PgxMap<Integer, Long> distribution = (PgxMap<Integer, Long>)this.getFromArguments(params, "distribution");
        String distributionName = (String)this.getFromArguments(params, "distributionMapName", "");
        this.validateRequiredArguments("graph", g);
        if (degree == Direction.BOTH) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"UNSUPPORTED_DIRECTION", (Object[])new Object[]{"BOTH", "INCOMING", "OUTGOING"}));
        }
        if (distribution != null && !distributionName.isEmpty()) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"ARGUMENT_CANNOT_BE_COMBINED", (Object[])new Object[]{"distributionMapName", "distribution"}));
        }
        if (distribution == null) {
            if (distributionName.isEmpty()) {
                distributionName = Arguments.DEGREE_DISTRIBUTION.getDefaultName(degree);
            }
            distribution = g.createMap(PropertyType.INTEGER, PropertyType.LONG, distributionName);
        }
        List<String> invokingInfo = this.createInvokationDescription(this.wrapUp("graph", g.getName()), this.wrapUp("distribution", distribution.getName()));
        switch (degree) {
            case OUTGOING: {
                this.logInvokation("outDegree distribution", invokingInfo);
                return this.outDegreeDistribution(g, distribution);
            }
        }
        this.logInvokation("inDegree distribution", invokingInfo);
        return this.inDegreeDistribution(g, distribution);
    }

    protected <ID> Pair<VertexProperty<ID, Integer>, VertexProperty<ID, PgxVertex<ID>>> filteredBfs(Map<String, Object> params) throws ExecutionException, InterruptedException {
        BfsArguments defaults = Arguments.BFS;
        params = defaults.parseArguments(params);
        PgxGraph g = (PgxGraph)this.getFromArguments(params, "graph");
        boolean initWithInfinity = (Boolean)this.getFromArguments(params, "initWithInfinity", true);
        PgxVertex root = (PgxVertex)this.getFromArguments(params, "root");
        VertexFilter navigator = (VertexFilter)this.getFromArguments(params, "navigator");
        int maxDepth = (Integer)this.getFromArguments(params, "maxDepth", Integer.MAX_VALUE);
        VertexProperty distance = (VertexProperty)this.getFromArguments(params, "distance");
        VertexProperty parent = (VertexProperty)this.getFromArguments(params, "parent");
        String distanceName = (String)this.getFromArguments(params, "distancePropertyName", "");
        String parentName = (String)this.getFromArguments(params, "parentPropertyName", "");
        this.validateRequiredArguments("graph", g);
        this.validateRequiredArguments("root", root);
        if (navigator == null) {
            navigator = VertexFilter.ALL;
        }
        distance = this.propertyValidation(distance, PropertyType.INTEGER, g, distanceName, "distance", 0);
        parent = this.propertyValidation(parent, PropertyType.VERTEX, g, parentName, "parent", 0);
        List<String> invokingInfo = this.createInvokationDescription(this.wrapUp("graph", g.getName()), this.wrapUp("root", root.toString()), this.wrapUp("navigator", navigator.toString()), this.wrapUp("initWithInfinity", String.valueOf(initWithInfinity)), this.wrapUp("maxDepth", String.valueOf(maxDepth)), this.wrapUp("distance", distance.getName()), this.wrapUp("parent", parent.getName()));
        this.logInvokation("filtered bfs", invokingInfo);
        return this.filteredBfs(g, root, navigator, initWithInfinity, maxDepth, distance, parent);
    }

    protected <ID> Pair<VertexProperty<ID, Integer>, VertexProperty<ID, PgxVertex<ID>>> filteredDfs(Map<String, Object> params) throws ExecutionException, InterruptedException {
        BfsArguments defaults = Arguments.BFS;
        params = defaults.parseArguments(params);
        PgxGraph g = (PgxGraph)this.getFromArguments(params, "graph");
        boolean initWithInfinity = (Boolean)this.getFromArguments(params, "initWithInfinity", true);
        PgxVertex root = (PgxVertex)this.getFromArguments(params, "root");
        VertexFilter navigator = (VertexFilter)this.getFromArguments(params, "navigator");
        int maxDepth = (Integer)this.getFromArguments(params, "maxDepth", Integer.MAX_VALUE);
        VertexProperty distance = (VertexProperty)this.getFromArguments(params, "distance");
        VertexProperty parent = (VertexProperty)this.getFromArguments(params, "parent");
        String distanceName = (String)this.getFromArguments(params, "distancePropertyName", "");
        String parentName = (String)this.getFromArguments(params, "parentPropertyName", "");
        this.validateRequiredArguments("graph", g);
        this.validateRequiredArguments("root", root);
        if (navigator == null) {
            navigator = VertexFilter.ALL;
        }
        distance = this.propertyValidation(distance, PropertyType.INTEGER, g, distanceName, "distance", 0);
        parent = this.propertyValidation(parent, PropertyType.VERTEX, g, parentName, "parent", 0);
        List<String> invokingInfo = this.createInvokationDescription(this.wrapUp("graph", g.getName()), this.wrapUp("root", root.toString()), this.wrapUp("navigator", navigator.toString()), this.wrapUp("initWithInfinity", String.valueOf(initWithInfinity)), this.wrapUp("maxDepth", String.valueOf(maxDepth)), this.wrapUp("distance", distance.getName()), this.wrapUp("parent", parent.getName()));
        this.logInvokation("filtered DFS", invokingInfo);
        return this.filteredDfs(g, root, navigator, initWithInfinity, maxDepth, distance, parent);
    }

    protected EdgeProperty<Boolean> prim(Map<String, Object> params) throws ExecutionException, InterruptedException {
        PrimArguments defaults = Arguments.PRIM;
        params = defaults.parseArguments(params);
        PgxGraph g = (PgxGraph)this.getFromArguments(params, "graph");
        EdgeProperty weight = (EdgeProperty)this.getFromArguments(params, "weight");
        EdgeProperty<Boolean> mst = (EdgeProperty<Boolean>)this.getFromArguments(params, "mst");
        String propertyName = (String)this.getFromArguments(params, "mstPropertyName", "");
        this.validateRequiredArguments("graph", g);
        this.validateRequiredArguments("weight", weight);
        if (mst != null && !propertyName.isEmpty()) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"ARGUMENT_CANNOT_BE_COMBINED", (Object[])new Object[]{"outName", "edgeProperty"}));
        }
        if (mst == null) {
            if (propertyName.isEmpty()) {
                propertyName = "mst";
            }
            mst = g.createEdgeProperty(PropertyType.BOOLEAN, 0, propertyName, false);
        }
        List<String> invokingInfo = this.createInvokationDescription(this.wrapUp("graph", g.getName()), this.wrapUp("prim", mst.getName()));
        this.logInvokation("prim", invokingInfo);
        return this.prim(g, (EdgeProperty<Double>)weight, mst);
    }

    private <ID, R> VertexProperty<ID, R> propertyValidation(VertexProperty<ID, R> property, PropertyType propertyType, PgxGraph g, String propertyName, String defaultPropertyName, int dimension) throws ExecutionException, InterruptedException {
        boolean useHardName = true;
        if (property != null && !propertyName.isEmpty()) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"ARGUMENT_CANNOT_BE_COMBINED", (Object[])new Object[]{"outName", "vertexProperty"}));
        }
        if (property == null) {
            if (propertyName.isEmpty()) {
                propertyName = defaultPropertyName;
                useHardName = false;
            }
            VertexProperty newProperty = g.createVertexProperty(propertyType, dimension, propertyName, useHardName);
            this.addTransientObject(newProperty);
            return newProperty;
        }
        return property;
    }

    private <V> Scalar<V> scalarValidation(Scalar<V> scalar, PropertyType propertyType, PgxGraph g, String scalarName, String defaultscalarName) throws ExecutionException, InterruptedException {
        if (scalar != null && !scalarName.isEmpty()) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"ARGUMENT_CANNOT_BE_COMBINED", (Object[])new Object[]{"outName", "scalar"}));
        }
        if (scalar == null) {
            if (scalarName.isEmpty()) {
                scalarName = defaultscalarName;
            }
            Scalar newScalar = g.createScalar(propertyType, scalarName);
            this.addTransientObject(newScalar);
            return newScalar;
        }
        return scalar;
    }

    private <ID> EdgeSequence edgeSequenceValidation(EdgeSequence sequence, PgxGraph g, String sequenceName, String defaultsequenceName) throws ExecutionException, InterruptedException {
        if (sequence != null && !sequenceName.isEmpty()) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"ARGUMENT_CANNOT_BE_COMBINED", (Object[])new Object[]{"outName", "sequence"}));
        }
        if (sequence == null) {
            if (sequenceName.isEmpty()) {
                sequenceName = defaultsequenceName;
            }
            EdgeSequence newSequence = g.createEdgeSequence(sequenceName);
            this.addTransientObject(newSequence);
            return newSequence;
        }
        return sequence;
    }

    private <ID> VertexSequence<ID> vertexSequenceValidation(VertexSequence<ID> sequence, PgxGraph g, String sequenceName, String defaultsequenceName) throws ExecutionException, InterruptedException {
        if (sequence != null && !sequenceName.isEmpty()) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"ARGUMENT_CANNOT_BE_COMBINED", (Object[])new Object[]{"outName", "sequence"}));
        }
        if (sequence == null) {
            if (sequenceName.isEmpty()) {
                sequenceName = defaultsequenceName;
            }
            VertexSequence newSequence = g.createVertexSequence(sequenceName);
            this.addTransientObject(newSequence);
            return newSequence;
        }
        return sequence;
    }

    private <ID> VertexSet<ID> vertexSetValidation(VertexSet<ID> set, PgxGraph g, String setName, String defaultsetName) throws ExecutionException, InterruptedException {
        if (set != null && !setName.isEmpty()) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"ARGUMENT_CANNOT_BE_COMBINED", (Object[])new Object[]{"name", "set"}));
        }
        if (set == null) {
            if (setName.isEmpty()) {
                setName = defaultsetName;
            }
            VertexSet newSet = g.createVertexSet(setName);
            this.addTransientObject(newSet);
            return newSet;
        }
        return set;
    }
}

