/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import oracle.pgx.api.EdgeLabel;
import oracle.pgx.api.EdgeProperty;
import oracle.pgx.api.PgxGraph;
import oracle.pgx.api.VertexProperty;
import oracle.pgx.common.PgxId;
import oracle.pgx.common.mutations.MutationStrategy;
import oracle.pgx.common.util.ErrorMessages;

public abstract class MutationStrategyBuilder<B extends MutationStrategyBuilder<B>> {
    protected final PgxGraph graph;
    protected boolean noTrivialVertices = false;
    protected boolean inPlace = false;
    protected boolean noMultiEdges = true;
    protected boolean noSelfEdges = true;
    protected String newGraphName;
    protected Collection<PgxId> keptEdgeProperties;
    protected Collection<PgxId> keptVertexProperties;
    protected PgxId edgeLabelId;

    MutationStrategyBuilder(PgxGraph graph) throws ExecutionException, InterruptedException {
        this.graph = graph;
        this.keptEdgeProperties = new ArrayList<PgxId>();
        graph.getEdgeProperties().forEach(edgeProperty -> this.keptEdgeProperties.add(edgeProperty.getPropertyId()));
        this.keptVertexProperties = new ArrayList<PgxId>();
        graph.getVertexProperties().forEach(vertexProperty -> this.keptVertexProperties.add(vertexProperty.getPropertyId()));
        try {
            EdgeLabel edgeLabel = graph.getEdgeLabel();
            this.edgeLabelId = edgeLabel.getPropertyId();
        }
        catch (Exception e) {
            this.edgeLabelId = null;
        }
    }

    protected final B getThis() {
        return (B)this;
    }

    public B setNewGraphName(String newGraphName) {
        this.newGraphName = newGraphName;
        return this.getThis();
    }

    public B setCopyMode(PgxGraph.Mode mode) {
        this.inPlace = mode == PgxGraph.Mode.MUTATE_IN_PLACE;
        return this.getThis();
    }

    public B setTrivialVertices(PgxGraph.TrivialVertices trivialVertices) {
        this.noTrivialVertices = trivialVertices == PgxGraph.TrivialVertices.REMOVE_TRIVIAL_VERTICES;
        return this.getThis();
    }

    public B setSelfEdges(PgxGraph.SelfEdges selfEdges) {
        this.noSelfEdges = selfEdges == PgxGraph.SelfEdges.REMOVE_SELF_EDGES;
        return this.getThis();
    }

    public B setMultiEdges(PgxGraph.MultiEdges multiEdges) {
        this.noMultiEdges = multiEdges == PgxGraph.MultiEdges.REMOVE_MULTI_EDGES;
        return this.getThis();
    }

    public B setKeptVertexProperties(Collection<VertexProperty<?, ?>> propsToKeep) {
        this.keptVertexProperties.clear();
        propsToKeep.forEach(prop -> this.keptVertexProperties.add(prop.getPropertyId()));
        return this.getThis();
    }

    public B setKeptEdgeProperties(Collection<EdgeProperty<?>> propsToKeep) {
        this.keptEdgeProperties.clear();
        propsToKeep.forEach(prop -> this.keptEdgeProperties.add(prop.getPropertyId()));
        return this.getThis();
    }

    public B dropVertexProperty(VertexProperty<?, ?> vertexProperty) {
        this.keptVertexProperties.remove(vertexProperty.getPropertyId());
        return this.getThis();
    }

    public B dropEdgeProperty(EdgeProperty<?> edgeProperty) {
        this.keptEdgeProperties.remove(edgeProperty.getPropertyId());
        return this.getThis();
    }

    public B dropVertexProperties(Collection<VertexProperty<?, ?>> vertexProperties) {
        vertexProperties.forEach(vertexProperty -> this.keptVertexProperties.remove(vertexProperty.getPropertyId()));
        return this.getThis();
    }

    public B dropEdgeProperties(Collection<EdgeProperty<?>> edgeProperties) {
        edgeProperties.forEach(edgeProperty -> this.keptEdgeProperties.remove(edgeProperty.getPropertyId()));
        return this.getThis();
    }

    public abstract MutationStrategy build() throws ExecutionException, InterruptedException;

    protected void assertEdgePropertyExists(PgxId propertyName) {
        if (propertyName.equals((Object)this.edgeLabelId) || this.keptEdgeProperties.contains(propertyName)) {
            return;
        }
        throw new IllegalArgumentException(ErrorMessages.getMessage((String)"PROPERTY_NOT_FOUND", (Object[])new Object[]{propertyName}));
    }
}

