/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.function.Supplier;
import oracle.pgx.api.AllPaths;
import oracle.pgx.api.BipartiteGraph;
import oracle.pgx.api.Destroyable;
import oracle.pgx.api.EdgeProperty;
import oracle.pgx.api.EdgeSequence;
import oracle.pgx.api.EdgeSet;
import oracle.pgx.api.MatrixFactorizationModel;
import oracle.pgx.api.Partition;
import oracle.pgx.api.PgxEdge;
import oracle.pgx.api.PgxFuture;
import oracle.pgx.api.PgxGraph;
import oracle.pgx.api.PgxMap;
import oracle.pgx.api.PgxPath;
import oracle.pgx.api.PgxSession;
import oracle.pgx.api.PgxVect;
import oracle.pgx.api.PgxVertex;
import oracle.pgx.api.Scalar;
import oracle.pgx.api.ScalarSequence;
import oracle.pgx.api.SessionContext;
import oracle.pgx.api.VertexProperty;
import oracle.pgx.api.VertexSequence;
import oracle.pgx.api.VertexSet;
import oracle.pgx.api.filter.EdgeFilter;
import oracle.pgx.api.filter.GraphFilter;
import oracle.pgx.api.filter.PathFindingFilter;
import oracle.pgx.api.filter.VertexFilter;
import oracle.pgx.api.internal.BuiltinAlgorithms;
import oracle.pgx.api.internal.algorithm.arguments.Arguments;
import oracle.pgx.api.internal.algorithm.arguments.BetweennessCentralityArguments;
import oracle.pgx.api.internal.algorithm.arguments.CenterArguments;
import oracle.pgx.api.internal.algorithm.arguments.ClosenessCentralityArguments;
import oracle.pgx.api.internal.algorithm.arguments.CommunitiesArguments;
import oracle.pgx.api.internal.algorithm.arguments.ConductanceArguments;
import oracle.pgx.api.internal.algorithm.arguments.DefaultPathNaming;
import oracle.pgx.api.internal.algorithm.arguments.DiameterArguments;
import oracle.pgx.api.internal.algorithm.arguments.DijkstraArguments;
import oracle.pgx.api.internal.algorithm.arguments.FindCycleArguments;
import oracle.pgx.api.internal.algorithm.arguments.KcoreArguments;
import oracle.pgx.api.internal.algorithm.arguments.PagerankArguments;
import oracle.pgx.api.internal.algorithm.arguments.PartitionModularityArguments;
import oracle.pgx.api.internal.algorithm.arguments.PeripheryArguments;
import oracle.pgx.api.internal.algorithm.arguments.RadiusArguments;
import oracle.pgx.api.internal.algorithm.arguments.SalsaArguments;
import oracle.pgx.api.internal.algorithm.arguments.SccArguments;
import oracle.pgx.api.internal.algorithm.arguments.TopologicalSortArguments;
import oracle.pgx.api.internal.algorithm.arguments.WhomToFollowArguments;
import oracle.pgx.api.mllib.DeepWalkModel;
import oracle.pgx.api.mllib.DeepWalkModelBuilder;
import oracle.pgx.api.mllib.GenericModelLoader;
import oracle.pgx.api.mllib.GenericModelRepositoryBuilder;
import oracle.pgx.api.mllib.GraphWiseConvLayerConfigBuilder;
import oracle.pgx.api.mllib.GraphWiseDgiLayerConfigBuilder;
import oracle.pgx.api.mllib.GraphWisePredictionLayerConfigBuilder;
import oracle.pgx.api.mllib.Pg2vecModel;
import oracle.pgx.api.mllib.Pg2vecModelBuilder;
import oracle.pgx.api.mllib.SupervisedGraphWiseModel;
import oracle.pgx.api.mllib.SupervisedGraphWiseModelBuilder;
import oracle.pgx.api.mllib.UnsupervisedGraphWiseModel;
import oracle.pgx.api.mllib.UnsupervisedGraphWiseModelBuilder;
import oracle.pgx.common.ObjectHolder;
import oracle.pgx.common.Pair;
import oracle.pgx.common.types.Direction;
import oracle.pgx.common.types.PropertyType;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.config.mllib.ModelKind;
import org.apache.commons.lang3.tuple.Triple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Analyst
extends Destroyable {
    protected static final Logger LOG = LoggerFactory.getLogger(Analyst.class);
    private final PgxSession session;
    private final SessionContext sessionContext;
    private final BuiltinAlgorithms algorithms;
    private final List<Destroyable> transientData;

    protected Analyst(PgxSession session) {
        this.session = session;
        this.sessionContext = session.getSessionContext();
        this.algorithms = new BuiltinAlgorithms(session.getCore());
        this.transientData = new LinkedList<Destroyable>();
    }

    protected <ID> Object serializeVertex(PgxVertex<ID> v) {
        return v.serialize();
    }

    BuiltinAlgorithms getBuiltinAlgorithms() {
        return this.algorithms;
    }

    public PgxSession getSession() {
        return this.session;
    }

    public Pg2vecModel loadPg2vecModel(String path, String key) throws InterruptedException, ExecutionException {
        return (Pg2vecModel)this.loadPg2vecModel().file().path(path).key(key).load();
    }

    public GenericModelLoader<Pg2vecModel> loadPg2vecModel() {
        return new GenericModelLoader<Pg2vecModel>(this.session, this.session.getCore(), this.session::getKeystorePath, this.session::getKeystorePassword, ModelKind.PG2VEC, Pg2vecModel::new);
    }

    public Pg2vecModelBuilder pg2vecModelBuilder() {
        return new Pg2vecModelBuilder(this.session, this.session.getCore(), this.session::getKeystorePath, this.session::getKeystorePassword);
    }

    public DeepWalkModel loadDeepWalkModel(String path, String key) throws InterruptedException, ExecutionException {
        return (DeepWalkModel)this.loadDeepWalkModel().file().path(path).key(key).load();
    }

    public GenericModelLoader<DeepWalkModel> loadDeepWalkModel() {
        return new GenericModelLoader<DeepWalkModel>(this.session, this.session.getCore(), this.session::getKeystorePath, this.session::getKeystorePassword, ModelKind.DEEPWALK, DeepWalkModel::new);
    }

    public GenericModelRepositoryBuilder modelRepository() {
        return new GenericModelRepositoryBuilder(this.session, this.session.getCore(), this.session::getKeystorePath, this.session::getKeystorePassword);
    }

    public DeepWalkModelBuilder deepWalkModelBuilder() {
        return new DeepWalkModelBuilder(this.session, this.session.getCore(), this.session::getKeystorePath, this.session::getKeystorePassword);
    }

    public SupervisedGraphWiseModel loadSupervisedGraphWiseModel(String path, String key) throws InterruptedException, ExecutionException {
        return (SupervisedGraphWiseModel)this.loadSupervisedGraphWiseModel().file().path(path).key(key).load();
    }

    public GenericModelLoader<SupervisedGraphWiseModel> loadSupervisedGraphWiseModel() {
        return new GenericModelLoader<SupervisedGraphWiseModel>(this.session, this.session.getCore(), this.session::getKeystorePath, this.session::getKeystorePassword, ModelKind.SUPERVISED_GRAPHWISE, (session, core, keystorePathSupplier, keystorePasswordSupplier, modelMetadata) -> new SupervisedGraphWiseModel(session, core, (Supplier<String>)keystorePathSupplier, (Supplier<char[]>)keystorePasswordSupplier, PgxGraph::new, modelMetadata));
    }

    public SupervisedGraphWiseModelBuilder supervisedGraphWiseModelBuilder() {
        return new SupervisedGraphWiseModelBuilder(this.session, this.session.getCore(), this.session::getKeystorePath, this.session::getKeystorePassword, PgxGraph::new);
    }

    public GraphWiseConvLayerConfigBuilder graphWiseConvLayerConfigBuilder() {
        return new GraphWiseConvLayerConfigBuilder();
    }

    public GraphWiseDgiLayerConfigBuilder graphWiseDgiLayerConfigBuilder() {
        return new GraphWiseDgiLayerConfigBuilder();
    }

    public GraphWisePredictionLayerConfigBuilder graphWisePredictionLayerConfigBuilder() {
        return new GraphWisePredictionLayerConfigBuilder();
    }

    public UnsupervisedGraphWiseModel loadUnsupervisedGraphWiseModel(String path, String key) throws InterruptedException, ExecutionException {
        return (UnsupervisedGraphWiseModel)this.loadUnsupervisedGraphWiseModel().file().path(path).key(key).load();
    }

    public GenericModelLoader<UnsupervisedGraphWiseModel> loadUnsupervisedGraphWiseModel() {
        return new GenericModelLoader<UnsupervisedGraphWiseModel>(this.session, this.session.getCore(), this.session::getKeystorePath, this.session::getKeystorePassword, ModelKind.UNSUPERVISED_GRAPHWISE, (session, core, keystorePathSupplier, keystorePasswordSupplier, modelMetadata) -> new UnsupervisedGraphWiseModel(session, core, (Supplier<String>)keystorePathSupplier, (Supplier<char[]>)keystorePasswordSupplier, modelMetadata, PgxGraph::new));
    }

    public UnsupervisedGraphWiseModelBuilder unsupervisedGraphWiseModelBuilder() {
        return new UnsupervisedGraphWiseModelBuilder(this.session, this.session.getCore(), this.session::getKeystorePath, this.session::getKeystorePassword, PgxGraph::new);
    }

    public <ID> PgxFuture<VertexProperty<ID, Double>> pagerankAsync(PgxGraph graph) {
        return this.pagerankAsync(graph, 0.001, 0.85, 100);
    }

    public <ID> PgxFuture<VertexProperty<ID, Double>> pagerankAsync(PgxGraph graph, boolean norm) {
        return this.pagerankAsync(graph, 0.001, 0.85, 100, norm);
    }

    public <ID> PgxFuture<VertexProperty<ID, Double>> pagerankAsync(PgxGraph graph, double e, double d, int max) {
        return this.pagerankAsync(graph, e, d, max, Arguments.PAGERANK.getDefaultName(PagerankArguments.PagerankVariant.DEFAULT));
    }

    protected <ID> PgxFuture<VertexProperty<ID, Double>> pagerankAsync(PgxGraph graph, double e, double d, int max, String propertyName) {
        return this.vertexCentralityAnalysis(graph, rank -> this.pagerankAsync(graph, e, d, max, (VertexProperty)rank), PropertyType.DOUBLE, propertyName);
    }

    public <ID> PgxFuture<VertexProperty<ID, Double>> pagerankAsync(PgxGraph graph, double e, double d, int max, boolean norm) {
        return this.pagerankAsync(graph, e, d, max, norm, Arguments.PAGERANK.getDefaultName(PagerankArguments.PagerankVariant.DEFAULT));
    }

    protected <ID> PgxFuture<VertexProperty<ID, Double>> pagerankAsync(PgxGraph graph, double e, double d, int max, boolean norm, String propertyName) {
        return this.vertexCentralityAnalysis(graph, rank -> this.pagerankAsync(graph, e, d, max, norm, (VertexProperty)rank), PropertyType.DOUBLE, propertyName);
    }

    public <ID> PgxFuture<VertexProperty<ID, Double>> pagerankAsync(PgxGraph graph, VertexProperty<ID, Double> rank) {
        return this.pagerankAsync(graph, 0.001, 0.85, 100, rank);
    }

    public <ID> PgxFuture<VertexProperty<ID, Double>> pagerankAsync(PgxGraph graph, boolean norm, VertexProperty<ID, Double> rank) {
        return this.pagerankAsync(graph, 0.001, 0.85, 100, norm, rank);
    }

    public <ID> PgxFuture<VertexProperty<ID, Double>> pagerankAsync(PgxGraph graph, double e, double d, int max, VertexProperty<ID, Double> rank) {
        PgxFuture promise = new PgxFuture();
        return ((PgxFuture)this.algorithms.pgxBuiltinK1aPagerank(this.sessionContext, graph.getId(), e, d, max, false, rank.getPropertyId()).cancelOn(promise).thenApply(result -> rank)).thenComplete(promise);
    }

    public <ID> PgxFuture<VertexProperty<ID, Double>> pagerankAsync(PgxGraph graph, double e, double d, int max, boolean norm, VertexProperty<ID, Double> rank) {
        PgxFuture promise = new PgxFuture();
        return ((PgxFuture)this.algorithms.pgxBuiltinK1aPagerank(this.sessionContext, graph.getId(), e, d, max, norm, rank.getPropertyId()).cancelOn(promise).thenApply(result -> rank)).thenComplete(promise);
    }

    public <ID> PgxFuture<VertexProperty<ID, Double>> pagerankApproximateAsync(PgxGraph graph) {
        return this.pagerankApproximateAsync(graph, 0.001, 0.85, 100);
    }

    public <ID> PgxFuture<VertexProperty<ID, Double>> pagerankApproximateAsync(PgxGraph graph, double e, double d, int max) {
        return this.pagerankApproximateAsync(graph, e, d, max, Arguments.PAGERANK.getDefaultName(PagerankArguments.PagerankVariant.APPROXIMATE));
    }

    protected <ID> PgxFuture<VertexProperty<ID, Double>> pagerankApproximateAsync(PgxGraph graph, double e, double d, int max, String propertyName) {
        return this.vertexCentralityAnalysis(graph, rank -> this.pagerankApproximateAsync(graph, e, d, max, (VertexProperty)rank), PropertyType.DOUBLE, propertyName);
    }

    public <ID> PgxFuture<VertexProperty<ID, Double>> pagerankApproximateAsync(PgxGraph graph, VertexProperty<ID, Double> rank) {
        return this.pagerankApproximateAsync(graph, 0.001, 0.85, 100, rank);
    }

    public <ID> PgxFuture<VertexProperty<ID, Double>> pagerankApproximateAsync(PgxGraph graph, double e, double d, int max, VertexProperty<ID, Double> rank) {
        PgxFuture promise = new PgxFuture();
        return ((PgxFuture)this.algorithms.pgxBuiltinK1bPagerankApproximate(this.sessionContext, graph.getId(), e, d, max, rank.getPropertyId()).cancelOn(promise).thenApply(result -> rank)).thenComplete(promise);
    }

    public <ID> PgxFuture<VertexProperty<ID, Double>> weightedPagerankAsync(PgxGraph graph, EdgeProperty<Double> weight) {
        return this.weightedPagerankAsync(graph, 0.001, 0.85, 100, weight);
    }

    public <ID> PgxFuture<VertexProperty<ID, Double>> weightedPagerankAsync(PgxGraph graph, boolean norm, EdgeProperty<Double> weight) {
        return this.weightedPagerankAsync(graph, 0.001, 0.85, 100, norm, weight);
    }

    public <ID> PgxFuture<VertexProperty<ID, Double>> weightedPagerankAsync(PgxGraph graph, double e, double d, int max, EdgeProperty<Double> weight) {
        return this.weightedPagerankAsync(graph, e, d, max, weight, Arguments.PAGERANK.getDefaultName(PagerankArguments.PagerankVariant.WEIGHTED));
    }

    protected <ID> PgxFuture<VertexProperty<ID, Double>> weightedPagerankAsync(PgxGraph graph, double e, double d, int max, EdgeProperty<Double> weight, String propertyName) {
        return this.vertexCentralityAnalysis(graph, rank -> this.weightedPagerankAsync(graph, e, d, max, weight, (VertexProperty)rank), PropertyType.DOUBLE, propertyName);
    }

    public <ID> PgxFuture<VertexProperty<ID, Double>> weightedPagerankAsync(PgxGraph graph, double e, double d, int max, boolean norm, EdgeProperty<Double> weight) {
        return this.weightedPagerankAsync(graph, e, d, max, norm, weight, Arguments.PAGERANK.getDefaultName(PagerankArguments.PagerankVariant.WEIGHTED));
    }

    protected <ID> PgxFuture<VertexProperty<ID, Double>> weightedPagerankAsync(PgxGraph graph, double e, double d, int max, boolean norm, EdgeProperty<Double> weight, String propertyName) {
        return this.vertexCentralityAnalysis(graph, rank -> this.weightedPagerankAsync(graph, e, d, max, norm, weight, (VertexProperty)rank), PropertyType.DOUBLE, propertyName);
    }

    public <ID> PgxFuture<VertexProperty<ID, Double>> weightedPagerankAsync(PgxGraph graph, EdgeProperty<Double> weight, VertexProperty<ID, Double> rank) {
        return this.weightedPagerankAsync(graph, 0.001, 0.85, 100, weight, rank);
    }

    public <ID> PgxFuture<VertexProperty<ID, Double>> weightedPagerankAsync(PgxGraph graph, boolean norm, EdgeProperty<Double> weight, VertexProperty<ID, Double> rank) {
        return this.weightedPagerankAsync(graph, 0.001, 0.85, 100, norm, weight, rank);
    }

    public <ID> PgxFuture<VertexProperty<ID, Double>> weightedPagerankAsync(PgxGraph graph, double e, double d, int max, EdgeProperty<Double> weight, VertexProperty<ID, Double> rank) {
        PgxFuture promise = new PgxFuture();
        return ((PgxFuture)this.algorithms.pgxBuiltinK1cPagerankWeighted(this.sessionContext, graph.getId(), e, d, max, false, weight.getPropertyId(), rank.getPropertyId()).cancelOn(promise).thenApply(result -> rank)).thenComplete(promise);
    }

    public <ID> PgxFuture<VertexProperty<ID, Double>> weightedPagerankAsync(PgxGraph graph, double e, double d, int max, boolean norm, EdgeProperty<Double> weight, VertexProperty<ID, Double> rank) {
        PgxFuture promise = new PgxFuture();
        return ((PgxFuture)this.algorithms.pgxBuiltinK1cPagerankWeighted(this.sessionContext, graph.getId(), e, d, max, norm, weight.getPropertyId(), rank.getPropertyId()).cancelOn(promise).thenApply(result -> rank)).thenComplete(promise);
    }

    public <ID> PgxFuture<VertexProperty<ID, Double>> personalizedPagerankAsync(PgxGraph graph, PgxVertex<ID> v) {
        return this.personalizedPagerankAsync(graph, v, 0.001, 0.85, 100);
    }

    public <ID> PgxFuture<VertexProperty<ID, Double>> personalizedPagerankAsync(PgxGraph graph, PgxVertex<ID> v, boolean norm) {
        return this.personalizedPagerankAsync(graph, v, 0.001, 0.85, 100, norm);
    }

    public <ID> PgxFuture<VertexProperty<ID, Double>> personalizedPagerankAsync(PgxGraph graph, PgxVertex<ID> v, double e, double d, int max) {
        return this.personalizedPagerankAsync(graph, v, e, d, max, Arguments.PAGERANK.getDefaultName(PagerankArguments.PagerankVariant.DEFAULT));
    }

    protected <ID> PgxFuture<VertexProperty<ID, Double>> personalizedPagerankAsync(PgxGraph graph, PgxVertex<ID> v, double e, double d, int max, String propertyName) {
        return this.vertexCentralityAnalysis(graph, rank -> this.personalizedPagerankAsync(graph, v, e, d, max, (VertexProperty)rank), PropertyType.DOUBLE, propertyName);
    }

    public <ID> PgxFuture<VertexProperty<ID, Double>> personalizedPagerankAsync(PgxGraph graph, PgxVertex<ID> v, double e, double d, int max, boolean norm) {
        return this.personalizedPagerankAsync(graph, v, e, d, max, norm, Arguments.PAGERANK.getDefaultName(PagerankArguments.PagerankVariant.DEFAULT));
    }

    protected <ID> PgxFuture<VertexProperty<ID, Double>> personalizedPagerankAsync(PgxGraph graph, PgxVertex<ID> v, double e, double d, int max, boolean norm, String propertyName) {
        return this.vertexCentralityAnalysis(graph, rank -> this.personalizedPagerankAsync(graph, v, e, d, max, norm, (VertexProperty)rank), PropertyType.DOUBLE, propertyName);
    }

    public <ID> PgxFuture<VertexProperty<ID, Double>> personalizedPagerankAsync(PgxGraph graph, PgxVertex<ID> v, VertexProperty<ID, Double> rank) {
        return this.personalizedPagerankAsync(graph, v, 0.001, 0.85, 100, rank);
    }

    public <ID> PgxFuture<VertexProperty<ID, Double>> personalizedPagerankAsync(PgxGraph graph, PgxVertex<ID> v, boolean norm, VertexProperty<ID, Double> rank) {
        return this.personalizedPagerankAsync(graph, v, 0.001, 0.85, 100, norm, rank);
    }

    public <ID> PgxFuture<VertexProperty<ID, Double>> personalizedPagerankAsync(PgxGraph graph, PgxVertex<ID> v, double e, double d, int max, VertexProperty<ID, Double> rank) {
        PgxFuture promise = new PgxFuture();
        return ((PgxFuture)this.algorithms.pgxBuiltinK2PersonalizedPagerank(this.sessionContext, graph.getId(), this.serializeVertex(v), e, d, max, false, rank.getPropertyId()).cancelOn(promise).thenApply(result -> rank)).thenComplete(promise);
    }

    public <ID> PgxFuture<VertexProperty<ID, Double>> personalizedPagerankAsync(PgxGraph graph, PgxVertex<ID> v, double e, double d, int max, boolean norm, VertexProperty<ID, Double> rank) {
        PgxFuture promise = new PgxFuture();
        return ((PgxFuture)this.algorithms.pgxBuiltinK2PersonalizedPagerank(this.sessionContext, graph.getId(), this.serializeVertex(v), e, d, max, norm, rank.getPropertyId()).cancelOn(promise).thenApply(result -> rank)).thenComplete(promise);
    }

    public <ID> PgxFuture<VertexProperty<ID, Double>> personalizedPagerankAsync(PgxGraph graph, VertexSet<ID> vertices) {
        return this.personalizedPagerankAsync(graph, vertices, 0.001, 0.85, 100);
    }

    public <ID> PgxFuture<VertexProperty<ID, Double>> personalizedPagerankAsync(PgxGraph graph, VertexSet<ID> vertices, boolean norm) {
        return this.personalizedPagerankAsync(graph, vertices, 0.001, 0.85, 100, norm);
    }

    public <ID> PgxFuture<VertexProperty<ID, Double>> personalizedPagerankAsync(PgxGraph graph, VertexSet<ID> vertices, double e, double d, int max) {
        return this.personalizedPagerankAsync(graph, vertices, e, d, max, Arguments.PAGERANK.getDefaultName(PagerankArguments.PagerankVariant.DEFAULT));
    }

    protected <ID> PgxFuture<VertexProperty<ID, Double>> personalizedPagerankAsync(PgxGraph graph, VertexSet<ID> vertices, double e, double d, int max, String propertyName) {
        return this.vertexCentralityAnalysis(graph, rank -> this.personalizedPagerankAsync(graph, vertices, e, d, max, (VertexProperty)rank), PropertyType.DOUBLE, propertyName);
    }

    public <ID> PgxFuture<VertexProperty<ID, Double>> personalizedPagerankAsync(PgxGraph graph, VertexSet<ID> vertices, double e, double d, int max, boolean norm) {
        return this.personalizedPagerankAsync(graph, vertices, e, d, max, norm, Arguments.PAGERANK.getDefaultName(PagerankArguments.PagerankVariant.DEFAULT));
    }

    protected <ID> PgxFuture<VertexProperty<ID, Double>> personalizedPagerankAsync(PgxGraph graph, VertexSet<ID> vertices, double e, double d, int max, boolean norm, String propertyName) {
        return this.vertexCentralityAnalysis(graph, rank -> this.personalizedPagerankAsync(graph, vertices, e, d, max, norm, (VertexProperty)rank), PropertyType.DOUBLE, propertyName);
    }

    public <ID> PgxFuture<VertexProperty<ID, Double>> personalizedPagerankAsync(PgxGraph graph, VertexSet<ID> vertices, VertexProperty<ID, Double> rank) {
        return this.personalizedPagerankAsync(graph, vertices, 0.001, 0.85, 100, rank);
    }

    public <ID> PgxFuture<VertexProperty<ID, Double>> personalizedPagerankAsync(PgxGraph graph, VertexSet<ID> vertices, boolean norm, VertexProperty<ID, Double> rank) {
        return this.personalizedPagerankAsync(graph, vertices, 0.001, 0.85, 100, norm, rank);
    }

    public <ID> PgxFuture<VertexProperty<ID, Double>> personalizedPagerankAsync(PgxGraph graph, VertexSet<ID> vertices, double e, double d, int max, VertexProperty<ID, Double> rank) {
        PgxFuture promise = new PgxFuture();
        return ((PgxFuture)this.algorithms.pgxBuiltinK2bPersonalizedPagerankFromSet(this.sessionContext, graph.getId(), vertices.getId(), e, d, max, false, rank.getPropertyId()).cancelOn(promise).thenApply(result -> rank)).thenComplete(promise);
    }

    public <ID> PgxFuture<VertexProperty<ID, Double>> personalizedPagerankAsync(PgxGraph graph, VertexSet<ID> vertices, double e, double d, int max, boolean norm, VertexProperty<ID, Double> rank) {
        PgxFuture promise = new PgxFuture();
        return ((PgxFuture)this.algorithms.pgxBuiltinK2bPersonalizedPagerankFromSet(this.sessionContext, graph.getId(), vertices.getId(), e, d, max, norm, rank.getPropertyId()).cancelOn(promise).thenApply(result -> rank)).thenComplete(promise);
    }

    public <ID> PgxFuture<VertexProperty<ID, Double>> personalizedWeightedPagerankAsync(PgxGraph graph, PgxVertex<ID> v, EdgeProperty<Double> weight) {
        return this.personalizedWeightedPagerankAsync(graph, v, 0.001, 0.85, 100, weight);
    }

    public <ID> PgxFuture<VertexProperty<ID, Double>> personalizedWeightedPagerankAsync(PgxGraph graph, PgxVertex<ID> v, boolean norm, EdgeProperty<Double> weight) {
        return this.personalizedWeightedPagerankAsync(graph, v, 0.001, 0.85, 100, norm, weight);
    }

    public <ID> PgxFuture<VertexProperty<ID, Double>> personalizedWeightedPagerankAsync(PgxGraph graph, PgxVertex<ID> v, double e, double d, int max, EdgeProperty<Double> weight) {
        return this.personalizedWeightedPagerankAsync(graph, v, e, d, max, weight, Arguments.PAGERANK.getDefaultName(PagerankArguments.PagerankVariant.PERSONALIZED_WEIGHTED));
    }

    protected <ID> PgxFuture<VertexProperty<ID, Double>> personalizedWeightedPagerankAsync(PgxGraph graph, PgxVertex<ID> v, double e, double d, int max, EdgeProperty<Double> weight, String propertyName) {
        return this.vertexCentralityAnalysis(graph, rank -> this.personalizedWeightedPagerankAsync(graph, v, e, d, max, weight, (VertexProperty)rank), PropertyType.DOUBLE, propertyName);
    }

    public <ID> PgxFuture<VertexProperty<ID, Double>> personalizedWeightedPagerankAsync(PgxGraph graph, PgxVertex<ID> v, double e, double d, int max, boolean norm, EdgeProperty<Double> weight) {
        return this.personalizedWeightedPagerankAsync(graph, v, e, d, max, norm, weight, Arguments.PAGERANK.getDefaultName(PagerankArguments.PagerankVariant.PERSONALIZED_WEIGHTED));
    }

    protected <ID> PgxFuture<VertexProperty<ID, Double>> personalizedWeightedPagerankAsync(PgxGraph graph, PgxVertex<ID> v, double e, double d, int max, boolean norm, EdgeProperty<Double> weight, String propertyName) {
        return this.vertexCentralityAnalysis(graph, rank -> this.personalizedWeightedPagerankAsync(graph, v, e, d, max, norm, weight, (VertexProperty)rank), PropertyType.DOUBLE, propertyName);
    }

    public <ID> PgxFuture<VertexProperty<ID, Double>> personalizedWeightedPagerankAsync(PgxGraph graph, PgxVertex<ID> v, EdgeProperty<Double> weight, VertexProperty<ID, Double> rank) {
        return this.personalizedWeightedPagerankAsync(graph, v, 0.001, 0.85, 100, weight, rank);
    }

    public <ID> PgxFuture<VertexProperty<ID, Double>> personalizedWeightedPagerankAsync(PgxGraph graph, PgxVertex<ID> v, boolean norm, EdgeProperty<Double> weight, VertexProperty<ID, Double> rank) {
        return this.personalizedWeightedPagerankAsync(graph, v, 0.001, 0.85, 100, norm, weight, rank);
    }

    public <ID> PgxFuture<VertexProperty<ID, Double>> personalizedWeightedPagerankAsync(PgxGraph graph, PgxVertex<ID> v, double e, double d, int max, EdgeProperty<Double> weight, VertexProperty<ID, Double> rank) {
        PgxFuture promise = new PgxFuture();
        return ((PgxFuture)this.algorithms.pgxBuiltinK2cPersonalizedWeightedPagerank(this.sessionContext, graph.getId(), this.serializeVertex(v), e, d, max, false, weight.getPropertyId(), rank.getPropertyId()).cancelOn(promise).thenApply(result -> rank)).thenComplete(promise);
    }

    public <ID> PgxFuture<VertexProperty<ID, Double>> personalizedWeightedPagerankAsync(PgxGraph graph, PgxVertex<ID> v, double e, double d, int max, boolean norm, EdgeProperty<Double> weight, VertexProperty<ID, Double> rank) {
        PgxFuture promise = new PgxFuture();
        return ((PgxFuture)this.algorithms.pgxBuiltinK2cPersonalizedWeightedPagerank(this.sessionContext, graph.getId(), this.serializeVertex(v), e, d, max, norm, weight.getPropertyId(), rank.getPropertyId()).cancelOn(promise).thenApply(result -> rank)).thenComplete(promise);
    }

    public <ID> PgxFuture<VertexProperty<ID, Double>> personalizedWeightedPagerankAsync(PgxGraph graph, VertexSet<ID> vertices, EdgeProperty<Double> weight) {
        return this.personalizedWeightedPagerankAsync(graph, vertices, 0.001, 0.85, 100, weight);
    }

    public <ID> PgxFuture<VertexProperty<ID, Double>> personalizedWeightedPagerankAsync(PgxGraph graph, VertexSet<ID> vertices, boolean norm, EdgeProperty<Double> weight) {
        return this.personalizedWeightedPagerankAsync(graph, vertices, 0.001, 0.85, 100, norm, weight);
    }

    public <ID> PgxFuture<VertexProperty<ID, Double>> personalizedWeightedPagerankAsync(PgxGraph graph, VertexSet<ID> vertices, double e, double d, int max, EdgeProperty<Double> weight) {
        return this.personalizedWeightedPagerankAsync(graph, vertices, e, d, max, weight, Arguments.PAGERANK.getDefaultName(PagerankArguments.PagerankVariant.PERSONALIZED_WEIGHTED));
    }

    protected <ID> PgxFuture<VertexProperty<ID, Double>> personalizedWeightedPagerankAsync(PgxGraph graph, VertexSet<ID> vertices, double e, double d, int max, EdgeProperty<Double> weight, String propertyName) {
        return this.vertexCentralityAnalysis(graph, rank -> this.personalizedWeightedPagerankAsync(graph, vertices, e, d, max, weight, (VertexProperty)rank), PropertyType.DOUBLE, propertyName);
    }

    public <ID> PgxFuture<VertexProperty<ID, Double>> personalizedWeightedPagerankAsync(PgxGraph graph, VertexSet<ID> vertices, double e, double d, int max, boolean norm, EdgeProperty<Double> weight) {
        return this.personalizedWeightedPagerankAsync(graph, vertices, e, d, max, norm, weight, Arguments.PAGERANK.getDefaultName(PagerankArguments.PagerankVariant.PERSONALIZED_WEIGHTED));
    }

    protected <ID> PgxFuture<VertexProperty<ID, Double>> personalizedWeightedPagerankAsync(PgxGraph graph, VertexSet<ID> vertices, double e, double d, int max, boolean norm, EdgeProperty<Double> weight, String propertyName) {
        return this.vertexCentralityAnalysis(graph, rank -> this.personalizedWeightedPagerankAsync(graph, vertices, e, d, max, norm, weight, (VertexProperty)rank), PropertyType.DOUBLE, propertyName);
    }

    public <ID> PgxFuture<VertexProperty<ID, Double>> personalizedWeightedPagerankAsync(PgxGraph graph, VertexSet<ID> vertices, EdgeProperty<Double> weight, VertexProperty<ID, Double> rank) {
        return this.personalizedWeightedPagerankAsync(graph, vertices, 0.001, 0.85, 100, weight, rank);
    }

    public <ID> PgxFuture<VertexProperty<ID, Double>> personalizedWeightedPagerankAsync(PgxGraph graph, VertexSet<ID> vertices, boolean norm, EdgeProperty<Double> weight, VertexProperty<ID, Double> rank) {
        return this.personalizedWeightedPagerankAsync(graph, vertices, 0.001, 0.85, 100, norm, weight, rank);
    }

    public <ID> PgxFuture<VertexProperty<ID, Double>> personalizedWeightedPagerankAsync(PgxGraph graph, VertexSet<ID> vertices, double e, double d, int max, EdgeProperty<Double> weight, VertexProperty<ID, Double> rank) {
        PgxFuture promise = new PgxFuture();
        return ((PgxFuture)this.algorithms.pgxBuiltinK2dPersonalizedWeightedPagerankFromSet(this.sessionContext, graph.getId(), vertices.getId(), e, d, max, false, weight.getPropertyId(), rank.getPropertyId()).cancelOn(promise).thenApply(result -> rank)).thenComplete(promise);
    }

    public <ID> PgxFuture<VertexProperty<ID, Double>> personalizedWeightedPagerankAsync(PgxGraph graph, VertexSet<ID> vertices, double e, double d, int max, boolean norm, EdgeProperty<Double> weight, VertexProperty<ID, Double> rank) {
        PgxFuture promise = new PgxFuture();
        return ((PgxFuture)this.algorithms.pgxBuiltinK2dPersonalizedWeightedPagerankFromSet(this.sessionContext, graph.getId(), vertices.getId(), e, d, max, norm, weight.getPropertyId(), rank.getPropertyId()).cancelOn(promise).thenApply(result -> rank)).thenComplete(promise);
    }

    public <ID> PgxFuture<VertexProperty<ID, Double>> vertexBetweennessCentralityAsync(PgxGraph graph) {
        return this.vertexBetweennessCentralityAsync(graph, Arguments.BC.getDefaultName(BetweennessCentralityArguments.BetweennessCentralityVariant.FULL));
    }

    protected <ID> PgxFuture<VertexProperty<ID, Double>> vertexBetweennessCentralityAsync(PgxGraph graph, String propertyName) {
        return this.vertexCentralityAnalysis(graph, bc -> this.vertexBetweennessCentralityAsync(graph, (VertexProperty)bc), PropertyType.DOUBLE, propertyName);
    }

    public <ID> PgxFuture<VertexProperty<ID, Double>> vertexBetweennessCentralityAsync(PgxGraph graph, VertexProperty<ID, Double> bc) {
        PgxFuture promise = new PgxFuture();
        return ((PgxFuture)this.algorithms.pgxBuiltinK3aNodeBetweennessCentrality(this.sessionContext, graph.getId(), bc.getPropertyId()).cancelOn(promise).thenApply(result -> bc)).thenComplete(promise);
    }

    public <ID> PgxFuture<VertexProperty<ID, Double>> approximateVertexBetweennessCentralityAsync(PgxGraph graph, int k) {
        return this.approximateVertexBetweennessCentralityAsync(graph, k, Arguments.BC.getDefaultName(BetweennessCentralityArguments.BetweennessCentralityVariant.APPROXIMATE));
    }

    protected <ID> PgxFuture<VertexProperty<ID, Double>> approximateVertexBetweennessCentralityAsync(PgxGraph graph, int k, String propertyName) {
        return this.vertexCentralityAnalysis(graph, bc -> this.approximateVertexBetweennessCentralityAsync(graph, k, (VertexProperty)bc), PropertyType.DOUBLE, propertyName);
    }

    public <ID> PgxFuture<VertexProperty<ID, Double>> approximateVertexBetweennessCentralityAsync(PgxGraph graph, int k, VertexProperty<ID, Double> bc) {
        PgxFuture promise = new PgxFuture();
        return ((PgxFuture)this.algorithms.pgxBuiltinK3bApproxNodeBetweennessCentrality(this.sessionContext, graph.getId(), k, bc.getPropertyId()).cancelOn(promise).thenApply(result -> bc)).thenComplete(promise);
    }

    @SafeVarargs
    public final <ID> PgxFuture<VertexProperty<ID, Double>> approximateVertexBetweennessCentralityFromSeedsAsync(PgxGraph graph, PgxVertex<ID> ... seeds) {
        return this.approximateVertexBetweennessCentralityFromSeedsAsync(graph, Arguments.BC.getDefaultName(BetweennessCentralityArguments.BetweennessCentralityVariant.APPROXIMATE), seeds);
    }

    @SafeVarargs
    protected final <ID> PgxFuture<VertexProperty<ID, Double>> approximateVertexBetweennessCentralityFromSeedsAsync(PgxGraph graph, String propertyName, PgxVertex<ID> ... seeds) {
        return this.vertexCentralityAnalysis(graph, bc -> this.approximateVertexBetweennessCentralityFromSeedsAsync(graph, (VertexProperty)bc, seeds), PropertyType.DOUBLE, propertyName);
    }

    @SafeVarargs
    public final <ID> PgxFuture<VertexProperty<ID, Double>> approximateVertexBetweennessCentralityFromSeedsAsync(PgxGraph graph, VertexProperty<ID, Double> bc, PgxVertex<ID> ... seeds) {
        PgxFuture promise = new PgxFuture();
        ObjectHolder seedsHolder = new ObjectHolder();
        return ((PgxFuture)((PgxFuture)graph.createVertexSequenceAsync().thenCompose(seedsSeq -> {
            seedsHolder.set(seedsSeq);
            return seedsSeq.addAllAsync(seeds);
        })).thenCompose(arg -> {
            VertexSequence seedsSeq = (VertexSequence)seedsHolder.get();
            assert (seedsSeq != null);
            return ((PgxFuture)this.algorithms.pgxBuiltinK3cApproxNodeBetweennessCentralityFromSeeds(this.sessionContext, graph.getId(), seedsSeq.getId(), bc.getPropertyId()).cancelOn(promise).thenApply(result -> bc)).thenComplete(promise);
        })).thenComplete(promise, () -> {
            VertexSequence seedsSeq = (VertexSequence)seedsHolder.get();
            if (seedsSeq != null) {
                seedsSeq.destroyAsync();
            }
        });
    }

    public <ID> PgxFuture<VertexProperty<ID, Double>> closenessCentralityUnitLengthAsync(PgxGraph graph) {
        return this.closenessCentralityUnitLengthAsync(graph, Arguments.CC.getDefaultName(ClosenessCentralityArguments.ClosenessCentralityVariant.DEFAULT));
    }

    protected <ID> PgxFuture<VertexProperty<ID, Double>> closenessCentralityUnitLengthAsync(PgxGraph graph, String propertyName) {
        return this.vertexCentralityAnalysis(graph, cc -> this.closenessCentralityUnitLengthAsync(graph, (VertexProperty)cc), PropertyType.DOUBLE, propertyName);
    }

    public <ID> PgxFuture<VertexProperty<ID, Double>> closenessCentralityUnitLengthAsync(PgxGraph graph, VertexProperty<ID, Double> cc) {
        PgxFuture promise = new PgxFuture();
        return ((PgxFuture)this.algorithms.pgxBuiltinK4aClosenessCentralityUnitLength(this.sessionContext, graph.getId(), cc.getPropertyId()).cancelOn(promise).thenApply(result -> cc)).thenComplete(promise);
    }

    public <ID> PgxFuture<VertexProperty<ID, Double>> closenessCentralityDoubleLengthAsync(PgxGraph graph, EdgeProperty<Double> cost) {
        return this.closenessCentralityDoubleLengthAsync(graph, cost, Arguments.CC.getDefaultName(ClosenessCentralityArguments.ClosenessCentralityVariant.WEIGHTED));
    }

    protected <ID> PgxFuture<VertexProperty<ID, Double>> closenessCentralityDoubleLengthAsync(PgxGraph graph, EdgeProperty<Double> cost, String propertyName) {
        return this.vertexCentralityAnalysis(graph, cc -> this.closenessCentralityDoubleLengthAsync(graph, cost, (VertexProperty)cc), PropertyType.DOUBLE, propertyName);
    }

    public <ID> PgxFuture<VertexProperty<ID, Double>> closenessCentralityDoubleLengthAsync(PgxGraph graph, EdgeProperty<Double> cost, VertexProperty<ID, Double> cc) {
        PgxFuture promise = new PgxFuture();
        return ((PgxFuture)this.algorithms.pgxBuiltinK4bClosenessCentralityDoubleLength(this.sessionContext, graph.getId(), cost.getPropertyId(), cc.getPropertyId()).cancelOn(promise).thenApply(result -> cc)).thenComplete(promise);
    }

    public <ID> PgxFuture<Pair<VertexProperty<ID, Double>, VertexProperty<ID, Double>>> hitsAsync(PgxGraph graph) {
        return this.hitsAsync(graph, 100);
    }

    public <ID> PgxFuture<Pair<VertexProperty<ID, Double>, VertexProperty<ID, Double>>> hitsAsync(PgxGraph graph, int max) {
        return this.hitsAsync(graph, max, "authority", "hubs");
    }

    public <ID> PgxFuture<Pair<VertexProperty<ID, Double>, VertexProperty<ID, Double>>> hitsAsync(PgxGraph graph, int max, VertexProperty<ID, Double> auth, VertexProperty<ID, Double> hubs) {
        PgxFuture promise = new PgxFuture();
        return ((PgxFuture)this.algorithms.pgxBuiltinK5Hits(this.sessionContext, graph.getId(), max, auth.getPropertyId(), hubs.getPropertyId()).cancelOn(promise).thenApply(result -> new Pair((Object)auth, (Object)hubs))).thenComplete(promise);
    }

    protected <ID> PgxFuture<Pair<VertexProperty<ID, Double>, VertexProperty<ID, Double>>> hitsAsync(PgxGraph graph, int max, String propertyAuthName, String propertyHubsName) {
        PgxFuture promise = new PgxFuture();
        ObjectHolder authHolder = new ObjectHolder();
        ObjectHolder hubsHolder = new ObjectHolder();
        return ((PgxFuture)((PgxFuture)((PgxFuture)graph.createVertexPropertyAsync(PropertyType.DOUBLE, 0, propertyAuthName, false).cancelOn(promise).thenCompose(auth -> {
            authHolder.set(auth);
            return graph.createVertexPropertyAsync(PropertyType.DOUBLE, 0, propertyHubsName, false).cancelOn(promise);
        })).thenCompose(hubs -> {
            hubsHolder.set(hubs);
            VertexProperty auth = (VertexProperty)authHolder.get();
            assert (auth != null);
            return this.hitsAsync(graph, max, auth, (VertexProperty)hubs).cancelOn(promise);
        })).cancelOn(promise).thenApply(arg -> {
            VertexProperty auth = (VertexProperty)authHolder.get();
            VertexProperty hubs = (VertexProperty)hubsHolder.get();
            assert (auth != null);
            assert (hubs != null);
            this.addTransientObject(auth);
            this.addTransientObject(hubs);
            return new Pair((Object)auth, (Object)hubs);
        })).thenComplete(promise);
    }

    public <ID> PgxFuture<Pair<VertexProperty<ID, Double>, VertexProperty<ID, Double>>> hitsAsync(PgxGraph graph, VertexProperty<ID, Double> auth, VertexProperty<ID, Double> hubs) {
        return this.hitsAsync(graph, 100, auth, hubs);
    }

    public <ID> PgxFuture<VertexProperty<ID, Double>> eigenvectorCentralityAsync(PgxGraph graph) {
        return this.eigenvectorCentralityAsync(graph, 100, 0.001, false, false);
    }

    public <ID> PgxFuture<VertexProperty<ID, Double>> eigenvectorCentralityAsync(PgxGraph graph, int max, double maxDiff, boolean useL2Norm, boolean useInEdge) {
        return this.eigenvectorCentralityAsync(graph, max, maxDiff, useL2Norm, useInEdge, "eigenvector");
    }

    public <ID> PgxFuture<VertexProperty<ID, Double>> eigenvectorCentralityAsync(PgxGraph graph, int max, double maxDiff, boolean useL2Norm, boolean useInEdge, VertexProperty<ID, Double> ec) {
        PgxFuture promise = new PgxFuture();
        return ((PgxFuture)this.algorithms.pgxBuiltinK6EigenvectorCentrality(this.sessionContext, graph.getId(), max, maxDiff, useL2Norm, useInEdge, ec.getPropertyId()).cancelOn(promise).thenApply(result -> ec)).thenComplete(promise);
    }

    public <ID> PgxFuture<VertexProperty<ID, Double>> eigenvectorCentralityAsync(PgxGraph graph, VertexProperty<ID, Double> ec) {
        return this.eigenvectorCentralityAsync(graph, 100, 0.001, false, false, ec);
    }

    protected <ID> PgxFuture<VertexProperty<ID, Double>> eigenvectorCentralityAsync(PgxGraph graph, int max, double maxDiff, boolean useL2Norm, boolean useInEdge, String propertyName) {
        return this.vertexCentralityAnalysis(graph, ec -> this.eigenvectorCentralityAsync(graph, max, maxDiff, useL2Norm, useInEdge, (VertexProperty)ec), PropertyType.DOUBLE, propertyName);
    }

    public <ID> PgxFuture<VertexProperty<ID, Integer>> outDegreeCentralityAsync(PgxGraph graph) {
        return this.outDegreeCentralityAsync(graph, Arguments.DEGREE_CENTRALITY.getDefaultName(Direction.OUTGOING));
    }

    public <ID> PgxFuture<VertexProperty<ID, Integer>> outDegreeCentralityAsync(PgxGraph graph, VertexProperty<ID, Integer> dc) {
        PgxFuture promise = new PgxFuture();
        return ((PgxFuture)this.algorithms.pgxBuiltinK7aOutdegreeCentrality(this.sessionContext, graph.getId(), dc.getPropertyId()).cancelOn(promise).thenApply(result -> dc)).thenComplete(promise);
    }

    public <ID> PgxFuture<VertexProperty<ID, Integer>> outDegreeCentralityAsync(PgxGraph graph, String propertyName) {
        return this.vertexCentralityAnalysis(graph, oc -> this.outDegreeCentralityAsync(graph, (VertexProperty)oc), PropertyType.INTEGER, propertyName);
    }

    public <ID> PgxFuture<VertexProperty<ID, Integer>> inDegreeCentralityAsync(PgxGraph graph) {
        return this.inDegreeCentralityAsync(graph, Arguments.DEGREE_CENTRALITY.getDefaultName(Direction.INCOMING));
    }

    public <ID> PgxFuture<VertexProperty<ID, Integer>> inDegreeCentralityAsync(PgxGraph graph, VertexProperty<ID, Integer> dc) {
        PgxFuture promise = new PgxFuture();
        return ((PgxFuture)this.algorithms.pgxBuiltinK7bIndegreeCentrality(this.sessionContext, graph.getId(), dc.getPropertyId()).cancelOn(promise).thenApply(result -> dc)).thenComplete(promise);
    }

    public <ID> PgxFuture<VertexProperty<ID, Integer>> inDegreeCentralityAsync(PgxGraph graph, String propertyName) {
        return this.vertexCentralityAnalysis(graph, ic -> this.inDegreeCentralityAsync(graph, (VertexProperty)ic), PropertyType.INTEGER, propertyName);
    }

    public <ID> PgxFuture<VertexProperty<ID, Integer>> degreeCentralityAsync(PgxGraph graph) {
        return this.degreeCentralityAsync(graph, Arguments.DEGREE_CENTRALITY.getDefaultName(Direction.BOTH));
    }

    public <ID> PgxFuture<VertexProperty<ID, Integer>> degreeCentralityAsync(PgxGraph graph, VertexProperty<ID, Integer> dc) {
        PgxFuture promise = new PgxFuture();
        return ((PgxFuture)this.algorithms.pgxBuiltinK7cDegreeCentrality(this.sessionContext, graph.getId(), dc.getPropertyId()).cancelOn(promise).thenApply(result -> dc)).thenComplete(promise);
    }

    public <ID> PgxFuture<VertexProperty<ID, Integer>> degreeCentralityAsync(PgxGraph graph, String propertyName) {
        return this.vertexCentralityAnalysis(graph, dc -> this.degreeCentralityAsync(graph, (VertexProperty)dc), PropertyType.INTEGER, propertyName);
    }

    public PgxFuture<EdgeProperty<Double>> adamicAdarCountingAsync(PgxGraph graph) {
        return this.adamicAdarCountingAsync(graph, "adamic_adar");
    }

    public PgxFuture<EdgeProperty<Double>> adamicAdarCountingAsync(PgxGraph graph, EdgeProperty<Double> aa) {
        PgxFuture promise = new PgxFuture();
        return ((PgxFuture)this.algorithms.pgxBuiltinS2AdamicAdarCounting(this.sessionContext, graph.getId(), aa.getPropertyId()).cancelOn(promise).thenApply(result -> aa)).thenComplete(promise);
    }

    protected PgxFuture<EdgeProperty<Double>> adamicAdarCountingAsync(PgxGraph graph, String propertyName) {
        PgxFuture promise = new PgxFuture();
        ObjectHolder aaHolder = new ObjectHolder();
        return ((PgxFuture)((PgxFuture)graph.createEdgePropertyAsync(PropertyType.DOUBLE, 0, propertyName, false).thenCompose(prop -> {
            aaHolder.set(prop);
            return this.adamicAdarCountingAsync(graph, (EdgeProperty<Double>)prop).cancelOn(promise);
        })).thenApply(arg -> {
            EdgeProperty aa = (EdgeProperty)aaHolder.get();
            assert (aa != null);
            this.addTransientObject(aa);
            return aa;
        })).thenComplete(promise);
    }

    public <ID> PgxFuture<PgxMap<PgxVertex<ID>, Integer>> randomWalkWithRestartAsync(PgxGraph graph, PgxVertex<ID> source, int length, double resetProb, PgxMap<PgxVertex<ID>, Integer> visitCount) {
        PgxFuture promise = new PgxFuture();
        return ((PgxFuture)this.algorithms.pgxBuiltinK8RandomWalkWithRestart(this.sessionContext, graph.getId(), this.serializeVertex(source), length, resetProb, visitCount.getName()).cancelOn(promise).thenApply(result -> visitCount)).thenComplete(promise);
    }

    public <ID> PgxFuture<Partition<ID>> communitiesLabelPropagationAsync(PgxGraph graph) {
        return this.communitiesLabelPropagationAsync(graph, 100);
    }

    public <ID> PgxFuture<Partition<ID>> communitiesLabelPropagationAsync(PgxGraph graph, int maxIterations) {
        return this.communitiesLabelPropagationAsync(graph, maxIterations, Arguments.COMMUNITIES.getDefaultName(CommunitiesArguments.CommunitiesVariant.LABEL_PROPAGATION));
    }

    public <ID> PgxFuture<Partition<ID>> communitiesLabelPropagationAsync(PgxGraph graph, VertexProperty<ID, Long> partitionDistribution) {
        return this.communitiesLabelPropagationAsync(graph, 100, partitionDistribution);
    }

    public <ID> PgxFuture<Partition<ID>> communitiesLabelPropagationAsync(PgxGraph graph, int maxIterations, VertexProperty<ID, Long> partitionDistribution) {
        PgxFuture promise = new PgxFuture();
        return ((PgxFuture)this.algorithms.pgxBuiltinC1CommunityDetectionLabelPropagation(this.sessionContext, graph.getId(), maxIterations, partitionDistribution.getPropertyId()).cancelOn(promise).thenComplete(promise).thenCompose(numComponents -> graph.createComponentsAsync(partitionDistribution, (long)numComponents))).thenApply(comps -> {
            this.addTransientObject((Destroyable)comps);
            return comps;
        });
    }

    protected <ID> PgxFuture<Partition<ID>> communitiesLabelPropagationAsync(PgxGraph graph, int maxIterations, String propertyName) {
        return this.componentAnalysis(graph, property -> this.communitiesLabelPropagationAsync(graph, maxIterations, (VertexProperty)property), propertyName);
    }

    public <ID> PgxFuture<Partition<ID>> communitiesConductanceMinimizationAsync(PgxGraph graph) {
        return this.communitiesConductanceMinimizationAsync(graph, 100);
    }

    public <ID> PgxFuture<Partition<ID>> communitiesConductanceMinimizationAsync(PgxGraph graph, int max) {
        return this.communitiesConductanceMinimizationAsync(graph, max, Arguments.COMMUNITIES.getDefaultName(CommunitiesArguments.CommunitiesVariant.CONDUCTANCE_MINIMIZATION));
    }

    public <ID> PgxFuture<Partition<ID>> communitiesConductanceMinimizationAsync(PgxGraph graph, VertexProperty<ID, Long> partitionDistribution) {
        return this.communitiesConductanceMinimizationAsync(graph, 100, partitionDistribution);
    }

    public <ID> PgxFuture<Partition<ID>> communitiesConductanceMinimizationAsync(PgxGraph graph, int maxIterations, VertexProperty<ID, Long> partitionDistribution) {
        PgxFuture promise = new PgxFuture();
        return ((PgxFuture)this.algorithms.pgxBuiltinC2CommunityDetectionConductanceMinimization(this.sessionContext, graph.getId(), maxIterations, partitionDistribution.getPropertyId()).cancelOn(promise).thenComplete(promise).thenCompose(comp -> graph.createComponentsAsync(partitionDistribution, (long)comp))).thenApply(comps -> {
            this.addTransientObject((Destroyable)comps);
            return comps;
        });
    }

    protected <ID> PgxFuture<Partition<ID>> communitiesConductanceMinimizationAsync(PgxGraph graph, int maxIterations, String propertyName) {
        return this.componentAnalysis(graph, property -> this.communitiesConductanceMinimizationAsync(graph, maxIterations, (VertexProperty)property), propertyName);
    }

    public <ID> PgxFuture<Partition<ID>> communitiesInfomapAsync(PgxGraph graph, VertexProperty<ID, Double> rank, EdgeProperty<Double> weight) {
        return this.communitiesInfomapAsync(graph, rank, weight, 0.15, 1.0E-4, 100, Arguments.COMMUNITIES.getDefaultName(CommunitiesArguments.CommunitiesVariant.INFOMAP));
    }

    public <ID> PgxFuture<Partition<ID>> communitiesInfomapAsync(PgxGraph graph, VertexProperty<ID, Double> rank, EdgeProperty<Double> weight, double tau, double tol, int maxIter) {
        return this.communitiesInfomapAsync(graph, rank, weight, tau, tol, maxIter, Arguments.COMMUNITIES.getDefaultName(CommunitiesArguments.CommunitiesVariant.INFOMAP));
    }

    public <ID> PgxFuture<Partition<ID>> communitiesInfomapAsync(PgxGraph graph, VertexProperty<ID, Double> rank, EdgeProperty<Double> weight, VertexProperty<ID, Long> module) {
        return this.communitiesInfomapAsync(graph, rank, weight, 0.15, 1.0E-4, 100, module);
    }

    public <ID> PgxFuture<Partition<ID>> communitiesInfomapAsync(PgxGraph graph, VertexProperty<ID, Double> rank, EdgeProperty<Double> weight, double tau, double tol, int maxIter, VertexProperty<ID, Long> module) {
        PgxFuture promise = new PgxFuture();
        return ((PgxFuture)this.algorithms.pgxBuiltinC3Infomap(this.sessionContext, graph.getId(), rank.getPropertyId(), weight.getPropertyId(), tau, tol, maxIter, module.getPropertyId()).cancelOn(promise).thenComplete(promise).thenCompose(numComponents -> graph.createComponentsAsync(module, (long)numComponents))).thenApply(comps -> {
            this.addTransientObject((Destroyable)comps);
            return comps;
        });
    }

    protected <ID> PgxFuture<Partition<ID>> communitiesInfomapAsync(PgxGraph graph, VertexProperty<ID, Double> rank, EdgeProperty<Double> weight, double tau, double tol, int maxIter, String propertyName) {
        return this.componentAnalysis(graph, property -> this.communitiesInfomapAsync(graph, rank, weight, tau, tol, maxIter, (VertexProperty)property), propertyName);
    }

    public <ID> PgxFuture<VertexProperty<ID, Long>> louvainAsync(PgxGraph graph, EdgeProperty<Double> weight, int maxIter, int nbrPass, double tol, VertexProperty<ID, Long> community) {
        PgxFuture promise = new PgxFuture();
        return ((PgxFuture)this.algorithms.pgxBuiltinC4Louvain(this.sessionContext, graph.getId(), weight.getPropertyId(), maxIter, nbrPass, tol, community.getPropertyId()).cancelOn(promise).thenApply(result -> community)).thenComplete(promise);
    }

    protected <ID> PgxFuture<VertexProperty<ID, Long>> louvainAsync(PgxGraph graph, EdgeProperty<Double> weight, int maxIter, int nbrPass, double tol, String communityName) {
        ObjectHolder louvainHolder = new ObjectHolder();
        return graph.createVertexPropertyAsync(PropertyType.LONG, 0, communityName, false).thenCompose(communityProperty -> {
            this.addTransientObject((Destroyable)communityProperty);
            louvainHolder.set(communityProperty);
            return this.louvainAsync(graph, weight, maxIter, nbrPass, tol, (VertexProperty)louvainHolder.get());
        });
    }

    public <ID> PgxFuture<VertexProperty<ID, Long>> louvainAsync(PgxGraph graph, EdgeProperty<Double> weight, int maxIter) {
        return this.louvainAsync(graph, weight, maxIter, 1, 0.001, "community");
    }

    public <ID> PgxFuture<VertexProperty<ID, Long>> louvainAsync(PgxGraph graph, EdgeProperty<Double> weight) {
        return this.louvainAsync(graph, weight, 100, 1, 0.001, "community");
    }

    public <ID> PgxFuture<VertexProperty<ID, String>> speakerListenerLabelPropagationAsync(PgxGraph graph, String labelsPropName) {
        return this.speakerListenerLabelPropagationAsync(graph, labelsPropName, 100, 0.0, "|");
    }

    public <ID> PgxFuture<VertexProperty<ID, String>> speakerListenerLabelPropagationAsync(PgxGraph graph, String labelsPropName, int maxIter, double threshold, String delimiter) {
        return graph.createVertexPropertyAsync(PropertyType.STRING, labelsPropName).thenCompose(labels -> this.speakerListenerLabelPropagationAsync(graph, (VertexProperty)labels, maxIter, threshold, delimiter));
    }

    public <ID> PgxFuture<VertexProperty<ID, String>> speakerListenerLabelPropagationAsync(PgxGraph graph, VertexProperty<ID, String> labels, int maxIter, double threshold, String delimiter) {
        if (threshold < 0.0 || threshold > 1.0) {
            return PgxFuture.exceptionallyCompletedFuture(new IllegalArgumentException(ErrorMessages.getMessage((String)"SLLP_INVALID_THRESHOLD", (Object[])new Object[]{threshold})));
        }
        PgxFuture promise = new PgxFuture();
        return ((PgxFuture)this.algorithms.pgxBuiltinC5SpeakerListenerLabelPropagation(this.sessionContext, graph.getId(), maxIter, threshold, delimiter, labels.getPropertyId()).cancelOn(promise).thenApply(result -> labels)).thenComplete(promise);
    }

    public <ID> PgxFuture<Scalar<Double>> conductanceAsync(PgxGraph graph, Partition<ID> partition, long partitionIndex) {
        return this.conductanceAsync(graph, partition, partitionIndex, Arguments.CONDUCTANCE.getDefaultName(ConductanceArguments.ConductanceVariant.SINGLE), null);
    }

    public <ID> PgxFuture<Scalar<Double>> conductanceAsync(PgxGraph graph, Partition<ID> partition, long partitionIndex, Scalar<Double> conductance) {
        return this.conductanceAsync(graph, partition, partitionIndex, null, conductance);
    }

    private <ID> PgxFuture<Scalar<Double>> conductanceAsync(PgxGraph graph, Partition<ID> partition, long partitionIndex, String conductanceName, Scalar<Double> conductance) {
        if (partitionIndex >= partition.size()) {
            return PgxFuture.exceptionallyCompletedFuture(new IllegalArgumentException(ErrorMessages.getMessage((String)"INVALID_PARTITION_INDEX", (Object[])new Object[]{partitionIndex, partition.size() - 1L})));
        }
        CompletableFuture conductancePromise = null;
        PgxFuture promise = new PgxFuture();
        ObjectHolder scalarHolder = new ObjectHolder();
        conductancePromise = conductance != null ? PgxFuture.completedFuture(conductance) : graph.createScalarAsync(PropertyType.DOUBLE, conductanceName).thenApply(scalar -> {
            this.addTransientObject((Destroyable)scalar);
            return scalar;
        });
        return ((PgxFuture)((PgxFuture)conductancePromise.thenCompose(scalar -> {
            scalarHolder.set(scalar);
            return this.algorithms.pgxBuiltinS3Conductance(this.sessionContext, graph.getId(), partition.getPropertyId(), partitionIndex).cancelOn(promise).thenComplete(promise);
        })).thenCompose(result -> {
            Scalar scalar = (Scalar)scalarHolder.get();
            return scalar.setAsync(result);
        })).thenApply(result -> (Scalar)scalarHolder.get());
    }

    public <ID> PgxFuture<Pair<Scalar<Double>, Scalar<Double>>> partitionConductanceAsync(PgxGraph graph, Partition<ID> partition) {
        return this.partitionConductanceAsync(graph, partition, Arguments.CONDUCTANCE.getDefaultName(ConductanceArguments.ConductanceVariant.MIN), Arguments.CONDUCTANCE.getDefaultName(ConductanceArguments.ConductanceVariant.DEFAULT));
    }

    public <ID> PgxFuture<Pair<Scalar<Double>, Scalar<Double>>> partitionConductanceAsync(PgxGraph graph, Partition<ID> partition, Scalar<Double> avgConductance, Scalar<Double> minConductance) {
        PgxFuture promise = new PgxFuture();
        return ((PgxFuture)this.algorithms.pgxBuiltinS5PartitionConductance(this.sessionContext, graph.getId(), partition.getPropertyId(), partition.size(), minConductance.getName()).cancelOn(promise).thenComplete(promise).thenCompose(avgConductance::setAsync)).thenApply(result -> new Pair((Object)avgConductance, (Object)minConductance));
    }

    protected <ID> PgxFuture<Pair<Scalar<Double>, Scalar<Double>>> partitionConductanceAsync(PgxGraph graph, Partition<ID> partition, String avgConductanceName, String minConductanceName) {
        ObjectHolder minCondScalarHolder = new ObjectHolder();
        ObjectHolder avgScalarHolder = new ObjectHolder();
        return ((PgxFuture)graph.createScalarAsync(PropertyType.DOUBLE, minConductanceName).thenCompose(minCond -> {
            minCondScalarHolder.set(minCond);
            return graph.createScalarAsync(PropertyType.DOUBLE, avgConductanceName);
        })).thenCompose(avg -> {
            avgScalarHolder.set(avg);
            Scalar minCond = (Scalar)minCondScalarHolder.get();
            assert (minCond != null);
            this.addTransientObject(minCond);
            this.addTransientObject((Destroyable)avg);
            return this.partitionConductanceAsync(graph, partition, (Scalar<Double>)avg, minCond);
        });
    }

    public <ID> PgxFuture<Scalar<Double>> partitionModularityAsync(PgxGraph graph, Partition<ID> partition) {
        return this.partitionModularityAsync(graph, partition, PartitionModularityArguments.DEFAULT_NAME);
    }

    public <ID> PgxFuture<Scalar<Double>> partitionModularityAsync(PgxGraph graph, Partition<ID> partition, Scalar<Double> modularity) {
        PgxFuture promise = new PgxFuture();
        return ((PgxFuture)this.algorithms.pgxBuiltinS4PartitionModularity(this.sessionContext, graph.getId(), partition.getPropertyId(), partition.size()).cancelOn(promise).thenComplete(promise).thenCompose(modularity::setAsync)).thenApply(result -> modularity);
    }

    public <ID> PgxFuture<Scalar<Double>> partitionModularityAsync(PgxGraph graph, Partition<ID> partition, String modularityName) {
        return graph.createScalarAsync(PropertyType.DOUBLE, modularityName).thenCompose(scalar -> {
            this.addTransientObject((Destroyable)scalar);
            return this.partitionModularityAsync(graph, partition, (Scalar<Double>)scalar);
        });
    }

    public <ID> PgxFuture<Partition<ID>> sccKosarajuAsync(PgxGraph graph) {
        return this.sccKosarajuAsync(graph, Arguments.SCC.getDefaultName(SccArguments.SccVariant.DEFAULT));
    }

    public <ID> PgxFuture<Partition<ID>> sccKosarajuAsync(PgxGraph graph, VertexProperty<ID, Long> partitionDistribution) {
        PgxFuture promise = new PgxFuture();
        return ((PgxFuture)this.algorithms.pgxBuiltinG2aStronglyConnectedComponentsKosaraju(this.sessionContext, graph.getId(), partitionDistribution.getPropertyId()).cancelOn(promise).thenComplete(promise).thenCompose(comp -> graph.createComponentsAsync(partitionDistribution, (long)comp))).thenApply(comps -> {
            this.addTransientObject((Destroyable)comps);
            return comps;
        });
    }

    protected <ID> PgxFuture<Partition<ID>> sccKosarajuAsync(PgxGraph graph, String partitonDistributionName) {
        return this.componentAnalysis(graph, property -> this.sccKosarajuAsync(graph, (VertexProperty)property), partitonDistributionName);
    }

    public <ID> PgxFuture<Partition<ID>> sccTarjanAsync(PgxGraph graph) {
        return this.sccTarjanAsync(graph, Arguments.SCC.getDefaultName(SccArguments.SccVariant.TARJAN));
    }

    public <ID> PgxFuture<Partition<ID>> sccTarjanAsync(PgxGraph graph, VertexProperty<ID, Long> partitonDistribution) {
        PgxFuture promise = new PgxFuture();
        return ((PgxFuture)this.algorithms.pgxBuiltinG2bStronglyConnectedComponentsTarjan(this.sessionContext, graph.getId(), partitonDistribution.getPropertyId()).cancelOn(promise).thenComplete(promise).thenCompose(comp -> graph.createComponentsAsync(partitonDistribution, (long)comp))).thenApply(comps -> {
            this.addTransientObject((Destroyable)comps);
            return comps;
        });
    }

    protected <ID> PgxFuture<Partition<ID>> sccTarjanAsync(PgxGraph graph, String partitonDistributionName) {
        return this.componentAnalysis(graph, property -> this.sccTarjanAsync(graph, (VertexProperty)property), partitonDistributionName);
    }

    public <ID> PgxFuture<Partition<ID>> wccAsync(PgxGraph graph) {
        return this.wccAsync(graph, "wcc");
    }

    public <ID> PgxFuture<Partition<ID>> wccAsync(PgxGraph graph, VertexProperty<ID, Long> partitionDistribution) {
        PgxFuture promise = new PgxFuture();
        return ((PgxFuture)this.algorithms.pgxBuiltinG3WeaklyConnectedComponents(this.sessionContext, graph.getId(), partitionDistribution.getPropertyId()).cancelOn(promise).thenComplete(promise).thenCompose(comp -> graph.createComponentsAsync(partitionDistribution, (long)comp))).thenApply(comps -> {
            this.addTransientObject((Destroyable)comps);
            return comps;
        });
    }

    public <ID> PgxFuture<Partition<ID>> wccAsync(PgxGraph graph, String partitonDistributionName) {
        return this.componentAnalysis(graph, property -> this.wccAsync(graph, (VertexProperty)property), partitonDistributionName);
    }

    public <ID> PgxFuture<VertexProperty<ID, Double>> salsaAsync(BipartiteGraph graph) {
        return this.salsaAsync(graph, 0.001, 100);
    }

    public <ID> PgxFuture<VertexProperty<ID, Double>> salsaAsync(BipartiteGraph graph, double maxDiff, int maxIter) {
        return this.salsaAsync(graph, maxDiff, maxIter, Arguments.SALSA.getDefaultName(SalsaArguments.SalsaVariant.DEFAULT));
    }

    public <ID> PgxFuture<VertexProperty<ID, Double>> salsaAsync(BipartiteGraph graph, VertexProperty<ID, Double> salsaRank) {
        return this.salsaAsync(graph, 0.001, 100, salsaRank);
    }

    public <ID> PgxFuture<VertexProperty<ID, Double>> salsaAsync(BipartiteGraph graph, double maxDiff, int maxIter, VertexProperty<ID, Double> salsaRank) {
        PgxFuture promise = new PgxFuture();
        return ((PgxFuture)this.algorithms.pgxBuiltinR1bSalsa(this.sessionContext, graph.getId(), graph.getIsLeftId(), maxDiff, maxIter, salsaRank.getPropertyId()).cancelOn(promise).thenApply(result -> salsaRank)).thenComplete(promise);
    }

    protected <ID> PgxFuture<VertexProperty<ID, Double>> salsaAsync(BipartiteGraph graph, double maxDiff, int maxIter, String salsaRankName) {
        return this.vertexCentralityAnalysis(graph, rank -> this.salsaAsync(graph, maxDiff, maxIter, (VertexProperty)rank), PropertyType.DOUBLE, salsaRankName);
    }

    public <ID> PgxFuture<VertexProperty<ID, Double>> personalizedSalsaAsync(BipartiteGraph graph, PgxVertex<ID> v) {
        return this.personalizedSalsaAsync(graph, v, 0.85, 100, 0.001);
    }

    public <ID> PgxFuture<VertexProperty<ID, Double>> personalizedSalsaAsync(BipartiteGraph graph, PgxVertex<ID> v, double d, int maxIter, double maxDiff) {
        return this.personalizedSalsaAsync(graph, v, d, maxIter, maxDiff, Arguments.SALSA.getDefaultName(SalsaArguments.SalsaVariant.PERSONALIZED));
    }

    public <ID> PgxFuture<VertexProperty<ID, Double>> personalizedSalsaAsync(BipartiteGraph graph, PgxVertex<ID> v, VertexProperty<ID, Double> salsaRank) {
        return this.personalizedSalsaAsync(graph, v, 0.85, 100, 0.001, salsaRank);
    }

    public <ID> PgxFuture<VertexProperty<ID, Double>> personalizedSalsaAsync(BipartiteGraph graph, PgxVertex<ID> v, double d, int maxIter, double maxDiff, VertexProperty<ID, Double> salsaRank) {
        PgxFuture promise = new PgxFuture();
        return ((PgxFuture)this.algorithms.pgxBuiltinR2PersonalizedSalsa(this.sessionContext, graph.getId(), this.serializeVertex(v), graph.getIsLeftId(), d, maxDiff, maxIter, salsaRank.getPropertyId()).cancelOn(promise).thenApply(result -> salsaRank)).thenComplete(promise);
    }

    protected <ID> PgxFuture<VertexProperty<ID, Double>> personalizedSalsaAsync(BipartiteGraph graph, PgxVertex<ID> v, double d, int maxIter, double maxDiff, String salsaRankName) {
        return this.vertexCentralityAnalysis(graph, rank -> this.personalizedSalsaAsync(graph, v, d, maxIter, maxDiff, (VertexProperty)rank), PropertyType.DOUBLE, salsaRankName);
    }

    public <ID> PgxFuture<VertexProperty<ID, Double>> personalizedSalsaAsync(BipartiteGraph graph, VertexSet<ID> vertices) {
        return this.personalizedSalsaAsync(graph, vertices, 0.85, 100, 0.001);
    }

    public <ID> PgxFuture<VertexProperty<ID, Double>> personalizedSalsaAsync(BipartiteGraph graph, VertexSet<ID> vertices, double d, int maxIter, double maxDiff) {
        return this.personalizedSalsaAsync(graph, vertices, d, maxIter, maxDiff, Arguments.SALSA.getDefaultName(SalsaArguments.SalsaVariant.PERSONALIZED));
    }

    public <ID> PgxFuture<VertexProperty<ID, Double>> personalizedSalsaAsync(BipartiteGraph graph, VertexSet<ID> vertices, double d, int maxIter, double maxDiff, VertexProperty<ID, Double> salsaRank) {
        PgxFuture promise = new PgxFuture();
        return ((PgxFuture)this.algorithms.pgxBuiltinR3PersonalizedSalsaFromSet(this.sessionContext, graph.getId(), vertices.getId(), graph.getIsLeftId(), d, maxDiff, maxIter, salsaRank.getPropertyId()).cancelOn(promise).thenApply(result -> salsaRank)).thenComplete(promise);
    }

    public <ID> PgxFuture<VertexProperty<ID, Double>> personalizedSalsaAsync(BipartiteGraph graph, VertexSet<ID> vertices, VertexProperty<ID, Double> salsaRank) {
        return this.personalizedSalsaAsync(graph, vertices, 0.85, 100, 0.001, salsaRank);
    }

    protected <ID> PgxFuture<VertexProperty<ID, Double>> personalizedSalsaAsync(BipartiteGraph graph, VertexSet<ID> vertices, double d, int maxIter, double maxDiff, String salsaRankName) {
        return this.vertexCentralityAnalysis(graph, rank -> this.personalizedSalsaAsync(graph, vertices, d, maxIter, maxDiff, (VertexProperty)rank), PropertyType.DOUBLE, salsaRankName);
    }

    public <ID> PgxFuture<Pair<VertexSequence<ID>, VertexSequence<ID>>> whomToFollowAsync(PgxGraph graph, PgxVertex<ID> vertex) {
        return this.whomToFollowAsync(graph, vertex, 100);
    }

    public <ID> PgxFuture<Pair<VertexSequence<ID>, VertexSequence<ID>>> whomToFollowAsync(PgxGraph graph, PgxVertex<ID> vertex, int topK) {
        return this.whomToFollowAsync(graph, vertex, topK, 500);
    }

    public <ID> PgxFuture<Pair<VertexSequence<ID>, VertexSequence<ID>>> whomToFollowAsync(PgxGraph graph, PgxVertex<ID> vertex, int topK, int sizeCircleOfTrust) {
        return this.whomToFollowAsync(graph, vertex, topK, sizeCircleOfTrust, 100, 0.001, 0.85, 100, 0.001);
    }

    public <ID> PgxFuture<Pair<VertexSequence<ID>, VertexSequence<ID>>> whomToFollowAsync(PgxGraph graph, PgxVertex<ID> vertex, VertexSequence<ID> hubs, VertexSequence<ID> authorities) {
        return this.whomToFollowAsync(graph, vertex, 100, hubs, authorities);
    }

    public <ID> PgxFuture<Pair<VertexSequence<ID>, VertexSequence<ID>>> whomToFollowAsync(PgxGraph graph, PgxVertex<ID> vertex, int topK, VertexSequence<ID> hubs, VertexSequence<ID> authorities) {
        return this.whomToFollowAsync(graph, vertex, topK, 500, hubs, authorities);
    }

    public <ID> PgxFuture<Pair<VertexSequence<ID>, VertexSequence<ID>>> whomToFollowAsync(PgxGraph graph, PgxVertex<ID> vertex, int topK, int sizeCircleOfTrust, VertexSequence<ID> hubs, VertexSequence<ID> authorities) {
        return this.whomToFollowAsync(graph, vertex, topK, sizeCircleOfTrust, 100, 0.001, 0.85, 100, 0.001, hubs, authorities);
    }

    public <ID> PgxFuture<Pair<VertexSequence<ID>, VertexSequence<ID>>> whomToFollowAsync(PgxGraph graph, PgxVertex<ID> vertex, int topK, int sizeCircleOfTrust, int maxIter, double tol, double dampingFactor, int salsaMaxIter, double salsaTol) {
        return this.whomToFollowAsync(graph, vertex, topK, sizeCircleOfTrust, maxIter, tol, dampingFactor, salsaMaxIter, salsaTol, WhomToFollowArguments.NAME_HUBS, WhomToFollowArguments.NAME_AUTHORITIES);
    }

    public <ID> PgxFuture<Pair<VertexSequence<ID>, VertexSequence<ID>>> whomToFollowAsync(PgxGraph graph, PgxVertex<ID> vertex, int topK, int sizeCircleOfTrust, int maxIter, double tol, double dampingFactor, int salsaMaxIter, double salsaTol, VertexSequence<ID> hubs, VertexSequence<ID> authorities) {
        PgxFuture promise = new PgxFuture();
        return ((PgxFuture)this.algorithms.pgxBuiltinL1WhomToFollow(this.sessionContext, graph.getId(), this.serializeVertex(vertex), topK, sizeCircleOfTrust, maxIter, tol, dampingFactor, salsaMaxIter, salsaTol, hubs.getId(), authorities.getId()).cancelOn(promise).thenApply(arg -> new Pair((Object)hubs, (Object)authorities))).thenComplete(promise);
    }

    protected <ID> PgxFuture<Pair<VertexSequence<ID>, VertexSequence<ID>>> whomToFollowAsync(PgxGraph graph, PgxVertex<ID> vertex, int topK, int sizeCircleOfTrust, int maxIter, double tol, double dampingFactor, int salsaMaxIter, double salsaTol, String hubsName, String authName) {
        ObjectHolder hubRecsHolder = new ObjectHolder();
        return ((PgxFuture)graph.createVertexSequenceAsync(hubsName).thenCompose(hub -> {
            hubRecsHolder.set(hub);
            this.addTransientObject((Destroyable)hub);
            return graph.createVertexSequenceAsync(authName);
        })).thenCompose(auth -> {
            VertexSequence hubs = (VertexSequence)hubRecsHolder.get();
            this.addTransientObject((Destroyable)auth);
            return this.whomToFollowAsync(graph, vertex, topK, sizeCircleOfTrust, maxIter, tol, dampingFactor, salsaMaxIter, salsaTol, hubs, (VertexSequence)auth);
        });
    }

    public <ID> PgxFuture<MatrixFactorizationModel<ID>> matrixFactorizationGradientDescentAsync(BipartiteGraph graph, EdgeProperty<Double> weight) {
        return this.matrixFactorizationGradientDescentAsync(graph, weight, 0.1, 0.9, 0.1, 100, 20);
    }

    public <ID> PgxFuture<MatrixFactorizationModel<ID>> matrixFactorizationGradientDescentAsync(BipartiteGraph graph, EdgeProperty<Double> weight, double learningRate, double changePerStep, double lambda, int maxStep, int vectorLength) {
        return this.matrixFactorizationGradientDescentAsync(graph, weight, learningRate, changePerStep, lambda, maxStep, vectorLength, "matrix_factorization");
    }

    public <ID> PgxFuture<MatrixFactorizationModel<ID>> matrixFactorizationGradientDescentAsync(BipartiteGraph graph, EdgeProperty<Double> weight, VertexProperty<ID, PgxVect<Double>> features) {
        return this.matrixFactorizationGradientDescentAsync(graph, weight, 0.1, 0.9, 0.1, 100, 20, features);
    }

    public <ID> PgxFuture<MatrixFactorizationModel<ID>> matrixFactorizationGradientDescentAsync(BipartiteGraph graph, EdgeProperty<Double> weight, double learningRate, double changePerStep, double lambda, int maxStep, int vectorLength, VertexProperty<ID, PgxVect<Double>> features) {
        PgxFuture promise = new PgxFuture();
        return this.algorithms.pgxBuiltinR2aMatrixFactorizationTraining(this.sessionContext, graph.getId(), graph.getIsLeftId(), weight.getPropertyId(), learningRate, changePerStep, lambda, maxStep, vectorLength, features.getPropertyId()).cancelOn(promise).thenComplete(promise).thenApply(rmse -> new MatrixFactorizationModel(this, graph, features, (double)rmse));
    }

    protected <ID> PgxFuture<MatrixFactorizationModel<ID>> matrixFactorizationGradientDescentAsync(BipartiteGraph graph, EdgeProperty<Double> weight, double learningRate, double changePerStep, double lambda, int maxStep, int vectorLength, String featuresName) {
        return graph.createVertexVectorPropertyAsync(PropertyType.DOUBLE, vectorLength, featuresName).thenCompose(featureProperty -> {
            this.addTransientObject((Destroyable)featureProperty);
            return this.matrixFactorizationGradientDescentAsync(graph, weight, learningRate, changePerStep, lambda, maxStep, vectorLength, (VertexProperty)featureProperty);
        });
    }

    public <ID> PgxFuture<VertexProperty<ID, Double>> matrixFactorizationRecommendationsAsync(BipartiteGraph graph, PgxVertex<ID> user, int vectorLength, VertexProperty<ID, PgxVect<Double>> feature, VertexProperty<ID, Double> estimatedRating) {
        PgxFuture promise = new PgxFuture();
        return ((PgxFuture)this.algorithms.pgxBuiltinR2bMatrixFactorizationRecommendations(this.sessionContext, graph.getId(), this.serializeVertex(user), graph.getIsLeftId(), vectorLength, feature.getPropertyId(), estimatedRating.getPropertyId()).cancelOn(promise).thenApply(result -> estimatedRating)).thenComplete(promise);
    }

    public <ID> PgxFuture<AllPaths<ID>> fattestPathAsync(PgxGraph graph, PgxVertex<ID> root, EdgeProperty<Double> capacity) {
        return this.fattestPathAsync(graph, root, capacity, "fattest_path_distance", "fattest_path_parent", "fattest_path_parent_edge");
    }

    public <ID> PgxFuture<AllPaths<ID>> fattestPathAsync(PgxGraph graph, PgxVertex<ID> root, EdgeProperty<Double> capacity, VertexProperty<ID, Double> distance, VertexProperty<ID, PgxVertex<ID>> parent, VertexProperty<ID, PgxEdge> parentEdge) {
        return this.algorithms.pgxBuiltinP5FattestPath(this.sessionContext, graph.getId(), capacity.getPropertyId(), this.serializeVertex(root), parent.getPropertyId(), parentEdge.getPropertyId(), distance.getPropertyId()).thenCompose(result -> graph.createAllPathsAsync(root, capacity, distance, parent, parentEdge));
    }

    protected <ID> PgxFuture<AllPaths<ID>> fattestPathAsync(PgxGraph graph, PgxVertex<ID> root, EdgeProperty<Double> capacity, String distanceName, String parentName, String parentEdgeName) {
        return this.allPathsAnalysis(graph, args -> {
            assert (args.parent != null);
            assert (args.parentEdge != null);
            assert (args.dist != null);
            return this.fattestPathAsync(graph, root, capacity, args.dist, args.parent, args.parentEdge);
        }, distanceName, parentName, parentEdgeName);
    }

    public <ID> PgxFuture<PgxPath<ID>> shortestPathDijkstraAsync(PgxGraph graph, PgxVertex<ID> src, PgxVertex<ID> dst, EdgeProperty<Double> cost) {
        DefaultPathNaming namingHolder = Arguments.DIJKSTRA.getDefaultName(DijkstraArguments.DijkstraVariant.CLASSICAL);
        return this.shortestPathDijkstraAsync(graph, src, dst, cost, namingHolder.parentName, namingHolder.parentEdgeName);
    }

    public <ID> PgxFuture<PgxPath<ID>> shortestPathDijkstraAsync(PgxGraph graph, PgxVertex<ID> src, PgxVertex<ID> dst, EdgeProperty<Double> cost, VertexProperty<ID, PgxVertex<ID>> parent, VertexProperty<ID, PgxEdge> parentEdge) {
        PgxFuture promise = new PgxFuture();
        return this.algorithms.pgxBuiltinP1aSingleSourceSingleDestinationDijkstra(this.sessionContext, graph.getId(), cost.getPropertyId(), this.serializeVertex(src), this.serializeVertex(dst), parent.getPropertyId(), parentEdge.getPropertyId()).cancelOn(promise).thenComplete(promise).thenCompose(result -> graph.createPathAsync(src, dst, cost, parent, parentEdge));
    }

    protected <ID> PgxFuture<PgxPath<ID>> shortestPathDijkstraAsync(PgxGraph graph, PgxVertex<ID> src, PgxVertex<ID> dst, EdgeProperty<Double> cost, String parentName, String parentEdgeName) {
        return this.pathAnalysis(graph, args -> {
            assert (args.parent != null);
            assert (args.parentEdge != null);
            return this.shortestPathDijkstraAsync(graph, src, dst, cost, args.parent, args.parentEdge);
        }, parentName, parentEdgeName);
    }

    public <ID> PgxFuture<PgxPath<ID>> shortestPathFilteredDijkstraAsync(PgxGraph graph, PgxVertex<ID> src, PgxVertex<ID> dst, EdgeProperty<Double> cost, GraphFilter filterExpr) {
        DefaultPathNaming namingHolder = Arguments.DIJKSTRA.getDefaultName(DijkstraArguments.DijkstraVariant.CLASSICAL);
        return this.shortestPathFilteredDijkstraAsync(graph, src, dst, cost, filterExpr, namingHolder.parentName, namingHolder.parentEdgeName);
    }

    public <ID> PgxFuture<PgxPath<ID>> shortestPathFilteredDijkstraAsync(PgxGraph graph, PgxVertex<ID> src, PgxVertex<ID> dst, EdgeProperty<Double> cost, GraphFilter filterExpr, VertexProperty<ID, PgxVertex<ID>> parent, VertexProperty<ID, PgxEdge> parentEdge) {
        Object srcEntity = this.serializeVertex(src);
        Object dstEntity = this.serializeVertex(dst);
        PathFindingFilter pathFindingFilter = new PathFindingFilter(filterExpr, srcEntity, dstEntity);
        PgxFuture promise = new PgxFuture();
        return this.algorithms.pgxBuiltinP1bSingleSourceSingleDestinationFilteredDijkstra(this.sessionContext, graph.getId(), cost.getPropertyId(), srcEntity, dstEntity, (GraphFilter)pathFindingFilter, parent.getPropertyId(), parentEdge.getPropertyId()).cancelOn(promise).thenComplete(promise).thenCompose(result -> graph.createPathAsync(src, dst, cost, parent, parentEdge));
    }

    protected <ID> PgxFuture<PgxPath<ID>> shortestPathFilteredDijkstraAsync(PgxGraph graph, PgxVertex<ID> src, PgxVertex<ID> dst, EdgeProperty<Double> cost, GraphFilter filterExpr, String parentName, String parentEdgeName) {
        return this.pathAnalysis(graph, args -> {
            assert (args.parent != null);
            assert (args.parentEdge != null);
            return this.shortestPathFilteredDijkstraAsync(graph, src, dst, cost, filterExpr, args.parent, args.parentEdge);
        }, parentName, parentEdgeName);
    }

    public <ID> PgxFuture<PgxPath<ID>> shortestPathDijkstraBidirectionalAsync(PgxGraph graph, PgxVertex<ID> src, PgxVertex<ID> dst, EdgeProperty<Double> cost) {
        DefaultPathNaming namingHolder = Arguments.DIJKSTRA.getDefaultName(DijkstraArguments.DijkstraVariant.BIDIRECTIONAL);
        return this.shortestPathDijkstraBidirectionalAsync(graph, src, dst, cost, namingHolder.parentName, namingHolder.parentEdgeName);
    }

    public <ID> PgxFuture<PgxPath<ID>> shortestPathDijkstraBidirectionalAsync(PgxGraph graph, PgxVertex<ID> src, PgxVertex<ID> dst, EdgeProperty<Double> cost, VertexProperty<ID, PgxVertex<ID>> parent, VertexProperty<ID, PgxEdge> parentEdge) {
        PgxFuture promise = new PgxFuture();
        return this.algorithms.pgxBuiltinP2SingleSourceSingleDestinationBidirectionalDijkstra(this.sessionContext, graph.getId(), cost.getPropertyId(), this.serializeVertex(src), this.serializeVertex(dst), parent.getPropertyId(), parentEdge.getPropertyId()).cancelOn(promise).thenComplete(promise).thenCompose(result -> graph.createPathAsync(src, dst, cost, parent, parentEdge));
    }

    public <ID> PgxFuture<PgxPath<ID>> shortestPathDijkstraBidirectionalAsync(PgxGraph graph, PgxVertex<ID> src, PgxVertex<ID> dst, EdgeProperty<Double> cost, String parentName, String parentEdgeName) {
        return this.pathAnalysis(graph, args -> {
            assert (args.parent != null);
            assert (args.parentEdge != null);
            return this.shortestPathDijkstraBidirectionalAsync(graph, src, dst, cost, args.parent, args.parentEdge);
        }, parentName, parentEdgeName);
    }

    public <ID> PgxFuture<PgxPath<ID>> shortestPathFilteredDijkstraBidirectionalAsync(PgxGraph graph, PgxVertex<ID> src, PgxVertex<ID> dst, EdgeProperty<Double> cost, GraphFilter filterExpr) {
        DefaultPathNaming namingHolder = Arguments.DIJKSTRA.getDefaultName(DijkstraArguments.DijkstraVariant.BIDIRECTIONAL);
        return this.shortestPathFilteredDijkstraBidirectionalAsync(graph, src, dst, cost, filterExpr, namingHolder.parentName, namingHolder.parentEdgeName);
    }

    public <ID> PgxFuture<PgxPath<ID>> shortestPathFilteredDijkstraBidirectionalAsync(PgxGraph graph, PgxVertex<ID> src, PgxVertex<ID> dst, EdgeProperty<Double> cost, GraphFilter filterExpr, VertexProperty<ID, PgxVertex<ID>> parent, VertexProperty<ID, PgxEdge> parentEdge) {
        PathFindingFilter pathFindingFilter = new PathFindingFilter(filterExpr, src.getId(), dst.getId());
        PgxFuture promise = new PgxFuture();
        return this.algorithms.pgxBuiltinP2bSingleSourceSingleDestinationFilteredBidirectionalDijkstra(this.sessionContext, graph.getId(), cost.getPropertyId(), this.serializeVertex(src), this.serializeVertex(dst), (GraphFilter)pathFindingFilter, parent.getPropertyId(), parentEdge.getPropertyId()).cancelOn(promise).thenComplete(promise).thenCompose(result -> graph.createPathAsync(src, dst, cost, parent, parentEdge));
    }

    public <ID> PgxFuture<PgxPath<ID>> shortestPathFilteredDijkstraBidirectionalAsync(PgxGraph graph, PgxVertex<ID> src, PgxVertex<ID> dst, EdgeProperty<Double> cost, GraphFilter filterExpr, String parentName, String parentEdgeName) {
        return this.pathAnalysis(graph, args -> {
            assert (args.parent != null);
            assert (args.parentEdge != null);
            return this.shortestPathFilteredDijkstraBidirectionalAsync(graph, src, dst, cost, filterExpr, args.parent, args.parentEdge);
        }, parentName, parentEdgeName);
    }

    public <ID> PgxFuture<AllPaths<ID>> shortestPathBellmanFordAsync(PgxGraph graph, PgxVertex<ID> src, EdgeProperty<Double> cost) {
        DefaultPathNaming pathNames = Arguments.BELLMAN_FORD.getDefaultName(Arguments.TraversalDirection.FORWARD);
        return this.shortestPathBellmanFordAsync(graph, src, cost, pathNames.distance, pathNames.parentName, pathNames.parentEdgeName);
    }

    public <ID> PgxFuture<AllPaths<ID>> shortestPathBellmanFordAsync(PgxGraph graph, PgxVertex<ID> src, EdgeProperty<Double> cost, VertexProperty<ID, Double> distance, VertexProperty<ID, PgxVertex<ID>> parent, VertexProperty<ID, PgxEdge> parentEdge) {
        PgxFuture promise = new PgxFuture();
        return this.algorithms.pgxBuiltinP3SingleSourceAllDestinationsBellmanFord(this.sessionContext, graph.getId(), cost.getPropertyId(), this.serializeVertex(src), distance.getPropertyId(), parent.getPropertyId(), parentEdge.getPropertyId()).cancelOn(promise).thenComplete(promise).thenCompose(result -> graph.createAllPathsAsync(src, cost, distance, parent, parentEdge));
    }

    protected <ID> PgxFuture<AllPaths<ID>> shortestPathBellmanFordAsync(PgxGraph graph, PgxVertex<ID> src, EdgeProperty<Double> cost, String distanceName, String parentName, String parentEdgeName) {
        return this.allPathsAnalysis(graph, args -> {
            assert (args.dist != null);
            assert (args.parent != null);
            assert (args.parentEdge != null);
            return this.shortestPathBellmanFordAsync(graph, src, cost, args.dist, args.parent, args.parentEdge);
        }, distanceName, parentName, parentEdgeName);
    }

    public <ID> PgxFuture<AllPaths<ID>> shortestPathBellmanFordReverseAsync(PgxGraph graph, PgxVertex<ID> src, EdgeProperty<Double> cost) {
        DefaultPathNaming pathNames = Arguments.BELLMAN_FORD.getDefaultName(Arguments.TraversalDirection.REVERSE);
        return this.shortestPathBellmanFordReverseAsync(graph, src, cost, pathNames.distance, pathNames.parentName, pathNames.parentEdgeName);
    }

    public <ID> PgxFuture<AllPaths<ID>> shortestPathBellmanFordReverseAsync(PgxGraph graph, PgxVertex<ID> src, EdgeProperty<Double> cost, VertexProperty<ID, Double> distance, VertexProperty<ID, PgxVertex<ID>> parent, VertexProperty<ID, PgxEdge> parentEdge) {
        PgxFuture promise = new PgxFuture();
        return this.algorithms.pgxBuiltinP3rSingleSourceAllDestinationsBellmanFordReverse(this.sessionContext, graph.getId(), cost.getPropertyId(), this.serializeVertex(src), distance.getPropertyId(), parent.getPropertyId(), parentEdge.getPropertyId()).cancelOn(promise).thenComplete(promise).thenCompose(result -> graph.createAllPathsAsync(src, cost, distance, parent, parentEdge));
    }

    protected <ID> PgxFuture<AllPaths<ID>> shortestPathBellmanFordReverseAsync(PgxGraph graph, PgxVertex<ID> src, EdgeProperty<Double> cost, String distanceName, String parentName, String parentEdgeName) {
        return this.allPathsAnalysis(graph, args -> {
            assert (args.dist != null);
            assert (args.parent != null);
            assert (args.parentEdge != null);
            return this.shortestPathBellmanFordReverseAsync(graph, src, cost, args.dist, args.parent, args.parentEdge);
        }, distanceName, parentName, parentEdgeName);
    }

    public <ID> PgxFuture<AllPaths<ID>> shortestPathHopDistAsync(PgxGraph graph, PgxVertex<ID> src) {
        DefaultPathNaming pathNames = Arguments.HOP_DIST.getDefaultName(Arguments.TraversalDirection.FORWARD);
        return this.shortestPathHopDistAsync(graph, src, pathNames.distance, pathNames.parentName, pathNames.parentEdgeName);
    }

    public <ID> PgxFuture<AllPaths<ID>> shortestPathHopDistAsync(PgxGraph graph, PgxVertex<ID> src, VertexProperty<ID, Double> distance, VertexProperty<ID, PgxVertex<ID>> parent, VertexProperty<ID, PgxEdge> parentEdge) {
        PgxFuture promise = new PgxFuture();
        return this.algorithms.pgxBuiltinP4SingleSourceAllDestinationsHopDistance(this.sessionContext, graph.getId(), this.serializeVertex(src), distance.getPropertyId(), parent.getPropertyId(), parentEdge.getPropertyId()).cancelOn(promise).thenComplete(promise).thenCompose(result -> graph.createAllPathsAsync(src, null, distance, parent, parentEdge));
    }

    protected <ID> PgxFuture<AllPaths<ID>> shortestPathHopDistAsync(PgxGraph graph, PgxVertex<ID> src, String distanceName, String parentName, String parentEdgeName) {
        return this.allPathsAnalysis(graph, args -> {
            assert (args.dist != null);
            assert (args.parent != null);
            assert (args.parentEdge != null);
            return this.shortestPathHopDistAsync(graph, src, args.dist, args.parent, args.parentEdge);
        }, distanceName, parentName, parentEdgeName);
    }

    public <ID> PgxFuture<AllPaths<ID>> shortestPathHopDistReverseAsync(PgxGraph graph, PgxVertex<ID> src) {
        DefaultPathNaming pathNames = Arguments.HOP_DIST.getDefaultName(Arguments.TraversalDirection.REVERSE);
        return this.shortestPathHopDistReverseAsync(graph, src, pathNames.distance, pathNames.parentName, pathNames.parentEdgeName);
    }

    public <ID> PgxFuture<AllPaths<ID>> shortestPathHopDistReverseAsync(PgxGraph graph, PgxVertex<ID> src, VertexProperty<ID, Double> distance, VertexProperty<ID, PgxVertex<ID>> parent, VertexProperty<ID, PgxEdge> parentEdge) {
        PgxFuture promise = new PgxFuture();
        return this.algorithms.pgxBuiltinP4rSingleSourceAllDestinationsHopDistanceReverse(this.sessionContext, graph.getId(), this.serializeVertex(src), distance.getPropertyId(), parent.getPropertyId(), parentEdge.getPropertyId()).cancelOn(promise).thenComplete(promise).thenCompose(result -> graph.createAllPathsAsync(src, null, distance, parent, parentEdge));
    }

    protected <ID> PgxFuture<AllPaths<ID>> shortestPathHopDistReverseAsync(PgxGraph graph, PgxVertex<ID> src, String distanceName, String parentName, String parentEdgeName) {
        return this.allPathsAnalysis(graph, args -> {
            assert (args.dist != null);
            assert (args.parent != null);
            assert (args.parentEdge != null);
            return this.shortestPathHopDistReverseAsync(graph, src, args.dist, args.parent, args.parentEdge);
        }, distanceName, parentName, parentEdgeName);
    }

    public PgxFuture<Long> countTrianglesAsync(PgxGraph graph, boolean sortVerticesByDegree) {
        PgxFuture promise = new PgxFuture();
        ObjectHolder copyHolder = new ObjectHolder();
        return ((PgxFuture)((PgxFuture)graph.simplifyAsync(PgxGraph.MultiEdges.REMOVE_MULTI_EDGES, PgxGraph.SelfEdges.REMOVE_SELF_EDGES, PgxGraph.TrivialVertices.REMOVE_TRIVIAL_VERTICES, PgxGraph.Mode.CREATE_COPY, null).cancelOn(promise).thenCompose(simplified -> {
            assert (simplified != null);
            copyHolder.set(simplified);
            if (sortVerticesByDegree) {
                return simplified.sortByDegreeAsync(VertexProperty.NONE, EdgeProperty.NONE, PgxGraph.SortOrder.ASCENDING, PgxGraph.Degree.OUT, PgxGraph.Mode.MUTATE_IN_PLACE, null);
            }
            PgxFuture<PgxGraph> dummy = new PgxFuture<PgxGraph>();
            dummy.complete((PgxGraph)simplified);
            return dummy;
        })).cancelOn(promise).thenCompose(sorted -> {
            if (graph.isDirected()) {
                return this.algorithms.pgxBuiltinS1TriangleCounting(this.sessionContext, sorted.getId());
            }
            return this.algorithms.pgxBuiltinS1bTriangleCountingUndirected(this.sessionContext, sorted.getId());
        })).thenComplete(promise, () -> {
            PgxGraph copy = (PgxGraph)copyHolder.get();
            if (copy != null) {
                copy.destroyAsync();
            }
        });
    }

    public <ID> PgxFuture<Pair<Scalar<Long>, VertexProperty<ID, Long>>> kcoreAsync(PgxGraph graph) {
        return this.kcoreAsync(graph, 0, Integer.MAX_VALUE);
    }

    public <ID> PgxFuture<Pair<Scalar<Long>, VertexProperty<ID, Long>>> kcoreAsync(PgxGraph graph, int minCore, int maxCore, Scalar<Long> maxKCore, VertexProperty<ID, Long> kcore) {
        PgxFuture promise = new PgxFuture();
        return ((PgxFuture)((PgxFuture)this.algorithms.pgxBuiltinS9Kcore(this.sessionContext, graph.getId(), minCore, maxCore, kcore.getPropertyId()).cancelOn(promise).thenCompose(maxKCore::setAsync)).thenApply(arg -> new Pair((Object)maxKCore, (Object)kcore))).thenComplete(promise);
    }

    public <ID> PgxFuture<Pair<Scalar<Long>, VertexProperty<ID, Long>>> kcoreAsync(PgxGraph graph, int minCore, int maxCore) {
        return this.kcoreAsync(graph, minCore, maxCore, KcoreArguments.MAX_KCORE_NAME, KcoreArguments.KCORE_NAME);
    }

    public <ID> PgxFuture<Pair<Scalar<Long>, VertexProperty<ID, Long>>> kcoreAsync(PgxGraph graph, Scalar<Long> maxKCore, VertexProperty<ID, Long> kcore) {
        return this.kcoreAsync(graph, 0, Integer.MAX_VALUE, maxKCore, kcore);
    }

    protected <ID> PgxFuture<Pair<Scalar<Long>, VertexProperty<ID, Long>>> kcoreAsync(PgxGraph graph, int minCore, int maxCore, String maxKCoreName, String kcoreName) {
        ObjectHolder kCoreHolder = new ObjectHolder();
        return ((PgxFuture)graph.createVertexPropertyAsync(PropertyType.LONG, 0, kcoreName, false).thenCompose(kCoreProperty -> {
            this.addTransientObject((Destroyable)kCoreProperty);
            kCoreHolder.set(kCoreProperty);
            return graph.createScalarAsync(PropertyType.LONG, maxKCoreName);
        })).thenCompose(maxKCore -> {
            this.addTransientObject((Destroyable)maxKCore);
            return this.kcoreAsync(graph, minCore, maxCore, (Scalar<Long>)maxKCore, (VertexProperty)kCoreHolder.get());
        });
    }

    public <ID> PgxFuture<Pair<Scalar<Integer>, VertexProperty<ID, Integer>>> diameterAsync(PgxGraph graph) {
        return this.diameterAsync(graph, DiameterArguments.DIAMETER_NAME, "eccentricity");
    }

    public <ID> PgxFuture<Pair<Scalar<Integer>, VertexProperty<ID, Integer>>> diameterAsync(PgxGraph graph, Scalar<Integer> diameter, VertexProperty<ID, Integer> eccentricity) {
        PgxFuture promise = new PgxFuture();
        return ((PgxFuture)((PgxFuture)this.algorithms.pgxBuiltinS11Diameter(this.sessionContext, graph.getId(), true, eccentricity.getPropertyId()).cancelOn(promise).thenCompose(diameter::setAsync)).thenApply(arg -> new Pair((Object)diameter, (Object)eccentricity))).thenComplete(promise);
    }

    protected <ID> PgxFuture<Pair<Scalar<Integer>, VertexProperty<ID, Integer>>> diameterAsync(PgxGraph graph, String diameterName, String eccentricityName) {
        ObjectHolder eccentricityHolder = new ObjectHolder();
        return ((PgxFuture)graph.createVertexPropertyAsync(PropertyType.INTEGER, 0, eccentricityName, false).thenCompose(eccentricityProperty -> {
            this.addTransientObject((Destroyable)eccentricityProperty);
            eccentricityHolder.set(eccentricityProperty);
            return graph.createScalarAsync(PropertyType.INTEGER, diameterName);
        })).thenCompose(diameter -> {
            this.addTransientObject((Destroyable)diameter);
            return this.diameterAsync(graph, (Scalar<Integer>)diameter, (VertexProperty)eccentricityHolder.get());
        });
    }

    public <ID> PgxFuture<Pair<Scalar<Integer>, VertexProperty<ID, Integer>>> radiusAsync(PgxGraph graph) {
        return this.radiusAsync(graph, RadiusArguments.RADIUS_NAME, "eccentricity");
    }

    public <ID> PgxFuture<Pair<Scalar<Integer>, VertexProperty<ID, Integer>>> radiusAsync(PgxGraph graph, Scalar<Integer> radius, VertexProperty<ID, Integer> eccentricity) {
        PgxFuture promise = new PgxFuture();
        return ((PgxFuture)((PgxFuture)this.algorithms.pgxBuiltinS11Diameter(this.sessionContext, graph.getId(), false, eccentricity.getPropertyId()).cancelOn(promise).thenCompose(radius::setAsync)).thenApply(arg -> new Pair((Object)radius, (Object)eccentricity))).thenComplete(promise);
    }

    protected <ID> PgxFuture<Pair<Scalar<Integer>, VertexProperty<ID, Integer>>> radiusAsync(PgxGraph graph, String radiusName, String eccentricityName) {
        ObjectHolder eccentricityHolder = new ObjectHolder();
        return ((PgxFuture)graph.createVertexPropertyAsync(PropertyType.INTEGER, 0, eccentricityName, false).thenCompose(eccentricityProperty -> {
            this.addTransientObject((Destroyable)eccentricityProperty);
            eccentricityHolder.set(eccentricityProperty);
            return graph.createScalarAsync(PropertyType.INTEGER, radiusName);
        })).thenCompose(radius -> {
            this.addTransientObject((Destroyable)radius);
            return this.radiusAsync(graph, (Scalar<Integer>)radius, (VertexProperty)eccentricityHolder.get());
        });
    }

    public <ID> PgxFuture<VertexSet<ID>> peripheryAsync(PgxGraph graph) {
        return this.peripheryAsync(graph, PeripheryArguments.PERIPHERY_NAME);
    }

    public <ID> PgxFuture<VertexSet<ID>> peripheryAsync(PgxGraph graph, VertexSet<ID> periphery) {
        PgxFuture promise = new PgxFuture();
        return ((PgxFuture)this.algorithms.pgxBuiltinS12Periphery(this.sessionContext, graph.getId(), true, periphery.getId()).cancelOn(promise).thenApply(result -> periphery)).thenComplete(promise);
    }

    protected <ID> PgxFuture<VertexSet<ID>> peripheryAsync(PgxGraph graph, String peripheryName) {
        ObjectHolder peripheryHolder = new ObjectHolder();
        return graph.createVertexSetAsync().thenCompose(periphery -> {
            this.addTransientObject((Destroyable)periphery);
            peripheryHolder.set(periphery);
            assert (peripheryHolder != null);
            return this.peripheryAsync(graph, (VertexSet)peripheryHolder.get());
        });
    }

    public <ID> PgxFuture<VertexSet<ID>> centerAsync(PgxGraph graph) {
        return this.centerAsync(graph, CenterArguments.CENTER_NAME);
    }

    public <ID> PgxFuture<VertexSet<ID>> centerAsync(PgxGraph graph, VertexSet<ID> center) {
        PgxFuture promise = new PgxFuture();
        return ((PgxFuture)this.algorithms.pgxBuiltinS12Periphery(this.sessionContext, graph.getId(), false, center.getId()).cancelOn(promise).thenApply(result -> center)).thenComplete(promise);
    }

    protected <ID> PgxFuture<VertexSet<ID>> centerAsync(PgxGraph graph, String centerName) {
        ObjectHolder centerHolder = new ObjectHolder();
        return graph.createVertexSetAsync().thenCompose(center -> {
            this.addTransientObject((Destroyable)center);
            centerHolder.set(center);
            assert (centerHolder != null);
            return this.centerAsync(graph, (VertexSet)centerHolder.get());
        });
    }

    public <ID> PgxFuture<VertexProperty<ID, Double>> localClusteringCoefficientAsync(PgxGraph graph) {
        return this.localClusteringCoefficientAsync(graph, "lcc");
    }

    public <ID> PgxFuture<VertexProperty<ID, Double>> localClusteringCoefficientAsync(PgxGraph graph, VertexProperty<ID, Double> lcc) {
        PgxFuture promise = new PgxFuture();
        return ((PgxFuture)this.algorithms.pgxBuiltinS13LocalClusteringCoefficient(this.sessionContext, graph.getId(), lcc.getPropertyId()).cancelOn(promise).thenApply(result -> lcc)).thenComplete(promise);
    }

    protected <ID> PgxFuture<VertexProperty<ID, Double>> localClusteringCoefficientAsync(PgxGraph graph, String lccName) {
        ObjectHolder lccHolder = new ObjectHolder();
        return graph.createVertexPropertyAsync(PropertyType.DOUBLE, 0, lccName, false).thenCompose(lccProperty -> {
            this.addTransientObject((Destroyable)lccProperty);
            lccHolder.set(lccProperty);
            return this.localClusteringCoefficientAsync(graph, (VertexProperty)lccHolder.get());
        });
    }

    public <ID> PgxFuture<PgxPath<ID>> findCycleAsync(PgxGraph graph) {
        return this.findCycleAsync(graph, FindCycleArguments.DEFAULT_NODE_SEQUENCE_NAME, FindCycleArguments.DEFAULT_EDGE_SEQUENCE_NAME);
    }

    protected <ID> PgxFuture<PgxPath<ID>> findCycleAsync(PgxGraph graph, String nodeSeqName, String edgeSeqName) {
        ObjectHolder nodeSeqHolder = new ObjectHolder();
        return ((PgxFuture)graph.createVertexSequenceAsync(nodeSeqName).thenCompose(nodeSeq -> {
            nodeSeqHolder.set(nodeSeq);
            this.addTransientObject((Destroyable)nodeSeq);
            return graph.createEdgeSequenceAsync(edgeSeqName);
        })).thenCompose(edgeSeq -> {
            this.addTransientObject((Destroyable)edgeSeq);
            return this.findCycleAsync(graph, (VertexSequence)nodeSeqHolder.get(), (EdgeSequence)edgeSeq);
        });
    }

    public <ID> PgxFuture<PgxPath<ID>> findCycleAsync(PgxGraph graph, VertexSequence<ID> nodeSeq, EdgeSequence edgeSeq) {
        PgxFuture promise = new PgxFuture();
        return this.algorithms.pgxBuiltinS14aFindCycle(this.sessionContext, graph.getId(), nodeSeq.getId(), edgeSeq.getId()).cancelOn(promise).thenComplete(promise).thenCompose(result -> graph.createPathAsync(nodeSeq, edgeSeq));
    }

    public <ID> PgxFuture<PgxPath<ID>> findCycleAsync(PgxGraph graph, PgxVertex<ID> src) {
        return this.findCycleAsync(graph, src, FindCycleArguments.DEFAULT_NODE_SEQUENCE_NAME, FindCycleArguments.DEFAULT_EDGE_SEQUENCE_NAME);
    }

    protected <ID> PgxFuture<PgxPath<ID>> findCycleAsync(PgxGraph graph, PgxVertex<ID> src, String nodeSeqName, String edgeSeqName) {
        ObjectHolder nodeSeqHolder = new ObjectHolder();
        return ((PgxFuture)graph.createVertexSequenceAsync(nodeSeqName).thenCompose(nodeSeq -> {
            nodeSeqHolder.set(nodeSeq);
            this.addTransientObject((Destroyable)nodeSeq);
            return graph.createEdgeSequenceAsync(edgeSeqName);
        })).thenCompose(edgeSeq -> {
            VertexSequence nodeSeq = (VertexSequence)nodeSeqHolder.get();
            this.addTransientObject((Destroyable)edgeSeq);
            return this.findCycleAsync(graph, src, nodeSeq, (EdgeSequence)edgeSeq);
        });
    }

    public <ID> PgxFuture<PgxPath<ID>> findCycleAsync(PgxGraph graph, PgxVertex<ID> src, VertexSequence<ID> nodeSeq, EdgeSequence edgeSeq) {
        PgxFuture promise = new PgxFuture();
        return this.algorithms.pgxBuiltinS14bFindCycleFromNode(this.sessionContext, graph.getId(), this.serializeVertex(src), nodeSeq.getId(), edgeSeq.getId()).cancelOn(promise).thenComplete(promise).thenCompose(result -> graph.createPathAsync(nodeSeq, edgeSeq));
    }

    public <ID> PgxFuture<Integer> reachabilityAsync(PgxGraph graph, PgxVertex<ID> source, PgxVertex<ID> dest, int maxHops, boolean ignoreEdgeDirection) {
        PgxFuture promise = new PgxFuture();
        if (ignoreEdgeDirection) {
            return this.algorithms.pgxBuiltinS15bReachabilityUndirected(this.sessionContext, graph.getId(), this.serializeVertex(source), this.serializeVertex(dest), maxHops).cancelOn(promise).thenComplete(promise);
        }
        return this.algorithms.pgxBuiltinS15aReachability(this.sessionContext, graph.getId(), this.serializeVertex(source), this.serializeVertex(dest), maxHops).cancelOn(promise).thenComplete(promise);
    }

    public <ID> PgxFuture<VertexProperty<ID, Integer>> topologicalSortAsync(PgxGraph graph) {
        return this.topologicalSortAsync(graph, Arguments.TOPOLOGICAL_SORT.getDefaultName(TopologicalSortArguments.TopologicalSortVariant.DEFAULT));
    }

    public <ID> PgxFuture<VertexProperty<ID, Integer>> topologicalSortAsync(PgxGraph graph, VertexProperty<ID, Integer> topoSort) {
        PgxFuture promise = new PgxFuture();
        return ((PgxFuture)this.algorithms.pgxBuiltinS16aTopologicalSort(this.sessionContext, graph.getId(), topoSort.getPropertyId()).cancelOn(promise).thenApply(result -> topoSort)).thenComplete(promise);
    }

    protected <ID> PgxFuture<VertexProperty<ID, Integer>> topologicalSortAsync(PgxGraph graph, String propertyName) {
        return this.vertexCentralityAnalysis(graph, topoSort -> this.topologicalSortAsync(graph, (VertexProperty)topoSort), PropertyType.INTEGER, propertyName);
    }

    public <ID> PgxFuture<VertexProperty<ID, Integer>> topologicalScheduleAsync(PgxGraph graph, VertexSet<ID> source) {
        return this.topologicalScheduleAsync(graph, source, Arguments.TOPOLOGICAL_SORT.getDefaultName(TopologicalSortArguments.TopologicalSortVariant.SCHEDULE));
    }

    public <ID> PgxFuture<VertexProperty<ID, Integer>> topologicalScheduleAsync(PgxGraph graph, VertexSet<ID> source, VertexProperty<ID, Integer> topoSched) {
        PgxFuture promise = new PgxFuture();
        return ((PgxFuture)this.algorithms.pgxBuiltinS16bTopologicalSchedule(this.sessionContext, graph.getId(), source.getId(), topoSched.getPropertyId()).cancelOn(promise).thenApply(result -> topoSched)).thenComplete(promise);
    }

    protected <ID> PgxFuture<VertexProperty<ID, Integer>> topologicalScheduleAsync(PgxGraph graph, VertexSet<ID> source, String propertyName) {
        return this.vertexCentralityAnalysis(graph, topoSched -> this.topologicalScheduleAsync(graph, source, (VertexProperty)topoSched), PropertyType.INTEGER, propertyName);
    }

    public PgxFuture<PgxMap<Integer, Long>> outDegreeDistributionAsync(PgxGraph graph) {
        return this.outDegreeDistributionAsync(graph, Arguments.DEGREE_DISTRIBUTION.getDefaultName(Direction.OUTGOING));
    }

    public PgxFuture<PgxMap<Integer, Long>> outDegreeDistributionAsync(PgxGraph graph, PgxMap<Integer, Long> distribution) {
        PgxFuture promise = new PgxFuture();
        return ((PgxFuture)this.algorithms.pgxBuiltinS6OutDegreeDistribution(this.sessionContext, graph.getId(), distribution.getName()).cancelOn(promise).thenApply(result -> distribution)).thenComplete(promise);
    }

    protected PgxFuture<PgxMap<Integer, Long>> outDegreeDistributionAsync(PgxGraph graph, String distributionName) {
        return this.degreeDistribution(graph, map -> this.outDegreeDistributionAsync(graph, (PgxMap<Integer, Long>)map), distributionName);
    }

    public PgxFuture<PgxMap<Integer, Long>> inDegreeDistributionAsync(PgxGraph graph) {
        return this.inDegreeDistributionAsync(graph, Arguments.DEGREE_DISTRIBUTION.getDefaultName(Direction.INCOMING));
    }

    public PgxFuture<PgxMap<Integer, Long>> inDegreeDistributionAsync(PgxGraph graph, PgxMap<Integer, Long> distribution) {
        PgxFuture promise = new PgxFuture();
        return ((PgxFuture)this.algorithms.pgxBuiltinS7InDegreeDistribution(this.sessionContext, graph.getId(), distribution.getName()).cancelOn(promise).thenApply(result -> distribution)).thenComplete(promise);
    }

    protected PgxFuture<PgxMap<Integer, Long>> inDegreeDistributionAsync(PgxGraph graph, String distributionName) {
        return this.degreeDistribution(graph, map -> this.inDegreeDistributionAsync(graph, (PgxMap<Integer, Long>)map), distributionName);
    }

    public PgxFuture<EdgeProperty<Boolean>> primAsync(PgxGraph graph, EdgeProperty<Double> weight) {
        return this.primAsync(graph, weight, "mst");
    }

    public PgxFuture<EdgeProperty<Boolean>> primAsync(PgxGraph graph, EdgeProperty<Double> weight, EdgeProperty<Boolean> mst) {
        PgxFuture promise = new PgxFuture();
        return ((PgxFuture)this.algorithms.pgxBuiltinA1Prim(this.sessionContext, graph.getId(), weight.getPropertyId(), mst.getPropertyId()).cancelOn(promise).thenApply(result -> mst)).thenComplete(promise);
    }

    protected PgxFuture<EdgeProperty<Boolean>> primAsync(PgxGraph graph, EdgeProperty<Double> weight, String mstName) {
        ObjectHolder mstHolder = new ObjectHolder();
        return graph.createEdgePropertyAsync(PropertyType.BOOLEAN, 0, mstName, false).thenCompose(mstProperty -> {
            this.addTransientObject((Destroyable)mstProperty);
            mstHolder.set(mstProperty);
            return this.primAsync(graph, weight, (EdgeProperty)mstHolder.get());
        });
    }

    public <ID> PgxFuture<Pair<VertexProperty<ID, Integer>, VertexProperty<ID, PgxVertex<ID>>>> filteredBfsAsync(PgxGraph graph, PgxVertex<ID> root) {
        return this.filteredBfsAsync(graph, root, VertexFilter.ALL, true);
    }

    public <ID> PgxFuture<Pair<VertexProperty<ID, Integer>, VertexProperty<ID, PgxVertex<ID>>>> filteredBfsAsync(PgxGraph graph, PgxVertex<ID> root, int maxDepth) {
        return this.filteredBfsAsync(graph, root, VertexFilter.ALL, true, maxDepth);
    }

    public <ID> PgxFuture<Pair<VertexProperty<ID, Integer>, VertexProperty<ID, PgxVertex<ID>>>> filteredBfsAsync(PgxGraph graph, PgxVertex<ID> root, VertexFilter navigator) {
        return this.filteredBfsAsync(graph, root, navigator, true);
    }

    public <ID> PgxFuture<Pair<VertexProperty<ID, Integer>, VertexProperty<ID, PgxVertex<ID>>>> filteredBfsAsync(PgxGraph graph, PgxVertex<ID> root, VertexFilter navigator, int maxDepth) {
        return this.filteredBfsAsync(graph, root, navigator, true, maxDepth);
    }

    public <ID> PgxFuture<Pair<VertexProperty<ID, Integer>, VertexProperty<ID, PgxVertex<ID>>>> filteredBfsAsync(PgxGraph graph, PgxVertex<ID> root, VertexFilter navigator, boolean initWithInf) {
        return this.filteredBfsAsync(graph, root, VertexFilter.ALL, navigator, initWithInf, Integer.MAX_VALUE, "distance", "parent");
    }

    public <ID> PgxFuture<Pair<VertexProperty<ID, Integer>, VertexProperty<ID, PgxVertex<ID>>>> filteredBfsAsync(PgxGraph graph, PgxVertex<ID> root, VertexFilter navigator, boolean initWithInf, int maxDepth) {
        return this.filteredBfsAsync(graph, root, VertexFilter.ALL, navigator, initWithInf, maxDepth, "distance", "parent");
    }

    public <ID> PgxFuture<Pair<VertexProperty<ID, Integer>, VertexProperty<ID, PgxVertex<ID>>>> filteredBfsAsync(PgxGraph graph, PgxVertex<ID> root, VertexFilter navigator, boolean initWithInf, VertexProperty<ID, Integer> distance, VertexProperty<ID, PgxVertex<ID>> parent) {
        return this.filteredBfsAsync(graph, root, navigator, initWithInf, Integer.MAX_VALUE, distance, parent);
    }

    public <ID> PgxFuture<Pair<VertexProperty<ID, Integer>, VertexProperty<ID, PgxVertex<ID>>>> filteredBfsAsync(PgxGraph graph, PgxVertex<ID> root, VertexFilter navigator, boolean initWithInf, int maxDepth, VertexProperty<ID, Integer> distance, VertexProperty<ID, PgxVertex<ID>> parent) {
        PgxFuture promise = new PgxFuture();
        return ((PgxFuture)this.algorithms.pgxBuiltinO1FilteredBfs(this.sessionContext, graph.getId(), this.serializeVertex(root), initWithInf, VertexFilter.ALL, navigator, maxDepth, distance.getPropertyId(), parent.getPropertyId()).cancelOn(promise).thenApply(arg -> new Pair((Object)distance, (Object)parent))).thenComplete(promise);
    }

    private <ID> PgxFuture<Pair<VertexProperty<ID, Integer>, VertexProperty<ID, PgxVertex<ID>>>> filteredBfsAsync(PgxGraph graph, PgxVertex<ID> root, VertexFilter filter, VertexFilter navigator, boolean initWithInf, int maxDepth, String distanceName, String parentName) {
        if (filter != VertexFilter.ALL) {
            LOG.warn("using the filter expression is deprecated and has no effect; use the navigator instead");
        }
        PgxFuture promise = new PgxFuture();
        ObjectHolder distHolder = new ObjectHolder();
        ObjectHolder parentHolder = new ObjectHolder();
        return ((PgxFuture)((PgxFuture)((PgxFuture)graph.createVertexPropertyAsync(PropertyType.INTEGER, 0, distanceName, false).thenCompose(dist -> {
            distHolder.set(dist);
            return graph.createVertexPropertyAsync(PropertyType.VERTEX, 0, parentName, false);
        })).thenCompose(parent -> {
            parentHolder.set(parent);
            VertexProperty dist = (VertexProperty)distHolder.get();
            assert (dist != null);
            return this.filteredBfsAsync(graph, root, navigator, initWithInf, maxDepth, dist, (VertexProperty)parent).cancelOn(promise);
        })).cancelOn(promise).thenApply(arg -> {
            VertexProperty dist = (VertexProperty)distHolder.get();
            VertexProperty parent = (VertexProperty)parentHolder.get();
            assert (dist != null);
            assert (parent != null);
            this.addTransientObject(dist);
            this.addTransientObject(parent);
            return new Pair((Object)dist, (Object)parent);
        })).thenComplete(promise);
    }

    public <ID> PgxFuture<Pair<VertexProperty<ID, Integer>, VertexProperty<ID, PgxVertex<ID>>>> filteredDfsAsync(PgxGraph graph, PgxVertex<ID> root) {
        return this.filteredDfsAsync(graph, root, VertexFilter.ALL, true);
    }

    public <ID> PgxFuture<Pair<VertexProperty<ID, Integer>, VertexProperty<ID, PgxVertex<ID>>>> filteredDfsAsync(PgxGraph graph, PgxVertex<ID> root, int maxDepth) {
        return this.filteredDfsAsync(graph, root, VertexFilter.ALL, true, maxDepth);
    }

    public <ID> PgxFuture<Pair<VertexProperty<ID, Integer>, VertexProperty<ID, PgxVertex<ID>>>> filteredDfsAsync(PgxGraph graph, PgxVertex<ID> root, VertexFilter navigator) {
        return this.filteredDfsAsync(graph, root, navigator, true);
    }

    public <ID> PgxFuture<Pair<VertexProperty<ID, Integer>, VertexProperty<ID, PgxVertex<ID>>>> filteredDfsAsync(PgxGraph graph, PgxVertex<ID> root, VertexFilter navigator, int maxDepth) {
        return this.filteredDfsAsync(graph, root, navigator, true, maxDepth);
    }

    public <ID> PgxFuture<Pair<VertexProperty<ID, Integer>, VertexProperty<ID, PgxVertex<ID>>>> filteredDfsAsync(PgxGraph graph, PgxVertex<ID> root, VertexFilter navigator, boolean initWithInf) {
        return this.filteredDfsAsync(graph, root, VertexFilter.ALL, navigator, initWithInf, Integer.MAX_VALUE, "distance", "parent");
    }

    public <ID> PgxFuture<Pair<VertexProperty<ID, Integer>, VertexProperty<ID, PgxVertex<ID>>>> filteredDfsAsync(PgxGraph graph, PgxVertex<ID> root, VertexFilter navigator, boolean initWithInf, int maxDepth) {
        return this.filteredDfsAsync(graph, root, VertexFilter.ALL, navigator, initWithInf, maxDepth, "distance", "parent");
    }

    public <ID> PgxFuture<Pair<VertexProperty<ID, Integer>, VertexProperty<ID, PgxVertex<ID>>>> filteredDfsAsync(PgxGraph graph, PgxVertex<ID> root, VertexFilter navigator, boolean initWithInf, VertexProperty<ID, Integer> distance, VertexProperty<ID, PgxVertex<ID>> parent) {
        return this.filteredDfsAsync(graph, root, navigator, initWithInf, Integer.MAX_VALUE, distance, parent);
    }

    public <ID> PgxFuture<Pair<VertexProperty<ID, Integer>, VertexProperty<ID, PgxVertex<ID>>>> filteredDfsAsync(PgxGraph graph, PgxVertex<ID> root, VertexFilter navigator, boolean initWithInf, int maxDepth, VertexProperty<ID, Integer> distance, VertexProperty<ID, PgxVertex<ID>> parent) {
        PgxFuture promise = new PgxFuture();
        return ((PgxFuture)this.algorithms.pgxBuiltinO2FilteredDfs(this.sessionContext, graph.getId(), this.serializeVertex(root), initWithInf, VertexFilter.ALL, navigator, maxDepth, distance.getPropertyId(), parent.getPropertyId()).cancelOn(promise).thenApply(arg -> new Pair((Object)distance, (Object)parent))).thenComplete(promise);
    }

    private <ID> PgxFuture<Pair<VertexProperty<ID, Integer>, VertexProperty<ID, PgxVertex<ID>>>> filteredDfsAsync(PgxGraph graph, PgxVertex<ID> root, VertexFilter filter, VertexFilter navigator, boolean initWithInf, int maxDepth, String distanceName, String parentName) {
        if (filter != VertexFilter.ALL) {
            LOG.warn("using the filter expression is deprecated and has no effect; use the navigator instead");
        }
        PgxFuture promise = new PgxFuture();
        ObjectHolder distHolder = new ObjectHolder();
        ObjectHolder parentHolder = new ObjectHolder();
        return ((PgxFuture)((PgxFuture)((PgxFuture)graph.createVertexPropertyAsync(PropertyType.INTEGER, 0, distanceName, false).thenCompose(dist -> {
            distHolder.set(dist);
            return graph.createVertexPropertyAsync(PropertyType.VERTEX, 0, parentName, false);
        })).thenCompose(parent -> {
            parentHolder.set(parent);
            VertexProperty dist = (VertexProperty)distHolder.get();
            assert (dist != null);
            return this.filteredDfsAsync(graph, root, navigator, initWithInf, maxDepth, dist, (VertexProperty)parent).cancelOn(promise);
        })).cancelOn(promise).thenApply(arg -> {
            VertexProperty dist = (VertexProperty)distHolder.get();
            VertexProperty parent = (VertexProperty)parentHolder.get();
            assert (dist != null);
            assert (parent != null);
            this.addTransientObject(dist);
            this.addTransientObject(parent);
            return new Pair((Object)dist, (Object)parent);
        })).thenComplete(promise);
    }

    public <ID> PgxFuture<Pair<PgxMap<Integer, PgxVertex<ID>>, VertexSet<ID>>> computeHighDegreeVerticesAsync(PgxGraph graph, int k, PgxMap<Integer, PgxVertex<ID>> highDegreeVertexMapping, VertexSet<ID> highDegreeVertices) {
        PgxFuture promise = new PgxFuture();
        return ((PgxFuture)this.algorithms.pgxBuiltinO6ComputeSupernodes(this.sessionContext, graph.getId(), k, highDegreeVertexMapping.getName(), highDegreeVertices.getId()).cancelOn(promise).thenApply(arg -> new Pair((Object)highDegreeVertexMapping, (Object)highDegreeVertices))).thenComplete(promise);
    }

    public <ID> PgxFuture<Pair<PgxMap<Integer, PgxVertex<ID>>, VertexSet<ID>>> computeHighDegreeVerticesAsync(PgxGraph graph, int k) {
        PgxFuture promise = new PgxFuture();
        return ((PgxFuture)graph.createVertexSetAsync().thenCombine(graph.createMapAsync(PropertyType.INTEGER, PropertyType.VERTEX), (highDegreeVertices, highDegreeVertexMapping) -> new Pair(highDegreeVertexMapping, highDegreeVertices)).cancelOn(promise).thenCompose(pair -> {
            PgxMap highDegreeVertexMapping = (PgxMap)pair.getFirst();
            VertexSet highDegreeVertices = (VertexSet)pair.getSecond();
            return this.algorithms.pgxBuiltinO6ComputeSupernodes(this.sessionContext, graph.getId(), k, highDegreeVertexMapping.getName(), highDegreeVertices.getId()).cancelOn(promise).thenApply(arg -> pair);
        })).thenComplete(promise);
    }

    public <ID> PgxFuture<VertexProperty<ID, PgxVect<Integer>>> createDistanceIndexAsync(PgxGraph graph, PgxMap<Integer, PgxVertex<ID>> highDegreeVertexMapping, VertexSet<ID> highDegreeVertices) {
        PgxFuture promise = new PgxFuture();
        int numHighDegreeVertices = highDegreeVertices.size();
        return ((PgxFuture)graph.createVertexVectorPropertyAsync(PropertyType.INTEGER, numHighDegreeVertices).thenCompose(index -> this.createDistanceIndexAsync(graph, highDegreeVertexMapping, highDegreeVertices, (VertexProperty)index).cancelOn(promise).thenApply(arg -> index))).thenComplete(promise);
    }

    public <ID> PgxFuture<VertexProperty<ID, PgxVect<Integer>>> createDistanceIndexAsync(PgxGraph graph, PgxMap<Integer, PgxVertex<ID>> highDegreeVertexMapping, VertexSet<ID> highDegreeVertices, VertexProperty<ID, PgxVect<Integer>> index) {
        int numHighDegreeVertices = highDegreeVertices.size();
        PgxFuture promise = new PgxFuture();
        return ((PgxFuture)this.algorithms.pgxBuiltinO7ComputeDistanceIndex(this.sessionContext, graph.getId(), numHighDegreeVertices, highDegreeVertexMapping.getName(), highDegreeVertices.getId(), index.getPropertyId()).cancelOn(promise).thenApply(arg -> index)).thenComplete(promise);
    }

    public <ID> PgxFuture<Pair<VertexSequence<ID>, EdgeSequence>> limitedShortestPathHopDistAsync(PgxGraph graph, PgxVertex<ID> src, PgxVertex<ID> dst, int maxHops, PgxMap<Integer, PgxVertex<ID>> highDegreeVertexMapping, VertexSet<ID> highDegreeVertices, VertexProperty<ID, PgxVect<Integer>> index, VertexSequence<ID> pathVertices, EdgeSequence pathEdges) {
        PgxFuture promise = new PgxFuture();
        int numHighDegreeVertices = highDegreeVertices.size();
        return ((PgxFuture)this.algorithms.pgxBuiltinO8LimitedPathFindingUndirected(this.sessionContext, graph.getId(), this.serializeVertex(src), this.serializeVertex(dst), numHighDegreeVertices, maxHops, highDegreeVertices.getId(), highDegreeVertexMapping.getName(), index.getPropertyId(), pathVertices.getId(), pathEdges.getId()).cancelOn(promise).thenApply(arg -> new Pair((Object)pathVertices, (Object)pathEdges))).thenComplete(promise);
    }

    public <ID> PgxFuture<Pair<VertexSequence<ID>, EdgeSequence>> limitedShortestPathHopDistAsync(PgxGraph graph, PgxVertex<ID> src, PgxVertex<ID> dst, int maxHops, PgxMap<Integer, PgxVertex<ID>> highDegreeVertexMapping, VertexSet<ID> highDegreeVertices, VertexProperty<ID, PgxVect<Integer>> index) {
        PgxFuture promise = new PgxFuture();
        return ((PgxFuture)this.createVertexSeqAndEdgeSeq(graph).thenCompose(pair -> {
            VertexSequence pathVertices = (VertexSequence)pair.getFirst();
            EdgeSequence pathEdges = (EdgeSequence)pair.getSecond();
            return this.limitedShortestPathHopDistAsync(graph, src, dst, maxHops, highDegreeVertexMapping, highDegreeVertices, index, pathVertices, pathEdges);
        })).thenComplete(promise);
    }

    public <ID> PgxFuture<Pair<VertexSequence<ID>, EdgeSequence>> limitedShortestPathHopDistFilteredAsync(PgxGraph graph, PgxVertex<ID> src, PgxVertex<ID> dst, int maxHops, PgxMap<Integer, PgxVertex<ID>> highDegreeVertexMapping, VertexSet<ID> highDegreeVertices, VertexProperty<ID, PgxVect<Integer>> index, EdgeFilter filter, VertexSequence<ID> pathVertices, EdgeSequence pathEdges) {
        PgxFuture promise = new PgxFuture();
        int numHighDegreeVertices = highDegreeVertices.size();
        return ((PgxFuture)this.algorithms.pgxBuiltinO9LimitedPathFindingUndirectedFiltered(this.sessionContext, graph.getId(), this.serializeVertex(src), this.serializeVertex(dst), numHighDegreeVertices, maxHops, highDegreeVertices.getId(), highDegreeVertexMapping.getName(), index.getPropertyId(), (GraphFilter)filter, pathVertices.getId(), pathEdges.getId()).cancelOn(promise).thenApply(arg -> new Pair((Object)pathVertices, (Object)pathEdges))).thenComplete(promise);
    }

    public <ID> PgxFuture<Pair<VertexSequence<ID>, EdgeSequence>> limitedShortestPathHopDistFilteredAsync(PgxGraph graph, PgxVertex<ID> src, PgxVertex<ID> dst, int maxHops, PgxMap<Integer, PgxVertex<ID>> highDegreeVertexMapping, VertexSet<ID> highDegreeVertices, VertexProperty<ID, PgxVect<Integer>> index, EdgeFilter filter) {
        PgxFuture promise = new PgxFuture();
        return ((PgxFuture)this.createVertexSeqAndEdgeSeq(graph).thenCompose(pair -> {
            VertexSequence pathVertices = (VertexSequence)pair.getFirst();
            EdgeSequence pathEdges = (EdgeSequence)pair.getSecond();
            return this.limitedShortestPathHopDistFilteredAsync(graph, src, dst, maxHops, highDegreeVertexMapping, highDegreeVertices, index, filter, pathVertices, pathEdges);
        })).thenComplete(promise);
    }

    public <ID> PgxFuture<Triple<VertexSet<ID>, EdgeSet, PgxMap<PgxVertex<ID>, Integer>>> allReachableVerticesEdgesAsync(PgxGraph graph, PgxVertex<ID> src, PgxVertex<ID> dst, int k) {
        PgxFuture promise = new PgxFuture();
        return ((PgxFuture)this.createVertexSetEdgeSetAndDistanceMap(graph).thenCompose(arguments -> {
            VertexSet pathVertices = (VertexSet)arguments.getLeft();
            EdgeSet pathEdges = (EdgeSet)arguments.getMiddle();
            PgxMap distances = (PgxMap)arguments.getRight();
            return this.algorithms.pgxBuiltinO10AllReachableVerticesEdges(this.sessionContext, graph.getId(), this.serializeVertex(src), this.serializeVertex(dst), k, pathVertices.getId(), pathEdges.getId(), distances.getName()).cancelOn(promise).thenApply(arg -> Triple.of((Object)pathVertices, (Object)pathEdges, (Object)distances));
        })).thenComplete(promise);
    }

    public <ID> PgxFuture<Triple<VertexSet<ID>, EdgeSet, PgxMap<PgxVertex<ID>, Integer>>> allReachableVerticesEdgesFilteredAsync(PgxGraph graph, PgxVertex<ID> src, PgxVertex<ID> dst, int k, EdgeFilter filter) {
        PgxFuture promise = new PgxFuture();
        return ((PgxFuture)this.createVertexSetEdgeSetAndDistanceMap(graph).thenCompose(arguments -> {
            VertexSet pathVertices = (VertexSet)arguments.getLeft();
            EdgeSet pathEdges = (EdgeSet)arguments.getMiddle();
            PgxMap distances = (PgxMap)arguments.getRight();
            return this.algorithms.pgxBuiltinO11AllReachableVerticesEdgesFiltered(this.sessionContext, graph.getId(), this.serializeVertex(src), this.serializeVertex(dst), k, (GraphFilter)filter, pathVertices.getId(), pathEdges.getId(), distances.getName()).cancelOn(promise).thenApply(arg -> Triple.of((Object)pathVertices, (Object)pathEdges, (Object)distances));
        })).thenComplete(promise);
    }

    public <ID> PgxFuture<Triple<ScalarSequence<Integer>, VertexSequence<ID>, EdgeSequence>> enumerateSimplePathsAsync(PgxGraph graph, PgxVertex<ID> src, PgxVertex<ID> dst, int k, VertexSet verticesOnPath, EdgeSet edgesOnPath, PgxMap<PgxVertex<ID>, Integer> dist) {
        PgxFuture promise = new PgxFuture();
        return ((PgxFuture)this.createIntSeqVertexSeqAndEdgeSeq(graph).thenCompose(arguments -> {
            ScalarSequence pathLengths = (ScalarSequence)arguments.getLeft();
            VertexSequence pathVertices = (VertexSequence)arguments.getMiddle();
            EdgeSequence pathEdges = (EdgeSequence)arguments.getRight();
            return this.algorithms.pgxBuiltinO12EnumerateSimplePaths(this.sessionContext, graph.getId(), this.serializeVertex(src), this.serializeVertex(dst), k, verticesOnPath.getId(), edgesOnPath.getId(), dist.getName(), pathLengths.getId(), pathVertices.getId(), pathEdges.getId()).cancelOn(promise).thenApply(arg -> Triple.of((Object)pathLengths, (Object)pathVertices, (Object)pathEdges));
        })).thenComplete(promise);
    }

    private <ID> PgxFuture<Pair<VertexSequence<ID>, EdgeSequence>> createVertexSeqAndEdgeSeq(PgxGraph graph) {
        return graph.createVertexSequenceAsync().thenCombine(graph.createEdgeSequenceAsync(), Pair::new);
    }

    private <ID> PgxFuture<Triple<VertexSet<ID>, EdgeSet, PgxMap<PgxVertex<ID>, Integer>>> createVertexSetEdgeSetAndDistanceMap(PgxGraph graph) {
        return graph.createVertexSetAsync().thenCombine(graph.createEdgeSetAsync().thenCombine(graph.createMapAsync(PropertyType.VERTEX, PropertyType.INTEGER), Pair::new), Pair::new).thenApply(Analyst::getTripleFromNestedPair);
    }

    private <ID> PgxFuture<Triple<ScalarSequence<Integer>, VertexSequence<ID>, EdgeSequence>> createIntSeqVertexSeqAndEdgeSeq(PgxGraph graph) {
        return this.session.createSequenceAsync(PropertyType.INTEGER).thenCombine(graph.createVertexSequenceAsync().thenCombine(graph.createEdgeSequenceAsync(), Pair::new), Pair::new).thenApply(Analyst::getTripleFromNestedPair);
    }

    private static <A, B, C> Triple<A, B, C> getTripleFromNestedPair(Pair<A, Pair<B, C>> arg) {
        return Triple.of((Object)arg.getFirst(), (Object)((Pair)arg.getSecond()).getFirst(), (Object)((Pair)arg.getSecond()).getSecond());
    }

    public <ID> PgxFuture<VertexProperty<ID, Boolean>> bipartiteCheckAsync(PgxGraph graph, VertexProperty<ID, Boolean> isLeft) {
        PgxFuture promise = new PgxFuture();
        return ((PgxFuture)this.algorithms.pgxBuiltinS10BipartiteCheck(this.sessionContext, graph.getId(), isLeft.getPropertyId()).cancelOn(promise).thenApply(result -> isLeft)).thenComplete(promise);
    }

    private <ID, V, R> PgxFuture<VertexProperty<ID, V>> vertexCentralityAnalysis(PgxGraph graph, Function<VertexProperty<ID, V>, PgxFuture<R>> analysis, PropertyType type, String rankPropertyName) {
        PgxFuture promise = new PgxFuture();
        ObjectHolder centralityPropertyHolder = new ObjectHolder();
        return ((PgxFuture)((PgxFuture)graph.createVertexPropertyAsync(type, 0, rankPropertyName, false).thenCompose(p -> {
            centralityPropertyHolder.set(p);
            return ((PgxFuture)analysis.apply((VertexProperty)p)).cancelOn(promise);
        })).thenApply(arg -> {
            VertexProperty centralityProperty = (VertexProperty)centralityPropertyHolder.get();
            assert (centralityProperty != null);
            this.addTransientObject(centralityProperty);
            return centralityProperty;
        })).thenComplete(promise);
    }

    protected PgxFuture<PgxMap<Integer, Long>> degreeDistribution(PgxGraph graph, Function<PgxMap<Integer, Long>, PgxFuture<PgxMap<Integer, Long>>> algorithm, String mapName) {
        PgxFuture promise = new PgxFuture();
        ObjectHolder mapHolder = new ObjectHolder();
        return ((PgxFuture)((PgxFuture)graph.createMapAsync(PropertyType.INTEGER, PropertyType.LONG, mapName).thenCompose(map -> {
            mapHolder.set(map);
            return ((PgxFuture)algorithm.apply((PgxMap<Integer, Long>)map)).cancelOn(promise);
        })).thenApply(arg -> {
            PgxMap map = (PgxMap)mapHolder.get();
            assert (map != null);
            this.addTransientObject(map);
            return map;
        })).thenComplete(promise);
    }

    private <ID> PgxFuture<Partition<ID>> componentAnalysis(PgxGraph graph, Function<VertexProperty<ID, Long>, PgxFuture<Partition<ID>>> analysis, String propertyName) {
        PgxFuture promise = new PgxFuture();
        ObjectHolder propertyIdHolder = new ObjectHolder();
        return graph.createVertexPropertyAsync(PropertyType.LONG, 0, propertyName, false).cancelOn(promise).thenCompose(property -> {
            propertyIdHolder.set(property);
            return ((PgxFuture)analysis.apply((VertexProperty)property)).cancelOn(promise);
        });
    }

    private <ID> PgxFuture<PgxPath<ID>> pathAnalysis(PgxGraph graph, Function<ShortestPathArgs<ID>, PgxFuture<PgxPath<ID>>> analysis, String parentName, String parentEdgeName) {
        ShortestPathArgs args = new ShortestPathArgs();
        return ((PgxFuture)graph.createVertexPropertyAsync(PropertyType.VERTEX, 0, parentName, false).thenCompose(prop -> {
            args.parent = prop;
            this.addTransientObject(args.parent);
            return graph.createVertexPropertyAsync(PropertyType.EDGE, 0, parentEdgeName, false);
        })).thenCompose(prop -> {
            args.parentEdge = prop;
            this.addTransientObject(args.parentEdge);
            return (CompletableFuture)analysis.apply(args);
        });
    }

    private <ID> PgxFuture<AllPaths<ID>> allPathsAnalysis(PgxGraph graph, Function<ShortestPathArgs<ID>, PgxFuture<AllPaths<ID>>> analysis, String distanceName, String parentName, String parentEdgeName) {
        PgxFuture promise = new PgxFuture();
        ShortestPathArgs args = new ShortestPathArgs();
        return ((PgxFuture)((PgxFuture)graph.createVertexPropertyAsync(PropertyType.DOUBLE, 0, distanceName, false).cancelOn(promise).thenCompose(dist -> {
            args.dist = dist;
            this.addTransientObject(args.dist);
            return graph.createVertexPropertyAsync(PropertyType.VERTEX, 0, parentName, false).cancelOn(promise);
        })).thenCompose(parent -> {
            args.parent = parent;
            this.addTransientObject(args.parent);
            return graph.createVertexPropertyAsync(PropertyType.EDGE, 0, parentEdgeName, false).cancelOn(promise);
        })).thenCompose(parentEdge -> {
            args.parentEdge = parentEdge;
            this.addTransientObject(args.parentEdge);
            return ((PgxFuture)analysis.apply(args)).cancelOn(promise);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addTransientObject(Destroyable obj) {
        List<Destroyable> list = this.transientData;
        synchronized (list) {
            this.transientData.add(obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PgxFuture<Void> destroyAsync() {
        List<Destroyable> list = this.transientData;
        synchronized (list) {
            ArrayList promises = new ArrayList(this.transientData.size());
            for (Destroyable data : this.transientData) {
                LOG.debug("destroy = {}", (Object)data);
                promises.add(data.destroyAsync());
            }
            this.transientData.clear();
            return PgxFuture.allOf(promises);
        }
    }

    public String toString() {
        return this.toString(Analyst.entry("session", this.getSession().getId()));
    }

    public <ID> VertexProperty<ID, Double> pagerank(PgxGraph graph) throws ExecutionException, InterruptedException {
        return this.pagerankAsync(graph).get();
    }

    public <ID> VertexProperty<ID, Double> pagerank(PgxGraph graph, boolean norm) throws ExecutionException, InterruptedException {
        return this.pagerankAsync(graph, norm).get();
    }

    public <ID> VertexProperty<ID, Double> pagerank(PgxGraph graph, double e, double d, int max) throws ExecutionException, InterruptedException {
        return this.pagerankAsync(graph, e, d, max).get();
    }

    public <ID> VertexProperty<ID, Double> pagerank(PgxGraph graph, double e, double d, int max, boolean norm) throws ExecutionException, InterruptedException {
        return this.pagerankAsync(graph, e, d, max, norm).get();
    }

    public <ID> VertexProperty<ID, Double> pagerank(PgxGraph graph, VertexProperty<ID, Double> rank) throws ExecutionException, InterruptedException {
        return this.pagerankAsync(graph, rank).get();
    }

    public <ID> VertexProperty<ID, Double> pagerank(PgxGraph graph, boolean norm, VertexProperty<ID, Double> rank) throws ExecutionException, InterruptedException {
        return this.pagerankAsync(graph, norm, rank).get();
    }

    public <ID> VertexProperty<ID, Double> pagerank(PgxGraph graph, double e, double d, int max, VertexProperty<ID, Double> rank) throws ExecutionException, InterruptedException {
        return this.pagerankAsync(graph, e, d, max, rank).get();
    }

    public <ID> VertexProperty<ID, Double> pagerank(PgxGraph graph, double e, double d, int max, boolean norm, VertexProperty<ID, Double> rank) throws ExecutionException, InterruptedException {
        return this.pagerankAsync(graph, e, d, max, norm, rank).get();
    }

    public <ID> VertexProperty<ID, Double> pagerankApproximate(PgxGraph graph) throws ExecutionException, InterruptedException {
        return this.pagerankApproximateAsync(graph).get();
    }

    public <ID> VertexProperty<ID, Double> pagerankApproximate(PgxGraph graph, double e, double d, int max) throws ExecutionException, InterruptedException {
        return this.pagerankApproximateAsync(graph, e, d, max).get();
    }

    public <ID> VertexProperty<ID, Double> pagerankApproximate(PgxGraph graph, VertexProperty<ID, Double> rank) throws ExecutionException, InterruptedException {
        return this.pagerankApproximateAsync(graph, rank).get();
    }

    public <ID> VertexProperty<ID, Double> pagerankApproximate(PgxGraph graph, double e, double d, int max, VertexProperty<ID, Double> rank) throws ExecutionException, InterruptedException {
        return this.pagerankApproximateAsync(graph, e, d, max, rank).get();
    }

    public <ID> VertexProperty<ID, Double> personalizedPagerank(PgxGraph graph, PgxVertex<ID> v) throws ExecutionException, InterruptedException {
        return this.personalizedPagerankAsync(graph, v).get();
    }

    public <ID> VertexProperty<ID, Double> personalizedPagerank(PgxGraph graph, PgxVertex<ID> v, boolean norm) throws ExecutionException, InterruptedException {
        return this.personalizedPagerankAsync(graph, v, norm).get();
    }

    public <ID> VertexProperty<ID, Double> personalizedPagerank(PgxGraph graph, PgxVertex<ID> v, double e, double d, int max) throws ExecutionException, InterruptedException {
        return this.personalizedPagerankAsync(graph, v, e, d, max).get();
    }

    public <ID> VertexProperty<ID, Double> personalizedPagerank(PgxGraph graph, PgxVertex<ID> v, double e, double d, int max, boolean norm) throws ExecutionException, InterruptedException {
        return this.personalizedPagerankAsync(graph, v, e, d, max, norm).get();
    }

    public <ID> VertexProperty<ID, Double> personalizedPagerank(PgxGraph graph, PgxVertex<ID> v, VertexProperty<ID, Double> rank) throws ExecutionException, InterruptedException {
        return this.personalizedPagerankAsync(graph, v, rank).get();
    }

    public <ID> VertexProperty<ID, Double> personalizedPagerank(PgxGraph graph, PgxVertex<ID> v, boolean norm, VertexProperty<ID, Double> rank) throws ExecutionException, InterruptedException {
        return this.personalizedPagerankAsync(graph, v, norm, rank).get();
    }

    public <ID> VertexProperty<ID, Double> personalizedPagerank(PgxGraph graph, PgxVertex<ID> v, double e, double d, int max, VertexProperty<ID, Double> rank) throws ExecutionException, InterruptedException {
        return this.personalizedPagerankAsync(graph, v, e, d, max, rank).get();
    }

    public <ID> VertexProperty<ID, Double> personalizedPagerank(PgxGraph graph, PgxVertex<ID> v, double e, double d, int max, boolean norm, VertexProperty<ID, Double> rank) throws ExecutionException, InterruptedException {
        return this.personalizedPagerankAsync(graph, v, e, d, max, norm, rank).get();
    }

    public <ID> VertexProperty<ID, Double> weightedPagerank(PgxGraph graph, EdgeProperty<Double> weight) throws ExecutionException, InterruptedException {
        return this.weightedPagerankAsync(graph, weight).get();
    }

    public <ID> VertexProperty<ID, Double> weightedPagerank(PgxGraph graph, boolean norm, EdgeProperty<Double> weight) throws ExecutionException, InterruptedException {
        return this.weightedPagerankAsync(graph, norm, weight).get();
    }

    public <ID> VertexProperty<ID, Double> weightedPagerank(PgxGraph graph, double e, double d, int max, EdgeProperty<Double> weight) throws ExecutionException, InterruptedException {
        return this.weightedPagerankAsync(graph, e, d, max, weight).get();
    }

    public <ID> VertexProperty<ID, Double> weightedPagerank(PgxGraph graph, double e, double d, int max, boolean norm, EdgeProperty<Double> weight) throws ExecutionException, InterruptedException {
        return this.weightedPagerankAsync(graph, e, d, max, norm, weight).get();
    }

    public <ID> VertexProperty<ID, Double> weightedPagerank(PgxGraph graph, EdgeProperty<Double> weight, VertexProperty<ID, Double> rank) throws ExecutionException, InterruptedException {
        return this.weightedPagerankAsync(graph, weight, rank).get();
    }

    public <ID> VertexProperty<ID, Double> weightedPagerank(PgxGraph graph, boolean norm, EdgeProperty<Double> weight, VertexProperty<ID, Double> rank) throws ExecutionException, InterruptedException {
        return this.weightedPagerankAsync(graph, norm, weight, rank).get();
    }

    public <ID> VertexProperty<ID, Double> weightedPagerank(PgxGraph graph, double e, double d, int max, EdgeProperty<Double> weight, VertexProperty<ID, Double> rank) throws ExecutionException, InterruptedException {
        return this.weightedPagerankAsync(graph, e, d, max, weight, rank).get();
    }

    public <ID> VertexProperty<ID, Double> weightedPagerank(PgxGraph graph, double e, double d, int max, boolean norm, EdgeProperty<Double> weight, VertexProperty<ID, Double> rank) throws ExecutionException, InterruptedException {
        return this.weightedPagerankAsync(graph, e, d, max, norm, weight, rank).get();
    }

    public <ID> VertexProperty<ID, Double> personalizedPagerank(PgxGraph graph, VertexSet<ID> vertices) throws ExecutionException, InterruptedException {
        return this.personalizedPagerankAsync(graph, vertices).get();
    }

    public <ID> VertexProperty<ID, Double> personalizedPagerank(PgxGraph graph, VertexSet<ID> vertices, boolean norm) throws ExecutionException, InterruptedException {
        return this.personalizedPagerankAsync(graph, vertices, norm).get();
    }

    public <ID> VertexProperty<ID, Double> personalizedPagerank(PgxGraph graph, VertexSet<ID> vertices, double e, double d, int max) throws ExecutionException, InterruptedException {
        return this.personalizedPagerankAsync(graph, vertices, e, d, max).get();
    }

    public <ID> VertexProperty<ID, Double> personalizedPagerank(PgxGraph graph, VertexSet<ID> vertices, double e, double d, int max, boolean norm) throws ExecutionException, InterruptedException {
        return this.personalizedPagerankAsync(graph, vertices, e, d, max, norm).get();
    }

    public <ID> VertexProperty<ID, Double> personalizedPagerank(PgxGraph graph, VertexSet<ID> vertices, double e, double d, int max, VertexProperty<ID, Double> rank) throws ExecutionException, InterruptedException {
        return this.personalizedPagerankAsync(graph, vertices, e, d, max, rank).get();
    }

    public <ID> VertexProperty<ID, Double> personalizedPagerank(PgxGraph graph, VertexSet<ID> vertices, double e, double d, int max, boolean norm, VertexProperty<ID, Double> rank) throws ExecutionException, InterruptedException {
        return this.personalizedPagerankAsync(graph, vertices, e, d, max, norm, rank).get();
    }

    public <ID> VertexProperty<ID, Double> personalizedPagerank(PgxGraph graph, VertexSet<ID> vertices, VertexProperty<ID, Double> rank) throws ExecutionException, InterruptedException {
        return this.personalizedPagerankAsync(graph, vertices, rank).get();
    }

    public <ID> VertexProperty<ID, Double> personalizedPagerank(PgxGraph graph, VertexSet<ID> vertices, boolean norm, VertexProperty<ID, Double> rank) throws ExecutionException, InterruptedException {
        return this.personalizedPagerankAsync(graph, vertices, norm, rank).get();
    }

    public <ID> VertexProperty<ID, Double> personalizedWeightedPagerank(PgxGraph graph, PgxVertex<ID> v, EdgeProperty<Double> weight) throws ExecutionException, InterruptedException {
        return this.personalizedWeightedPagerankAsync(graph, v, weight).get();
    }

    public <ID> VertexProperty<ID, Double> personalizedWeightedPagerank(PgxGraph graph, PgxVertex<ID> v, boolean norm, EdgeProperty<Double> weight) throws ExecutionException, InterruptedException {
        return this.personalizedWeightedPagerankAsync(graph, v, norm, weight).get();
    }

    public <ID> VertexProperty<ID, Double> personalizedWeightedPagerank(PgxGraph graph, PgxVertex<ID> v, double e, double d, int max, EdgeProperty<Double> weight) throws ExecutionException, InterruptedException {
        return this.personalizedWeightedPagerankAsync(graph, v, e, d, max, weight).get();
    }

    public <ID> VertexProperty<ID, Double> personalizedWeightedPagerank(PgxGraph graph, PgxVertex<ID> v, double e, double d, int max, boolean norm, EdgeProperty<Double> weight) throws ExecutionException, InterruptedException {
        return this.personalizedWeightedPagerankAsync(graph, v, e, d, max, norm, weight).get();
    }

    public <ID> VertexProperty<ID, Double> personalizedWeightedPagerank(PgxGraph graph, PgxVertex<ID> v, EdgeProperty<Double> weight, VertexProperty<ID, Double> rank) throws ExecutionException, InterruptedException {
        return this.personalizedWeightedPagerankAsync(graph, v, weight, rank).get();
    }

    public <ID> VertexProperty<ID, Double> personalizedWeightedPagerank(PgxGraph graph, PgxVertex<ID> v, boolean norm, EdgeProperty<Double> weight, VertexProperty<ID, Double> rank) throws ExecutionException, InterruptedException {
        return this.personalizedWeightedPagerankAsync(graph, v, norm, weight, rank).get();
    }

    public <ID> VertexProperty<ID, Double> personalizedWeightedPagerank(PgxGraph graph, PgxVertex<ID> v, double e, double d, int max, EdgeProperty<Double> weight, VertexProperty<ID, Double> rank) throws ExecutionException, InterruptedException {
        return this.personalizedWeightedPagerankAsync(graph, v, e, d, max, weight, rank).get();
    }

    public <ID> VertexProperty<ID, Double> personalizedWeightedPagerank(PgxGraph graph, PgxVertex<ID> v, double e, double d, int max, boolean norm, EdgeProperty<Double> weight, VertexProperty<ID, Double> rank) throws ExecutionException, InterruptedException {
        return this.personalizedWeightedPagerankAsync(graph, v, e, d, max, norm, weight, rank).get();
    }

    public <ID> VertexProperty<ID, Double> personalizedWeightedPagerank(PgxGraph graph, VertexSet<ID> vertices, EdgeProperty<Double> weight) throws ExecutionException, InterruptedException {
        return this.personalizedWeightedPagerankAsync(graph, vertices, weight).get();
    }

    public <ID> VertexProperty<ID, Double> personalizedWeightedPagerank(PgxGraph graph, VertexSet<ID> vertices, boolean norm, EdgeProperty<Double> weight) throws ExecutionException, InterruptedException {
        return this.personalizedWeightedPagerankAsync(graph, vertices, norm, weight).get();
    }

    public <ID> VertexProperty<ID, Double> personalizedWeightedPagerank(PgxGraph graph, VertexSet<ID> vertices, double e, double d, int max, EdgeProperty<Double> weight) throws ExecutionException, InterruptedException {
        return this.personalizedWeightedPagerankAsync(graph, vertices, e, d, max, weight).get();
    }

    public <ID> VertexProperty<ID, Double> personalizedWeightedPagerank(PgxGraph graph, VertexSet<ID> vertices, double e, double d, int max, boolean norm, EdgeProperty<Double> weight) throws ExecutionException, InterruptedException {
        return this.personalizedWeightedPagerankAsync(graph, vertices, e, d, max, norm, weight).get();
    }

    public <ID> VertexProperty<ID, Double> personalizedWeightedPagerank(PgxGraph graph, VertexSet<ID> vertices, EdgeProperty<Double> weight, VertexProperty<ID, Double> rank) throws ExecutionException, InterruptedException {
        return this.personalizedWeightedPagerankAsync(graph, vertices, weight, rank).get();
    }

    public <ID> VertexProperty<ID, Double> personalizedWeightedPagerank(PgxGraph graph, VertexSet<ID> vertices, boolean norm, EdgeProperty<Double> weight, VertexProperty<ID, Double> rank) throws ExecutionException, InterruptedException {
        return this.personalizedWeightedPagerankAsync(graph, vertices, norm, weight, rank).get();
    }

    public <ID> VertexProperty<ID, Double> personalizedWeightedPagerank(PgxGraph graph, VertexSet<ID> vertices, double e, double d, int max, EdgeProperty<Double> weight, VertexProperty<ID, Double> rank) throws ExecutionException, InterruptedException {
        return this.personalizedWeightedPagerankAsync(graph, vertices, e, d, max, weight, rank).get();
    }

    public <ID> VertexProperty<ID, Double> personalizedWeightedPagerank(PgxGraph graph, VertexSet<ID> vertices, double e, double d, int max, boolean norm, EdgeProperty<Double> weight, VertexProperty<ID, Double> rank) throws ExecutionException, InterruptedException {
        return this.personalizedWeightedPagerankAsync(graph, vertices, e, d, max, norm, weight, rank).get();
    }

    public <ID> VertexProperty<ID, Double> vertexBetweennessCentrality(PgxGraph graph) throws ExecutionException, InterruptedException {
        return this.vertexBetweennessCentralityAsync(graph).get();
    }

    public <ID> VertexProperty<ID, Double> vertexBetweennessCentrality(PgxGraph graph, VertexProperty<ID, Double> bc) throws ExecutionException, InterruptedException {
        return this.vertexBetweennessCentralityAsync(graph, bc).get();
    }

    public <ID> VertexProperty<ID, Double> approximateVertexBetweennessCentrality(PgxGraph graph, int k) throws ExecutionException, InterruptedException {
        return this.approximateVertexBetweennessCentralityAsync(graph, k).get();
    }

    public <ID> VertexProperty<ID, Double> approximateVertexBetweennessCentrality(PgxGraph graph, int k, VertexProperty<ID, Double> bc) throws ExecutionException, InterruptedException {
        return this.approximateVertexBetweennessCentralityAsync(graph, k, bc).get();
    }

    @SafeVarargs
    public final <ID> VertexProperty<ID, Double> approximateVertexBetweennessCentralityFromSeeds(PgxGraph graph, PgxVertex<ID> ... seeds) throws ExecutionException, InterruptedException {
        return this.approximateVertexBetweennessCentralityFromSeedsAsync(graph, seeds).get();
    }

    @SafeVarargs
    public final <ID> VertexProperty<ID, Double> approximateVertexBetweennessCentralityFromSeeds(PgxGraph graph, VertexProperty<ID, Double> bc, PgxVertex<ID> ... seeds) throws ExecutionException, InterruptedException {
        return this.approximateVertexBetweennessCentralityFromSeedsAsync(graph, bc, seeds).get();
    }

    public <ID> VertexProperty<ID, Double> closenessCentralityUnitLength(PgxGraph graph) throws ExecutionException, InterruptedException {
        return this.closenessCentralityUnitLengthAsync(graph).get();
    }

    public <ID> VertexProperty<ID, Double> closenessCentralityUnitLength(PgxGraph graph, VertexProperty<ID, Double> cc) throws ExecutionException, InterruptedException {
        return this.closenessCentralityUnitLengthAsync(graph, cc).get();
    }

    public <ID> VertexProperty<ID, Double> closenessCentralityDoubleLength(PgxGraph graph, EdgeProperty<Double> cost) throws ExecutionException, InterruptedException {
        return this.closenessCentralityDoubleLengthAsync(graph, cost).get();
    }

    public <ID> VertexProperty<ID, Double> closenessCentralityDoubleLength(PgxGraph graph, EdgeProperty<Double> cost, VertexProperty<ID, Double> cc) throws ExecutionException, InterruptedException {
        return this.closenessCentralityDoubleLengthAsync(graph, cost, cc).get();
    }

    public <ID> Pair<VertexProperty<ID, Double>, VertexProperty<ID, Double>> hits(PgxGraph graph) throws ExecutionException, InterruptedException {
        return this.hitsAsync(graph).get();
    }

    public <ID> Pair<VertexProperty<ID, Double>, VertexProperty<ID, Double>> hits(PgxGraph graph, int max) throws ExecutionException, InterruptedException {
        return this.hitsAsync(graph, max).get();
    }

    public <ID> Pair<VertexProperty<ID, Double>, VertexProperty<ID, Double>> hits(PgxGraph graph, int max, VertexProperty<ID, Double> auth, VertexProperty<ID, Double> hubs) throws ExecutionException, InterruptedException {
        return this.hitsAsync(graph, max, auth, hubs).get();
    }

    public <ID> Pair<VertexProperty<ID, Double>, VertexProperty<ID, Double>> hits(PgxGraph graph, VertexProperty<ID, Double> auth, VertexProperty<ID, Double> hubs) throws ExecutionException, InterruptedException {
        return this.hitsAsync(graph, auth, hubs).get();
    }

    public <ID> VertexProperty<ID, Double> eigenvectorCentrality(PgxGraph graph) throws ExecutionException, InterruptedException {
        return this.eigenvectorCentralityAsync(graph).get();
    }

    public <ID> VertexProperty<ID, Double> eigenvectorCentrality(PgxGraph graph, int max, double maxDiff, boolean useL2Norm, boolean useInEdge) throws ExecutionException, InterruptedException {
        return this.eigenvectorCentralityAsync(graph, max, maxDiff, useL2Norm, useInEdge).get();
    }

    public <ID> VertexProperty<ID, Double> eigenvectorCentrality(PgxGraph graph, int max, double maxDiff, boolean useL2Norm, boolean useInEdge, VertexProperty<ID, Double> ec) throws ExecutionException, InterruptedException {
        return this.eigenvectorCentralityAsync(graph, max, maxDiff, useL2Norm, useInEdge, ec).get();
    }

    public <ID> VertexProperty<ID, Double> eigenvectorCentrality(PgxGraph graph, VertexProperty<ID, Double> ec) throws ExecutionException, InterruptedException {
        return this.eigenvectorCentralityAsync(graph, ec).get();
    }

    public <ID> VertexProperty<ID, Integer> outDegreeCentrality(PgxGraph graph) throws ExecutionException, InterruptedException {
        return this.outDegreeCentralityAsync(graph).get();
    }

    public <ID> VertexProperty<ID, Integer> outDegreeCentrality(PgxGraph graph, VertexProperty<ID, Integer> dc) throws ExecutionException, InterruptedException {
        return this.outDegreeCentralityAsync(graph, dc).get();
    }

    public <ID> VertexProperty<ID, Integer> inDegreeCentrality(PgxGraph graph) throws ExecutionException, InterruptedException {
        return this.inDegreeCentralityAsync(graph).get();
    }

    public <ID> VertexProperty<ID, Integer> inDegreeCentrality(PgxGraph graph, VertexProperty<ID, Integer> dc) throws ExecutionException, InterruptedException {
        return this.inDegreeCentralityAsync(graph, dc).get();
    }

    public <ID> VertexProperty<ID, Integer> degreeCentrality(PgxGraph graph) throws ExecutionException, InterruptedException {
        return this.degreeCentralityAsync(graph).get();
    }

    public <ID> VertexProperty<ID, Integer> degreeCentrality(PgxGraph graph, VertexProperty<ID, Integer> dc) throws ExecutionException, InterruptedException {
        return this.degreeCentralityAsync(graph, dc).get();
    }

    public <ID> Pair<VertexSequence<ID>, VertexSequence<ID>> whomToFollow(PgxGraph graph, PgxVertex<ID> vertex) throws ExecutionException, InterruptedException {
        return this.whomToFollowAsync(graph, vertex).get();
    }

    public <ID> Pair<VertexSequence<ID>, VertexSequence<ID>> whomToFollow(PgxGraph graph, PgxVertex<ID> vertex, int topK) throws ExecutionException, InterruptedException {
        return this.whomToFollowAsync(graph, vertex, topK).get();
    }

    public <ID> Pair<VertexSequence<ID>, VertexSequence<ID>> whomToFollow(PgxGraph graph, PgxVertex<ID> vertex, int topK, int sizeCircleOfTrust) throws ExecutionException, InterruptedException {
        return this.whomToFollowAsync(graph, vertex, topK, sizeCircleOfTrust).get();
    }

    public <ID> Pair<VertexSequence<ID>, VertexSequence<ID>> whomToFollow(PgxGraph graph, PgxVertex<ID> vertex, VertexSequence<ID> hubs, VertexSequence<ID> authorities) throws ExecutionException, InterruptedException {
        return this.whomToFollowAsync(graph, vertex, hubs, authorities).get();
    }

    public <ID> Pair<VertexSequence<ID>, VertexSequence<ID>> whomToFollow(PgxGraph graph, PgxVertex<ID> vertex, int topK, VertexSequence<ID> hubs, VertexSequence<ID> authorities) throws ExecutionException, InterruptedException {
        return this.whomToFollowAsync(graph, vertex, topK, hubs, authorities).get();
    }

    public <ID> Pair<VertexSequence<ID>, VertexSequence<ID>> whomToFollow(PgxGraph graph, PgxVertex<ID> vertex, int topK, int sizeCircleOfTrust, VertexSequence<ID> hubs, VertexSequence<ID> authorities) throws ExecutionException, InterruptedException {
        return this.whomToFollowAsync(graph, vertex, topK, sizeCircleOfTrust, hubs, authorities).get();
    }

    public <ID> Pair<VertexSequence<ID>, VertexSequence<ID>> whomToFollow(PgxGraph graph, PgxVertex<ID> vertex, int topK, int sizeCircleOfTrust, int maxIter, double tol, double dampingFactor, int salsaMaxIter, double salsaTol) throws ExecutionException, InterruptedException {
        return this.whomToFollowAsync(graph, vertex, topK, sizeCircleOfTrust, maxIter, tol, dampingFactor, salsaMaxIter, salsaTol).get();
    }

    public <ID> Pair<VertexSequence<ID>, VertexSequence<ID>> whomToFollow(PgxGraph graph, PgxVertex<ID> vertex, int topK, int sizeCircleOfTrust, int maxIter, double tol, double dampingFactor, int salsaMaxIter, double salsaTol, VertexSequence<ID> hubs, VertexSequence<ID> authorities) throws ExecutionException, InterruptedException {
        return this.whomToFollowAsync(graph, vertex, topK, sizeCircleOfTrust, maxIter, tol, dampingFactor, salsaMaxIter, salsaTol, hubs, authorities).get();
    }

    public <ID> VertexProperty<ID, Double> salsa(BipartiteGraph graph) throws ExecutionException, InterruptedException {
        return this.salsaAsync(graph).get();
    }

    public <ID> VertexProperty<ID, Double> salsa(BipartiteGraph graph, double maxDiff, int maxIter) throws ExecutionException, InterruptedException {
        return this.salsaAsync(graph, maxDiff, maxIter).get();
    }

    public <ID> VertexProperty<ID, Double> salsa(BipartiteGraph graph, double maxDiff, int maxIter, VertexProperty<ID, Double> salsaRank) throws ExecutionException, InterruptedException {
        return this.salsaAsync(graph, maxDiff, maxIter, salsaRank).get();
    }

    public <ID> VertexProperty<ID, Double> salsa(BipartiteGraph graph, VertexProperty<ID, Double> salsaRank) throws ExecutionException, InterruptedException {
        return this.salsaAsync(graph, salsaRank).get();
    }

    public <ID> VertexProperty<ID, Double> personalizedSalsa(BipartiteGraph graph, PgxVertex<ID> v) throws ExecutionException, InterruptedException {
        return this.personalizedSalsaAsync(graph, v).get();
    }

    public <ID> VertexProperty<ID, Double> personalizedSalsa(BipartiteGraph graph, PgxVertex<ID> v, double d, int maxIter, double maxDiff) throws ExecutionException, InterruptedException {
        return this.personalizedSalsaAsync(graph, v, d, maxIter, maxDiff).get();
    }

    public <ID> VertexProperty<ID, Double> personalizedSalsa(BipartiteGraph graph, PgxVertex<ID> v, VertexProperty<ID, Double> salsaRank) throws ExecutionException, InterruptedException {
        return this.personalizedSalsaAsync(graph, v, salsaRank).get();
    }

    public <ID> VertexProperty<ID, Double> personalizedSalsa(BipartiteGraph graph, PgxVertex<ID> v, double d, int maxIter, double maxDiff, VertexProperty<ID, Double> salsaRank) throws ExecutionException, InterruptedException {
        return this.personalizedSalsaAsync(graph, v, d, maxIter, maxDiff, salsaRank).get();
    }

    public <ID> VertexProperty<ID, Double> personalizedSalsa(BipartiteGraph graph, VertexSet<ID> vertices) throws ExecutionException, InterruptedException {
        return this.personalizedSalsaAsync(graph, vertices).get();
    }

    public <ID> VertexProperty<ID, Double> personalizedSalsa(BipartiteGraph graph, VertexSet<ID> vertices, VertexProperty<ID, Double> salsaRank) throws ExecutionException, InterruptedException {
        return this.personalizedSalsaAsync(graph, vertices, salsaRank).get();
    }

    public <ID> VertexProperty<ID, Double> personalizedSalsa(BipartiteGraph graph, VertexSet<ID> vertices, double d, int maxIter, double maxDiff) throws ExecutionException, InterruptedException {
        return this.personalizedSalsaAsync(graph, vertices, d, maxIter, maxDiff).get();
    }

    public <ID> VertexProperty<ID, Double> personalizedSalsa(BipartiteGraph graph, VertexSet<ID> vertices, double d, int maxIter, double maxDiff, VertexProperty<ID, Double> salsaRank) throws ExecutionException, InterruptedException {
        return this.personalizedSalsaAsync(graph, vertices, d, maxIter, maxDiff, salsaRank).get();
    }

    public <ID> Partition<ID> communitiesConductanceMinimization(PgxGraph graph) throws ExecutionException, InterruptedException {
        return this.communitiesConductanceMinimizationAsync(graph).get();
    }

    public <ID> Partition<ID> communitiesConductanceMinimization(PgxGraph graph, int maxIterations) throws ExecutionException, InterruptedException {
        return this.communitiesConductanceMinimizationAsync(graph, maxIterations).get();
    }

    public <ID> Partition<ID> communitiesConductanceMinimization(PgxGraph graph, VertexProperty<ID, Long> partitionDistribution) throws ExecutionException, InterruptedException {
        return this.communitiesConductanceMinimizationAsync(graph, partitionDistribution).get();
    }

    public <ID> Partition<ID> communitiesConductanceMinimization(PgxGraph graph, int maxIterations, VertexProperty<ID, Long> partitionDistribution) throws ExecutionException, InterruptedException {
        return this.communitiesConductanceMinimizationAsync(graph, maxIterations, partitionDistribution).get();
    }

    public <ID> Partition<ID> communitiesLabelPropagation(PgxGraph graph) throws ExecutionException, InterruptedException {
        return this.communitiesLabelPropagationAsync(graph).get();
    }

    public <ID> Partition<ID> communitiesLabelPropagation(PgxGraph graph, int maxIterations) throws ExecutionException, InterruptedException {
        return this.communitiesLabelPropagationAsync(graph, maxIterations).get();
    }

    public <ID> Partition<ID> communitiesLabelPropagation(PgxGraph graph, int maxIterations, VertexProperty<ID, Long> partitionDistribution) throws ExecutionException, InterruptedException {
        return this.communitiesLabelPropagationAsync(graph, maxIterations, partitionDistribution).get();
    }

    public <ID> Partition<ID> communitiesLabelPropagation(PgxGraph graph, VertexProperty<ID, Long> partitonDistribution) throws ExecutionException, InterruptedException {
        return this.communitiesLabelPropagationAsync(graph, partitonDistribution).get();
    }

    public <ID> Partition<ID> communitiesInfomap(PgxGraph graph, VertexProperty<ID, Double> rank, EdgeProperty<Double> weight) throws ExecutionException, InterruptedException {
        return this.communitiesInfomapAsync(graph, rank, weight).get();
    }

    public <ID> Partition<ID> communitiesInfomap(PgxGraph graph, VertexProperty<ID, Double> rank, EdgeProperty<Double> weight, double tau, double tol, int maxIter) throws ExecutionException, InterruptedException {
        return this.communitiesInfomapAsync(graph, rank, weight, tau, tol, maxIter).get();
    }

    public <ID> Partition<ID> communitiesInfomap(PgxGraph graph, VertexProperty<ID, Double> rank, EdgeProperty<Double> weight, VertexProperty<ID, Long> module) throws ExecutionException, InterruptedException {
        return this.communitiesInfomapAsync(graph, rank, weight, module).get();
    }

    public <ID> Partition<ID> communitiesInfomap(PgxGraph graph, VertexProperty<ID, Double> rank, EdgeProperty<Double> weight, double tau, double tol, int maxIter, VertexProperty<ID, Long> module) throws ExecutionException, InterruptedException {
        return this.communitiesInfomapAsync(graph, rank, weight, tau, tol, maxIter, module).get();
    }

    protected <ID> Partition<ID> communitiesInfomap(PgxGraph graph, VertexProperty<ID, Double> rank, EdgeProperty<Double> weight, double tau, double tol, int maxIter, String propertyName) throws ExecutionException, InterruptedException {
        return this.communitiesInfomapAsync(graph, rank, weight, tau, tol, maxIter, propertyName).get();
    }

    public <ID> VertexProperty<ID, Long> louvain(PgxGraph graph, EdgeProperty<Double> weight, int maxIter, int nbrPass, double tol, VertexProperty<ID, Long> community) throws ExecutionException, InterruptedException {
        return this.louvainAsync(graph, weight, maxIter, nbrPass, tol, community).get();
    }

    public <ID> VertexProperty<ID, Long> louvain(PgxGraph graph, EdgeProperty<Double> weight, int maxIter) throws ExecutionException, InterruptedException {
        return this.louvainAsync(graph, weight, maxIter).get();
    }

    public <ID> VertexProperty<ID, Long> louvain(PgxGraph graph, EdgeProperty<Double> weight) throws ExecutionException, InterruptedException {
        return this.louvainAsync(graph, weight).get();
    }

    public <ID> VertexProperty<ID, String> speakerListenerLabelPropagation(PgxGraph graph, String labelsPropName) throws ExecutionException, InterruptedException {
        return this.speakerListenerLabelPropagationAsync(graph, labelsPropName).get();
    }

    public <ID> VertexProperty<ID, String> speakerListenerLabelPropagation(PgxGraph graph, String labelsPropName, int maxIter, double threshold, String delimiter) throws ExecutionException, InterruptedException {
        return this.speakerListenerLabelPropagationAsync(graph, labelsPropName, maxIter, threshold, delimiter).get();
    }

    public <ID> VertexProperty<ID, String> speakerListenerLabelPropagation(PgxGraph graph, VertexProperty<ID, String> labels, int maxIter, double threshold, String delimiter) throws ExecutionException, InterruptedException {
        return this.speakerListenerLabelPropagationAsync(graph, labels, maxIter, threshold, delimiter).get();
    }

    public long countTriangles(PgxGraph graph, boolean sortVerticesByDegree) throws ExecutionException, InterruptedException {
        return this.countTrianglesAsync(graph, sortVerticesByDegree).get();
    }

    public <V> EdgeProperty<Double> adamicAdarCounting(PgxGraph graph) throws ExecutionException, InterruptedException {
        return this.adamicAdarCountingAsync(graph).get();
    }

    public <V> EdgeProperty<Double> adamicAdarCounting(PgxGraph graph, EdgeProperty<Double> aa) throws ExecutionException, InterruptedException {
        return this.adamicAdarCountingAsync(graph, aa).get();
    }

    public <ID> PgxMap<PgxVertex<ID>, Integer> randomWalkWithRestart(PgxGraph graph, PgxVertex<ID> source, int length, double resetProb, PgxMap<PgxVertex<ID>, Integer> visitCount) throws ExecutionException, InterruptedException {
        return this.randomWalkWithRestartAsync(graph, source, length, resetProb, visitCount).get();
    }

    public <ID> VertexProperty<ID, Boolean> bipartiteCheck(PgxGraph graph, VertexProperty<ID, Boolean> isLeft) throws ExecutionException, InterruptedException {
        return this.bipartiteCheckAsync(graph, isLeft).get();
    }

    public <ID> Scalar<Double> conductance(PgxGraph graph, Partition<ID> partition, long partitionIndex) throws ExecutionException, InterruptedException {
        return this.conductanceAsync(graph, partition, partitionIndex).get();
    }

    public <ID> Scalar<Double> conductance(PgxGraph graph, Partition<ID> partition, long partitionIndex, Scalar<Double> conductance) throws ExecutionException, InterruptedException {
        return this.conductanceAsync(graph, partition, partitionIndex, conductance).get();
    }

    public <ID> Scalar<Double> partitionModularity(PgxGraph graph, Partition<ID> partition) throws ExecutionException, InterruptedException {
        return this.partitionModularityAsync(graph, partition).get();
    }

    public <ID> Scalar<Double> partitionModularity(PgxGraph graph, Partition<ID> partition, Scalar<Double> modularity) throws ExecutionException, InterruptedException {
        return this.partitionModularityAsync(graph, partition, modularity).get();
    }

    public <ID> Pair<Scalar<Double>, Scalar<Double>> partitionConductance(PgxGraph graph, Partition<ID> partition) throws ExecutionException, InterruptedException {
        return this.partitionConductanceAsync(graph, partition).get();
    }

    public <ID> Pair<Scalar<Double>, Scalar<Double>> partitionConductance(PgxGraph graph, Partition<ID> partition, Scalar<Double> avgConductance, Scalar<Double> minConductance) throws ExecutionException, InterruptedException {
        return this.partitionConductanceAsync(graph, partition, avgConductance, minConductance).get();
    }

    public <ID> Pair<Scalar<Long>, VertexProperty<ID, Long>> kcore(PgxGraph graph) throws ExecutionException, InterruptedException {
        return this.kcoreAsync(graph).get();
    }

    public <ID> Pair<Scalar<Long>, VertexProperty<ID, Long>> kcore(PgxGraph graph, int minCore, int maxCore) throws ExecutionException, InterruptedException {
        return this.kcoreAsync(graph, minCore, maxCore).get();
    }

    public <ID> Pair<Scalar<Long>, VertexProperty<ID, Long>> kcore(PgxGraph graph, Scalar<Long> maxKCore, VertexProperty<ID, Long> kcore) throws ExecutionException, InterruptedException {
        return this.kcoreAsync(graph, maxKCore, kcore).get();
    }

    public <ID> Pair<Scalar<Long>, VertexProperty<ID, Long>> kcore(PgxGraph graph, int minCore, int maxCore, Scalar<Long> maxKCore, VertexProperty<ID, Long> kcore) throws ExecutionException, InterruptedException {
        return this.kcoreAsync(graph, minCore, maxCore, maxKCore, kcore).get();
    }

    public <ID> Pair<Scalar<Integer>, VertexProperty<ID, Integer>> diameter(PgxGraph graph) throws ExecutionException, InterruptedException {
        return this.diameterAsync(graph).get();
    }

    public <ID> Pair<Scalar<Integer>, VertexProperty<ID, Integer>> diameter(PgxGraph graph, Scalar<Integer> diameter, VertexProperty<ID, Integer> eccentricity) throws ExecutionException, InterruptedException {
        return this.diameterAsync(graph, diameter, eccentricity).get();
    }

    public <ID> Pair<Scalar<Integer>, VertexProperty<ID, Integer>> radius(PgxGraph graph) throws ExecutionException, InterruptedException {
        return this.radiusAsync(graph).get();
    }

    public <ID> Pair<Scalar<Integer>, VertexProperty<ID, Integer>> radius(PgxGraph graph, Scalar<Integer> radius, VertexProperty<ID, Integer> eccentricity) throws ExecutionException, InterruptedException {
        return this.radiusAsync(graph, radius, eccentricity).get();
    }

    public <ID> VertexSet<ID> periphery(PgxGraph graph) throws ExecutionException, InterruptedException {
        return this.peripheryAsync(graph).get();
    }

    public <ID> VertexSet<ID> periphery(PgxGraph graph, VertexSet<ID> periphery) throws ExecutionException, InterruptedException {
        return this.peripheryAsync(graph, periphery).get();
    }

    public <ID> VertexSet<ID> center(PgxGraph graph) throws ExecutionException, InterruptedException {
        return this.centerAsync(graph).get();
    }

    public <ID> VertexSet<ID> center(PgxGraph graph, VertexSet<ID> center) throws ExecutionException, InterruptedException {
        return this.centerAsync(graph, center).get();
    }

    public <ID> VertexProperty<ID, Double> localClusteringCoefficient(PgxGraph graph) throws ExecutionException, InterruptedException {
        return this.localClusteringCoefficientAsync(graph).get();
    }

    public <ID> VertexProperty<ID, Double> localClusteringCoefficient(PgxGraph graph, VertexProperty<ID, Double> lcc) throws ExecutionException, InterruptedException {
        return this.localClusteringCoefficientAsync(graph, lcc).get();
    }

    public <ID> PgxPath<ID> findCycle(PgxGraph graph) throws ExecutionException, InterruptedException {
        return this.findCycleAsync(graph).get();
    }

    public <ID> PgxPath<ID> findCycle(PgxGraph graph, VertexSequence<ID> nodeSeq, EdgeSequence edgeSeq) throws ExecutionException, InterruptedException {
        return this.findCycleAsync(graph, nodeSeq, edgeSeq).get();
    }

    public <ID> PgxPath<ID> findCycle(PgxGraph graph, PgxVertex<ID> src) throws ExecutionException, InterruptedException {
        return this.findCycleAsync(graph, src).get();
    }

    public <ID> PgxPath<ID> findCycle(PgxGraph graph, PgxVertex<ID> src, VertexSequence<ID> nodeSeq, EdgeSequence edgeSeq) throws ExecutionException, InterruptedException {
        return this.findCycleAsync(graph, src, nodeSeq, edgeSeq).get();
    }

    public <ID> Integer reachability(PgxGraph graph, PgxVertex<ID> source, PgxVertex<ID> dest, int maxHops, boolean ignoreEdgeDirection) throws ExecutionException, InterruptedException {
        return this.reachabilityAsync(graph, source, dest, maxHops, ignoreEdgeDirection).get();
    }

    public <ID> VertexProperty<ID, Integer> topologicalSort(PgxGraph graph) throws ExecutionException, InterruptedException {
        return this.topologicalSortAsync(graph).get();
    }

    public <ID> VertexProperty<ID, Integer> topologicalSort(PgxGraph graph, VertexProperty<ID, Integer> topoSort) throws ExecutionException, InterruptedException {
        return this.topologicalSortAsync(graph, topoSort).get();
    }

    public <ID> VertexProperty<ID, Integer> topologicalSchedule(PgxGraph graph, VertexSet<ID> source) throws ExecutionException, InterruptedException {
        return this.topologicalScheduleAsync(graph, source).get();
    }

    public <ID> VertexProperty<ID, Integer> topologicalSchedule(PgxGraph graph, VertexSet<ID> source, VertexProperty<ID, Integer> topoSched) throws ExecutionException, InterruptedException {
        return this.topologicalScheduleAsync(graph, source, topoSched).get();
    }

    public PgxMap<Integer, Long> outDegreeDistribution(PgxGraph graph) throws ExecutionException, InterruptedException {
        return this.outDegreeDistributionAsync(graph).get();
    }

    public PgxMap<Integer, Long> outDegreeDistribution(PgxGraph graph, PgxMap<Integer, Long> distribution) throws ExecutionException, InterruptedException {
        return this.outDegreeDistributionAsync(graph, distribution).get();
    }

    public PgxMap<Integer, Long> inDegreeDistribution(PgxGraph graph) throws ExecutionException, InterruptedException {
        return this.inDegreeDistributionAsync(graph).get();
    }

    public PgxMap<Integer, Long> inDegreeDistribution(PgxGraph graph, PgxMap<Integer, Long> distribution) throws ExecutionException, InterruptedException {
        return this.inDegreeDistributionAsync(graph, distribution).get();
    }

    public <ID> AllPaths<ID> fattestPath(PgxGraph graph, PgxVertex<ID> root, EdgeProperty<Double> capacity) throws ExecutionException, InterruptedException {
        return this.fattestPathAsync(graph, root, capacity).get();
    }

    public <ID> AllPaths<ID> fattestPath(PgxGraph graph, PgxVertex<ID> root, EdgeProperty<Double> capacity, VertexProperty<ID, Double> distance, VertexProperty<ID, PgxVertex<ID>> parent, VertexProperty<ID, PgxEdge> parentEdge) throws ExecutionException, InterruptedException {
        return this.fattestPathAsync(graph, root, capacity, distance, parent, parentEdge).get();
    }

    public <ID> Partition<ID> sccKosaraju(PgxGraph graph) throws ExecutionException, InterruptedException {
        return this.sccKosarajuAsync(graph).get();
    }

    public <ID> Partition<ID> sccKosaraju(PgxGraph graph, VertexProperty<ID, Long> partitionDistribution) throws ExecutionException, InterruptedException {
        return this.sccKosarajuAsync(graph, partitionDistribution).get();
    }

    public <ID> Partition<ID> sccTarjan(PgxGraph graph) throws ExecutionException, InterruptedException {
        return this.sccTarjanAsync(graph).get();
    }

    public <ID> Partition<ID> sccTarjan(PgxGraph graph, VertexProperty<ID, Long> partitionDistribution) throws ExecutionException, InterruptedException {
        return this.sccTarjanAsync(graph, partitionDistribution).get();
    }

    public <ID> Partition<ID> wcc(PgxGraph graph) throws ExecutionException, InterruptedException {
        return this.wccAsync(graph).get();
    }

    public <ID> Partition<ID> wcc(PgxGraph graph, VertexProperty<ID, Long> partitionDistribution) throws ExecutionException, InterruptedException {
        return this.wccAsync(graph, partitionDistribution).get();
    }

    public <ID> PgxPath<ID> shortestPathDijkstra(PgxGraph graph, PgxVertex<ID> src, PgxVertex<ID> dst, EdgeProperty<Double> cost) throws ExecutionException, InterruptedException {
        return this.shortestPathDijkstraAsync(graph, src, dst, cost).get();
    }

    public <ID> PgxPath<ID> shortestPathDijkstra(PgxGraph graph, PgxVertex<ID> src, PgxVertex<ID> dst, EdgeProperty<Double> cost, VertexProperty<ID, PgxVertex<ID>> parent, VertexProperty<ID, PgxEdge> parentEdge) throws ExecutionException, InterruptedException {
        return this.shortestPathDijkstraAsync(graph, src, dst, cost, parent, parentEdge).get();
    }

    public <ID> PgxPath<ID> shortestPathFilteredDijkstra(PgxGraph graph, PgxVertex<ID> src, PgxVertex<ID> dst, EdgeProperty<Double> cost, GraphFilter filterExpr) throws ExecutionException, InterruptedException {
        return this.shortestPathFilteredDijkstraAsync(graph, src, dst, cost, filterExpr).get();
    }

    public <ID> PgxPath<ID> shortestPathFilteredDijkstra(PgxGraph graph, PgxVertex<ID> src, PgxVertex<ID> dst, EdgeProperty<Double> cost, GraphFilter filterExpr, VertexProperty<ID, PgxVertex<ID>> parent, VertexProperty<ID, PgxEdge> parentEdge) throws ExecutionException, InterruptedException {
        return this.shortestPathFilteredDijkstraAsync(graph, src, dst, cost, filterExpr, parent, parentEdge).get();
    }

    public <ID> PgxPath<ID> shortestPathDijkstraBidirectional(PgxGraph graph, PgxVertex<ID> src, PgxVertex<ID> dst, EdgeProperty<Double> cost) throws ExecutionException, InterruptedException {
        return this.shortestPathDijkstraBidirectionalAsync(graph, src, dst, cost).get();
    }

    public <ID> PgxPath<ID> shortestPathDijkstraBidirectional(PgxGraph graph, PgxVertex<ID> src, PgxVertex<ID> dst, EdgeProperty<Double> cost, VertexProperty<ID, PgxVertex<ID>> parent, VertexProperty<ID, PgxEdge> parentEdge) throws ExecutionException, InterruptedException {
        return this.shortestPathDijkstraBidirectionalAsync(graph, src, dst, cost, parent, parentEdge).get();
    }

    public <ID> PgxPath<ID> shortestPathFilteredDijkstraBidirectional(PgxGraph graph, PgxVertex<ID> src, PgxVertex<ID> dst, EdgeProperty<Double> cost, GraphFilter filterExpr) throws ExecutionException, InterruptedException {
        return this.shortestPathFilteredDijkstraBidirectionalAsync(graph, src, dst, cost, filterExpr).get();
    }

    public <ID> PgxPath<ID> shortestPathFilteredDijkstraBidirectional(PgxGraph graph, PgxVertex<ID> src, PgxVertex<ID> dst, EdgeProperty<Double> cost, GraphFilter filterExpr, VertexProperty<ID, PgxVertex<ID>> parent, VertexProperty<ID, PgxEdge> parentEdge) throws ExecutionException, InterruptedException {
        return this.shortestPathFilteredDijkstraBidirectionalAsync(graph, src, dst, cost, filterExpr, parent, parentEdge).get();
    }

    public <ID> AllPaths<ID> shortestPathBellmanFord(PgxGraph graph, PgxVertex<ID> src, EdgeProperty<Double> cost) throws ExecutionException, InterruptedException {
        return this.shortestPathBellmanFordAsync(graph, src, cost).get();
    }

    public <ID> AllPaths<ID> shortestPathBellmanFord(PgxGraph graph, PgxVertex<ID> src, EdgeProperty<Double> cost, VertexProperty<ID, Double> distance, VertexProperty<ID, PgxVertex<ID>> parent, VertexProperty<ID, PgxEdge> parentEdge) throws ExecutionException, InterruptedException {
        return this.shortestPathBellmanFordAsync(graph, src, cost, distance, parent, parentEdge).get();
    }

    public <ID> AllPaths<ID> shortestPathBellmanFordReverse(PgxGraph graph, PgxVertex<ID> src, EdgeProperty<Double> cost) throws ExecutionException, InterruptedException {
        return this.shortestPathBellmanFordReverseAsync(graph, src, cost).get();
    }

    public <ID> AllPaths<ID> shortestPathBellmanFordReverse(PgxGraph graph, PgxVertex<ID> src, EdgeProperty<Double> cost, VertexProperty<ID, Double> distance, VertexProperty<ID, PgxVertex<ID>> parent, VertexProperty<ID, PgxEdge> parentEdge) throws ExecutionException, InterruptedException {
        return this.shortestPathBellmanFordReverseAsync(graph, src, cost, distance, parent, parentEdge).get();
    }

    public <ID> AllPaths<ID> shortestPathHopDist(PgxGraph graph, PgxVertex<ID> src) throws ExecutionException, InterruptedException {
        return this.shortestPathHopDistAsync(graph, src).get();
    }

    public <ID> AllPaths<ID> shortestPathHopDist(PgxGraph graph, PgxVertex<ID> src, VertexProperty<ID, Double> distance, VertexProperty<ID, PgxVertex<ID>> parent, VertexProperty<ID, PgxEdge> parentEdge) throws ExecutionException, InterruptedException {
        return this.shortestPathHopDistAsync(graph, src, distance, parent, parentEdge).get();
    }

    public <ID> AllPaths<ID> shortestPathHopDistReverse(PgxGraph graph, PgxVertex<ID> src) throws ExecutionException, InterruptedException {
        return this.shortestPathHopDistReverseAsync(graph, src).get();
    }

    public <ID> AllPaths<ID> shortestPathHopDistReverse(PgxGraph graph, PgxVertex<ID> src, VertexProperty<ID, Double> distance, VertexProperty<ID, PgxVertex<ID>> parent, VertexProperty<ID, PgxEdge> parentEdge) throws ExecutionException, InterruptedException {
        return this.shortestPathHopDistReverseAsync(graph, src, distance, parent, parentEdge).get();
    }

    public <ID> MatrixFactorizationModel<ID> matrixFactorizationGradientDescent(BipartiteGraph graph, EdgeProperty<Double> weight) throws InterruptedException, ExecutionException {
        return this.matrixFactorizationGradientDescentAsync(graph, weight).get();
    }

    public <ID> MatrixFactorizationModel<ID> matrixFactorizationGradientDescent(BipartiteGraph graph, EdgeProperty<Double> weight, VertexProperty<ID, PgxVect<Double>> features) throws InterruptedException, ExecutionException {
        return this.matrixFactorizationGradientDescentAsync(graph, weight, features).get();
    }

    public <ID> MatrixFactorizationModel<ID> matrixFactorizationGradientDescent(BipartiteGraph graph, EdgeProperty<Double> weight, double learningRate, double changePerStep, double lambda, int maxStep, int vectorLength, VertexProperty<ID, PgxVect<Double>> features) throws InterruptedException, ExecutionException {
        return this.matrixFactorizationGradientDescentAsync(graph, weight, learningRate, changePerStep, lambda, maxStep, vectorLength, features).get();
    }

    public <ID> MatrixFactorizationModel<ID> matrixFactorizationGradientDescent(BipartiteGraph graph, EdgeProperty<Double> weight, double learningRate, double changePerStep, double lambda, int maxStep, int vectorLength) throws InterruptedException, ExecutionException {
        return this.matrixFactorizationGradientDescentAsync(graph, weight, learningRate, changePerStep, lambda, maxStep, vectorLength).get();
    }

    public <ID> VertexProperty<ID, Double> matrixFactorizationRecommendations(BipartiteGraph graph, PgxVertex<ID> user, int vectorLength, VertexProperty<ID, PgxVect<Double>> feature, VertexProperty<ID, Double> estimatedRating) throws InterruptedException, ExecutionException {
        return this.matrixFactorizationRecommendationsAsync(graph, user, vectorLength, feature, estimatedRating).get();
    }

    public EdgeProperty<Boolean> prim(PgxGraph graph, EdgeProperty<Double> weight) throws ExecutionException, InterruptedException {
        return this.primAsync(graph, weight).get();
    }

    public EdgeProperty<Boolean> prim(PgxGraph graph, EdgeProperty<Double> weight, EdgeProperty<Boolean> mst) throws ExecutionException, InterruptedException {
        return this.primAsync(graph, weight, mst).get();
    }

    public <ID> Pair<VertexProperty<ID, Integer>, VertexProperty<ID, PgxVertex<ID>>> filteredBfs(PgxGraph graph, PgxVertex<ID> root) throws ExecutionException, InterruptedException {
        return this.filteredBfsAsync(graph, root).get();
    }

    public <ID> Pair<VertexProperty<ID, Integer>, VertexProperty<ID, PgxVertex<ID>>> filteredBfs(PgxGraph graph, PgxVertex<ID> root, int maxDepth) throws ExecutionException, InterruptedException {
        return this.filteredBfsAsync(graph, root, maxDepth).get();
    }

    public <ID> Pair<VertexProperty<ID, Integer>, VertexProperty<ID, PgxVertex<ID>>> filteredBfs(PgxGraph graph, PgxVertex<ID> root, VertexFilter navigator) throws ExecutionException, InterruptedException {
        return this.filteredBfsAsync(graph, root, navigator).get();
    }

    public <ID> Pair<VertexProperty<ID, Integer>, VertexProperty<ID, PgxVertex<ID>>> filteredBfs(PgxGraph graph, PgxVertex<ID> root, VertexFilter navigator, int maxDepth) throws ExecutionException, InterruptedException {
        return this.filteredBfsAsync(graph, root, navigator, maxDepth).get();
    }

    public <ID> Pair<VertexProperty<ID, Integer>, VertexProperty<ID, PgxVertex<ID>>> filteredBfs(PgxGraph graph, PgxVertex<ID> root, VertexFilter navigator, boolean initWithInf) throws ExecutionException, InterruptedException {
        return this.filteredBfsAsync(graph, root, navigator, initWithInf).get();
    }

    public <ID> Pair<VertexProperty<ID, Integer>, VertexProperty<ID, PgxVertex<ID>>> filteredBfs(PgxGraph graph, PgxVertex<ID> root, VertexFilter navigator, boolean initWithInf, int maxDepth) throws ExecutionException, InterruptedException {
        return this.filteredBfsAsync(graph, root, navigator, initWithInf, maxDepth).get();
    }

    public <ID> Pair<VertexProperty<ID, Integer>, VertexProperty<ID, PgxVertex<ID>>> filteredBfs(PgxGraph graph, PgxVertex<ID> root, VertexFilter navigator, boolean initWithInf, VertexProperty<ID, Integer> distance, VertexProperty<ID, PgxVertex<ID>> parent) throws ExecutionException, InterruptedException {
        return this.filteredBfsAsync(graph, root, navigator, initWithInf, distance, parent).get();
    }

    public <ID> Pair<VertexProperty<ID, Integer>, VertexProperty<ID, PgxVertex<ID>>> filteredBfs(PgxGraph graph, PgxVertex<ID> root, VertexFilter navigator, boolean initWithInf, int maxDepth, VertexProperty<ID, Integer> distance, VertexProperty<ID, PgxVertex<ID>> parent) throws ExecutionException, InterruptedException {
        return this.filteredBfsAsync(graph, root, navigator, initWithInf, maxDepth, distance, parent).get();
    }

    public <ID> Pair<VertexProperty<ID, Integer>, VertexProperty<ID, PgxVertex<ID>>> filteredDfs(PgxGraph graph, PgxVertex<ID> root) throws ExecutionException, InterruptedException {
        return this.filteredDfsAsync(graph, root).get();
    }

    public <ID> Pair<VertexProperty<ID, Integer>, VertexProperty<ID, PgxVertex<ID>>> filteredDfs(PgxGraph graph, PgxVertex<ID> root, int maxDepth) throws ExecutionException, InterruptedException {
        return this.filteredDfsAsync(graph, root, maxDepth).get();
    }

    public <ID> Pair<VertexProperty<ID, Integer>, VertexProperty<ID, PgxVertex<ID>>> filteredDfs(PgxGraph graph, PgxVertex<ID> root, VertexFilter navigator) throws ExecutionException, InterruptedException {
        return this.filteredDfsAsync(graph, root, navigator).get();
    }

    public <ID> Pair<VertexProperty<ID, Integer>, VertexProperty<ID, PgxVertex<ID>>> filteredDfs(PgxGraph graph, PgxVertex<ID> root, VertexFilter navigator, int maxDepth) throws ExecutionException, InterruptedException {
        return this.filteredDfsAsync(graph, root, navigator, maxDepth).get();
    }

    public <ID> Pair<VertexProperty<ID, Integer>, VertexProperty<ID, PgxVertex<ID>>> filteredDfs(PgxGraph graph, PgxVertex<ID> root, VertexFilter navigator, boolean initWithInf) throws ExecutionException, InterruptedException {
        return this.filteredDfsAsync(graph, root, navigator, initWithInf).get();
    }

    public <ID> Pair<VertexProperty<ID, Integer>, VertexProperty<ID, PgxVertex<ID>>> filteredDfs(PgxGraph graph, PgxVertex<ID> root, VertexFilter navigator, boolean initWithInf, int maxDepth) throws ExecutionException, InterruptedException {
        return this.filteredDfsAsync(graph, root, navigator, initWithInf, maxDepth).get();
    }

    public <ID> Pair<VertexProperty<ID, Integer>, VertexProperty<ID, PgxVertex<ID>>> filteredDfs(PgxGraph graph, PgxVertex<ID> root, VertexFilter navigator, boolean initWithInf, VertexProperty<ID, Integer> distance, VertexProperty<ID, PgxVertex<ID>> parent) throws ExecutionException, InterruptedException {
        return this.filteredDfsAsync(graph, root, navigator, initWithInf, distance, parent).get();
    }

    public <ID> Pair<VertexProperty<ID, Integer>, VertexProperty<ID, PgxVertex<ID>>> filteredDfs(PgxGraph graph, PgxVertex<ID> root, VertexFilter navigator, boolean initWithInf, int maxDepth, VertexProperty<ID, Integer> distance, VertexProperty<ID, PgxVertex<ID>> parent) throws ExecutionException, InterruptedException {
        return this.filteredDfsAsync(graph, root, navigator, initWithInf, maxDepth, distance, parent).get();
    }

    public <ID> Pair<PgxMap<Integer, PgxVertex<ID>>, VertexSet<ID>> computeHighDegreeVertices(PgxGraph graph, int k, PgxMap<Integer, PgxVertex<ID>> highDegreeVertexMapping, VertexSet<ID> highDegreeVertices) throws ExecutionException, InterruptedException {
        return this.computeHighDegreeVerticesAsync(graph, k, highDegreeVertexMapping, highDegreeVertices).get();
    }

    public <ID> Pair<PgxMap<Integer, PgxVertex<ID>>, VertexSet<ID>> computeHighDegreeVertices(PgxGraph graph, int k) throws ExecutionException, InterruptedException {
        return this.computeHighDegreeVerticesAsync(graph, k).get();
    }

    public <ID> VertexProperty<ID, PgxVect<Integer>> createDistanceIndex(PgxGraph graph, PgxMap<Integer, PgxVertex<ID>> highDegreeVertexMapping, VertexSet<ID> highDegreeVertices) throws ExecutionException, InterruptedException {
        return this.createDistanceIndexAsync(graph, highDegreeVertexMapping, highDegreeVertices).get();
    }

    public <ID> VertexProperty<ID, PgxVect<Integer>> createDistanceIndex(PgxGraph graph, PgxMap<Integer, PgxVertex<ID>> highDegreeVertexMapping, VertexSet<ID> highDegreeVertices, VertexProperty<ID, PgxVect<Integer>> index) throws ExecutionException, InterruptedException {
        return this.createDistanceIndexAsync(graph, highDegreeVertexMapping, highDegreeVertices, index).get();
    }

    public <ID> Pair<VertexSequence<ID>, EdgeSequence> limitedShortestPathHopDist(PgxGraph graph, PgxVertex<ID> src, PgxVertex<ID> dst, int maxHops, PgxMap<Integer, PgxVertex<ID>> highDegreeVertexMapping, VertexSet<ID> highDegreeVertices, VertexProperty<ID, PgxVect<Integer>> index, VertexSequence<ID> pathVertices, EdgeSequence pathEdges) throws ExecutionException, InterruptedException {
        return this.limitedShortestPathHopDistAsync(graph, src, dst, maxHops, highDegreeVertexMapping, highDegreeVertices, index, pathVertices, pathEdges).get();
    }

    public <ID> Pair<VertexSequence<ID>, EdgeSequence> limitedShortestPathHopDist(PgxGraph graph, PgxVertex<ID> src, PgxVertex<ID> dst, int maxHops, PgxMap<Integer, PgxVertex<ID>> highDegreeVertexMapping, VertexSet<ID> highDegreeVertices, VertexProperty<ID, PgxVect<Integer>> index) throws ExecutionException, InterruptedException {
        return this.limitedShortestPathHopDistAsync(graph, src, dst, maxHops, highDegreeVertexMapping, highDegreeVertices, index).get();
    }

    public <ID> Pair<VertexSequence<ID>, EdgeSequence> limitedShortestPathHopDistFiltered(PgxGraph graph, PgxVertex<ID> src, PgxVertex<ID> dst, int maxHops, PgxMap<Integer, PgxVertex<ID>> highDegreeVertexMapping, VertexSet<ID> highDegreeVertices, VertexProperty<ID, PgxVect<Integer>> index, EdgeFilter filter, VertexSequence<ID> pathVertices, EdgeSequence pathEdges) throws ExecutionException, InterruptedException {
        return this.limitedShortestPathHopDistFilteredAsync(graph, src, dst, maxHops, highDegreeVertexMapping, highDegreeVertices, index, filter, pathVertices, pathEdges).get();
    }

    public <ID> Pair<VertexSequence<ID>, EdgeSequence> limitedShortestPathHopDistFiltered(PgxGraph graph, PgxVertex<ID> src, PgxVertex<ID> dst, int maxHops, PgxMap<Integer, PgxVertex<ID>> highDegreeVertexMapping, VertexSet<ID> highDegreeVertices, VertexProperty<ID, PgxVect<Integer>> index, EdgeFilter filter) throws ExecutionException, InterruptedException {
        return this.limitedShortestPathHopDistFilteredAsync(graph, src, dst, maxHops, highDegreeVertexMapping, highDegreeVertices, index, filter).get();
    }

    public <ID> Triple<VertexSet<ID>, EdgeSet, PgxMap<PgxVertex<ID>, Integer>> allReachableVerticesEdges(PgxGraph graph, PgxVertex<ID> src, PgxVertex<ID> dst, int k) throws ExecutionException, InterruptedException {
        return this.allReachableVerticesEdgesAsync(graph, src, dst, k).get();
    }

    public <ID> Triple<VertexSet<ID>, EdgeSet, PgxMap<PgxVertex<ID>, Integer>> allReachableVerticesEdgesFiltered(PgxGraph graph, PgxVertex<ID> src, PgxVertex<ID> dst, int k, EdgeFilter filter) throws ExecutionException, InterruptedException {
        return this.allReachableVerticesEdgesFilteredAsync(graph, src, dst, k, filter).get();
    }

    public <ID> Triple<ScalarSequence<Integer>, VertexSequence<ID>, EdgeSequence> enumerateSimplePaths(PgxGraph graph, PgxVertex<ID> src, PgxVertex<ID> dst, int k, VertexSet verticesOnPath, EdgeSet edgesOnPath, PgxMap<PgxVertex<ID>, Integer> dist) throws ExecutionException, InterruptedException {
        return this.enumerateSimplePathsAsync(graph, src, dst, k, verticesOnPath, edgesOnPath, dist).get();
    }

    <ID> PgxMap<PgxVertex<ID>, Integer> randomWalkWithRestart(PgxGraph graph, PgxVertex<ID> source, Integer length, BigDecimal resetProb, PgxMap<PgxVertex<ID>, Integer> visitCount) throws ExecutionException, InterruptedException {
        return this.randomWalkWithRestart(graph, source, (int)length, resetProb.doubleValue(), visitCount);
    }

    <ID> VertexProperty<ID, Double> pagerank(PgxGraph graph, BigDecimal e, BigDecimal d, int max) throws ExecutionException, InterruptedException {
        return this.pagerank(graph, e.doubleValue(), d.doubleValue(), max);
    }

    <ID> VertexProperty<ID, Double> pagerank(PgxGraph graph, BigDecimal e, BigDecimal d, int max, boolean norm) throws ExecutionException, InterruptedException {
        return this.pagerank(graph, e.doubleValue(), d.doubleValue(), max, norm);
    }

    <ID> VertexProperty<ID, Double> pagerank(PgxGraph graph, BigDecimal e, BigDecimal d, int max, VertexProperty<ID, Double> rank) throws ExecutionException, InterruptedException {
        return this.pagerank(graph, e.doubleValue(), d.doubleValue(), max, rank);
    }

    <ID> VertexProperty<ID, Double> pagerank(PgxGraph graph, BigDecimal e, BigDecimal d, int max, boolean norm, VertexProperty<ID, Double> rank) throws ExecutionException, InterruptedException {
        return this.pagerank(graph, e.doubleValue(), d.doubleValue(), max, norm, rank);
    }

    <ID> VertexProperty<ID, Double> pagerankApproximate(PgxGraph graph, BigDecimal e, BigDecimal d, int max) throws ExecutionException, InterruptedException {
        return this.pagerankApproximate(graph, e.doubleValue(), d.doubleValue(), max);
    }

    <ID> VertexProperty<ID, Double> pagerankApproximate(PgxGraph graph, BigDecimal e, BigDecimal d, int max, VertexProperty<ID, Double> rank) throws ExecutionException, InterruptedException {
        return this.pagerankApproximate(graph, e.doubleValue(), d.doubleValue(), max, rank);
    }

    <ID> VertexProperty<ID, Double> weightedPagerank(PgxGraph graph, BigDecimal e, BigDecimal d, int max, EdgeProperty<Double> weight) throws ExecutionException, InterruptedException {
        return this.weightedPagerank(graph, e.doubleValue(), d.doubleValue(), max, weight);
    }

    <ID> VertexProperty<ID, Double> weightedPagerank(PgxGraph graph, BigDecimal e, BigDecimal d, int max, boolean norm, EdgeProperty<Double> weight) throws ExecutionException, InterruptedException {
        return this.weightedPagerank(graph, e.doubleValue(), d.doubleValue(), max, norm, weight);
    }

    <ID> VertexProperty<ID, Double> weightedPagerank(PgxGraph graph, BigDecimal e, BigDecimal d, int max, EdgeProperty<Double> weight, VertexProperty<ID, Double> rank) throws ExecutionException, InterruptedException {
        return this.weightedPagerank(graph, e.doubleValue(), d.doubleValue(), max, weight, rank);
    }

    <ID> VertexProperty<ID, Double> weightedPagerank(PgxGraph graph, BigDecimal e, BigDecimal d, int max, boolean norm, EdgeProperty<Double> weight, VertexProperty<ID, Double> rank) throws ExecutionException, InterruptedException {
        return this.weightedPagerank(graph, e.doubleValue(), d.doubleValue(), max, norm, weight, rank);
    }

    <ID> VertexProperty<ID, Double> personalizedPagerank(PgxGraph graph, PgxVertex<ID> v, BigDecimal e, BigDecimal d, int max) throws ExecutionException, InterruptedException {
        return this.personalizedPagerank(graph, v, e.doubleValue(), d.doubleValue(), max);
    }

    <ID> VertexProperty<ID, Double> personalizedPagerank(PgxGraph graph, PgxVertex<ID> v, BigDecimal e, BigDecimal d, int max, boolean norm) throws ExecutionException, InterruptedException {
        return this.personalizedPagerank(graph, v, e.doubleValue(), d.doubleValue(), max, norm);
    }

    <ID> VertexProperty<ID, Double> personalizedPagerank(PgxGraph graph, PgxVertex<ID> v, BigDecimal e, BigDecimal d, int max, VertexProperty<ID, Double> rank) throws ExecutionException, InterruptedException {
        return this.personalizedPagerank(graph, v, e.doubleValue(), d.doubleValue(), max, rank);
    }

    <ID> VertexProperty<ID, Double> personalizedPagerank(PgxGraph graph, PgxVertex<ID> v, BigDecimal e, BigDecimal d, int max, boolean norm, VertexProperty<ID, Double> rank) throws ExecutionException, InterruptedException {
        return this.personalizedPagerank(graph, v, e.doubleValue(), d.doubleValue(), max, norm, rank);
    }

    <ID> VertexProperty<ID, Double> personalizedPagerank(PgxGraph graph, VertexSet<ID> vertices, BigDecimal e, BigDecimal d, int max) throws ExecutionException, InterruptedException {
        return this.personalizedPagerank(graph, vertices, e.doubleValue(), d.doubleValue(), max);
    }

    <ID> VertexProperty<ID, Double> personalizedPagerank(PgxGraph graph, VertexSet<ID> vertices, BigDecimal e, BigDecimal d, int max, boolean norm) throws ExecutionException, InterruptedException {
        return this.personalizedPagerank(graph, vertices, e.doubleValue(), d.doubleValue(), max, norm);
    }

    <ID> VertexProperty<ID, Double> personalizedPagerank(PgxGraph graph, VertexSet<ID> vertices, BigDecimal e, BigDecimal d, int max, VertexProperty<ID, Double> rank) throws ExecutionException, InterruptedException {
        return this.personalizedPagerank(graph, vertices, e.doubleValue(), d.doubleValue(), max, rank);
    }

    <ID> VertexProperty<ID, Double> personalizedPagerank(PgxGraph graph, VertexSet<ID> vertices, BigDecimal e, BigDecimal d, int max, boolean norm, VertexProperty<ID, Double> rank) throws ExecutionException, InterruptedException {
        return this.personalizedPagerank(graph, vertices, e.doubleValue(), d.doubleValue(), max, norm, rank);
    }

    <ID> VertexProperty<ID, Double> personalizedWeightedPagerank(PgxGraph graph, PgxVertex<ID> v, BigDecimal e, BigDecimal d, int max, EdgeProperty<Double> weight) throws ExecutionException, InterruptedException {
        return this.personalizedWeightedPagerank(graph, v, e.doubleValue(), d.doubleValue(), max, weight);
    }

    <ID> VertexProperty<ID, Double> personalizedWeightedPagerank(PgxGraph graph, PgxVertex<ID> v, BigDecimal e, BigDecimal d, int max, boolean norm, EdgeProperty<Double> weight) throws ExecutionException, InterruptedException {
        return this.personalizedWeightedPagerank(graph, v, e.doubleValue(), d.doubleValue(), max, norm, weight);
    }

    <ID> VertexProperty<ID, Double> personalizedWeightedPagerank(PgxGraph graph, PgxVertex<ID> v, BigDecimal e, BigDecimal d, int max, EdgeProperty<Double> weight, VertexProperty<ID, Double> rank) throws ExecutionException, InterruptedException {
        return this.personalizedWeightedPagerank(graph, v, e.doubleValue(), d.doubleValue(), max, weight, rank);
    }

    <ID> VertexProperty<ID, Double> personalizedWeightedPagerank(PgxGraph graph, PgxVertex<ID> v, BigDecimal e, BigDecimal d, int max, boolean norm, EdgeProperty<Double> weight, VertexProperty<ID, Double> rank) throws ExecutionException, InterruptedException {
        return this.personalizedWeightedPagerank(graph, v, e.doubleValue(), d.doubleValue(), max, norm, weight, rank);
    }

    <ID> VertexProperty<ID, Double> personalizedWeightedPagerank(PgxGraph graph, VertexSet<ID> vertices, BigDecimal e, BigDecimal d, int max, EdgeProperty<Double> weight) throws ExecutionException, InterruptedException {
        return this.personalizedWeightedPagerank(graph, vertices, e.doubleValue(), d.doubleValue(), max, weight);
    }

    <ID> VertexProperty<ID, Double> personalizedWeightedPagerank(PgxGraph graph, VertexSet<ID> vertices, BigDecimal e, BigDecimal d, int max, boolean norm, EdgeProperty<Double> weight) throws ExecutionException, InterruptedException {
        return this.personalizedWeightedPagerank(graph, vertices, e.doubleValue(), d.doubleValue(), max, norm, weight);
    }

    <ID> VertexProperty<ID, Double> personalizedWeightedPagerank(PgxGraph graph, VertexSet<ID> vertices, BigDecimal e, BigDecimal d, int max, EdgeProperty<Double> weight, VertexProperty<ID, Double> rank) throws ExecutionException, InterruptedException {
        return this.personalizedWeightedPagerank(graph, vertices, e.doubleValue(), d.doubleValue(), max, weight, rank);
    }

    <ID> VertexProperty<ID, Double> personalizedWeightedPagerank(PgxGraph graph, VertexSet<ID> vertices, BigDecimal e, BigDecimal d, int max, boolean norm, EdgeProperty<Double> weight, VertexProperty<ID, Double> rank) throws ExecutionException, InterruptedException {
        return this.personalizedWeightedPagerank(graph, vertices, e.doubleValue(), d.doubleValue(), max, norm, weight, rank);
    }

    <ID> VertexProperty<ID, Double> eigenvectorCentrality(PgxGraph graph, int max, BigDecimal maxDiff, boolean useL2Norm, boolean useInEdge) throws ExecutionException, InterruptedException {
        return this.eigenvectorCentrality(graph, max, maxDiff.doubleValue(), useL2Norm, useInEdge);
    }

    <ID> VertexProperty<ID, Double> eigenvectorCentrality(PgxGraph graph, int max, BigDecimal maxDiff, boolean useL2Norm, boolean useInEdge, VertexProperty<ID, Double> ec) throws ExecutionException, InterruptedException {
        return this.eigenvectorCentrality(graph, max, maxDiff.doubleValue(), useL2Norm, useInEdge, ec);
    }

    <ID> Pair<VertexSequence<ID>, VertexSequence<ID>> whomToFollow(PgxGraph graph, PgxVertex<ID> vertex, int topK, int sizeCircleOfTrust, int maxIter, BigDecimal tol, BigDecimal dampingFactor, int salsaMaxIter, BigDecimal salsaTol) throws ExecutionException, InterruptedException {
        return this.whomToFollow(graph, vertex, topK, sizeCircleOfTrust, maxIter, tol.doubleValue(), dampingFactor.doubleValue(), salsaMaxIter, salsaTol.doubleValue());
    }

    <ID> Pair<VertexSequence<ID>, VertexSequence<ID>> whomToFollow(PgxGraph graph, PgxVertex<ID> vertex, int topK, int sizeCircleOfTrust, int maxIter, BigDecimal tol, BigDecimal dampingFactor, int salsaMaxIter, BigDecimal salsaTol, VertexSequence<ID> hubs, VertexSequence<ID> authorities) throws ExecutionException, InterruptedException {
        return this.whomToFollow(graph, vertex, topK, sizeCircleOfTrust, maxIter, tol.doubleValue(), dampingFactor.doubleValue(), salsaMaxIter, salsaTol.doubleValue(), hubs, authorities);
    }

    <ID> VertexProperty<ID, Double> salsa(BipartiteGraph graph, BigDecimal maxDiff, int maxIter) throws ExecutionException, InterruptedException {
        return this.salsa(graph, maxDiff.doubleValue(), maxIter);
    }

    <ID> VertexProperty<ID, Double> salsa(BipartiteGraph graph, BigDecimal maxDiff, int maxIter, VertexProperty<ID, Double> salsaRank) throws ExecutionException, InterruptedException {
        return this.salsa(graph, maxDiff.doubleValue(), maxIter, salsaRank);
    }

    <ID> VertexProperty<ID, Double> personalizedSalsa(BipartiteGraph graph, VertexSet<ID> vertices, BigDecimal d, int maxIterations, BigDecimal maxDiff) throws ExecutionException, InterruptedException {
        return this.personalizedSalsa(graph, vertices, d.doubleValue(), maxIterations, maxDiff.doubleValue());
    }

    <ID> VertexProperty<ID, Double> personalizedSalsa(BipartiteGraph graph, VertexSet<ID> vertices, BigDecimal d, int maxIterations, BigDecimal maxDiff, VertexProperty<ID, Double> salsaRank) throws ExecutionException, InterruptedException {
        return this.personalizedSalsa(graph, vertices, d.doubleValue(), maxIterations, maxDiff.doubleValue(), salsaRank);
    }

    <ID> VertexProperty<ID, Double> personalizedSalsa(BipartiteGraph graph, PgxVertex<ID> v, BigDecimal d, int maxIterations, BigDecimal maxDiff) throws ExecutionException, InterruptedException {
        return this.personalizedSalsa(graph, v, d.doubleValue(), maxIterations, maxDiff.doubleValue());
    }

    <ID> VertexProperty<ID, Double> personalizedSalsa(BipartiteGraph graph, PgxVertex<ID> v, BigDecimal d, int maxIterations, BigDecimal maxDiff, VertexProperty<ID, Double> salsaRank) throws ExecutionException, InterruptedException {
        return this.personalizedSalsa(graph, v, d.doubleValue(), maxIterations, maxDiff.doubleValue(), salsaRank);
    }

    <ID> Partition<ID> communitiesInfomap(PgxGraph graph, VertexProperty<ID, Double> rank, EdgeProperty<Double> weight, BigDecimal tau, BigDecimal tol, int maxIter) throws ExecutionException, InterruptedException {
        return this.communitiesInfomap(graph, rank, weight, tau.doubleValue(), tol.doubleValue(), maxIter);
    }

    <ID> Partition<ID> communitiesInfomap(PgxGraph graph, VertexProperty<ID, Double> rank, EdgeProperty<Double> weight, BigDecimal tau, BigDecimal tol, int maxIter, VertexProperty<ID, Long> module) throws ExecutionException, InterruptedException {
        return this.communitiesInfomap(graph, rank, weight, tau.doubleValue(), tol.doubleValue(), maxIter, module);
    }

    <ID> MatrixFactorizationModel<ID> matrixFactorizationGradientDescent(BipartiteGraph graph, EdgeProperty<Double> weight, BigDecimal learningRate, BigDecimal changePerStep, BigDecimal lambda, int maxStep, int vectorLength) throws InterruptedException, ExecutionException {
        return this.matrixFactorizationGradientDescent(graph, weight, learningRate.doubleValue(), changePerStep.doubleValue(), lambda.doubleValue(), maxStep, vectorLength);
    }

    <ID> MatrixFactorizationModel<ID> matrixFactorizationGradientDescent(BipartiteGraph graph, EdgeProperty<Double> weight, BigDecimal learningRate, BigDecimal changePerStep, BigDecimal lambda, int maxStep, int vectorLength, VertexProperty<ID, PgxVect<Double>> features) throws InterruptedException, ExecutionException {
        return this.matrixFactorizationGradientDescent(graph, weight, learningRate.doubleValue(), changePerStep.doubleValue(), lambda.doubleValue(), maxStep, vectorLength, features);
    }

    public <ID> PgxMap<PgxVertex<ID>, Integer> randomWalkWithRestart(PgxGraph graph, ID source, int length, BigDecimal resetProb, PgxMap<PgxVertex<ID>, Integer> visitCount) throws ExecutionException, InterruptedException {
        return this.randomWalkWithRestart(graph, graph.getVertex(source), (Integer)length, resetProb, visitCount);
    }

    public <ID> VertexProperty<ID, Double> matrixFactorizationRecommendations(BipartiteGraph graph, ID user, int vectorLength, VertexProperty<ID, PgxVect<Double>> feature, VertexProperty<ID, Double> estimatedRating) throws ExecutionException, InterruptedException {
        return this.matrixFactorizationRecommendations(graph, (ID)graph.getVertex(user), vectorLength, feature, estimatedRating);
    }

    public <ID> VertexProperty<ID, Double> personalizedPagerank(PgxGraph graph, ID vertexId, BigDecimal e, BigDecimal d, int max) throws ExecutionException, InterruptedException {
        return this.personalizedPagerank(graph, (ID)graph.getVertex(vertexId), e, d, max);
    }

    public <ID> VertexProperty<ID, Double> personalizedPagerank(PgxGraph graph, ID vertexId, BigDecimal e, BigDecimal d, int max, boolean norm) throws ExecutionException, InterruptedException {
        return this.personalizedPagerank(graph, (ID)graph.getVertex(vertexId), e, d, max, norm);
    }

    public <ID> VertexProperty<ID, Double> personalizedPagerank(PgxGraph graph, ID vertexId, BigDecimal e, BigDecimal d, int max, VertexProperty<ID, Double> rank) throws ExecutionException, InterruptedException {
        return this.personalizedPagerank(graph, (ID)graph.getVertex(vertexId), e, d, max, rank);
    }

    public <ID> VertexProperty<ID, Double> personalizedPagerank(PgxGraph graph, ID vertexId, BigDecimal e, BigDecimal d, int max, boolean norm, VertexProperty<ID, Double> rank) throws ExecutionException, InterruptedException {
        return this.personalizedPagerank(graph, (ID)graph.getVertex(vertexId), e, d, max, norm, rank);
    }

    public <ID> VertexProperty<ID, Double> personalizedWeightedPagerank(PgxGraph graph, ID vertexId, BigDecimal e, BigDecimal d, int max, EdgeProperty<Double> weight) throws ExecutionException, InterruptedException {
        return this.personalizedWeightedPagerank(graph, (ID)graph.getVertex(vertexId), e, d, max, weight);
    }

    public <ID> VertexProperty<ID, Double> personalizedWeightedPagerank(PgxGraph graph, ID vertexId, BigDecimal e, BigDecimal d, int max, boolean norm, EdgeProperty<Double> weight) throws ExecutionException, InterruptedException {
        return this.personalizedWeightedPagerank(graph, (ID)graph.getVertex(vertexId), e, d, max, norm, weight);
    }

    public <ID> VertexProperty<ID, Double> personalizedWeightedPagerank(PgxGraph graph, ID vertexId, BigDecimal e, BigDecimal d, int max, EdgeProperty<Double> weight, VertexProperty<ID, Double> rank) throws ExecutionException, InterruptedException {
        return this.personalizedWeightedPagerank(graph, (ID)graph.getVertex(vertexId), e, d, max, weight, rank);
    }

    public <ID> VertexProperty<ID, Double> personalizedWeightedPagerank(PgxGraph graph, ID vertexId, BigDecimal e, BigDecimal d, int max, boolean norm, EdgeProperty<Double> weight, VertexProperty<ID, Double> rank) throws ExecutionException, InterruptedException {
        return this.personalizedWeightedPagerank(graph, (ID)graph.getVertex(vertexId), e, d, max, norm, weight, rank);
    }

    public <ID> Pair<VertexSequence<ID>, VertexSequence<ID>> whomToFollow(PgxGraph graph, ID vertexId, int topK) throws ExecutionException, InterruptedException {
        return this.whomToFollow(graph, (ID)graph.getVertex(vertexId), topK);
    }

    public <ID> Pair<VertexSequence<ID>, VertexSequence<ID>> whomToFollow(PgxGraph graph, ID vertexId, int topK, int sizeCircleOfTrust) throws ExecutionException, InterruptedException {
        return this.whomToFollow(graph, (ID)graph.getVertex(vertexId), topK, sizeCircleOfTrust);
    }

    public <ID> Pair<VertexSequence<ID>, VertexSequence<ID>> whomToFollow(PgxGraph graph, ID vertexId, int topK, int sizeCircleOfTrust, int maxIter, BigDecimal tol, BigDecimal dampingFactor, int salsaMaxIter, BigDecimal salsaTol) throws ExecutionException, InterruptedException {
        return this.whomToFollow(graph, (ID)graph.getVertex(vertexId), topK, sizeCircleOfTrust, maxIter, tol, dampingFactor, salsaMaxIter, salsaTol);
    }

    public <ID> Pair<VertexSequence<ID>, VertexSequence<ID>> whomToFollow(PgxGraph graph, ID vertexId, int topK, int sizeCircleOfTrust, int maxIter, BigDecimal tol, BigDecimal dampingFactor, int salsaMaxIter, BigDecimal salsaTol, VertexSequence<ID> hubs, VertexSequence<ID> authorities) throws ExecutionException, InterruptedException {
        return this.whomToFollow(graph, (ID)graph.getVertex(vertexId), topK, sizeCircleOfTrust, maxIter, tol, dampingFactor, salsaMaxIter, salsaTol, hubs, authorities);
    }

    public <ID> AllPaths<ID> fattestPath(PgxGraph graph, ID rootId, EdgeProperty<Double> capacity) throws ExecutionException, InterruptedException {
        return this.fattestPath(graph, (ID)graph.getVertex(rootId), capacity);
    }

    public <ID> AllPaths<ID> fattestPath(PgxGraph graph, ID rootId, EdgeProperty<Double> capacity, VertexProperty<ID, Double> distance, VertexProperty<ID, PgxVertex<ID>> parent, VertexProperty<ID, PgxEdge> parentEdge) throws ExecutionException, InterruptedException {
        return this.fattestPath(graph, (ID)graph.getVertex(rootId), capacity, distance, parent, parentEdge);
    }

    public <ID> PgxPath<ID> shortestPathDijkstra(PgxGraph graph, ID srcId, ID dstId, EdgeProperty<Double> cost) throws ExecutionException, InterruptedException {
        return this.shortestPathDijkstra(graph, (ID)graph.getVertex(srcId), (ID)graph.getVertex(dstId), cost);
    }

    public <ID> PgxPath<ID> shortestPathDijkstra(PgxGraph graph, ID srcId, ID dstId, EdgeProperty<Double> cost, VertexProperty<ID, PgxVertex<ID>> parent, VertexProperty<ID, PgxEdge> parentEdge) throws ExecutionException, InterruptedException {
        return this.shortestPathDijkstra(graph, (ID)graph.getVertex(srcId), (ID)graph.getVertex(dstId), cost, parent, parentEdge);
    }

    public <ID> PgxPath<ID> shortestPathFilteredDijkstra(PgxGraph graph, ID srcId, ID dstId, EdgeProperty<Double> cost, GraphFilter filterExpr) throws ExecutionException, InterruptedException {
        return this.shortestPathFilteredDijkstra(graph, (ID)graph.getVertex(srcId), (ID)graph.getVertex(dstId), cost, filterExpr);
    }

    public <ID> PgxPath<ID> shortestPathFilteredDijkstra(PgxGraph graph, ID srcId, ID dstId, EdgeProperty<Double> cost, GraphFilter filterExpr, VertexProperty<ID, PgxVertex<ID>> parent, VertexProperty<ID, PgxEdge> parentEdge) throws ExecutionException, InterruptedException {
        return this.shortestPathFilteredDijkstra(graph, (ID)graph.getVertex(srcId), (ID)graph.getVertex(dstId), cost, filterExpr, parent, parentEdge);
    }

    public <ID> PgxPath<ID> shortestPathDijkstraBidirectional(PgxGraph graph, ID srcId, ID dstId, EdgeProperty<Double> cost) throws ExecutionException, InterruptedException {
        return this.shortestPathDijkstraBidirectional(graph, (ID)graph.getVertex(srcId), (ID)graph.getVertex(dstId), cost);
    }

    public <ID> PgxPath<ID> shortestPathDijkstraBidirectional(PgxGraph graph, ID srcId, ID dstId, EdgeProperty<Double> cost, VertexProperty<ID, PgxVertex<ID>> parent, VertexProperty<ID, PgxEdge> parentEdge) throws ExecutionException, InterruptedException {
        return this.shortestPathDijkstraBidirectional(graph, (ID)graph.getVertex(srcId), (ID)graph.getVertex(dstId), cost, parent, parentEdge);
    }

    public <ID> PgxPath<ID> shortestPathFilteredDijkstraBidirectional(PgxGraph graph, ID srcId, ID dstId, EdgeProperty<Double> cost, GraphFilter filterExpr) throws ExecutionException, InterruptedException {
        return this.shortestPathFilteredDijkstraBidirectional(graph, (ID)graph.getVertex(srcId), (ID)graph.getVertex(dstId), cost, filterExpr);
    }

    public <ID> PgxPath<ID> shortestPathFilteredDijkstraBidirectional(PgxGraph graph, ID srcId, ID dstId, EdgeProperty<Double> cost, GraphFilter filterExpr, VertexProperty<ID, PgxVertex<ID>> parent, VertexProperty<ID, PgxEdge> parentEdge) throws ExecutionException, InterruptedException {
        return this.shortestPathFilteredDijkstraBidirectional(graph, (ID)graph.getVertex(srcId), (ID)graph.getVertex(dstId), cost, filterExpr, parent, parentEdge);
    }

    public <ID> AllPaths<ID> shortestPathBellmanFord(PgxGraph graph, ID srcId, EdgeProperty<Double> cost, VertexProperty<ID, Double> distance, VertexProperty<ID, PgxVertex<ID>> parent, VertexProperty<ID, PgxEdge> parentEdge) throws ExecutionException, InterruptedException {
        return this.shortestPathBellmanFord(graph, (ID)graph.getVertex(srcId), cost, distance, parent, parentEdge);
    }

    public <ID> AllPaths<ID> shortestPathBellmanFord(PgxGraph graph, ID srcId, EdgeProperty<Double> cost) throws ExecutionException, InterruptedException {
        return this.shortestPathBellmanFord(graph, (ID)graph.getVertex(srcId), cost);
    }

    public <ID> AllPaths<ID> shortestPathBellmanFordReverse(PgxGraph graph, ID srcId, EdgeProperty<Double> cost) throws ExecutionException, InterruptedException {
        return this.shortestPathBellmanFordReverse(graph, (ID)graph.getVertex(srcId), cost);
    }

    public <ID> AllPaths<ID> shortestPathBellmanFordReverse(PgxGraph graph, ID srcId, EdgeProperty<Double> cost, VertexProperty<ID, Double> distance, VertexProperty<ID, PgxVertex<ID>> parent, VertexProperty<ID, PgxEdge> parentEdge) throws ExecutionException, InterruptedException {
        return this.shortestPathBellmanFordReverse(graph, (ID)graph.getVertex(srcId), cost, distance, parent, parentEdge);
    }

    public <ID> AllPaths<ID> shortestPathHopDist(PgxGraph graph, ID srcId) throws ExecutionException, InterruptedException {
        return this.shortestPathHopDist(graph, (ID)graph.getVertex(srcId));
    }

    public <ID> AllPaths<ID> shortestPathHopDist(PgxGraph graph, ID srcId, VertexProperty<ID, Double> distance, VertexProperty<ID, PgxVertex<ID>> parent, VertexProperty<ID, PgxEdge> parentEdge) throws ExecutionException, InterruptedException {
        return this.shortestPathHopDist(graph, (ID)graph.getVertex(srcId), distance, parent, parentEdge);
    }

    public <ID> AllPaths<ID> shortestPathHopDistReverse(PgxGraph graph, ID srcId) throws ExecutionException, InterruptedException {
        return this.shortestPathHopDistReverse(graph, (ID)graph.getVertex(srcId));
    }

    public <ID> AllPaths<ID> shortestPathHopDistReverse(PgxGraph graph, ID srcId, VertexProperty<ID, Double> distance, VertexProperty<ID, PgxVertex<ID>> parent, VertexProperty<ID, PgxEdge> parentEdge) throws ExecutionException, InterruptedException {
        return this.shortestPathHopDistReverse(graph, (ID)graph.getVertex(srcId), distance, parent, parentEdge);
    }

    public <ID> VertexProperty<ID, Double> personalizedSalsa(BipartiteGraph graph, ID v, BigDecimal d, int maxIterations, BigDecimal maxDiff) throws ExecutionException, InterruptedException {
        return this.personalizedSalsa(graph, graph.getVertex(v), d.doubleValue(), maxIterations, maxDiff.doubleValue());
    }

    public <ID> VertexProperty<ID, Double> personalizedSalsa(BipartiteGraph graph, ID v, BigDecimal d, int maxIterations, BigDecimal maxDiff, VertexProperty<ID, Double> salsaRank) throws ExecutionException, InterruptedException {
        return this.personalizedSalsa(graph, graph.getVertex(v), d.doubleValue(), maxIterations, maxDiff.doubleValue(), salsaRank);
    }

    public EdgeProperty<Boolean> prim(PgxGraph graph, EdgeProperty<Double> weight, String mstName) throws ExecutionException, InterruptedException {
        return this.primAsync(graph, weight, mstName).get();
    }

    public <ID> Pair<VertexProperty<ID, Integer>, VertexProperty<ID, PgxVertex<ID>>> filteredBfs(PgxGraph graph, ID root) throws ExecutionException, InterruptedException {
        return this.filteredBfsAsync(graph, graph.getVertex(root)).get();
    }

    public <ID> Pair<VertexProperty<ID, Integer>, VertexProperty<ID, PgxVertex<ID>>> filteredBfs(PgxGraph graph, ID root, int maxDepth) throws ExecutionException, InterruptedException {
        return this.filteredBfsAsync(graph, graph.getVertex(root), maxDepth).get();
    }

    public <ID> Pair<VertexProperty<ID, Integer>, VertexProperty<ID, PgxVertex<ID>>> filteredDfs(PgxGraph graph, ID root) throws ExecutionException, InterruptedException {
        return this.filteredDfsAsync(graph, graph.getVertex(root)).get();
    }

    public <ID> Pair<VertexProperty<ID, Integer>, VertexProperty<ID, PgxVertex<ID>>> filteredDfs(PgxGraph graph, ID root, int maxDepth) throws ExecutionException, InterruptedException {
        return this.filteredDfsAsync(graph, graph.getVertex(root), maxDepth).get();
    }

    private static final class ShortestPathArgs<ID> {
        VertexProperty<ID, PgxVertex<ID>> parent = null;
        VertexProperty<ID, PgxEdge> parentEdge = null;
        VertexProperty<ID, Double> dist = null;

        private ShortestPathArgs() {
        }
    }
}

