/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.internal;

import java.io.PrintStream;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import oracle.pgql.lang.PgqlException;
import oracle.pgql.lang.ResultSet;
import oracle.pgql.lang.ResultSetFormatter;
import oracle.pgql.lang.ResultSetMetaData;
import oracle.pgql.lang.spatial.Point2D;
import oracle.pgx.api.PgqlResultElement;
import oracle.pgx.api.PgqlResultSet;
import oracle.pgx.api.PgxEdge;
import oracle.pgx.api.PgxFuture;
import oracle.pgx.api.PgxGraph;
import oracle.pgx.api.PgxResult;
import oracle.pgx.api.PgxSession;
import oracle.pgx.api.PgxVertex;
import oracle.pgx.api.ResultImpl;
import oracle.pgx.api.frames.PgxFrame;
import oracle.pgx.api.frames.internal.PgxFrameImpl;
import oracle.pgx.api.internal.ApiObject;
import oracle.pgx.api.internal.Core;
import oracle.pgx.api.internal.FrameMetaData;
import oracle.pgx.api.internal.PgqlResultSetProxy;
import oracle.pgx.common.util.ErrorMessages;

public class PgqlResultSetImpl
extends ApiObject
implements PgqlResultSet {
    private static final String NULL_STRING = "<null>";
    private static final long DEFAULT_PRINT_LIMIT = 1000L;
    private final Core core;
    private final PgxSession session;
    protected final Supplier<String> keystorePathSupplier;
    protected final Supplier<char[]> keystorePasswordSupplier;
    private final PgxGraph graph;
    private final PgqlResultSetProxy proxy;
    private final List<? extends PgqlResultElement> resultElements;
    private boolean closed;
    private long cursor = 0L;
    private ResultImpl row = null;

    public PgqlResultSetImpl(Core core, PgxGraph graph, Supplier<String> keystorePathSupplier, Supplier<char[]> keystorePasswordSupplier, PgqlResultSetProxy proxy) {
        this(core, graph.getSession(), graph, keystorePathSupplier, keystorePasswordSupplier, proxy);
    }

    public PgqlResultSetImpl(Core core, PgxSession session, PgxGraph graph, Supplier<String> keystorePathSupplier, Supplier<char[]> keystorePasswordSupplier, PgqlResultSetProxy proxy) {
        this.core = core;
        this.session = session;
        this.graph = graph;
        this.keystorePasswordSupplier = keystorePasswordSupplier;
        this.keystorePathSupplier = keystorePathSupplier;
        this.proxy = proxy;
        this.resultElements = proxy.getResultElements();
    }

    @Override
    public String getId() {
        return this.proxy.getId();
    }

    @Override
    public PgxGraph getGraph() {
        return this.graph;
    }

    @Override
    public List<? extends PgqlResultElement> getPgqlResultElements() {
        return this.proxy.getResultElements();
    }

    public ResultSetMetaData getMetaData() {
        return this.proxy;
    }

    @Override
    public long getNumResults() {
        return this.proxy.getNumResults();
    }

    public String toString() {
        return this.toString(PgqlResultSetImpl.entry("graph", this.getGraphName()), PgqlResultSetImpl.entry("numResults", this.getNumResults()));
    }

    private String getGraphName() {
        return this.graph == null ? NULL_STRING : this.graph.getName();
    }

    @Override
    public PgqlResultSet print(PrintStream printStream, long numResults, int from) {
        try {
            ResultSetFormatter.out((ResultSet)this, (PrintStream)printStream, (long)numResults, (int)from);
        }
        catch (PgqlException ex) {
            throw new RuntimeException(ex.getMessage());
        }
        return this;
    }

    @Override
    public PgqlResultSet print() {
        try {
            ResultSetFormatter.out((ResultSet)this);
        }
        catch (PgqlException ex) {
            throw new RuntimeException(ex.getMessage());
        }
        return this;
    }

    @Override
    public PgxFuture<PgxFrame> toFrameAsync() {
        return this.core.createFrameFromPgqlResult(this.session.getSessionContext(), this.proxy.getId()).thenApply(frameMetaData -> new PgxFrameImpl(this.session, this.core, (FrameMetaData)((Object)frameMetaData), this.keystorePathSupplier, this.keystorePasswordSupplier));
    }

    @Override
    public void close() {
        this.closed = true;
        this.core.destroyPgqlResultSet(this.session.getSessionContext(), this.proxy.getId()).join();
    }

    private void checkNotClosed() {
        if (this.closed) {
            throw new IllegalStateException(ErrorMessages.getMessage((String)"PGQL_RESULTSET_CLOSED", (Object[])new Object[0]));
        }
    }

    private void checkNotClosedPgqlException() throws PgqlException {
        if (this.closed) {
            throw new PgqlException(ErrorMessages.getMessage((String)"PGQL_RESULTSET_CLOSED", (Object[])new Object[0]));
        }
    }

    private void validityCheck(int columnNumber) throws PgqlException {
        this.checkNotClosedPgqlException();
        if (this.row == null) {
            throw new PgqlException(ErrorMessages.getMessage((String)"INVALID_ROW", (Object[])new Object[0]));
        }
        if (columnNumber < 1 || columnNumber > this.getPgqlResultElements().size()) {
            throw new PgqlException(ErrorMessages.getMessage((String)"INVALID_COLUMN", (Object[])new Object[]{columnNumber, this.getPgqlResultElements().size()}));
        }
    }

    private int getColumnNumber(String elementName) throws PgqlException {
        return PgqlResultSetImpl.getColumnNumber(elementName, this.resultElements);
    }

    public static int getColumnNumber(String elementName, List<? extends PgqlResultElement> resultElements) throws PgqlException {
        Integer exactMatch = PgqlResultSetImpl.getColumnNumber(resultElements, (String columnName) -> columnName.equals(elementName));
        if (exactMatch != null) {
            return exactMatch;
        }
        Integer caseInsensitiveMatch = PgqlResultSetImpl.getColumnNumber(resultElements, (String columnName) -> columnName.equalsIgnoreCase(elementName));
        if (caseInsensitiveMatch != null) {
            return caseInsensitiveMatch;
        }
        throw new PgqlException(ErrorMessages.getMessage((String)"COLUMN_NAME_DOES_NOT_EXIST", (Object[])new Object[]{elementName}));
    }

    private static Integer getColumnNumber(List<? extends PgqlResultElement> resultElements, Predicate<String> columnMatches) {
        for (int i = 0; i < resultElements.size(); ++i) {
            if (!columnMatches.test(resultElements.get(i).getVarName())) continue;
            return i + 1;
        }
        return null;
    }

    private boolean updateCursor(long cursor) throws PgqlException {
        this.checkNotClosedPgqlException();
        if (cursor < 1L) {
            this.cursor = 0L;
            this.row = null;
            return false;
        }
        if (cursor > this.getNumResults()) {
            this.cursor = this.getNumResults() + 1L;
            this.row = null;
            return false;
        }
        this.cursor = cursor;
        List<Object> rawResults = this.proxy.getResultRow(cursor);
        this.row = new ResultImpl(this, rawResults);
        return true;
    }

    public void beforeFirst() throws PgqlException {
        this.updateCursor(0L);
    }

    public void afterLast() throws PgqlException {
        this.updateCursor(this.getNumResults() + 1L);
    }

    public boolean first() throws PgqlException {
        return this.updateCursor(1L);
    }

    public boolean last() throws PgqlException {
        return this.updateCursor(this.getNumResults());
    }

    public boolean absolute(long row) throws PgqlException {
        if (row < 0L) {
            return this.updateCursor(this.getNumResults() + 1L + row);
        }
        return this.updateCursor(row);
    }

    public boolean relative(long rows) throws PgqlException {
        return this.updateCursor(this.cursor + rows);
    }

    public boolean next() throws PgqlException {
        return this.updateCursor(this.cursor + 1L);
    }

    public boolean previous() throws PgqlException {
        return this.updateCursor(this.cursor - 1L);
    }

    public Iterator<PgxResult> iterator() {
        return new PgxResultIterator(this.proxy.getResults().iterator());
    }

    public Object getObject(int elementIdx) throws PgqlException {
        this.validityCheck(elementIdx);
        return this.row.getObject(elementIdx);
    }

    public Object getObject(String elementName) throws PgqlException {
        return this.getObject(this.getColumnNumber(elementName));
    }

    public String getString(int elementIdx) throws PgqlException {
        this.validityCheck(elementIdx);
        return this.row.getString(elementIdx);
    }

    public String getString(String elementName) throws PgqlException {
        return this.getString(this.getColumnNumber(elementName));
    }

    public Integer getInteger(int elementIdx) throws PgqlException {
        this.validityCheck(elementIdx);
        return this.row.getInteger(elementIdx);
    }

    public Integer getInteger(String elementName) throws PgqlException {
        return this.getInteger(this.getColumnNumber(elementName));
    }

    public Long getLong(int elementIdx) throws PgqlException {
        this.validityCheck(elementIdx);
        return this.row.getLong(elementIdx);
    }

    public Long getLong(String elementName) throws PgqlException {
        return this.getLong(this.getColumnNumber(elementName));
    }

    public Float getFloat(int elementIdx) throws PgqlException {
        this.validityCheck(elementIdx);
        return this.row.getFloat(elementIdx);
    }

    public Float getFloat(String elementName) throws PgqlException {
        return this.getFloat(this.getColumnNumber(elementName));
    }

    public Double getDouble(int elementIdx) throws PgqlException {
        this.validityCheck(elementIdx);
        return this.row.getDouble(elementIdx);
    }

    public Double getDouble(String elementName) throws PgqlException {
        return this.getDouble(this.getColumnNumber(elementName));
    }

    public Boolean getBoolean(int elementIdx) throws PgqlException {
        this.validityCheck(elementIdx);
        return this.row.getBoolean(elementIdx);
    }

    public Boolean getBoolean(String elementName) throws PgqlException {
        return this.getBoolean(this.getColumnNumber(elementName));
    }

    public Set<String> getVertexLabels(int elementIdx) throws PgqlException {
        this.validityCheck(elementIdx);
        return this.row.getVertexLabels(elementIdx);
    }

    public Set<String> getVertexLabels(String elementName) throws PgqlException {
        return this.getVertexLabels(this.getColumnNumber(elementName));
    }

    public LocalDate getDate(int elementIdx) throws PgqlException {
        this.validityCheck(elementIdx);
        return this.row.getDate(elementIdx);
    }

    public LocalDate getDate(String elementName) throws PgqlException {
        return this.getDate(this.getColumnNumber(elementName));
    }

    public LocalTime getTime(int elementIdx) throws PgqlException {
        this.validityCheck(elementIdx);
        return this.row.getTime(elementIdx);
    }

    public LocalTime getTime(String elementName) throws PgqlException {
        return this.getTime(this.getColumnNumber(elementName));
    }

    public LocalDateTime getTimestamp(int elementIdx) throws PgqlException {
        this.validityCheck(elementIdx);
        return this.row.getTimestamp(elementIdx);
    }

    public LocalDateTime getTimestamp(String elementName) throws PgqlException {
        return this.getTimestamp(this.getColumnNumber(elementName));
    }

    public OffsetTime getTimeWithTimezone(int elementIdx) throws PgqlException {
        this.validityCheck(elementIdx);
        return this.row.getTimeWithTimezone(elementIdx);
    }

    public OffsetTime getTimeWithTimezone(String elementName) throws PgqlException {
        return this.getTimeWithTimezone(this.getColumnNumber(elementName));
    }

    public OffsetDateTime getTimestampWithTimezone(int elementIdx) throws PgqlException {
        this.validityCheck(elementIdx);
        return this.row.getTimestampWithTimezone(elementIdx);
    }

    public OffsetDateTime getTimestampWithTimezone(String elementName) throws PgqlException {
        return this.getTimestampWithTimezone(this.getColumnNumber(elementName));
    }

    public Date getLegacyDate(int elementIdx) throws PgqlException {
        this.validityCheck(elementIdx);
        return this.row.getLegacyDate(elementIdx);
    }

    public Date getLegacyDate(String elementName) throws PgqlException {
        return this.getLegacyDate(this.getColumnNumber(elementName));
    }

    public <T> List<T> getList(int elementIdx) throws PgqlException {
        return this.row.getList(elementIdx);
    }

    public <T> List<T> getList(String elementName) throws PgqlException {
        return this.getList(this.getColumnNumber(elementName));
    }

    public Point2D getPoint2D(int elementIdx) throws PgqlException {
        this.validityCheck(elementIdx);
        return this.row.getPoint2D(elementIdx);
    }

    public Point2D getPoint2D(String elementName) throws PgqlException {
        return this.getPoint2D(this.getColumnNumber(elementName));
    }

    @Override
    public PgxEdge getEdge(int elementIdx) throws PgqlException {
        this.validityCheck(elementIdx);
        return this.row.getEdge(elementIdx);
    }

    @Override
    public PgxEdge getEdge(String elementName) throws PgqlException {
        return this.getEdge(this.getColumnNumber(elementName));
    }

    @Override
    public <ID extends Comparable<ID>> PgxVertex<ID> getVertex(int elementIdx) throws PgqlException {
        this.validityCheck(elementIdx);
        return this.row.getVertex(elementIdx);
    }

    @Override
    public <ID extends Comparable<ID>> PgxVertex<ID> getVertex(String elementName) throws PgqlException {
        return this.getVertex(this.getColumnNumber(elementName));
    }

    private class PgxResultIterator
    implements Iterator<PgxResult> {
        private final Iterator<List<Object>> proxyIterator;

        public PgxResultIterator(Iterator<List<Object>> proxyIterator) {
            this.proxyIterator = proxyIterator;
        }

        @Override
        public boolean hasNext() {
            PgqlResultSetImpl.this.checkNotClosed();
            return this.proxyIterator.hasNext();
        }

        @Override
        public PgxResult next() {
            List<Object> rawResult = this.proxyIterator.next();
            return new ResultImpl(PgqlResultSetImpl.this, rawResult);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

