/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.ExecutionException;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import oracle.pgx.api.EdgeSequence;
import oracle.pgx.api.EdgeSet;
import oracle.pgx.api.PgxEntity;
import oracle.pgx.api.PgxFuture;
import oracle.pgx.api.PgxGraph;
import oracle.pgx.api.PgxManagedObject;
import oracle.pgx.api.PgxSession;
import oracle.pgx.api.SessionContext;
import oracle.pgx.api.VertexSequence;
import oracle.pgx.api.VertexSet;
import oracle.pgx.api.internal.CollectionProxy;
import oracle.pgx.api.internal.Core;
import oracle.pgx.common.IdentifiableCollection;
import oracle.pgx.common.IllegalEnumConstantException;
import oracle.pgx.common.PgxId;
import oracle.pgx.common.types.CollectionType;
import oracle.pgx.common.types.EntityType;
import oracle.pgx.common.types.IdType;
import oracle.pgx.common.types.PropertyType;

public abstract class PgxCollection<E, ID>
extends PgxManagedObject
implements Iterable<E>,
IdentifiableCollection {
    protected final Core core;
    private final PgxSession session;
    private final String collectionName;
    private final PgxId collectionId;
    private final CollectionType type;
    private final PropertyType contentType;
    private final PgxGraph graph;

    PgxCollection(PgxGraph graph, PgxId collectionId, String collectionName, CollectionType type, EntityType elementType) {
        this.graph = graph;
        this.core = this.graph.getSession().getCore();
        this.session = this.graph.getSession();
        this.collectionId = collectionId;
        this.collectionName = collectionName;
        this.type = type;
        this.contentType = elementType.toPropertyType();
    }

    PgxCollection(PgxSession session, PgxId collectionId, String collectionName, CollectionType type, PropertyType contentType) {
        this.session = session;
        this.core = session.getCore();
        this.graph = null;
        this.collectionId = collectionId;
        this.collectionName = collectionName;
        this.type = type;
        this.contentType = contentType;
    }

    protected PgxSession getSession() {
        return this.session;
    }

    protected String getSessionId() {
        return this.session.getId();
    }

    protected SessionContext getSessionContext() {
        return this.session.getSessionContext();
    }

    public PgxId getId() {
        return this.collectionId;
    }

    @Override
    public String getName() {
        return this.collectionName;
    }

    public PgxGraph getGraph() {
        return this.graph;
    }

    @Override
    public PgxFuture<Void> destroyAsync() {
        return this.core.destroyCollection(this.getSessionContext(), this.getId());
    }

    public CollectionType getCollectionType() {
        return this.type;
    }

    public PropertyType getContentType() {
        return this.contentType;
    }

    public Stream<E> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    public PgxFuture<Void> addAllAsync(E[] elements) {
        return this.addAllElementsAsync(Arrays.asList(elements));
    }

    public abstract PgxFuture<Void> addAllElementsAsync(Collection<E> var1);

    public abstract PgxFuture<Void> removeAllElementsAsync(Collection<E> var1);

    public PgxFuture<Void> clearAsync() {
        return this.core.clearCollection(this.getSessionContext(), this.getId()).thenReturn(null);
    }

    public PgxFuture<PgxCollection<E, ID>> cloneAsync() {
        return this.cloneAsync(null);
    }

    public PgxFuture<PgxCollection<E, ID>> cloneAsync(String newName) {
        return this.core.cloneCollection(this.getSessionContext(), this.getId(), newName).thenApply(collectionInfo -> this.createCollection(collectionInfo.getCollectionId(), collectionInfo.getName()));
    }

    public PgxFuture<PgxCollection<E, ID>> toMutableAsync() {
        return this.toMutableAsync(null);
    }

    public PgxFuture<PgxCollection<E, ID>> toMutableAsync(String newName) {
        return this.core.toMutableCollection(this.getSessionContext(), this.getId(), newName).thenApply(collectionInfo -> this.createCollection(collectionInfo.getCollectionId(), collectionInfo.getName()));
    }

    public PgxFuture<Boolean> isMutableAsync() {
        return this.core.isCollectionMutable(this.getSessionContext(), this.getId());
    }

    protected abstract PgxCollection<E, ID> createCollection(PgxId var1, String var2);

    public String toString() {
        return this.toString(PgxCollection.entry("name", this.getName()), PgxCollection.entry("graph", this.getGraph().getName()));
    }

    public abstract IdType getIdType();

    public PgxFuture<Integer> sizeAsync() {
        return this.getProxyAsync().thenApply(CollectionProxy::size);
    }

    public PgxFuture<Iterator<E>> iteratorAsync() {
        return this.getProxyAsync().thenApply(this::newProxyIterator);
    }

    protected abstract AbstractProxyIterator<E> newProxyIterator(CollectionProxy var1);

    protected PgxFuture<CollectionProxy> getProxyAsync() {
        return this.core.getCollectionProxy(this.getSessionContext(), this.getId());
    }

    protected CollectionProxy getProxy() {
        return this.getProxyAsync().join();
    }

    public void add(E entity) {
        this.addAllElements(Collections.singletonList(entity));
    }

    public void remove(E entity) {
        this.removeAllElements(Collections.singletonList(entity));
    }

    public abstract PgxFuture<Boolean> containsAsync(E var1);

    public int size() {
        return this.sizeAsync().join();
    }

    @Override
    public Iterator<E> iterator() {
        return this.iteratorAsync().join();
    }

    public abstract void addAll(PgxEntity[] var1);

    public void addAllElements(Collection<E> source) {
        this.addAllElementsAsync(source).join();
    }

    public void removeAllElements(Collection<E> source) {
        this.removeAllElementsAsync(source).join();
    }

    public void clear() {
        this.clearAsync().join();
    }

    public PgxCollection<E, ID> toMutable() throws ExecutionException, InterruptedException {
        return this.toMutableAsync().get();
    }

    public PgxCollection<E, ID> toMutable(String newName) throws ExecutionException, InterruptedException {
        return this.toMutableAsync(newName).get();
    }

    public boolean isMutable() throws ExecutionException, InterruptedException {
        return this.isMutableAsync().join();
    }

    public PgxCollection<E, ID> clone() {
        return this.cloneAsync().join();
    }

    public PgxCollection<E, ID> clone(String newName) throws InterruptedException, ExecutionException {
        return this.cloneAsync(newName).get();
    }

    public boolean contains(E element) {
        return this.containsAsync(element).join();
    }

    static <E extends PgxEntity<ID>, ID> PgxCollection<E, ID> createFromNameAndTypes(PgxGraph graph, PgxId collectionId, String collectionName, EntityType entityType, CollectionType collectionType) {
        switch (entityType) {
            case VERTEX: {
                switch (collectionType) {
                    case SEQUENCE: {
                        return new VertexSequence(graph, collectionId, collectionName);
                    }
                    case SET: {
                        return new VertexSet(graph, collectionId, collectionName);
                    }
                }
                throw new IllegalStateException();
            }
            case EDGE: {
                switch (collectionType) {
                    case SEQUENCE: {
                        return new EdgeSequence(graph, collectionId, collectionName);
                    }
                    case SET: {
                        return new EdgeSet(graph, collectionId, collectionName);
                    }
                }
                throw new IllegalStateException();
            }
        }
        throw new IllegalEnumConstantException((Enum)entityType);
    }

    protected static abstract class AbstractProxyIterator<E>
    implements Iterator<E> {
        protected final Iterator<Object> wrapped;

        AbstractProxyIterator(CollectionProxy proxy) {
            this.wrapped = proxy.iterator();
        }
    }
}

