/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.annotations.VisibleForTesting;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import oracle.pgx.api.EdgeProviderMetaData;
import oracle.pgx.api.EntityProviderMetaData;
import oracle.pgx.api.GraphChangeSet;
import oracle.pgx.api.GraphDelta;
import oracle.pgx.api.PgxGraph;
import oracle.pgx.api.PropertyMetaData;
import oracle.pgx.api.Synchronizer;
import oracle.pgx.api.SynchronizerConnectionHandler;
import oracle.pgx.api.internal.synchronizer.FetcherUtils;
import oracle.pgx.api.internal.synchronizer.FlashbackConfig;
import oracle.pgx.api.internal.synchronizer.FlashbackQueryFactory;
import oracle.pgx.api.internal.synchronizer.FlashbackScnData;
import oracle.pgx.api.internal.synchronizer.GraphDeltaImpl;
import oracle.pgx.api.internal.synchronizer.PartitionedDataSourceVersion;
import oracle.pgx.api.internal.synchronizer.ResultSetToChangeSetHandler;
import oracle.pgx.common.types.IdStrategy;
import oracle.pgx.common.types.IdType;
import oracle.pgx.common.types.PropertyType;
import oracle.pgx.common.util.DbUtils;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.common.util.JsonUtil;
import oracle.pgx.config.EntityProviderConfig;
import oracle.pgx.config.GraphConfig;
import oracle.pgx.config.GraphPropertyConfig;
import oracle.pgx.config.IdGenerationStrategy;
import oracle.pgx.config.OnInvalidChange;
import oracle.pgx.config.PartitionedGraphConfig;
import oracle.pgx.config.RdbmsEntityProviderConfig;
import oracle.pgx.config.RdbmsEntityProviderConfigBuilder;
import oracle.pgx.config.SnapshotsSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlashbackSynchronizer
implements Synchronizer {
    private final PgxGraph graph;
    private final OnInvalidChange policy;
    private final PartitionedGraphConfig config;
    private final Connection oracleConn;
    private final List<EntityProviderConfig> vertexProviders;
    private final List<EntityProviderConfig> edgeProviders;
    private final FlashbackScnData scnData;
    private GraphChangeSet changeSet;
    private ResultSetToChangeSetHandler changeSetHandler;
    private GraphDelta graphDelta;
    private String schema;
    private String username;
    private static final Logger LOG = LoggerFactory.getLogger(FlashbackSynchronizer.class);

    FlashbackSynchronizer(PgxGraph graph) {
        this(graph, OnInvalidChange.ERROR);
    }

    FlashbackSynchronizer(PgxGraph graph, OnInvalidChange invalidChangePolicy) {
        this(graph, invalidChangePolicy, (GraphConfig)((PartitionedGraphConfig)graph.getConfig()));
    }

    FlashbackSynchronizer(PgxGraph graph, OnInvalidChange invalidChangePolicy, GraphConfig graphConfig) {
        this(graph, invalidChangePolicy, graphConfig, null);
    }

    FlashbackSynchronizer(PgxGraph graph, OnInvalidChange invalidChangePolicy, Connection oracleConn) {
        this(graph, invalidChangePolicy, (GraphConfig)((PartitionedGraphConfig)graph.getConfig()), oracleConn);
    }

    FlashbackSynchronizer(PgxGraph graph, OnInvalidChange errorPolicy, GraphConfig graphConfig, Connection oracleConn) {
        FlashbackSynchronizer.validateParameters(graph, graphConfig, oracleConn);
        this.graph = graph;
        this.policy = errorPolicy;
        this.config = (PartitionedGraphConfig)graphConfig;
        this.oracleConn = this.extractConnection(graph, this.config, oracleConn);
        this.validateOracleConnection(this.oracleConn);
        this.vertexProviders = this.extractVertexProviderConfigs(graph, this.config);
        this.edgeProviders = this.extractEdgeProviderConfigs(graph, this.config);
        this.changeSet = graph.createChangeSet(IdGenerationStrategy.USER_IDS, IdGenerationStrategy.USER_IDS);
        this.changeSet.setInvalidChangePolicy(errorPolicy);
        this.scnData = FlashbackScnData.getSynchronizerScnData(graph.getDataSourceVersion());
        this.changeSetHandler = new ResultSetToChangeSetHandler(this.changeSet, this.graph);
    }

    private Connection extractConnection(PgxGraph graph, PartitionedGraphConfig config, Connection oracleConn) {
        if (oracleConn != null) {
            return oracleConn;
        }
        SynchronizerConnectionHandler connHandler = new SynchronizerConnectionHandler(graph);
        if (SynchronizerConnectionHandler.graphConfigContainsConnectionProperties(config)) {
            return connHandler.getConnection(config);
        }
        return connHandler.getConnection((PartitionedGraphConfig)graph.getConfig());
    }

    private List<EntityProviderConfig> extractVertexProviderConfigs(PgxGraph graph, PartitionedGraphConfig config) {
        if (config != null) {
            return config.getVertexProviders();
        }
        return this.convertMetadataIntoProviderConfig(graph.getMetaData().getVertexProvidersMetaData());
    }

    private List<EntityProviderConfig> extractEdgeProviderConfigs(PgxGraph graph, PartitionedGraphConfig config) {
        if (config != null) {
            return config.getEdgeProviders();
        }
        return this.convertMetadataIntoProviderConfig(graph.getMetaData().getEdgeProvidersMetaData());
    }

    private List<EntityProviderConfig> convertMetadataIntoProviderConfig(Map<String, ? extends EntityProviderMetaData> metadata) {
        HashMap<String, IdType> providerKeyTypes = new HashMap<String, IdType>();
        for (EntityProviderMetaData entityProviderMetaData : metadata.values()) {
            providerKeyTypes.put(entityProviderMetaData.getName(), entityProviderMetaData.getIdType());
        }
        ArrayList<EntityProviderConfig> configList = new ArrayList<EntityProviderConfig>();
        for (EntityProviderMetaData entityProviderMetaData : metadata.values()) {
            configList.add(this.convertMetadataIntoProviderConfig(entityProviderMetaData, providerKeyTypes));
        }
        return configList;
    }

    private EntityProviderConfig convertMetadataIntoProviderConfig(EntityProviderMetaData providerMetadata, Map<String, IdType> providerKeyTypes) {
        RdbmsEntityProviderConfigBuilder builder = new RdbmsEntityProviderConfigBuilder();
        ((RdbmsEntityProviderConfigBuilder)((RdbmsEntityProviderConfigBuilder)builder.setName(providerMetadata.getName())).setDatabaseTableName(providerMetadata.getName()).setKeyType(providerMetadata.getIdType())).setUsername(this.username).setSchema(this.schema);
        if (providerMetadata instanceof EdgeProviderMetaData) {
            String sourceProviderName = ((EdgeProviderMetaData)providerMetadata).getSourceVertexProviderName();
            String destinationProviderName = ((EdgeProviderMetaData)providerMetadata).getDestinationVertexProviderName();
            ((RdbmsEntityProviderConfigBuilder)builder.setSourceVertexProvider(sourceProviderName)).setDestinationVertexProvider(destinationProviderName);
            builder.setSourceVertexKeyType(providerKeyTypes.get(sourceProviderName));
            builder.setDestinationVertexKeyType(providerKeyTypes.get(destinationProviderName));
        }
        for (PropertyMetaData propMetaData : providerMetadata.getProperties()) {
            builder.addVectorProperty(propMetaData.getName(), propMetaData.getPropertyType(), propMetaData.getDimension());
        }
        return builder.build();
    }

    @Override
    public void fetch() throws SQLException {
        try {
            Long currentScn = DbUtils.getCurrentScn((Connection)this.oracleConn);
            LOG.debug("Current SCN {}", (Object)currentScn);
            FetcherUtils utils = new FetcherUtils(currentScn);
            this.graphDelta = new GraphDeltaImpl(this.fetchAddedVertices(utils), this.fetchAddedEdges(utils), this.fetchUpdatedVertices(utils), this.fetchUpdatedEdges(utils), this.fetchRemovedEdges(utils), this.fetchRemovedVertices(utils));
            this.scnData.updateLastFetchedScnMaps(currentScn);
        }
        catch (SQLException ex) {
            if (this.oracleConn.isClosed()) {
                throw new IllegalArgumentException(ErrorMessages.getMessage((String)"DATABASE_CONNECTION_CLOSED", (Object[])new Object[0]), ex);
            }
            this.oracleConn.close();
            throw ex;
        }
    }

    long fetchAddedEdges(FetcherUtils utils) throws SQLException {
        return this.fetchEdgeChanges(utils, FlashbackQueryFactory::selectAddedEdges, this.changeSetHandler::addEdgesToChangeSet, "added");
    }

    long fetchUpdatedEdges(FetcherUtils utils) throws SQLException {
        return this.fetchEdgeChanges(utils, FlashbackQueryFactory::selectEdgeChanges, this.changeSetHandler::updateEdgesToChangeSet, "updated");
    }

    long fetchRemovedEdges(FetcherUtils utils) throws SQLException {
        return this.fetchEdgeChanges(utils, FlashbackQueryFactory::selectRemovedEdges, this.changeSetHandler::removeEdgesFromChangeSet, "removed");
    }

    long fetchEdgeChanges(FetcherUtils utils, Function<FlashbackConfig, String> queryCreator, ResultSetToChangeSetHandler.ResultSetToChangeSet resultSetToChangeSet, String actionMsg) throws SQLException {
        long changes = 0L;
        for (EntityProviderConfig provider : this.edgeProviders) {
            LOG.debug("Fetching " + actionMsg + " edges for: {}", (Object)provider.getName());
            RdbmsEntityProviderConfig rdbmsProvider = (RdbmsEntityProviderConfig)provider;
            long providerScn = this.scnData.getLastFetchedScnForEdgeProvider(provider.getName());
            FlashbackConfig fbConfig = utils.createFlashbackConfig(this.graph, (EntityProviderConfig)rdbmsProvider, providerScn);
            String query = queryCreator.apply(fbConfig);
            try {
                Statement statement = this.oracleConn.createStatement();
                Throwable throwable = null;
                try {
                    changes += ResultSetToChangeSetHandler.fetchAndAddToChangeSet(statement, query, resultSetToChangeSet, rdbmsProvider);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (statement == null) continue;
                    if (throwable != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    statement.close();
                }
            }
            catch (SQLException ex) {
                FetcherUtils.rethrowSqlException(ex, rdbmsProvider.getDatabaseTableName());
            }
        }
        return changes;
    }

    long fetchAddedVertices(FetcherUtils utils) throws SQLException {
        return this.fetchVertexChanges(utils, FlashbackQueryFactory::selectAddedVertices, this.changeSetHandler::addVerticesToChangeSet, "added");
    }

    long fetchUpdatedVertices(FetcherUtils utils) throws SQLException {
        return this.fetchVertexChanges(utils, FlashbackQueryFactory::selectVertexChanges, this.changeSetHandler::updateVerticesToChangeSet, "updated");
    }

    long fetchRemovedVertices(FetcherUtils utils) throws SQLException {
        return this.fetchVertexChanges(utils, FlashbackQueryFactory::selectRemovedVertices, this.changeSetHandler::removeVerticesFromChangeSet, "removed");
    }

    long fetchVertexChanges(FetcherUtils utils, Function<FlashbackConfig, String> queryCreator, ResultSetToChangeSetHandler.ResultSetToChangeSet resultSetToChangeSet, String actionMsg) throws SQLException {
        long changes = 0L;
        for (EntityProviderConfig provider : this.vertexProviders) {
            LOG.debug("Fetching " + actionMsg + " vertices for: {}", (Object)provider.getName());
            RdbmsEntityProviderConfig rdbmsProvider = (RdbmsEntityProviderConfig)provider;
            long providerScn = this.scnData.getLastFetchedScnForVertexProvider(provider.getName());
            FlashbackConfig fbConfig = utils.createFlashbackConfig(this.graph, (EntityProviderConfig)rdbmsProvider, providerScn);
            String query = queryCreator.apply(fbConfig);
            try {
                Statement statement = this.oracleConn.createStatement();
                Throwable throwable = null;
                try {
                    changes += ResultSetToChangeSetHandler.fetchAndAddToChangeSet(statement, query, resultSetToChangeSet, rdbmsProvider);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (statement == null) continue;
                    if (throwable != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    statement.close();
                }
            }
            catch (SQLException ex) {
                FetcherUtils.rethrowSqlException(ex, rdbmsProvider.getDatabaseTableName());
            }
        }
        return changes;
    }

    @Override
    public PgxGraph apply() {
        try {
            PartitionedDataSourceVersion dataSourceVersion = new PartitionedDataSourceVersion(this.scnData.getLastFetchedScnMapVertices(), this.scnData.getLastFetchedScnMapEdges());
            this.changeSet.setDataSourceVersion(this.createLatestDataSourceVersionString(dataSourceVersion));
            PgxGraph newSnapshot = this.changeSet.buildNewSnapshot();
            newSnapshot.close();
            this.graph.getSession().setSnapshot(this.graph, -1L);
            this.changeSet = this.graph.createChangeSet(IdGenerationStrategy.USER_IDS, IdGenerationStrategy.USER_IDS);
            this.changeSet.setInvalidChangePolicy(this.policy);
            this.scnData.commitFetchedScn();
            this.changeSetHandler = new ResultSetToChangeSetHandler(this.changeSet, this.graph);
            return this.graph;
        }
        catch (JsonProcessingException e) {
            this.scnData.rollbackLastFetchedScnMaps();
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)ErrorMessages.getMessage((String)"CANNOT_CREATE_DATA_SOURCE_VERSION_STRING", (Object[])new Object[0]), (Object[])new Object[0]), e);
        }
        catch (Exception e) {
            this.scnData.rollbackLastFetchedScnMaps();
            throw new IllegalArgumentException(e);
        }
    }

    String createLatestDataSourceVersionString(PartitionedDataSourceVersion partitionedDataversion) throws JsonProcessingException {
        String dataSourceVersion = JsonUtil.toJson((Object)partitionedDataversion);
        LOG.debug("New datasourceVersion {}", (Object)dataSourceVersion);
        return dataSourceVersion;
    }

    @Override
    public GraphDelta getGraphDelta() {
        return this.graphDelta;
    }

    private static void validateParameters(PgxGraph graph, GraphConfig config, Connection oracleConn) {
        FlashbackSynchronizer.verifyConnectionDetails(graph, config, oracleConn);
        FlashbackSynchronizer.validatePartitionedGraph(graph, config);
        FlashbackSynchronizer.validateGraphParameters(config);
        FlashbackSynchronizer.validateProviders(((PartitionedGraphConfig)config).getVertexProviders(), graph.getVertexIdStrategy());
        FlashbackSynchronizer.validateProviders(((PartitionedGraphConfig)config).getEdgeProviders(), graph.getEdgeIdStrategy());
    }

    static void verifyConnectionDetails(PgxGraph graph, GraphConfig graphConfig, Connection oracleConn) {
        if (graphConfig == null && oracleConn == null) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"SYNC_RETRIEVE_CONNECTION_EXCEPTION", (Object[])new Object[]{graph.getName()}));
        }
    }

    static void validateProviders(List<EntityProviderConfig> providers, IdStrategy strategy) {
        List<PropertyType> forbiddenTypes = Arrays.asList(PropertyType.VERTEX, PropertyType.EDGE, PropertyType.RO_STRING_SET, PropertyType.POINT2D);
        for (EntityProviderConfig provider : providers) {
            FlashbackSynchronizer.validateProviderTypes(provider, forbiddenTypes);
            FlashbackSynchronizer.validateProviderLoading(provider, strategy);
        }
    }

    static void validateProviderTypes(EntityProviderConfig provider, List<PropertyType> forbiddenTypes) {
        List props = provider.getProps();
        for (GraphPropertyConfig prop : props) {
            if (!forbiddenTypes.contains(prop.getType())) continue;
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"FLASHBACK_TYPE_NOT_COMPATIBLE_EXCEPTION", (Object[])new Object[]{prop.getType()}));
        }
    }

    static void validateProviderLoading(EntityProviderConfig provider, IdStrategy strategy) {
        if (Boolean.FALSE.equals(provider.getLoading().isCreateKeyMapping()) && strategy != IdStrategy.PARTITIONED_IDS) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"SYNC_LOADING_PARAMS_EXCEPTION", (Object[])new Object[0]));
        }
    }

    static void validatePartitionedGraph(PgxGraph graph, GraphConfig config) {
        if (config == null) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"SYNC_RETRIEVE_GRAPH_CONFIG_EXCEPTION", (Object[])new Object[]{graph.getName()}));
        }
        if (graph.isHomogeneous() || !(config instanceof PartitionedGraphConfig)) {
            throw new UnsupportedOperationException(ErrorMessages.getMessage((String)"UNSUPPORTED_SYNCHRONIZATION_NON_PARTITIONED_GRAPH", (Object[])new Object[]{graph.getName()}));
        }
    }

    static void validateGraphParameters(GraphConfig config) {
        SnapshotsSource source = config.getLoading().getSnapshotsSource();
        if (source != SnapshotsSource.CHANGE_SET) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"SYNC_SNAPSHOT_SOURCE_EXCEPTION", (Object[])new Object[]{SnapshotsSource.CHANGE_SET, source}));
        }
    }

    void validateOracleConnection(Connection oracleConn) {
        if (oracleConn == null) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"NO_DB_CONNECTION_INFO", (Object[])new Object[0]));
        }
        try {
            if (oracleConn.isClosed()) {
                throw new IllegalArgumentException(ErrorMessages.getMessage((String)"DATABASE_CONNECTION_CLOSED", (Object[])new Object[0]));
            }
            this.schema = oracleConn.getSchema();
            if (oracleConn.getMetaData() != null) {
                this.username = oracleConn.getMetaData().getUserName();
            }
            if (this.username == null) {
                this.username = this.schema;
            }
        }
        catch (SQLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @VisibleForTesting
    GraphChangeSet getChangeSet() {
        return this.changeSet;
    }
}

