/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.pgql.pgview.translation.expression;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import oracle.pg.rdbms.pgql.PgqlUtils;
import oracle.pg.rdbms.pgql.pgview.translation.expression.TableExpression;

public class XmlTable
extends TableExpression {
    public static final String ROWNUM_COL = "\"ROWN_$\"";
    public static final String ALIAS_SUFFIX = "_xmltab";
    public static final String DUMMY_COL = "\"DUMMY_$\"";
    private final String baseAlias;
    private final String alias;
    private final List<Column> columns;
    private final boolean addRownum;
    private final boolean isReversed;

    public XmlTable(String baseAlias, List<Column> columns, boolean addRownum, boolean isReversed) {
        this.baseAlias = oracle.pgql.lang.ir.PgqlUtils.printIdentifier((String)baseAlias);
        this.alias = XmlTable.getTableAlias(baseAlias);
        this.columns = this.removeDuplicateColumns(columns);
        this.addRownum = addRownum;
        this.isReversed = isReversed;
    }

    @Override
    public String prettyPrint() {
        String columnsClause = this.getColumnsClause();
        String xmlTable = "xmltable('/EXP_PATH/EXPRESSIONS' passing xmltype(nvl(" + this.baseAlias + ".\"EXP_PATH\", '')) " + columnsClause + ")";
        if (this.addRownum) {
            boolean hasColumns;
            String selectColumns = this.columns.stream().map(column -> PgqlUtils.escapeAndEnquoteIdentifier(column.columnName)).collect(Collectors.joining(", "));
            boolean bl = hasColumns = this.columns.size() > 0;
            if (this.isReversed) {
                xmlTable = "(SELECT " + (hasColumns ? selectColumns : "1") + " FROM " + xmlTable + " ORDER BY ROWNUM desc)";
            }
            xmlTable = "lateral ( SELECT " + selectColumns + (hasColumns ? ", " : "") + "ROWNUM AS " + ROWNUM_COL + " FROM " + xmlTable + ")";
        }
        return xmlTable + " " + this.alias;
    }

    private List<Column> removeDuplicateColumns(List<Column> columns) {
        HashSet<String> columnNames = new HashSet<String>();
        ArrayList<Column> newColumns = new ArrayList<Column>();
        for (Column column : columns) {
            if (columnNames.contains(column.columnName)) continue;
            newColumns.add(column);
            columnNames.add(column.columnName);
        }
        return newColumns;
    }

    private String getColumnsClause() {
        return "columns " + (this.columns.size() > 0 ? this.columns.stream().map(Column::prettyPrint).collect(Collectors.joining(", ")) : "\"DUMMY_$\" VARCHAR2(1) path '/EXPRESSIONS'");
    }

    public static String getTableAlias(String baseAlias) {
        return oracle.pgql.lang.ir.PgqlUtils.printIdentifier((String)(baseAlias + ALIAS_SUFFIX));
    }

    public static class Column {
        final String columnName;
        final String type;
        final String path;

        public Column(String columnName, String type, String path) {
            this.columnName = PgqlUtils.escapeAndEnquoteIdentifier(columnName);
            this.type = type;
            this.path = path;
        }

        public String prettyPrint() {
            return this.columnName + " " + this.type + " path '" + this.path + "'";
        }
    }
}

