/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.pgql.pgview.metadata;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import oracle.pg.rdbms.pgql.pgview.metadata.Property;

public class Label {
    private final String label;
    private final Map<String, Property> properties;

    public Label(String label) {
        this.label = label;
        this.properties = new HashMap<String, Property>();
    }

    public String getLabel() {
        return this.label;
    }

    public Set<String> getProperties() {
        return this.properties.keySet();
    }

    public void addProperty(Property property) {
        this.properties.put(property.getName(), property);
    }

    public Property getProperty(String propertyName) {
        return this.properties.get(propertyName);
    }

    public boolean hasProperty(String propertyName) {
        return this.properties.containsKey(propertyName);
    }

    public String getColumnType(String columnName, boolean appendLength) {
        for (Property property : this.properties.values()) {
            if (!property.getColumn().getName().equals(columnName)) continue;
            return property.getColumn().getType(appendLength);
        }
        return null;
    }
}

