/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.pgql.pgview;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import oracle.pg.rdbms.pgql.DbmsUtils;
import oracle.pg.rdbms.pgql.PgqlConnection;
import oracle.pg.rdbms.pgql.PgqlCpgRdbmsExpander;
import oracle.pg.rdbms.pgql.PgqlToSqlException;
import oracle.pgql.lang.ddl.propertygraph.CreatePropertyGraph;
import oracle.pgql.lang.ddl.propertygraph.EdgeTable;
import oracle.pgql.lang.ddl.propertygraph.ElementTable;
import oracle.pgql.lang.ddl.propertygraph.Label;
import oracle.pgql.lang.ddl.propertygraph.Property;
import oracle.pgql.lang.ddl.propertygraph.VertexTable;
import oracle.pgql.lang.ir.QueryExpression;

public class PgViewDdlExecution {
    private static final String CREATE_TABLES_STR = "DECLARE\n  elem_table_tab   VARCHAR2(128) := SYS.DBMS_ASSERT.QUALIFIED_SQL_NAME(?);\n  elem_table_pk    VARCHAR2(128) := SYS.DBMS_ASSERT.ENQUOTE_NAME(?);\n  label_tab        VARCHAR2(128) := SYS.DBMS_ASSERT.QUALIFIED_SQL_NAME(?);\n  label_pk         VARCHAR2(128) := SYS.DBMS_ASSERT.ENQUOTE_NAME(?);\n  property_tab     VARCHAR2(128) := SYS.DBMS_ASSERT.QUALIFIED_SQL_NAME(?);\n  property_pk      VARCHAR2(128) := SYS.DBMS_ASSERT.ENQUOTE_NAME(?);\n  key_tab          VARCHAR2(128) := SYS.DBMS_ASSERT.QUALIFIED_SQL_NAME(?);\n  key_pk           VARCHAR2(128) := SYS.DBMS_ASSERT.ENQUOTE_NAME(?);\n  src_dst_key_tab  VARCHAR2(128) := SYS.DBMS_ASSERT.QUALIFIED_SQL_NAME(?);\n  src_dst_key_pk   VARCHAR2(128) := SYS.DBMS_ASSERT.ENQUOTE_NAME(?);\nBEGIN\n  execute immediate\n  'CREATE TABLE ' || elem_table_tab || ' (\n     ET_NAME      VARCHAR2(128),\n     ET_TYPE      VARCHAR2(6),\n     SCHEMA_NAME  VARCHAR2(128),\n     TABLE_NAME   VARCHAR2(128),\n     CONSTRAINT ' || elem_table_pk || ' PRIMARY KEY(ET_NAME, ET_TYPE)\n   )';\n  execute immediate\n  'CREATE TABLE ' || label_tab || ' (\n     LABEL_NAME  VARCHAR2(128),\n     ET_NAME     VARCHAR2(128),\n     ET_TYPE     VARCHAR2(6),\n     CONSTRAINT ' || label_pk || ' PRIMARY KEY(LABEL_NAME, ET_NAME, ET_TYPE)\n   )';\n  execute immediate\n  'CREATE TABLE ' || property_tab || ' (\n     PROPERTY_NAME  VARCHAR2(128),\n     ET_NAME        VARCHAR2(128),\n     ET_TYPE        VARCHAR2(6),\n     LABEL_NAME     VARCHAR2(128),\n     COLUMN_NAME    VARCHAR2(128),\n     CONSTRAINT ' || property_pk || ' PRIMARY KEY(PROPERTY_NAME, ET_NAME, LABEL_NAME)\n   )';\n  execute immediate\n  'CREATE TABLE ' || key_tab || ' (\n     COLUMN_NAME    VARCHAR2(128),\n     COLUMN_NUMBER  NUMBER,\n     KEY_TYPE       VARCHAR2(6),\n     ET_NAME        VARCHAR2(128),\n     CONSTRAINT ' || key_pk || ' PRIMARY KEY(COLUMN_NAME, KEY_TYPE, ET_NAME)\n   )';\n  execute immediate\n  'CREATE TABLE ' || src_dst_key_tab || ' (\n     ET_NAME           VARCHAR2(128),\n     VT_NAME           VARCHAR2(128),\n     KEY_TYPE          VARCHAR2(16),\n     ET_COLUMN_NAME    VARCHAR2(128),\n     ET_COLUMN_NUMBER  NUMBER,\n     CONSTRAINT ' || src_dst_key_pk || ' PRIMARY KEY(ET_NAME, VT_NAME, KEY_TYPE, ET_COLUMN_NAME)\n   )';\nEND;";
    private static final String DROP_TABLES_STR = "DECLARE\n  elem_table_tab  VARCHAR2(128) := SYS.DBMS_ASSERT.QUALIFIED_SQL_NAME(?);\n  label_tab       VARCHAR2(128) := SYS.DBMS_ASSERT.QUALIFIED_SQL_NAME(?);\n  property_tab    VARCHAR2(128) := SYS.DBMS_ASSERT.QUALIFIED_SQL_NAME(?);\n  key_tab         VARCHAR2(128) := SYS.DBMS_ASSERT.QUALIFIED_SQL_NAME(?);\n  src_dst_key_tab VARCHAR2(128) := SYS.DBMS_ASSERT.QUALIFIED_SQL_NAME(?);\nBEGIN\n  execute immediate\n  'DROP TABLE ' || elem_table_tab;\n  execute immediate\n  'DROP TABLE ' || label_tab;\n  execute immediate\n  'DROP TABLE ' || property_tab;\n  execute immediate\n  'DROP TABLE ' || key_tab;\n  execute immediate\n  'DROP TABLE ' || src_dst_key_tab;\nEND;";
    private static final String INSERT_ELEMENT_TABLE_STR = "DECLARE\n  elem_table_tab  VARCHAR2(128) := SYS.DBMS_ASSERT.QUALIFIED_SQL_NAME(?);\n  et_name         VARCHAR2(128) := ?;\n  et_type         VARCHAR2(128) := ?;\n  schema_name     VARCHAR2(128) := ?;\n  table_name      VARCHAR2(128) := ?;\nBEGIN\n  execute immediate 'INSERT INTO ' || elem_table_tab || '   (ET_NAME, ET_TYPE, SCHEMA_NAME, TABLE_NAME) VALUES (:et_name, :et_type, :schema_name, :table_name)'\n  using et_name, et_type, schema_name, table_name;\nEND;";
    private static final String INSERT_KEY_STR = "DECLARE\n  key_tab        VARCHAR2(128) := SYS.DBMS_ASSERT.QUALIFIED_SQL_NAME(?);\n  column_name    VARCHAR2(128) := ?;\n  column_number  NUMBER        := ?;\n  key_type       VARCHAR2(128) := ?;\n  et_name        VARCHAR2(128) := ?;\nBEGIN\n  execute immediate 'INSERT INTO ' || key_tab || '   (COLUMN_NAME, COLUMN_NUMBER, KEY_TYPE, ET_NAME)   VALUES (:column_name, :column_number, :key_type, :et_name)'\n  using column_name, column_number, key_type, et_name;\nEND;";
    private static final String INSERT_SRC_DST_KEY_STR = "DECLARE\n  src_dst_key_tab   VARCHAR2(128) := SYS.DBMS_ASSERT.QUALIFIED_SQL_NAME(?);\n  et_name           VARCHAR2(128) := ?;\n  vt_name           VARCHAR2(128) := ?;\n  key_type          VARCHAR2(128) := ?;\n  et_column_name    VARCHAR2(128) := ?;\n  et_column_number  NUMBER := ?;\nBEGIN\n  execute immediate 'INSERT INTO ' || src_dst_key_tab || '   (ET_NAME, VT_NAME, KEY_TYPE, ET_COLUMN_NAME, ET_COLUMN_NUMBER)  VALUES (:et_name, :vt_name, :key_type, :et_column_name, :et_column_number)'\n  using et_name, vt_name, key_type, et_column_name, et_column_number;\nEND;";
    private static final String INSERT_LABEL_STR = "DECLARE\n  label_tab   VARCHAR2(128) := SYS.DBMS_ASSERT.QUALIFIED_SQL_NAME(?);\n  label_name  VARCHAR2(128) := ?;\n  et_name     VARCHAR2(128) := ?;\n  et_type     VARCHAR2(128) := ?;\nBEGIN\n  execute immediate 'INSERT INTO ' || label_tab || '   (LABEL_NAME, ET_NAME, ET_TYPE) VALUES (:label_name, :et_name, :et_type)'\n  using label_name, et_name, et_type;\nEND;";
    private static final String INSERT_PROPERTY_STR = "DECLARE\n  property_tab   VARCHAR2(128) := SYS.DBMS_ASSERT.QUALIFIED_SQL_NAME(?);\n  property_name  VARCHAR2(128) := ?;\n  et_name        VARCHAR2(128) := ?;\n  et_type        VARCHAR2(128) := ?;\n  label_name     VARCHAR2(128) := ?;\n  column_name    VARCHAR2(128) := ?;\nBEGIN\n  execute immediate 'INSERT INTO ' || property_tab || '   (PROPERTY_NAME, ET_NAME, ET_TYPE, LABEL_NAME, COLUMN_NAME)   VALUES (:property_name, :et_name, :et_type, :label_name, :column_name)'\n  using property_name, et_name, et_type, label_name, column_name;\nEND;";
    private final PgqlConnection pgqlConn;
    private final String graphSchema;
    private final String graphName;
    private final PgqlCpgRdbmsExpander expander;

    public PgViewDdlExecution(PgqlConnection pgqlConn, String graphSchema, String graphName) {
        this.pgqlConn = pgqlConn;
        this.graphSchema = graphSchema;
        this.graphName = graphName;
        this.expander = PgqlCpgRdbmsExpander.getPgqlCpgRdbmsExpander(pgqlConn, true);
    }

    public void createPG(CreatePropertyGraph cpg) throws SQLException {
        this.expander.expand(cpg);
        try (PreparedStatement createTablesPS = this.pgqlConn.getJdbcConnection().prepareStatement(CREATE_TABLES_STR);){
            String[] pgTablesSuffix = new String[]{"_ELEM_TABLE$", "_LABEL$", "_PROPERTY$", "_KEY$", "_SRC_DST_KEY$"};
            for (int i = 0; i < pgTablesSuffix.length; ++i) {
                createTablesPS.setString(2 * i + 1, this.getTableForSuffix(pgTablesSuffix[i]));
                createTablesPS.setString(2 * i + 2, this.getTablePrimaryKeyForSuffix(pgTablesSuffix[i]));
            }
            createTablesPS.execute();
        }
        var3_3 = null;
        try (PreparedStatement insertElemTabPS = this.pgqlConn.getJdbcConnection().prepareStatement(INSERT_ELEMENT_TABLE_STR);
             PreparedStatement insertKeyPS = this.pgqlConn.getJdbcConnection().prepareStatement(INSERT_KEY_STR);
             PreparedStatement insertSrcDstKeyPS = this.pgqlConn.getJdbcConnection().prepareStatement(INSERT_SRC_DST_KEY_STR);
             PreparedStatement insertLabelPS = this.pgqlConn.getJdbcConnection().prepareStatement(INSERT_LABEL_STR);
             PreparedStatement insertPropertyPS = this.pgqlConn.getJdbcConnection().prepareStatement(INSERT_PROPERTY_STR);){
            for (VertexTable vt : cpg.getVertexTables()) {
                this.insertElementTable(insertElemTabPS, insertKeyPS, insertLabelPS, insertPropertyPS, (ElementTable)vt, "VERTEX");
            }
            for (EdgeTable et : cpg.getEdgeTables()) {
                this.insertElementTable(insertElemTabPS, insertKeyPS, insertLabelPS, insertPropertyPS, (ElementTable)et, "EDGE");
                int columnNumber = 1;
                String edgeTab = et.getTableAlias();
                String sourceTab = et.getSourceVertexTable().getTableAlias();
                for (String column : et.getEdgeSourceKey().getColumnNames()) {
                    this.insertSrcDstKey(insertSrcDstKeyPS, edgeTab, sourceTab, "EDGE_SOURCE", column, columnNumber++);
                }
                columnNumber = 1;
                String destTab = et.getDestinationVertexTable().getTableAlias();
                for (String column : et.getEdgeDestinationKey().getColumnNames()) {
                    this.insertSrcDstKey(insertSrcDstKeyPS, edgeTab, destTab, "EDGE_DESTINATION", column, columnNumber++);
                }
            }
            insertElemTabPS.executeBatch();
            insertKeyPS.executeBatch();
            insertSrcDstKeyPS.executeBatch();
            insertLabelPS.executeBatch();
            insertPropertyPS.executeBatch();
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        this.pgqlConn.getJdbcConnection().commit();
    }

    public void dropPG() throws SQLException {
        try (PreparedStatement dropTablesPS = this.pgqlConn.getJdbcConnection().prepareStatement(DROP_TABLES_STR);){
            String[] pgTablesSuffix = new String[]{"_ELEM_TABLE$", "_LABEL$", "_PROPERTY$", "_KEY$", "_SRC_DST_KEY$"};
            for (int i = 0; i < pgTablesSuffix.length; ++i) {
                dropTablesPS.setString(i + 1, this.getTableForSuffix(pgTablesSuffix[i]));
            }
            dropTablesPS.execute();
        }
    }

    private void insertElementTable(PreparedStatement insertElemTabPS, PreparedStatement insertKeyPS, PreparedStatement insertLabelPS, PreparedStatement insertPropertyPS, ElementTable elementTable, String tableType) throws SQLException {
        String tableAlias = elementTable.getTableAlias();
        insertElemTabPS.setString(1, this.getTableForSuffix("_ELEM_TABLE$"));
        insertElemTabPS.setString(2, tableAlias);
        insertElemTabPS.setString(3, tableType);
        insertElemTabPS.setString(4, elementTable.getTableName().getSchemaName());
        insertElemTabPS.setString(5, elementTable.getTableName().getName());
        insertElemTabPS.addBatch();
        if (elementTable.getKey() != null) {
            int columnNumber = 1;
            for (String column : elementTable.getKey().getColumnNames()) {
                insertKeyPS.setString(1, this.getTableForSuffix("_KEY$"));
                insertKeyPS.setString(2, column);
                insertKeyPS.setInt(3, columnNumber++);
                insertKeyPS.setString(4, tableType);
                insertKeyPS.setString(5, tableAlias);
                insertKeyPS.addBatch();
            }
        }
        for (Label label : elementTable.getLabels()) {
            String labelName = label.getName();
            insertLabelPS.setString(1, this.getTableForSuffix("_LABEL$"));
            insertLabelPS.setString(2, labelName);
            insertLabelPS.setString(3, tableAlias);
            insertLabelPS.setString(4, tableType);
            insertLabelPS.addBatch();
            for (Property property : label.getProperties()) {
                QueryExpression qe = property.getValueExpression();
                String propertyName = property.getPropertyName();
                String columnName = ((QueryExpression.VarRef)qe).getVariable().getName();
                insertPropertyPS.setString(1, this.getTableForSuffix("_PROPERTY$"));
                insertPropertyPS.setString(2, propertyName);
                insertPropertyPS.setString(3, tableAlias);
                insertPropertyPS.setString(4, tableType);
                insertPropertyPS.setString(5, labelName);
                insertPropertyPS.setString(6, columnName);
                insertPropertyPS.addBatch();
            }
        }
    }

    private void insertSrcDstKey(PreparedStatement insertSrcDstKeyPS, String edgeTable, String vertexTable, String keyType, String columnName, int columnNumber) throws SQLException {
        insertSrcDstKeyPS.setString(1, this.getTableForSuffix("_SRC_DST_KEY$"));
        insertSrcDstKeyPS.setString(2, edgeTable);
        insertSrcDstKeyPS.setString(3, vertexTable);
        insertSrcDstKeyPS.setString(4, keyType);
        insertSrcDstKeyPS.setString(5, columnName);
        insertSrcDstKeyPS.setInt(6, columnNumber);
        insertSrcDstKeyPS.addBatch();
    }

    private String getTableForSuffix(String suffix) {
        try {
            return DbmsUtils.getTableForSuffix(this.pgqlConn.getJdbcConnection(), this.graphSchema, this.graphName, suffix);
        }
        catch (SQLException ex) {
            throw new PgqlToSqlException(ex);
        }
    }

    private String getTablePrimaryKeyForSuffix(String suffix) {
        try {
            return DbmsUtils.enquoteTableName(this.pgqlConn.getJdbcConnection(), this.graphName + suffix + "_PK");
        }
        catch (SQLException ex) {
            throw new PgqlToSqlException(ex);
        }
    }
}

