/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.pgql;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.pg.rdbms.pgql.ValuePair;

public class TraversalStruct {
    private Map<String, List<int[]>> edgeJoinMap = new HashMap<String, List<int[]>>();
    private Map<String, Set<String>> varPropMap = new HashMap<String, Set<String>>();
    private Map<String, String[]> varAliasMap = new HashMap<String, String[]>();
    private Map<ValuePair, String> propAliasMap = new HashMap<ValuePair, String>();
    private Map<String, String[]> idTableMap = new HashMap<String, String[]>();
    private Map<String, String> varIdMap = new HashMap<String, String>();
    private Map<String, Set<Integer>> aliasModifyListMap = new HashMap<String, Set<Integer>>();
    private Set<String> anyDirectedAlias = new HashSet<String>();

    public void clearStruct() {
        this.edgeJoinMap.clear();
        this.varPropMap.clear();
        this.varAliasMap.clear();
        this.propAliasMap.clear();
        this.idTableMap.clear();
        this.varIdMap.clear();
        this.aliasModifyListMap.clear();
        this.anyDirectedAlias.clear();
    }

    public String toString() {
        StringBuffer buff = new StringBuffer("");
        buff.append("\nID-Table Map:\n").append(this.dumpIdTableMap());
        buff.append("\nEdge-Join Map:\n").append(this.dumpEdgeJoinMap());
        buff.append("\nVar-Prop Map:\n").append(this.dumpVarPropMap());
        buff.append("\nVar-Alias Map:\n").append(this.dumpVarAliasMap());
        buff.append("\nProp-Alias Map:\n").append(this.dumpPropAliasMap());
        buff.append("\nVar-ID Map:\n").append(this.dumpVarIdMap());
        buff.append("\nAlias-Modify_List Map:\n").append(this.dumpAliasModifyListMap());
        buff.append("\nAny directed aliases:\n").append(this.dumpAnyDirectedAliasSet());
        return buff.toString();
    }

    private String dumpEdgeJoinMap() {
        StringBuffer buff = new StringBuffer();
        Set<Map.Entry<String, List<int[]>>> es = this.edgeJoinMap.entrySet();
        for (Map.Entry<String, List<int[]>> e : es) {
            buff.append("[").append(e.getKey()).append("]->{");
            List<int[]> val = e.getValue();
            for (int[] i : val) {
                buff.append("[").append(i[0]).append(",").append(i[1]).append("]");
            }
            buff.append("}\n");
        }
        return buff.toString();
    }

    private String dumpIdTableMap() {
        StringBuffer buff = new StringBuffer();
        Set<Map.Entry<String, String[]>> es = this.idTableMap.entrySet();
        for (Map.Entry<String, String[]> e : es) {
            buff.append("[").append(e.getKey()).append("]->");
            buff.append("[").append(e.getValue()[0]).append(",").append(e.getValue()[1]).append("]");
            buff.append("\n");
        }
        return buff.toString();
    }

    private String dumpVarPropMap() {
        StringBuffer buff = new StringBuffer();
        Set<Map.Entry<String, Set<String>>> es = this.varPropMap.entrySet();
        for (Map.Entry<String, Set<String>> e : es) {
            buff.append("[").append(e.getKey()).append("]->{");
            Set<String> pSet = e.getValue();
            boolean needComma = false;
            for (String p : pSet) {
                if (needComma) {
                    buff.append(",");
                }
                buff.append(p);
                needComma = true;
            }
            buff.append("}\n");
        }
        return buff.toString();
    }

    private String dumpVarAliasMap() {
        StringBuffer buff = new StringBuffer();
        Set<Map.Entry<String, String[]>> es = this.varAliasMap.entrySet();
        for (Map.Entry<String, String[]> e : es) {
            String[] val = e.getValue();
            buff.append("[").append(e.getKey()).append("]->[");
            buff.append(val[0]).append(".").append(val[1]).append("]\n");
        }
        return buff.toString();
    }

    private String dumpPropAliasMap() {
        StringBuffer buff = new StringBuffer();
        Set<Map.Entry<ValuePair, String>> es = this.propAliasMap.entrySet();
        for (Map.Entry<ValuePair, String> e : es) {
            ValuePair vp = e.getKey();
            buff.append("[").append(vp.v1).append(".").append(vp.v2).append("]->[");
            buff.append(e.getValue()).append("]\n");
        }
        return buff.toString();
    }

    private String dumpVarIdMap() {
        StringBuffer buff = new StringBuffer();
        Set<Map.Entry<String, String>> es = this.varIdMap.entrySet();
        for (Map.Entry<String, String> e : es) {
            String var = e.getKey();
            buff.append("[").append(var).append("]->[");
            buff.append(e.getValue()).append("]\n");
        }
        return buff.toString();
    }

    private String dumpAliasModifyListMap() {
        StringBuffer buff = new StringBuffer();
        Set<Map.Entry<String, Set<Integer>>> es = this.aliasModifyListMap.entrySet();
        for (Map.Entry<String, Set<Integer>> e : es) {
            String var = e.getKey();
            buff.append("[").append(var).append("]->");
            buff.append(e.getValue()).append("\n");
        }
        return buff.toString();
    }

    private String dumpAnyDirectedAliasSet() {
        StringBuffer buff = new StringBuffer("[");
        for (String s : this.anyDirectedAlias) {
            buff.append(" " + s);
        }
        buff.append(" ]");
        return buff.toString();
    }

    public List<int[]> getEdgeJoin(String varName) {
        return this.edgeJoinMap.get(varName);
    }

    public void putEdgeJoin(String varName, List<int[]> joinList) {
        this.edgeJoinMap.put(varName, joinList);
    }

    public boolean containsEdgeJoinVar(String varName) {
        return this.edgeJoinMap.containsKey(varName);
    }

    public Set<Map.Entry<String, List<int[]>>> getAllEdgeJoins() {
        return this.edgeJoinMap.entrySet();
    }

    public Set<String> getVarProps(String varName) {
        return this.varPropMap.get(varName);
    }

    public void putVarProp(String varName, Set<String> props) {
        this.varPropMap.put(varName, props);
    }

    public Set<Map.Entry<String, Set<String>>> getAllVarProps() {
        return this.varPropMap.entrySet();
    }

    public Set<Map.Entry<String, String[]>> getAllVarAliases() {
        return this.varAliasMap.entrySet();
    }

    public boolean containsVarAlias(String varName) {
        return this.varAliasMap.containsKey(varName);
    }

    public String[] getVarAlias(String varName) {
        return this.varAliasMap.get(varName);
    }

    public void putVarAlias(String varName, String[] alias) {
        this.varAliasMap.put(varName, alias);
    }

    public boolean containsPropAlias(ValuePair varPropPair) {
        return this.propAliasMap.containsKey(varPropPair);
    }

    public String getPropAlias(ValuePair varPropPair) {
        return this.propAliasMap.get(varPropPair);
    }

    public void putPropAlias(ValuePair varPropPair, String alias) {
        this.propAliasMap.put(varPropPair, alias);
    }

    public String[] getTableNameForId(String id) {
        return this.idTableMap.get(id);
    }

    public void putTableNameForId(String id, String[] tableNameAndProp) {
        this.idTableMap.put(id, tableNameAndProp);
    }

    public Set<Map.Entry<String, String[]>> getAllTableNamesForIds() {
        return this.idTableMap.entrySet();
    }

    public List<String> getEdgeAliases(String vtTab) {
        ArrayList<String> edgeAliases = new ArrayList<String>();
        for (String k : this.idTableMap.keySet()) {
            if (this.idTableMap.get(k)[0].equals(vtTab)) continue;
            edgeAliases.add(k);
        }
        return edgeAliases;
    }

    public List<String> getVertexAliases(String gtTab) {
        ArrayList<String> vertexAliases = new ArrayList<String>();
        for (String k : this.idTableMap.keySet()) {
            if (!this.idTableMap.get(k)[0].equals(gtTab)) continue;
            vertexAliases.add(k);
        }
        return vertexAliases;
    }

    public String getVarId(String varName) {
        return this.varIdMap.get(varName);
    }

    public void putVarId(String varName, String id) {
        this.varIdMap.put(varName, id);
    }

    public boolean isModifyTableAlias(String alias) {
        return this.aliasModifyListMap.containsKey(alias);
    }

    public void putAliasModifyList(String alias, Set<Integer> modifyList) {
        this.aliasModifyListMap.put(alias, modifyList);
    }

    public Set<Integer> getAliasModifyList(String alias) {
        return this.aliasModifyListMap.get(alias);
    }

    public boolean isAnyDirectedAlias(String alias) {
        return this.anyDirectedAlias.contains(alias);
    }

    public void addAnyDirectedAlias(String alias) {
        this.anyDirectedAlias.add(alias);
    }
}

