/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.pgql;

import java.util.ArrayList;
import java.util.List;
import oracle.pg.rdbms.pgql.PgqlConnection;
import oracle.pg.rdbms.pgql.PgqlCreatePgUtils;
import oracle.pg.rdbms.pgql.PgqlToSqlException;
import oracle.pgql.lang.ddl.propertygraph.CreatePropertyGraph;
import oracle.pgql.lang.ddl.propertygraph.EdgeTable;
import oracle.pgql.lang.ddl.propertygraph.ElementTable;
import oracle.pgql.lang.ddl.propertygraph.Key;
import oracle.pgql.lang.ddl.propertygraph.Label;
import oracle.pgql.lang.ddl.propertygraph.Property;
import oracle.pgql.lang.ddl.propertygraph.VertexTable;
import oracle.pgql.lang.ir.ExpAsVar;
import oracle.pgql.lang.ir.QueryExpression;
import oracle.pgql.lang.ir.QueryVariable;
import oracle.pgql.lang.ir.SchemaQualifiedName;

public class PgqlCpgRdbmsExpander {
    private final PgqlConnection pgqlConn;
    private final boolean forPgView;

    private PgqlCpgRdbmsExpander(PgqlConnection pgqlConn, boolean forPgView) {
        this.pgqlConn = pgqlConn;
        this.forPgView = forPgView;
    }

    public static PgqlCpgRdbmsExpander getPgqlCpgRdbmsExpander(PgqlConnection pgqlConn, boolean forPgView) {
        return new PgqlCpgRdbmsExpander(pgqlConn, forPgView);
    }

    public void expand(CreatePropertyGraph cpg) {
        if (cpg.getGraphName().getSchemaName() == null) {
            cpg.getGraphName().setSchemaName(this.pgqlConn.getSchema());
        }
        for (VertexTable vt : cpg.getVertexTables()) {
            this.expandElementTable((ElementTable)vt, "vertex");
        }
        for (EdgeTable et : cpg.getEdgeTables()) {
            this.expandElementTable((ElementTable)et, "edge");
            this.expandEdgeTable(et);
        }
    }

    public void expandElementTable(ElementTable et, String tableType) {
        SchemaQualifiedName tableName = et.getTableName();
        if (tableName.getSchemaName() == null) {
            tableName.setSchemaName(this.pgqlConn.getSchema());
        }
        if (!PgqlCreatePgUtils.existsTableOrView(this.pgqlConn, tableName.getSchemaName(), tableName.getName())) {
            this.throwTableError(et, tableType, "does not exist");
        }
        if (et.getKey() == null) {
            List<String> key = PgqlCreatePgUtils.getPrimaryKey(this.pgqlConn, et);
            if (key != null) {
                et.setKey(new Key(key));
            } else {
                this.throwTableError(et, tableType, "does not have a primary key, please provide one");
            }
        } else {
            this.verifyKeyColumnsExist(et.getKey(), et, tableType, "table");
        }
        for (Label l : et.getLabels()) {
            this.expandLabel(l, et, tableType);
        }
    }

    public void expandEdgeTable(EdgeTable et) {
        if (et.getEdgeSourceKey() == null) {
            et.setEdgeSourceKey(this.getForeignKey(et, et.getSourceVertexTable()));
        } else {
            this.verifyKeyColumnsExist(et.getEdgeSourceKey(), (ElementTable)et, "edge", "source");
        }
        if (et.getSourceVertexKey() != null && et.getSourceVertexTable().getKey() != null && !et.getSourceVertexKey().equals((Object)et.getSourceVertexTable().getKey())) {
            throw new PgqlToSqlException("The source vertex key of edge table " + et.getTableAlias() + " is " + et.getSourceVertexKey() + " but should be the same as the key " + et.getSourceVertexTable().getKey() + " of vertex table " + et.getSourceVertexTable().getTableAlias());
        }
        if (et.getEdgeDestinationKey() == null) {
            et.setEdgeDestinationKey(this.getForeignKey(et, et.getDestinationVertexTable()));
        } else {
            this.verifyKeyColumnsExist(et.getEdgeDestinationKey(), (ElementTable)et, "edge", "destination");
        }
        if (et.getDestinationVertexKey() != null && et.getDestinationVertexTable().getKey() != null && !et.getDestinationVertexKey().equals((Object)et.getDestinationVertexTable().getKey())) {
            throw new PgqlToSqlException("The destination vertex key of edge table " + et.getTableAlias() + " is " + et.getDestinationVertexKey() + " but should be the same as the key " + et.getDestinationVertexTable().getKey() + " of vertex table " + et.getDestinationVertexTable().getTableAlias());
        }
    }

    private Key getForeignKey(EdgeTable et, VertexTable vt) {
        SchemaQualifiedName etName = et.getTableName();
        SchemaQualifiedName vtName = vt.getTableName();
        List<List<String>> foreignKeys = PgqlCreatePgUtils.getForeignKeys(this.pgqlConn, et, vt);
        if (foreignKeys == null) {
            if (!this.forPgView && etName.equals((Object)vtName) && et.getKey() != null) {
                return et.getKey();
            }
            this.throwTableError((ElementTable)et, "edge", "does not have a key referencing " + vtName + ", please provide one");
        }
        if (foreignKeys.size() > 1) {
            throw new PgqlToSqlException("Ambiguous key for edge provider " + et.getTableAlias() + ". Edge table " + etName + " has several columns referencing " + vtName + ", please specify a key");
        }
        return new Key(foreignKeys.get(0));
    }

    private void expandLabel(Label l, ElementTable et, String tableType) {
        SchemaQualifiedName tableName = et.getTableName();
        if (l.isPropertiesAreAllColumns()) {
            List<String> columns = PgqlCreatePgUtils.getColumns(this.pgqlConn, tableName.getSchemaName(), tableName.getName());
            ArrayList<Property> properties = new ArrayList<Property>();
            for (String col : columns) {
                if (l.getPropertiesAreAllColumnsExcept() != null && l.getPropertiesAreAllColumnsExcept().contains(col)) continue;
                properties.add(new Property((QueryExpression)new QueryExpression.VarRef((QueryVariable)new ExpAsVar((QueryExpression)new QueryExpression.Constant.ConstString(col), col, true)), col));
            }
            l.setProperties(properties);
            l.setPropertiesAreAllColumns(false);
            l.setPropertiesAreAllColumnsExcept(null);
        } else {
            for (Property property : l.getProperties()) {
                QueryExpression qe = property.getValueExpression();
                if (qe.getExpType() != QueryExpression.ExpressionType.VARREF) {
                    throw new PgqlToSqlException("Only column references are supported as table PROPERTIES");
                }
                String columnName = ((QueryExpression.VarRef)qe).getVariable().getName();
                this.verifyColumnExists(columnName, et, tableType, "property");
            }
        }
    }

    private void verifyKeyColumnsExist(Key key, ElementTable et, String tableType, String keyType) {
        for (String column : key.getColumnNames()) {
            this.verifyColumnExists(column, et, tableType, keyType + " key");
        }
    }

    private void verifyColumnExists(String column, ElementTable et, String tableType, String columnType) {
        SchemaQualifiedName tableName = et.getTableName();
        if (!PgqlCreatePgUtils.existsColumn(this.pgqlConn, tableName.getSchemaName(), tableName.getName(), column)) {
            this.throwTableError(et, tableType, "does not have a " + columnType + " column " + column);
        }
    }

    private void throwTableError(ElementTable et, String tableType, String errorMessage) {
        throw new PgqlToSqlException("In " + tableType + " provider " + et.getTableAlias() + ", table " + et.getTableName() + " " + errorMessage);
    }
}

