/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.pgql;

import java.sql.Connection;
import java.sql.SQLException;
import oracle.pg.rdbms.pgql.DbmsUtils;
import oracle.pg.rdbms.pgql.PgqlExecution;
import oracle.pg.rdbms.pgql.PgqlPreparedStatement;
import oracle.pg.rdbms.pgql.PgqlStatement;
import oracle.pg.rdbms.pgql.PgqlToSqlException;
import oracle.pg.rdbms.pgql.PgqlTranslator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PgqlConnection {
    private static Logger ms_log = LoggerFactory.getLogger(PgqlConnection.class);
    private final Connection conn;
    private String schema;
    private String graph;

    private PgqlConnection(Connection conn) {
        this.conn = conn;
        this.schema = null;
        this.graph = null;
    }

    public static PgqlConnection getConnection(Connection conn) {
        return new PgqlConnection(conn);
    }

    public void setSchema(String schema) {
        try {
            this.schema = schema == null ? null : PgqlConnection.stripQuotes(DbmsUtils.sanitizeIdentifier(this.conn, schema));
        }
        catch (SQLException ex) {
            throw new PgqlToSqlException(ex);
        }
    }

    public void setGraph(String graph) {
        try {
            this.graph = graph == null ? null : PgqlConnection.stripQuotes(DbmsUtils.sanitizeIdentifier(this.conn, graph));
        }
        catch (SQLException ex) {
            throw new PgqlToSqlException(ex);
        }
    }

    private static String stripQuotes(String s) {
        if (s.matches("^\".+\"$")) {
            return s.substring(1, s.length() - 1);
        }
        return s;
    }

    public PgqlStatement createStatement() {
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("returning new PgqlExecution object");
        }
        return new PgqlExecution(this);
    }

    public PgqlPreparedStatement prepareStatement(String pgql) {
        return this.prepareStatement(pgql, 0, 0, 2, -1, null, null);
    }

    public PgqlPreparedStatement prepareStatement(String pgql, String matchOptions, String options) {
        return this.prepareStatement(pgql, 0, 0, 2, -1, matchOptions, options);
    }

    public PgqlPreparedStatement prepareStatement(String pgql, int timeout, int parallel, int dynamicSampling, int maxResults, String matchOptions, String options) {
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("returning new PgqlExecution object");
        }
        return new PgqlExecution(this, pgql, timeout, parallel, dynamicSampling, maxResults, matchOptions, options);
    }

    public String getSchema() throws PgqlToSqlException {
        try {
            return this.schema == null ? this.conn.getSchema() : this.schema;
        }
        catch (SQLException ex) {
            throw new PgqlToSqlException(ex);
        }
    }

    public String getGraph() {
        return this.graph;
    }

    public Connection getJdbcConnection() {
        return this.conn;
    }

    public void clearTranslationCache() {
        ms_log.debug("Clearing translation cache");
        PgqlExecution.clearTranslationCache(this);
    }

    public void disableTranslationCache() {
        ms_log.debug("Disabling translation cache");
        PgqlExecution.disableTranslationCache(this);
    }

    public void enableTranslationCache() {
        ms_log.debug("Enabling translation cache");
        PgqlExecution.enableTranslationCache(this);
    }

    public void setTranslationCacheMaxCapacity(int maxCapacity) {
        ms_log.debug("Setting translation cache max capacity to " + maxCapacity);
        PgqlExecution.setTranslationCacheMaxCapacity(this, maxCapacity);
    }

    public void clearGraphMetadataCache() {
        ms_log.debug("Clearing graph metadata cache");
        PgqlTranslator.clearGraphMetadataCache(this);
    }

    public void disableGraphMetadataCache() {
        ms_log.debug("Disabling graph metadata cache");
        PgqlTranslator.disableGraphMetadataCache(this);
    }

    public void enableGraphMetadataCache() {
        ms_log.debug("Enabling graph metadata cache");
        PgqlTranslator.enableGraphMetadataCache(this);
    }

    public void setGraphMetadataCacheMaxCapacity(int maxCapacity) {
        ms_log.debug("Setting graph metadata cache max capacity to " + maxCapacity);
        PgqlTranslator.setGraphMetadataCacheMaxCapacity(this, maxCapacity);
    }
}

