/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.pgql;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import oracle.pg.rdbms.pgql.BindValueInfo;
import oracle.pg.rdbms.pgql.DbmsUtils;
import oracle.pg.rdbms.pgql.ExprContext;
import oracle.pg.rdbms.pgql.ExprTranslation;
import oracle.pg.rdbms.pgql.PgqlColumnDescriptor;
import oracle.pg.rdbms.pgql.PgqlSqlQueryTrans;
import oracle.pg.rdbms.pgql.PgqlToSqlException;
import oracle.pg.rdbms.pgql.PgqlTranslator;
import oracle.pg.rdbms.pgql.ValuePair;
import oracle.pgql.lang.PgqlException;
import oracle.pgql.lang.ir.GraphQuery;
import oracle.pgql.lang.ir.QueryExpression;
import oracle.pgql.lang.ir.QueryVariable;
import oracle.pgql.lang.ir.SelectQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExprTransVisitor {
    private static Logger ms_log = LoggerFactory.getLogger(ExprTransVisitor.class);
    public static final int FILTER_MODE = 0;
    public static final int ORDER_BY_MODE = 1;
    public static final int GROUP_BY_MODE = 2;
    public static final int PROJECT_MODE = 3;
    public static final int ASC_DIR = 0;
    public static final int DESC_DIR = 1;
    static final int FLOAT_FAM = 0;
    static final int DOUBLE_FAM = 1;
    static final int DOUBLE_CONST_FAM = 2;
    static final int INTEGER_FAM = 3;
    static final int LONG_FAM = 4;
    static final int LONG_CONST_FAM = 5;
    static final int STRING_FAM = 6;
    static final int STRING_CONST_FAM = 7;
    static final int TIMESTAMP_FAM = 8;
    static final int TIMESTAMP_TZ_FAM = 9;
    static final int BOOLEAN_FAM = 10;
    static final int BOOL_CONST_FAM = 11;
    static final int PROP_FAM = 12;
    static final int VERTEX_VAR_FAM = 13;
    static final int EDGE_VAR_FAM = 14;
    static final int NULL_FAM = 15;
    static final int STAR_FAM = 16;
    private ExprContext eCtx;
    private static final String NLS_NUM_CHAR_ARG = "'NLS_Numeric_Characters=''.,'''";
    private static final String DEFAULT_NUM_FMT = "'TM9'";
    private static final String DATE_FMT = "'SYYYY-MM-DD'";
    private static final String DATETIME_FMT = "'SYYYY-MM-DD\"T\"HH24:MI:SS.FF'";
    private static final String DATETIME_TZ_FMT = "'SYYYY-MM-DD\"T\"HH24:MI:SS.FFTZH:TZM'";
    private static final String DATETIME_TZ_ALT_FMT = "'SYYYY-MM-DD HH24:MI:SS.FFTZH:TZM'";
    private static final String DEFAULT_TIME_TZ = "n'T00:00:00.00Z'";
    private static final String DEFAULT_TZ = "n'Z'";
    private static final String DEFAULT_TO_CHAR_TZ = "'GMT'";
    private static final int DATETIME_ORD_POS = 1;
    private static final int NUMBER_ORD_POS = 2;
    private static final int STRING_ORD_POS = 3;
    private static final int BOOLEAN_ORD_POS = 4;
    private static final String UPPER_Y_CONST = "Y";
    private static final String LOWER_Y_CONST = "y";
    private static final String TRUE_CONST = "true";
    private static final String UPPER_N_CONST = "N";
    private static final String LOWER_N_CONST = "n";
    private static final String FALSE_CONST = "false";
    private static final String XSD_BOOLEAN = "<http://www.w3.org/2001/XMLSchema#boolean>";
    private static final String XSD_DATETIME = "<http://www.w3.org/2001/XMLSchema#dateTime>";
    private static final String XSD_DOUBLE = "<http://www.w3.org/2001/XMLSchema#double>";
    private static final String XSD_FLOAT = "<http://www.w3.org/2001/XMLSchema#float>";
    private static final String XSD_INTEGER = "<http://www.w3.org/2001/XMLSchema#integer>";
    private static final String XSD_STRING = "<http://www.w3.org/2001/XMLSchema#string>";
    private static final String NULL_CONST = "NULL";
    protected static final String VERTEX_TYPE = "n'V'";
    protected static final String EDGE_TYPE = "n'E'";
    private static final String JAVA_DATETIME_TZ_FMT = "yyyy-MM-dd'T'HH:mm:ss.SSSXXX";
    private static final String DEFAULT_NULL_ON_CONVERSION_ERROR = " default null on conversion error";
    private static DateTimeFormatter dtzf;
    private static final String JAVA_DATETIME_FMT = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    private static DateTimeFormatter dtf;

    private ExprTransVisitor(ExprContext eCtx) {
        this.eCtx = eCtx;
    }

    public static ExprTransVisitor getExprTransVisitor(ExprContext eCtx) {
        return new ExprTransVisitor(eCtx);
    }

    public ExprTranslation visit(QueryExpression.Constant.ConstInteger n, int[] childTypeFams, String[][] childSQL, boolean isRoot, boolean negated) throws PgqlToSqlException {
        String[] sql = new String[]{Long.toString((Long)n.getValue())};
        int typeFam = ExprTransVisitor.getTypeFamily((QueryExpression)n, n.getExpType(), null, null);
        if (isRoot) {
            sql = this.getRootTrans(typeFam, sql);
        }
        return new ExprTranslation(sql, typeFam);
    }

    public ExprTranslation visit(QueryExpression.Constant.ConstDecimal n, int[] childTypeFams, String[][] childSQL, boolean isRoot, boolean negated) throws PgqlToSqlException {
        String[] sql = new String[]{Double.toString((Double)n.getValue())};
        int typeFam = ExprTransVisitor.getTypeFamily((QueryExpression)n, n.getExpType(), null, null);
        if (isRoot) {
            sql = this.getRootTrans(typeFam, sql);
        }
        return new ExprTranslation(sql, typeFam);
    }

    public ExprTranslation visit(QueryExpression.Constant.ConstString n, int[] childTypeFams, String[][] childSQL, boolean isRoot, boolean negated) throws PgqlToSqlException {
        String[] sql = new String[1];
        int typeFam = ExprTransVisitor.getTypeFamily((QueryExpression)n, n.getExpType(), null, null);
        sql[0] = DbmsUtils.escapeAndEnquoteLiteral((String)n.getValue());
        if (isRoot) {
            sql = this.getRootTrans(typeFam, sql);
        }
        return new ExprTranslation(sql, typeFam);
    }

    public ExprTranslation visit(QueryExpression.Constant.ConstBoolean n, int[] childTypeFams, String[][] childSQL, boolean isRoot, boolean negated) throws PgqlToSqlException {
        String[] sql = new String[]{(Boolean)n.getValue() != false ? "n'Y'" : "n'N'"};
        int typeFam = ExprTransVisitor.getTypeFamily((QueryExpression)n, n.getExpType(), null, null);
        if (isRoot) {
            sql = this.getRootTrans(typeFam, sql);
            if (this.eCtx.transMode == 0) {
                sql[0] = sql[0] + " = n'Y'";
            }
        }
        return new ExprTranslation(sql, typeFam);
    }

    public ExprTranslation visit(QueryExpression.Constant.ConstDate n, int[] childTypeFams, String[][] childSQL, boolean isRoot, boolean negated) throws PgqlToSqlException {
        String[] sql = new String[]{""};
        int typeFam = ExprTransVisitor.getTypeFamily((QueryExpression)n, n.getExpType(), null, null);
        try {
            LocalDate ld = (LocalDate)n.getValue();
            String datetimeStr = ld.atStartOfDay(ZoneOffset.UTC).format(dtzf);
            sql[0] = this.getToTimestampTz(datetimeStr);
        }
        catch (Exception ex) {
            throw new PgqlToSqlException(ex);
        }
        if (isRoot) {
            sql = this.getRootTrans(typeFam, sql);
        }
        return new ExprTranslation(sql, typeFam);
    }

    public ExprTranslation visit(QueryExpression.Constant.ConstTime n, int[] childTypeFams, String[][] childSQL, boolean isRoot, boolean negated) throws PgqlToSqlException {
        throw new PgqlToSqlException("TIME values are unsupported");
    }

    public ExprTranslation visit(QueryExpression.Constant.ConstTimestamp n, int[] childTypeFams, String[][] childSQL, boolean isRoot, boolean negated) throws PgqlToSqlException {
        String[] sql = new String[]{""};
        int typeFam = ExprTransVisitor.getTypeFamily((QueryExpression)n, n.getExpType(), null, null);
        try {
            LocalDateTime ldt = (LocalDateTime)n.getValue();
            String datetimeStr = ldt.format(dtf);
            sql[0] = this.getToTimestamp(datetimeStr);
        }
        catch (Exception ex) {
            throw new PgqlToSqlException(ex);
        }
        if (isRoot) {
            sql = this.getRootTrans(typeFam, sql);
        }
        return new ExprTranslation(sql, typeFam);
    }

    public ExprTranslation visit(QueryExpression.Constant.ConstTimeWithTimezone n, int[] childTypeFams, String[][] childSQL, boolean isRoot, boolean negated) throws PgqlToSqlException {
        throw new PgqlToSqlException("TIME values are unsupported");
    }

    public ExprTranslation visit(QueryExpression.Constant.ConstTimestampWithTimezone n, int[] childTypeFams, String[][] childSQL, boolean isRoot, boolean negated) throws PgqlToSqlException {
        String[] sql = new String[]{""};
        int typeFam = ExprTransVisitor.getTypeFamily((QueryExpression)n, n.getExpType(), null, null);
        try {
            OffsetDateTime odt = (OffsetDateTime)n.getValue();
            String datetimeStr = odt.format(dtzf);
            sql[0] = this.getToTimestampTz(datetimeStr);
        }
        catch (Exception ex) {
            throw new PgqlToSqlException(ex);
        }
        if (isRoot) {
            sql = this.getRootTrans(typeFam, sql);
        }
        return new ExprTranslation(sql, typeFam);
    }

    public ExprTranslation visit(QueryExpression.BindVariable n, int[] childTypeFams, String[][] childSQL, boolean isRoot, boolean negated) throws PgqlToSqlException {
        String[] sql = new String[]{BindValueInfo.getBvEncoding(n)};
        QueryExpression.ExpressionType bvType = this.eCtx.bvInfo.getBindVarType(n);
        int typeFam = ExprTransVisitor.getTypeFamily((QueryExpression)n, bvType, null, null);
        if (isRoot) {
            sql = this.getRootTrans(typeFam, sql);
            if (typeFam == 11 && this.eCtx.transMode == 0) {
                sql[0] = sql[0] + " = n'Y'";
            }
        }
        return new ExprTranslation(sql, typeFam);
    }

    public ExprTranslation visit(QueryExpression.ArithmeticExpression.Sub n, int[] childTypeFams, String[][] childSQL, boolean isRoot, boolean negated) throws PgqlToSqlException {
        return this.getSQLForArthExpr((QueryExpression)n, "-", childTypeFams, childSQL, isRoot);
    }

    public ExprTranslation visit(QueryExpression.ArithmeticExpression.Add n, int[] childTypeFams, String[][] childSQL, boolean isRoot, boolean negated) throws PgqlToSqlException {
        return this.getSQLForArthExpr((QueryExpression)n, "+", childTypeFams, childSQL, isRoot);
    }

    public ExprTranslation visit(QueryExpression.ArithmeticExpression.Mul n, int[] childTypeFams, String[][] childSQL, boolean isRoot, boolean negated) throws PgqlToSqlException {
        return this.getSQLForArthExpr((QueryExpression)n, "*", childTypeFams, childSQL, isRoot);
    }

    public ExprTranslation visit(QueryExpression.ArithmeticExpression.Div n, int[] childTypeFams, String[][] childSQL, boolean isRoot, boolean negated) throws PgqlToSqlException {
        return this.getSQLForArthExpr((QueryExpression)n, "/", childTypeFams, childSQL, isRoot);
    }

    public ExprTranslation visit(QueryExpression.ArithmeticExpression.Mod n, int[] childTypeFams, String[][] childSQL, boolean isRoot, boolean negated) throws PgqlToSqlException {
        return this.getSQLForArthExpr((QueryExpression)n, "%", childTypeFams, childSQL, isRoot);
    }

    public ExprTranslation visit(QueryExpression.ArithmeticExpression.UMin n, int[] childTypeFams, String[][] childSQL, boolean isRoot, boolean negated) throws PgqlToSqlException {
        String[] sql = new String[]{"-(" + this.getNumber(childTypeFams[0], childSQL[0]) + ")"};
        int typeFam = ExprTransVisitor.getTypeFamily((QueryExpression)n, n.getExpType(), null, null);
        if (isRoot) {
            sql = this.getRootTrans(typeFam, sql);
        }
        return new ExprTranslation(sql, typeFam);
    }

    public ExprTranslation visit(QueryExpression.LogicalExpression.And n, int[] childTypeFams, String[][] childSQL, boolean isRoot, boolean negated) throws PgqlToSqlException {
        return this.getSQLForBoolExpr((QueryExpression)n, "AND", childTypeFams, childSQL, isRoot, negated);
    }

    public ExprTranslation visit(QueryExpression.LogicalExpression.Or n, int[] childTypeFams, String[][] childSQL, boolean isRoot, boolean negated) throws PgqlToSqlException {
        return this.getSQLForBoolExpr((QueryExpression)n, "OR", childTypeFams, childSQL, isRoot, negated);
    }

    public ExprTranslation visit(QueryExpression.LogicalExpression.Not n, int[] childTypeFams, String[][] childSQL, boolean isRoot, boolean negated) throws PgqlToSqlException {
        String[] sql = new String[1];
        int typeFam = ExprTransVisitor.getTypeFamily((QueryExpression)n, n.getExpType(), null, null);
        sql[0] = n.getExp().getExpType() == QueryExpression.ExpressionType.EXISTS ? "NOT " + this.getBooleanExpr(childTypeFams[0], childSQL[0], negated) : "NOT(" + this.getBooleanExpr(childTypeFams[0], childSQL[0], negated) + ")";
        if (isRoot) {
            sql = this.getRootTrans(typeFam, sql);
        }
        return new ExprTranslation(sql, typeFam);
    }

    public ExprTranslation visit(QueryExpression.RelationalExpression.Equal n, int[] childTypeFams, String[][] childSQL, boolean isRoot, boolean negated) throws PgqlToSqlException {
        return this.getSQLForRelExpr((QueryExpression)n, "=", childTypeFams, childSQL, isRoot, negated);
    }

    public ExprTranslation visit(QueryExpression.RelationalExpression.NotEqual n, int[] childTypeFams, String[][] childSQL, boolean isRoot, boolean negated) throws PgqlToSqlException {
        return this.getSQLForRelExpr((QueryExpression)n, "<>", childTypeFams, childSQL, isRoot, negated);
    }

    public ExprTranslation visit(QueryExpression.RelationalExpression.Greater n, int[] childTypeFams, String[][] childSQL, boolean isRoot, boolean negated) throws PgqlToSqlException {
        return this.getSQLForRelExpr((QueryExpression)n, ">", childTypeFams, childSQL, isRoot, negated);
    }

    public ExprTranslation visit(QueryExpression.RelationalExpression.GreaterEqual n, int[] childTypeFams, String[][] childSQL, boolean isRoot, boolean negated) throws PgqlToSqlException {
        return this.getSQLForRelExpr((QueryExpression)n, ">=", childTypeFams, childSQL, isRoot, negated);
    }

    public ExprTranslation visit(QueryExpression.RelationalExpression.Less n, int[] childTypeFams, String[][] childSQL, boolean isRoot, boolean negated) throws PgqlToSqlException {
        return this.getSQLForRelExpr((QueryExpression)n, "<", childTypeFams, childSQL, isRoot, negated);
    }

    public ExprTranslation visit(QueryExpression.RelationalExpression.LessEqual n, int[] childTypeFams, String[][] childSQL, boolean isRoot, boolean negated) throws PgqlToSqlException {
        return this.getSQLForRelExpr((QueryExpression)n, "<=", childTypeFams, childSQL, isRoot, negated);
    }

    public ExprTranslation visit(QueryExpression.Aggregation.AggrCount n, int[] childTypeFams, String[][] childSQL, boolean isRoot, boolean negated) throws PgqlToSqlException {
        String mod = "";
        if (n.isDistinct()) {
            mod = "DISTINCT ";
        }
        String[] sql = new String[]{""};
        int typeFam = ExprTransVisitor.getTypeFamily((QueryExpression)n, n.getExpType(), null, null);
        if (childTypeFams[0] == 16) {
            if (n.isDistinct()) {
                throw new PgqlToSqlException("COUNT(DISTINCT *) is not supported");
            }
            sql[0] = "COUNT(*)";
        } else {
            int family = childTypeFams[0];
            sql[0] = family == 13 || family == 14 ? "COUNT(" + mod + childSQL[0][1] + ")" : (family == 12 ? (n.isDistinct() ? "COUNT(" + mod + "to_nchar(" + childSQL[0][0] + "," + DEFAULT_NUM_FMT + "," + NLS_NUM_CHAR_ARG + ")||to_nchar(':')||" + childSQL[0][1] + ")" : "COUNT(" + childSQL[0][1] + ")") : (family == 10 ? "COUNT(" + mod + this.projectBoolConstant(family, childSQL[0]) + ")" : "COUNT(" + mod + childSQL[0][0] + ")"));
        }
        if (isRoot) {
            sql = this.getRootTrans(typeFam, sql);
        }
        return new ExprTranslation(sql, typeFam);
    }

    public ExprTranslation visit(QueryExpression.Aggregation.AggrMin n, int[] childTypeFams, String[][] childSQL, boolean isRoot, boolean negated) throws PgqlToSqlException {
        return this.getSQLForMinMax((QueryExpression)n, "MIN", childTypeFams, childSQL[0], isRoot, negated);
    }

    public ExprTranslation visit(QueryExpression.Aggregation.AggrMax n, int[] childTypeFams, String[][] childSQL, boolean isRoot, boolean negated) throws PgqlToSqlException {
        return this.getSQLForMinMax((QueryExpression)n, "MAX", childTypeFams, childSQL[0], isRoot, negated);
    }

    public ExprTranslation visit(QueryExpression.Aggregation.AggrSum n, int[] childTypeFams, String[][] childSQL, boolean isRoot, boolean negated) throws PgqlToSqlException {
        return this.getSQLForAvgSum((QueryExpression)n, "SUM", childTypeFams, childSQL[0], isRoot, n.isDistinct());
    }

    public ExprTranslation visit(QueryExpression.Aggregation.AggrAvg n, int[] childTypeFams, String[][] childSQL, boolean isRoot, boolean negated) throws PgqlToSqlException {
        return this.getSQLForAvgSum((QueryExpression)n, "AVG", childTypeFams, childSQL[0], isRoot, n.isDistinct());
    }

    public ExprTranslation visit(QueryExpression.Star n, int[] childTypeFams, String[][] childSQL, boolean isRoot, boolean negated) {
        return new ExprTranslation(new String[]{"*"}, 16);
    }

    public ExprTranslation visit(QueryExpression.VarRef n, int[] childTypeFams, String[][] childSQL, boolean isRoot, boolean negated) throws PgqlToSqlException {
        String[] sql = new String[2];
        int typeFam = ExprTransVisitor.getTypeFamily((QueryExpression)n, n.getExpType(), null, null);
        QueryVariable.VariableType vt = n.getVariable().getVariableType();
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("Variable Type [" + vt + "]");
        }
        switch (vt) {
            case VERTEX: {
                sql[0] = VERTEX_TYPE;
                break;
            }
            case EDGE: {
                sql[0] = EDGE_TYPE;
                break;
            }
            default: {
                throw new PgqlToSqlException("unsupported variable type");
            }
        }
        String[] varInfo = this.getInfoForVar(this.getVariableName((QueryExpression)n));
        sql[1] = varInfo[0] + "." + varInfo[1];
        if (isRoot) {
            sql = this.getRootTrans(typeFam, sql);
        }
        return new ExprTranslation(sql, typeFam);
    }

    public ExprTranslation visit(QueryExpression.PropertyAccess n, int[] childTypeFams, String[][] childSQL, boolean isRoot, boolean negated) throws PgqlToSqlException {
        String[] sql = new String[4];
        int typeFam = ExprTransVisitor.getTypeFamily((QueryExpression)n, n.getExpType(), null, null);
        String alias = this.getTabAliasForProperty(this.getVariableName((QueryExpression)n), n.getPropertyName());
        sql[0] = alias + "." + "T";
        sql[1] = alias + "." + "V";
        sql[2] = alias + "." + "VN";
        sql[3] = alias + "." + "VT";
        if (isRoot) {
            sql = this.getRootTrans(typeFam, sql);
            if (this.eCtx.transMode == 0) {
                sql[0] = "((CASE WHEN " + sql[0] + " = " + 6 + "  THEN UPPER(" + sql[1] + ") ELSE NULL END) = n'" + UPPER_Y_CONST + "')";
            }
        }
        return new ExprTranslation(sql, typeFam);
    }

    public ExprTranslation visit(QueryExpression.FunctionCall n, int[] childTypeFams, String[][] childSQL, boolean isRoot, boolean negated) throws PgqlToSqlException {
        if (n.getPackageName() != null) {
            throw new PgqlToSqlException("Unsupported function: " + n.getPackageName() + "." + n.getFunctionName());
        }
        String fName = n.getFunctionName().toUpperCase();
        if ("ID".equals(fName)) {
            return this.visitId(n, childTypeFams, childSQL, isRoot, negated);
        }
        if ("LABEL".equals(fName)) {
            return this.visitLabel(n, childTypeFams, childSQL, isRoot, negated);
        }
        if ("LABELS".equals(fName)) {
            return this.visitLabels(n, childTypeFams, childSQL, isRoot, negated);
        }
        if ("HAS_LABEL".equals(fName)) {
            return this.visitHasLabel(n, childTypeFams, childSQL, isRoot, negated);
        }
        if ("IN_DEGREE".equals(fName)) {
            return this.visitInDegree(n, childTypeFams, childSQL, isRoot, negated);
        }
        if ("OUT_DEGREE".equals(fName)) {
            return this.visitOutDegree(n, childTypeFams, childSQL, isRoot, negated);
        }
        if ("JAVA_REGEXP_LIKE".equals(fName)) {
            return this.visitRegex(n, childTypeFams, childSQL, isRoot, negated);
        }
        if ("HAS_PROP".equals(fName)) {
            return this.visitHasProp(n, childTypeFams, childSQL, isRoot, negated);
        }
        if ("ALL_DIFFERENT".equals(fName)) {
            return this.visitAllDifferent(n, childTypeFams, childSQL, isRoot, negated);
        }
        if ("CONTAINS".equals(fName)) {
            return this.visitContains(n, childTypeFams, childSQL, isRoot, negated);
        }
        if ("ABS".equals(fName) || "CEIL".equals(fName) || "CEILING".equals(fName) || "FLOOR".equals(fName) || "ROUND".equals(fName)) {
            return this.visitNumeric(n, childTypeFams, childSQL, isRoot, negated);
        }
        throw new PgqlToSqlException("Unsupported function: " + n.getPackageName() + "." + n.getFunctionName());
    }

    public ExprTranslation visit(QueryExpression.Function.Cast n, int[] childTypeFams, String[][] childSQL, boolean isRoot, boolean negated) throws PgqlToSqlException {
        String[] sql = new String[]{""};
        String targetType = n.getTargetTypeName().toUpperCase();
        int returnType = 0;
        if (targetType.equals("INT") || targetType.equals("INTEGER")) {
            sql[0] = this.castToInteger(childTypeFams[0], childSQL[0]);
            returnType = 3;
        } else if (targetType.equals("LONG")) {
            sql[0] = this.castToLong(childTypeFams[0], childSQL[0]);
            returnType = 4;
        } else if (targetType.equals("FLOAT")) {
            sql[0] = this.castToFloat(childTypeFams[0], childSQL[0]);
            returnType = 0;
        } else if (targetType.equals("DOUBLE")) {
            sql[0] = this.castToDouble(childTypeFams[0], childSQL[0]);
            returnType = 1;
        } else if (targetType.equals("STRING")) {
            sql[0] = this.castToString(childTypeFams[0], childSQL[0]);
            returnType = 6;
        } else if (targetType.equals("BOOLEAN")) {
            sql[0] = this.castToBoolean(childTypeFams[0], childSQL[0]);
            returnType = 11;
        } else if (targetType.equals("DATE")) {
            sql[0] = this.castToDate(childTypeFams[0], childSQL[0]);
            returnType = 9;
        } else if (targetType.equals("TIMESTAMP")) {
            sql[0] = this.castToTs(childTypeFams[0], childSQL[0]);
            returnType = 8;
        } else if (targetType.equals("TIMESTAMP WITH TIMEZONE")) {
            sql[0] = this.castToTsWithTz(childTypeFams[0], childSQL[0]);
            returnType = 9;
        } else {
            throw new PgqlToSqlException("Unexpected target type for CAST function");
        }
        if (isRoot) {
            sql = this.getRootTrans(returnType, sql);
        }
        return new ExprTranslation(sql, returnType);
    }

    public ExprTranslation visit(QueryExpression.IfElse n, int[] childTypeFams, String[][] childSQL, boolean isRoot, boolean negated) throws PgqlToSqlException {
        String[] sql;
        String booleanExpression = this.getBooleanExpr(childTypeFams[0], childSQL[0], negated);
        String thenSQL = "";
        String elseSQL = "";
        int thenFamily = childTypeFams[1];
        int elseFamily = childTypeFams[2];
        int returnType = thenFamily != 12 ? thenFamily : elseFamily;
        if (returnType == 2) {
            returnType = 1;
        } else if (returnType == 5) {
            returnType = 4;
        }
        if (returnType == 12) {
            sql = new String[]{"CASE WHEN " + booleanExpression + " THEN " + childSQL[1][0] + " ELSE " + childSQL[2][0] + " END", "CASE WHEN " + booleanExpression + " THEN " + childSQL[1][1] + " ELSE " + childSQL[2][1] + " END", "CASE WHEN " + booleanExpression + " THEN " + childSQL[1][2] + " ELSE " + childSQL[2][2] + " END", "CASE WHEN " + booleanExpression + " THEN " + childSQL[1][3] + " ELSE " + childSQL[2][3] + " END"};
        } else {
            if (this.isNumeric(returnType)) {
                thenSQL = this.getNumber(thenFamily, childSQL[1]);
                elseSQL = this.getNumber(elseFamily, childSQL[2]);
            } else if (this.isString(returnType)) {
                thenSQL = this.projectString(thenFamily, childSQL[1]);
                elseSQL = this.projectString(elseFamily, childSQL[2]);
            } else if (this.isBoolean(returnType)) {
                thenSQL = this.projectBoolConstant(thenFamily, childSQL[1]);
                elseSQL = this.projectBoolConstant(elseFamily, childSQL[2]);
            } else if (this.isDate(returnType)) {
                thenSQL = this.getDate(thenFamily, childSQL[1]);
                elseSQL = this.getDate(elseFamily, childSQL[2]);
            } else if (returnType == 13 || returnType == 14) {
                thenSQL = childSQL[1][1];
                elseSQL = childSQL[2][1];
            } else {
                thenSQL = NULL_CONST;
                elseSQL = NULL_CONST;
            }
            sql = new String[]{"CASE WHEN " + booleanExpression + " THEN " + thenSQL + " ELSE " + elseSQL + " END"};
        }
        if (isRoot) {
            sql = this.getRootTrans(returnType, sql);
        }
        return new ExprTranslation(sql, returnType);
    }

    public ExprTranslation visit(QueryExpression.Function.Exists n, int[] childTypeFams, String[][] childSQL, boolean isRoot, boolean negated) throws PgqlToSqlException {
        if (this.eCtx.parentTStruct != null) {
            throw new PgqlToSqlException("Nested EXISTS clauses are not supported");
        }
        String[] sql = new String[]{""};
        SelectQuery gq = n.getQuery();
        PgqlTranslator pt = PgqlTranslator.getPgqlTranslator(this.eCtx.ctx, this.eCtx.tStruct, this.eCtx.exprAliasMap);
        try {
            int[] returnTypeFam = new int[1];
            sql[0] = "EXISTS (\n" + pt.translateQuery((GraphQuery)gq, this.eCtx.bvInfo, returnTypeFam).getSqlTranslation() + "\n)";
        }
        catch (PgqlException ex) {
            throw new PgqlToSqlException(ex);
        }
        if (isRoot) {
            sql = this.getRootTrans(10, sql);
        }
        return new ExprTranslation(sql, 10);
    }

    public ExprTranslation visit(QueryExpression.ExtractExpression n, int[] childTypeFams, String[][] childSQL, boolean isRoot, boolean negated) throws PgqlToSqlException {
        String expr;
        int returnType;
        QueryExpression.ExtractExpression.ExtractField field = n.getField();
        switch (field) {
            case YEAR: 
            case MONTH: 
            case DAY: 
            case HOUR: 
            case MINUTE: 
            case TIMEZONE_HOUR: 
            case TIMEZONE_MINUTE: {
                returnType = 3;
                break;
            }
            case SECOND: {
                returnType = 1;
                break;
            }
            default: {
                throw new PgqlToSqlException("Unsupported extract field:" + field);
            }
        }
        switch (childTypeFams[0]) {
            case 12: {
                expr = childSQL[0][3];
                break;
            }
            default: {
                expr = childSQL[0][0];
            }
        }
        String[] sql = new String[]{"EXTRACT (" + field + " FROM " + expr + ")"};
        if (isRoot) {
            sql = this.getRootTrans(returnType, sql);
        }
        return new ExprTranslation(sql, returnType);
    }

    public ExprTranslation visit(QueryExpression.IsNull n, int[] childTypeFams, String[][] childSQL, boolean isRoot, boolean negated) throws PgqlToSqlException {
        String expr;
        int returnType = 10;
        switch (childTypeFams[0]) {
            case 12: {
                expr = "(DECODE(" + childSQL[0][0] + "," + 1 + "," + childSQL[0][1] + "," + 2 + "," + childSQL[0][2] + "," + 7 + "," + childSQL[0][2] + "," + 3 + "," + childSQL[0][2] + "," + 4 + "," + childSQL[0][2] + "," + 5 + "," + childSQL[0][3] + "," + 6 + "," + childSQL[0][1] + "))";
                break;
            }
            default: {
                expr = childSQL[0][0];
            }
        }
        String[] sql = new String[]{expr + " IS NULL"};
        if (isRoot) {
            sql = this.getRootTrans(returnType, sql);
        }
        return new ExprTranslation(sql, returnType);
    }

    public ExprTranslation visit(QueryExpression.ScalarSubquery n, int[] childTypeFams, String[][] childSQL, boolean isRoot, boolean negated) throws PgqlToSqlException {
        if (this.eCtx.parentTStruct != null) {
            throw new PgqlToSqlException("Nested scalar subqueries are not supported");
        }
        String[] sql = null;
        int[] returnTypeFam = new int[1];
        SelectQuery gq = n.getQuery();
        PgqlTranslator pt = PgqlTranslator.getPgqlTranslator(this.eCtx.ctx, this.eCtx.tStruct, this.eCtx.exprAliasMap);
        String colName = "";
        String sqSql = "";
        try {
            PgqlSqlQueryTrans opst = pt.translateQuery((GraphQuery)gq, this.eCtx.bvInfo, returnTypeFam);
            PgqlColumnDescriptor[] opcd = opst.getReturnTypes();
            colName = opcd[0].getColName();
            sqSql = opst.getSqlTranslation();
        }
        catch (PgqlException ex) {
            throw new PgqlToSqlException(ex);
        }
        int rootTypeFam = returnTypeFam[0];
        switch (returnTypeFam[0]) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                sql = new String[]{"(SELECT \"" + colName + "$VN\" FROM (\n" + sqSql + "\n))"};
                break;
            }
            case 6: 
            case 7: {
                sql = new String[]{"(SELECT \"" + colName + "$V\" FROM (\n" + sqSql + "\n))"};
                break;
            }
            case 8: 
            case 9: {
                sql = new String[]{"(SELECT \"" + colName + "$VT\" FROM (\n" + sqSql + "\n))"};
                break;
            }
            case 10: 
            case 11: {
                rootTypeFam = 11;
                sql = new String[]{"(SELECT \"" + colName + "$V\" FROM (\n" + sqSql + "\n))"};
                break;
            }
            case 12: {
                sql = new String[]{"(SELECT \"" + colName + "$T\" FROM (\n" + sqSql + "\n))", "(SELECT \"" + colName + "$V\" FROM (\n" + sqSql + "\n))", "(SELECT \"" + colName + "$VN\" FROM (\n" + sqSql + "\n))", "(SELECT \"" + colName + "$VT\" FROM (\n" + sqSql + "\n))"};
                break;
            }
            case 13: 
            case 14: {
                sql = new String[]{"(SELECT \"" + colName + "$IT\" FROM (\n" + sqSql + "\n))", "(SELECT \"" + colName + "$ID\" FROM (\n" + sqSql + "\n))"};
                break;
            }
            case 15: {
                sql = new String[]{"to_number(null)", "to_nchar(null)", "to_number(null)", "to_timestamp_tz(null)"};
                break;
            }
            default: {
                throw new PgqlToSqlException("Unexpected type family for scalar subquery" + returnTypeFam[0]);
            }
        }
        if (isRoot) {
            sql = this.getRootTrans(rootTypeFam, sql);
        }
        return new ExprTranslation(sql, rootTypeFam);
    }

    private ExprTranslation visitRegex(QueryExpression.FunctionCall n, int[] childTypeFams, String[][] childSQL, boolean isRoot, boolean negated) throws PgqlToSqlException {
        String source;
        String pattern;
        String[] sql = new String[]{""};
        int typeFam = ExprTransVisitor.getTypeFamily((QueryExpression)n, n.getExpType(), "JAVA_REGEXP_LIKE", null);
        if (childTypeFams[1] == 7 || childTypeFams[1] == 6) {
            pattern = childSQL[1][0];
            source = "";
            int sourceType = childTypeFams[0];
            switch (sourceType) {
                case 6: 
                case 7: {
                    source = childSQL[0][0];
                    break;
                }
                case 12: {
                    source = childSQL[0][1];
                    break;
                }
                default: {
                    throw new PgqlToSqlException("Unsupported source argument for regular expression");
                }
            }
        } else {
            throw new PgqlToSqlException("Regular expression pattern must be a constant string");
        }
        sql[0] = "REGEXP_INSTR(" + source + "," + pattern + ") > 0";
        if (isRoot) {
            sql = this.getRootTrans(typeFam, sql);
        }
        return new ExprTranslation(sql, typeFam);
    }

    public ExprTranslation visitHasLabel(QueryExpression.FunctionCall n, int[] childTypeFams, String[][] childSQL, boolean isRoot, boolean negated) throws PgqlToSqlException {
        String[] sql = new String[]{""};
        int typeFam = ExprTransVisitor.getTypeFamily((QueryExpression)n, n.getExpType(), "HAS_LABEL", null);
        if (childTypeFams[0] == 13 && childTypeFams[1] == 7) {
            if (!this.eCtx.ctx.useVLCol) {
                throw new PgqlToSqlException("has_label() built-in function is not supported for vertices");
            }
            String alias = this.getTabAliasForProperty(this.getVariableName((QueryExpression)n.getArgs().get(0)), "label");
            sql[0] = "(" + alias + "." + "VL" + " = " + childSQL[1][0] + " AND " + alias + "." + "VL" + " IS NOT NULL)";
        } else if (childTypeFams[0] == 14 && childTypeFams[1] == 7) {
            String[] varInfo = this.getInfoForVar(this.getVariableName((QueryExpression)n.getArgs().get(0)));
            sql[0] = "(" + varInfo[0] + "." + "EL" + " = " + childSQL[1][0] + " AND " + varInfo[0] + "." + "EL" + " IS NOT NULL)";
        } else {
            throw new PgqlToSqlException("Unexpected child under hasLabel");
        }
        if (isRoot) {
            sql = this.getRootTrans(typeFam, sql);
        }
        return new ExprTranslation(sql, typeFam);
    }

    public ExprTranslation visitId(QueryExpression.FunctionCall n, int[] childTypeFams, String[][] childSQL, boolean isRoot, boolean negated) throws PgqlToSqlException {
        String[] sql = new String[]{childSQL[0][1]};
        int typeFam = ExprTransVisitor.getTypeFamily((QueryExpression)n, n.getExpType(), "ID", null);
        if (isRoot) {
            sql = this.getRootTrans(typeFam, sql);
        }
        return new ExprTranslation(sql, typeFam);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ExprTranslation visitHasProp(QueryExpression.FunctionCall n, int[] childTypeFams, String[][] childSQL, boolean isRoot, boolean negated) throws PgqlToSqlException {
        String[] sql = new String[]{""};
        int typeFam = ExprTransVisitor.getTypeFamily((QueryExpression)n, n.getExpType(), "HAS_PROP", null);
        if (childTypeFams[0] != 13 && childTypeFams[0] != 14 || childTypeFams[1] != 7) throw new PgqlToSqlException("Unexpected child under HAS function");
        String[] varInfo = this.getInfoForVar(this.getVariableName((QueryExpression)n.getArgs().get(0)));
        String prop = childSQL[1][0];
        String tabName = "";
        String colName = "";
        if (varInfo[1].equals(PgqlTranslator.COLS[0])) {
            tabName = this.eCtx.ctx.geTab;
            colName = PgqlTranslator.COLS[0];
        } else {
            if (!varInfo[1].equals(PgqlTranslator.COLS[1]) && !varInfo[1].equals(PgqlTranslator.COLS[2]) && !varInfo[1].equals(PgqlTranslator.COLS[3])) throw new PgqlToSqlException("Unexpected variable under HAS function");
            tabName = this.eCtx.ctx.vtTab;
            colName = PgqlTranslator.COLS[3];
        }
        sql[0] = "EXISTS ( SELECT 1 FROM " + tabName + " T WHERE T." + colName + " = " + varInfo[0] + "." + varInfo[1] + " AND T." + "K" + " = " + prop + ")";
        if (!isRoot) return new ExprTranslation(sql, typeFam);
        sql = this.getRootTrans(typeFam, sql);
        return new ExprTranslation(sql, typeFam);
    }

    public ExprTranslation visitLabels(QueryExpression.FunctionCall n, int[] childTypeFams, String[][] childSQL, boolean isRoot, boolean negated) throws PgqlToSqlException {
        throw new PgqlToSqlException("labels() built-in function is not supported");
    }

    public ExprTranslation visitInDegree(QueryExpression.FunctionCall n, int[] childTypeFams, String[][] childSQL, boolean isRoot, boolean negated) throws PgqlToSqlException {
        return this.getSQLForInOutDegree((QueryExpression)n, "INDG", childTypeFams, childSQL[0], isRoot);
    }

    public ExprTranslation visitOutDegree(QueryExpression.FunctionCall n, int[] childTypeFams, String[][] childSQL, boolean isRoot, boolean negated) throws PgqlToSqlException {
        return this.getSQLForInOutDegree((QueryExpression)n, "OUTDG", childTypeFams, childSQL[0], isRoot);
    }

    public ExprTranslation visitLabel(QueryExpression.FunctionCall n, int[] childTypeFams, String[][] childSQL, boolean isRoot, boolean negated) throws PgqlToSqlException {
        String[] sql = new String[]{""};
        int typeFam = ExprTransVisitor.getTypeFamily((QueryExpression)n, n.getExpType(), "LABEL", null);
        if (childTypeFams[0] == 13) {
            if (!this.eCtx.ctx.useVLCol) {
                throw new PgqlToSqlException("label() built-in function is not supported for vertices");
            }
            String alias = this.getTabAliasForProperty(this.getVariableName((QueryExpression)n.getArgs().get(0)), "label");
            sql[0] = alias + "." + "VL";
        } else if (childTypeFams[0] == 14) {
            String[] varInfo = this.getInfoForVar(this.getVariableName((QueryExpression)n.getArgs().get(0)));
            sql[0] = varInfo[0] + "." + "EL";
        } else {
            throw new PgqlToSqlException("Unexpected child under label");
        }
        if (isRoot) {
            sql = this.getRootTrans(typeFam, sql);
        }
        return new ExprTranslation(sql, typeFam);
    }

    public ExprTranslation visitAllDifferent(QueryExpression.FunctionCall n, int[] childTypeFams, String[][] childSQL, boolean isRoot, boolean negated) throws PgqlToSqlException {
        StringBuffer buff = new StringBuffer("");
        int numExps = n.getArgs().size();
        if (numExps < 2) {
            throw new PgqlToSqlException("Not enough expressions inside ALL_DIFFERENT");
        }
        int[] pairTypeFams = new int[2];
        String[][] pairSQL = new String[2][];
        for (int i = 0; i < numExps - 1; ++i) {
            for (int j = i + 1; j < numExps; ++j) {
                pairTypeFams[0] = childTypeFams[i];
                pairTypeFams[1] = childTypeFams[j];
                pairSQL[0] = childSQL[i];
                pairSQL[1] = childSQL[j];
                if (j > 1) {
                    buff.append(" AND ");
                }
                buff.append("(" + this.getSQLForRelExpr((QueryExpression)n, "<>", pairTypeFams, pairSQL, false, negated).getSQL()[0] + ")");
            }
        }
        String[] sql = new String[]{buff.toString()};
        int typeFam = ExprTransVisitor.getTypeFamily((QueryExpression)n, n.getExpType(), "ALL_DIFFERENT", null);
        if (isRoot) {
            sql = this.getRootTrans(typeFam, sql);
        }
        return new ExprTranslation(sql, typeFam);
    }

    public ExprTranslation visitContains(QueryExpression.FunctionCall n, int[] childTypeFams, String[][] childSQL, boolean isRoot, boolean negated) throws PgqlToSqlException {
        List args = n.getArgs();
        if (args.size() != 2) {
            throw new PgqlToSqlException("Wrong number of arguments to CONTAINS");
        }
        if (childTypeFams[0] != 12 || childTypeFams[1] != 6 && childTypeFams[1] != 7) {
            throw new PgqlToSqlException("Wrong types of arguments to CONTAINS - expecting (PROP_ACCESS, STRING)");
        }
        String pattern = "to_char(" + childSQL[1][0] + ")";
        String[] sql = new String[]{"CONTAINS(" + childSQL[0][1] + "," + pattern + ") > 0"};
        int typeFam = ExprTransVisitor.getTypeFamily((QueryExpression)n, n.getExpType(), "CONTAINS", null);
        if (isRoot) {
            sql = this.getRootTrans(typeFam, sql);
        }
        return new ExprTranslation(sql, typeFam);
    }

    private ExprTranslation visitNumeric(QueryExpression.FunctionCall n, int[] childTypeFams, String[][] childSQL, boolean isRoot, boolean negated) throws PgqlToSqlException {
        String[] sql;
        String functionName;
        int typeFam = childTypeFams[0];
        switch (functionName = n.getFunctionName().toLowerCase().replace("ceiling", "ceil")) {
            case "abs": 
            case "ceil": 
            case "floor": 
            case "round": {
                break;
            }
            default: {
                throw new PgqlToSqlException("Unsupported numeric function:" + functionName);
            }
        }
        if (typeFam == 12) {
            sql = new String[4];
            sql[0] = childSQL[0][0];
            String vn = functionName + "(" + childSQL[0][2] + ")";
            sql[1] = "to_nchar(" + vn + "," + DEFAULT_NUM_FMT + "," + NLS_NUM_CHAR_ARG + ")";
            sql[2] = vn;
            sql[3] = "to_timestamp_tz(null)";
        } else {
            sql = new String[]{functionName + "(" + childSQL[0][0] + ")"};
        }
        if (isRoot) {
            sql = this.getRootTrans(typeFam, sql);
        }
        return new ExprTranslation(sql, typeFam);
    }

    public ExprTranslation visit(QueryExpression.InPredicate n, int[] childTypeFams, String[][] childSQL, boolean isRoot, boolean negated) throws PgqlToSqlException {
        String[] sql = new String[1];
        String str_ivl = "";
        int typeFam = 10;
        QueryExpression.ExpressionType exprType = n.getInValueList().getExpType();
        if (exprType != QueryExpression.ExpressionType.IN_VALUE_LIST) {
            throw new UnsupportedOperationException(exprType + " is not supported as InValueList");
        }
        QueryExpression.InPredicate.InValueList ivl = (QueryExpression.InPredicate.InValueList)n.getInValueList();
        QueryExpression.ExpressionType arrayType = ivl.getArrayElementType();
        switch (arrayType) {
            case INTEGER: {
                str_ivl = Arrays.stream(ivl.getIntegerValues()).mapToObj(val -> String.valueOf(val)).collect(Collectors.joining(", ", "( ", " )"));
                sql[0] = this.getNumber(childTypeFams[0], childSQL[0]) + " IN " + str_ivl;
                break;
            }
            case DECIMAL: {
                str_ivl = Arrays.stream(ivl.getDecimalValues()).mapToObj(val -> String.valueOf(val)).collect(Collectors.joining(", ", "( ", " )"));
                sql[0] = this.getNumber(childTypeFams[0], childSQL[0]) + " IN " + str_ivl;
                break;
            }
            case BOOLEAN: {
                String val2 = "(";
                int i = 0;
                int len = ivl.getBooleanValues().length;
                for (boolean elt2 : ivl.getBooleanValues()) {
                    val2 = val2 + (elt2 ? "n'Y'" : "n'N'");
                    if (++i == len) continue;
                    val2 = val2 + ", ";
                }
                str_ivl = val2 = val2 + ')';
                sql[0] = "(" + this.getBoolConstant(childTypeFams[0], childSQL[0], true, negated, false) + " IN " + str_ivl + ")";
                break;
            }
            case DATE: {
                str_ivl = Arrays.stream(ivl.getDateValues()).map(ld -> {
                    String datetimeStr = ld.atStartOfDay(ZoneOffset.UTC).format(DateTimeFormatter.ofPattern(JAVA_DATETIME_TZ_FMT));
                    return this.getToTimestampTz(datetimeStr);
                }).collect(Collectors.joining(", ", "( ", " )"));
                sql[0] = this.getDate(childTypeFams[0], childSQL[0]) + " IN " + str_ivl;
                break;
            }
            case TIMESTAMP: {
                str_ivl = Arrays.stream(ivl.getTimestampValues()).map(ldt -> {
                    ZoneId zone = ZoneId.systemDefault();
                    OffsetDateTime odt = ldt.atOffset(zone.getRules().getOffset((LocalDateTime)ldt));
                    String datetimeStr = odt.format(DateTimeFormatter.ofPattern(JAVA_DATETIME_FMT));
                    return this.getToTimestamp(datetimeStr);
                }).collect(Collectors.joining(", ", "( ", " )"));
                sql[0] = this.getDate(childTypeFams[0], childSQL[0]) + " IN " + str_ivl;
                break;
            }
            case STRING: {
                str_ivl = Arrays.stream(ivl.getStringValues()).map(elt -> DbmsUtils.escapeAndEnquoteLiteral(elt)).collect(Collectors.joining(", ", "( ", " )"));
                sql[0] = "(" + this.getString(childTypeFams[0], childSQL[0], true, negated, false) + " IN " + str_ivl + ")";
                break;
            }
            default: {
                sql[0] = "null=null";
            }
        }
        if (isRoot) {
            sql = this.getRootTrans(typeFam, sql);
        }
        return new ExprTranslation(sql, typeFam);
    }

    private ExprTranslation getSQLForArthExpr(QueryExpression expr, String op, int[] childTypeFams, String[][] childSQL, boolean isRoot) throws PgqlToSqlException {
        int lhsFamily = childTypeFams[0];
        int rhsFamily = childTypeFams[1];
        String[] sql = new String[]{""};
        int typeFam = ExprTransVisitor.getTypeFamily(expr, expr.getExpType(), null, null);
        sql[0] = op != "%" ? "(" + this.getNumber(lhsFamily, childSQL[0]) + " " + op + " " + this.getNumber(rhsFamily, childSQL[1]) + ")" : "MOD(" + this.getNumber(lhsFamily, childSQL[0]) + " , " + this.getNumber(rhsFamily, childSQL[1]) + ")";
        if (isRoot) {
            sql = this.getRootTrans(typeFam, sql);
        }
        return new ExprTranslation(sql, typeFam);
    }

    private ExprTranslation getSQLForBoolExpr(QueryExpression expr, String op, int[] childTypeFams, String[][] childSQL, boolean isRoot, boolean negated) throws PgqlToSqlException {
        String[] sql = new String[]{"(" + this.getBooleanExpr(childTypeFams[0], childSQL[0], negated) + " " + op + " " + this.getBooleanExpr(childTypeFams[1], childSQL[1], negated) + ")"};
        int typeFam = ExprTransVisitor.getTypeFamily(expr, expr.getExpType(), null, null);
        if (isRoot) {
            sql = this.getRootTrans(typeFam, sql);
        }
        return new ExprTranslation(sql, typeFam);
    }

    private ExprTranslation getSQLForRelExpr(QueryExpression expr, String op, int[] childTypeFams, String[][] childSQL, boolean isRoot, boolean negated) throws PgqlToSqlException {
        String[] sql = new String[]{""};
        int typeFam = 10;
        int lhsFamily = childTypeFams[0];
        int rhsFamily = childTypeFams[1];
        int compFamily = -1;
        sql[0] = !this.familiesMatch(lhsFamily, rhsFamily) ? "(NULL=NULL)" : (this.isNumeric(compFamily = lhsFamily != 12 ? lhsFamily : rhsFamily) ? this.getNumber(lhsFamily, childSQL[0]) + " " + op + " " + this.getNumber(rhsFamily, childSQL[1]) : (this.isString(compFamily) ? "(" + this.getStringForRelExpr(lhsFamily, childSQL[0], true, negated) + " " + op + " " + this.getStringForRelExpr(rhsFamily, childSQL[1], false, negated) + ")" : (this.isBoolean(compFamily) ? "(" + this.getBoolConstantForRelExpr(lhsFamily, childSQL[0], true, negated) + " " + op + " " + this.getBoolConstantForRelExpr(rhsFamily, childSQL[1], false, negated) + ")" : (this.isDate(compFamily) ? this.getDate(lhsFamily, childSQL[0]) + " " + op + " " + this.getDate(rhsFamily, childSQL[1]) : (compFamily == 12 ? this.getPropRelExpr(lhsFamily, childSQL[0], rhsFamily, childSQL[1], op, negated) : (compFamily == 13 || compFamily == 14 ? childSQL[0][1] + " " + op + " " + childSQL[1][1] : "(NULL=NULL)"))))));
        if (isRoot) {
            sql = this.getRootTrans(typeFam, sql);
        }
        return new ExprTranslation(sql, typeFam);
    }

    private ExprTranslation getSQLForMinMax(QueryExpression expr, String op, int[] childTypeFams, String[] childSQL, boolean isRoot, boolean negated) throws PgqlToSqlException {
        String[] sql = new String[1];
        int family = childTypeFams[0];
        if (family == 12) {
            String pfx2;
            String pfx1;
            sql = new String[4];
            if (op == "MAX") {
                pfx1 = "n'9'";
                pfx2 = "n'1'";
            } else {
                pfx1 = "n'1'";
                pfx2 = "n'9'";
            }
            String orderAggDecode = op + "(DECODE(" + childSQL[0] + "," + 1 + "," + 3 + "," + 2 + "," + 2 + "," + 7 + "," + 2 + "," + 3 + "," + 2 + "," + 4 + "," + 2 + "," + 5 + "," + 1 + "," + 6 + "," + 4 + "))";
            sql[0] = "DECODE(" + orderAggDecode + "," + 1 + "," + 5 + "," + 2 + "," + 4 + "," + 3 + "," + 1 + "," + 4 + "," + 6 + ")";
            sql[1] = "DECODE(" + orderAggDecode + "," + 1 + ",to_nchar(" + op + "(" + childSQL[3] + ")," + DATETIME_TZ_FMT + "," + NLS_NUM_CHAR_ARG + ")," + 2 + ",to_nchar(" + op + "(" + childSQL[2] + ")," + DEFAULT_NUM_FMT + "," + NLS_NUM_CHAR_ARG + ")," + 3 + ",SUBSTRC(" + op + "(DECODE(" + childSQL[0] + "," + 1 + "," + pfx1 + "," + pfx2 + ")||" + childSQL[1] + "),2)," + 4 + ",SUBSTRC(" + op + "(DECODE(" + childSQL[0] + "," + 6 + "," + pfx1 + "," + pfx2 + ")||" + childSQL[1] + "),2)," + NULL_CONST + ")";
            sql[2] = "DECODE(" + orderAggDecode + "," + 2 + "," + op + "(" + childSQL[2] + ")," + NULL_CONST + ")";
            sql[3] = "DECODE(" + orderAggDecode + "," + 1 + "," + op + "(" + childSQL[3] + ")," + NULL_CONST + ")";
        } else if (family == 10) {
            sql[0] = op + "(" + this.projectBoolConstant(family, childSQL) + ")";
        } else if (family == 13 || family == 14) {
            sql = new String[]{childSQL[0], op + "(" + childSQL[1] + ")"};
        } else {
            sql[0] = op + "(" + childSQL[0] + ")";
        }
        if (isRoot) {
            sql = family == 10 ? this.getRootTrans(11, sql) : this.getRootTrans(family, sql);
        }
        return new ExprTranslation(sql, family);
    }

    private ExprTranslation getSQLForAvgSum(QueryExpression expr, String op, int[] childTypeFams, String[] childSQL, boolean isRoot, boolean isDistinct) throws PgqlToSqlException {
        String[] sql = new String[]{""};
        int family = childTypeFams[0];
        int returnTypeFam = ExprTransVisitor.getTypeFamily(expr, expr.getExpType(), null, null);
        String mod = "";
        if (isDistinct) {
            mod = "DISTINCT ";
        }
        sql[0] = family == 12 ? op + "(" + mod + childSQL[2] + ")" : (family == 13 || family == 14 ? op + "(" + mod + childSQL[1] + ")" : op + "(" + mod + childSQL[0] + ")");
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("SQL for AVG/SUM [" + sql[0] + "]");
        }
        if (isRoot) {
            sql = this.getRootTrans(returnTypeFam, sql);
        }
        return new ExprTranslation(sql, returnTypeFam);
    }

    private ExprTranslation getSQLForInOutDegree(QueryExpression expr, String op, int[] childTypeFams, String[] childSQL, boolean isRoot) throws PgqlToSqlException {
        String propName = op;
        List args = ((QueryExpression.FunctionCall)expr).getArgs();
        String[] sql = new String[]{""};
        int typeFam = ExprTransVisitor.getTypeFamily(expr, expr.getExpType(), "IN_DEGREE", null);
        if (childTypeFams[0] != 13) {
            throw new PgqlToSqlException("Unexpected child under inDegree/outDegree function");
        }
        String var = this.getVariableName((QueryExpression)args.get(0));
        sql[0] = this.getTabAliasForProperty(var, propName) + "." + propName;
        sql[0] = "COALESCE(" + sql[0] + ",0)";
        if (isRoot) {
            sql = this.getRootTrans(typeFam, sql);
        }
        return new ExprTranslation(sql, typeFam);
    }

    private boolean familiesMatch(int family1, int family2) {
        return family1 == family2 || this.isString(family1) && this.isString(family2) || this.isNumeric(family1) && this.isNumeric(family2) || this.isBoolean(family1) && this.isBoolean(family2) || this.isDate(family1) && this.isDate(family2) || family1 == 12 || family2 == 12;
    }

    private boolean isString(int family) {
        return family == 6 || family == 7;
    }

    private boolean isNumeric(int family) {
        return family == 1 || family == 2 || family == 0 || family == 3 || family == 4 || family == 5;
    }

    private boolean isBoolean(int family) {
        return family == 10 || family == 11;
    }

    private boolean isDate(int family) {
        return family == 8 || family == 9;
    }

    private String getDirKeyword() {
        if (this.eCtx.direction == 0) {
            return "ASC NULLS LAST";
        }
        return "DESC NULLS FIRST";
    }

    private String getPropRelExpr(int typeFamily1, String[] exprSQL1, int typeFamily2, String[] exprSQL2, String op, boolean negated) throws PgqlToSqlException {
        String sql = "(CASE WHEN " + this.getStringForRelExpr(typeFamily1, exprSQL1, true, negated) + " " + op + " " + this.getStringForRelExpr(typeFamily2, exprSQL2, false, negated) + " THEN 1 WHEN " + this.getNumber(typeFamily1, exprSQL1) + " " + op + " " + this.getNumber(typeFamily2, exprSQL2) + " THEN 1 WHEN " + this.getDate(typeFamily1, exprSQL1) + " " + op + " " + this.getDate(typeFamily2, exprSQL2) + " THEN 1 WHEN " + this.getBoolConstantForRelExpr(typeFamily1, exprSQL1, true, negated) + " " + op + " " + this.getBoolConstantForRelExpr(typeFamily2, exprSQL2, false, negated) + " THEN 1 ELSE 0 END) = 1";
        return sql;
    }

    private String getStringForRelExpr(int typeFamily, String[] exprSQL, boolean isLHS, boolean negated) throws PgqlToSqlException {
        return this.getString(typeFamily, exprSQL, isLHS, negated, true);
    }

    private String projectString(int typeFamily, String[] exprSQL) throws PgqlToSqlException {
        return this.getString(typeFamily, exprSQL, false, false, false);
    }

    private String getString(int typeFamily, String[] exprSQL, boolean isLHS, boolean negated, boolean forRelExpression) throws PgqlToSqlException {
        String sql = "";
        if (typeFamily == 6 || typeFamily == 7) {
            return exprSQL[0];
        }
        sql = typeFamily == 12 ? (forRelExpression && !negated && this.eCtx.transMode == 0 ? (isLHS ? exprSQL[0] + " = " + 1 + " AND " + exprSQL[1] : exprSQL[1] + " AND " + exprSQL[0] + " = " + 1) : "(CASE WHEN " + exprSQL[0] + " = " + 1 + " THEN " + exprSQL[1] + " ELSE NULL END)") : NULL_CONST;
        return sql;
    }

    private String castToInteger(int typeFamily, String[] exprSQL) throws PgqlToSqlException {
        return "CAST (" + this.castToDecimal(typeFamily, exprSQL) + " AS NUMBER(10) " + (this.eCtx.ctx.addDefaultNull ? DEFAULT_NULL_ON_CONVERSION_ERROR : "") + ")";
    }

    private String castToLong(int typeFamily, String[] exprSQL) throws PgqlToSqlException {
        return "CAST (" + this.castToDecimal(typeFamily, exprSQL) + " AS NUMBER(19) " + (this.eCtx.ctx.addDefaultNull ? DEFAULT_NULL_ON_CONVERSION_ERROR : "") + ")";
    }

    private String castToFloat(int typeFamily, String[] exprSQL) throws PgqlToSqlException {
        return "CAST (" + this.castToDecimal(typeFamily, exprSQL) + " AS BINARY_FLOAT " + (this.eCtx.ctx.addDefaultNull ? DEFAULT_NULL_ON_CONVERSION_ERROR : "") + ")";
    }

    private String castToDouble(int typeFamily, String[] exprSQL) throws PgqlToSqlException {
        return "CAST (" + this.castToDecimal(typeFamily, exprSQL) + " AS BINARY_DOUBLE " + (this.eCtx.ctx.addDefaultNull ? DEFAULT_NULL_ON_CONVERSION_ERROR : "") + ")";
    }

    private String castToDecimal(int typeFamily, String[] exprSQL) throws PgqlToSqlException {
        String str = "";
        switch (typeFamily) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                str = exprSQL[0];
                break;
            }
            case 6: 
            case 7: {
                str = "(CASE WHEN (TRIM(UPPER(" + exprSQL[0] + ")) IN (n'TRUE',n'Y')) THEN 1\nWHEN (TRIM(UPPER(" + exprSQL[0] + ")) IN (n'FALSE',n'N')) THEN 0\nELSE to_number(" + exprSQL[0] + (this.eCtx.ctx.addDefaultNull ? DEFAULT_NULL_ON_CONVERSION_ERROR : "") + ") END)";
                break;
            }
            case 11: {
                str = "(CASE (" + exprSQL[0] + ") WHEN n'" + UPPER_Y_CONST + "' THEN 1 ELSE 0 END)";
                break;
            }
            case 10: {
                str = "(CASE WHEN " + exprSQL[0] + " THEN 1 WHEN NOT (" + exprSQL[0] + ") THEN 0 ELSE NULL END)";
                break;
            }
            case 12: {
                str = "(CASE WHEN (TRIM(UPPER(" + exprSQL[1] + ")) IN (n'TRUE',n'Y')) THEN 1\nWHEN (TRIM(UPPER(" + exprSQL[1] + ")) IN (n'FALSE',n'N')) THEN 0\nELSE to_number(" + exprSQL[1] + (this.eCtx.ctx.addDefaultNull ? DEFAULT_NULL_ON_CONVERSION_ERROR : "") + ") END)";
                break;
            }
            case 13: 
            case 14: {
                str = exprSQL[1];
                break;
            }
            case 8: 
            case 9: 
            case 15: {
                str = NULL_CONST;
                break;
            }
            default: {
                throw new PgqlToSqlException("Attempt to cast unexpected type");
            }
        }
        return str;
    }

    private String castToString(int typeFamily, String[] exprSQL) throws PgqlToSqlException {
        String str = "";
        switch (typeFamily) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                str = "to_nchar(" + exprSQL[0] + "," + DEFAULT_NUM_FMT + "," + NLS_NUM_CHAR_ARG + ")";
                break;
            }
            case 6: 
            case 7: 
            case 11: {
                str = exprSQL[0];
                break;
            }
            case 10: {
                str = "(CASE WHEN " + exprSQL[0] + " THEN n'" + UPPER_Y_CONST + "' WHEN NOT (" + exprSQL[0] + ") THEN n'" + UPPER_N_CONST + "' ELSE NULL END)";
                break;
            }
            case 12: {
                str = exprSQL[1];
                break;
            }
            case 13: 
            case 14: {
                str = "to_nchar(" + exprSQL[1] + "," + DEFAULT_NUM_FMT + "," + NLS_NUM_CHAR_ARG + ")";
                break;
            }
            case 15: {
                str = NULL_CONST;
                break;
            }
            case 8: {
                str = this.getStrFromTimestamp(exprSQL[0]);
                break;
            }
            case 9: {
                str = this.getStrFromTimestampTz(exprSQL[0]);
                break;
            }
            default: {
                throw new PgqlToSqlException("Attempt to cast unexpected type");
            }
        }
        return str;
    }

    private String castToBoolean(int typeFamily, String[] exprSQL) throws PgqlToSqlException {
        String str = "";
        switch (typeFamily) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                str = "(CASE WHEN " + exprSQL[0] + " = 1 THEN n'" + UPPER_Y_CONST + "' WHEN " + exprSQL[0] + " = 0 THEN n'" + UPPER_N_CONST + "' ELSE NULL END)";
                break;
            }
            case 6: 
            case 7: {
                str = "(CASE WHEN TRIM(UPPER(" + exprSQL[0] + ")) IN (n'1',n'Y',n'TRUE') THEN n'" + UPPER_Y_CONST + "' WHEN TRIM(UPPER(" + exprSQL[0] + ")) IN (n'0',n'N',n'FALSE') THEN n'" + UPPER_N_CONST + "' ELSE NULL END)";
                break;
            }
            case 11: {
                str = exprSQL[0];
                break;
            }
            case 10: {
                str = "(CASE WHEN " + exprSQL[0] + " THEN n'" + UPPER_Y_CONST + "' WHEN NOT (" + exprSQL[0] + ") THEN n'" + UPPER_N_CONST + "' ELSE NULL END)";
                break;
            }
            case 12: {
                str = "(CASE WHEN TRIM(UPPER(" + exprSQL[1] + ")) IN (n'1',n'Y',n'TRUE') THEN n'" + UPPER_Y_CONST + "' WHEN TRIM(UPPER(" + exprSQL[1] + ")) IN (n'0',n'N',n'FALSE') THEN n'" + UPPER_N_CONST + "' ELSE NULL END)";
                break;
            }
            case 13: 
            case 14: {
                str = "(CASE WHEN " + exprSQL[1] + " = 1 THEN n'" + UPPER_Y_CONST + "' WHEN " + exprSQL[1] + " = 0 THEN n'" + UPPER_N_CONST + "' ELSE NULL END)";
                break;
            }
            case 8: 
            case 9: 
            case 15: {
                str = NULL_CONST;
                break;
            }
            default: {
                throw new PgqlToSqlException("Attempt to cast unexpected type");
            }
        }
        return str;
    }

    private String castToDate(int typeFamily, String[] exprSQL) throws PgqlToSqlException {
        String str = "";
        switch (typeFamily) {
            case 8: 
            case 9: {
                str = "TO_TIMESTAMP_TZ(TO_NCHAR(" + exprSQL[0] + "," + DATE_FMT + ")||" + DEFAULT_TIME_TZ + (this.eCtx.ctx.addDefaultNull ? DEFAULT_NULL_ON_CONVERSION_ERROR : "") + "," + DATETIME_TZ_FMT + ")";
                break;
            }
            case 6: 
            case 7: {
                str = "TO_TIMESTAMP_TZ(TO_NCHAR(" + this.strToTsWithTz(exprSQL[0]) + "," + DATE_FMT + ")||" + DEFAULT_TIME_TZ + (this.eCtx.ctx.addDefaultNull ? DEFAULT_NULL_ON_CONVERSION_ERROR : "") + "," + DATETIME_TZ_FMT + ")";
                break;
            }
            case 12: {
                str = "NVL2(" + exprSQL[3] + ",TO_TIMESTAMP_TZ(TO_NCHAR(" + exprSQL[3] + "," + DATE_FMT + ")||" + DEFAULT_TIME_TZ + (this.eCtx.ctx.addDefaultNull ? DEFAULT_NULL_ON_CONVERSION_ERROR : "") + "," + DATETIME_TZ_FMT + "),TO_TIMESTAMP_TZ(TO_NCHAR(" + this.strToTsWithTz(exprSQL[1]) + "," + DATE_FMT + ")||" + DEFAULT_TIME_TZ + (this.eCtx.ctx.addDefaultNull ? DEFAULT_NULL_ON_CONVERSION_ERROR : "") + "," + DATETIME_TZ_FMT + "))";
                break;
            }
            default: {
                str = NULL_CONST;
            }
        }
        return str;
    }

    private String castToTs(int typeFamily, String[] exprSQL) throws PgqlToSqlException {
        String str = "";
        switch (typeFamily) {
            case 8: 
            case 9: {
                str = "TO_TIMESTAMP_TZ(TO_NCHAR(" + exprSQL[0] + "," + DATETIME_FMT + ")||" + DEFAULT_TZ + (this.eCtx.ctx.addDefaultNull ? DEFAULT_NULL_ON_CONVERSION_ERROR : "") + "," + DATETIME_TZ_FMT + ")";
                break;
            }
            case 6: 
            case 7: {
                str = "TO_TIMESTAMP_TZ(TO_NCHAR(" + this.strToTsWithTz(exprSQL[0]) + "," + DATETIME_FMT + ")||" + DEFAULT_TZ + (this.eCtx.ctx.addDefaultNull ? DEFAULT_NULL_ON_CONVERSION_ERROR : "") + "," + DATETIME_TZ_FMT + ")";
                break;
            }
            case 12: {
                str = "NVL2(" + exprSQL[3] + ",TO_TIMESTAMP_TZ(TO_NCHAR(" + exprSQL[3] + "," + DATETIME_FMT + ")||" + DEFAULT_TZ + (this.eCtx.ctx.addDefaultNull ? DEFAULT_NULL_ON_CONVERSION_ERROR : "") + "," + DATETIME_TZ_FMT + "),TO_TIMESTAMP_TZ(TO_NCHAR(" + this.strToTsWithTz(exprSQL[1]) + "," + DATETIME_FMT + ")||" + DEFAULT_TZ + (this.eCtx.ctx.addDefaultNull ? DEFAULT_NULL_ON_CONVERSION_ERROR : "") + "," + DATETIME_TZ_FMT + "))";
                break;
            }
            default: {
                str = NULL_CONST;
            }
        }
        return str;
    }

    private String castToTsWithTz(int typeFamily, String[] exprSQL) throws PgqlToSqlException {
        String str = "";
        switch (typeFamily) {
            case 9: {
                str = exprSQL[0];
                break;
            }
            case 8: {
                str = "TO_TIMESTAMP_TZ(TO_NCHAR(" + exprSQL[0] + "," + DATETIME_FMT + ")||" + DEFAULT_TZ + (this.eCtx.ctx.addDefaultNull ? DEFAULT_NULL_ON_CONVERSION_ERROR : "") + "," + DATETIME_TZ_FMT + ")";
                break;
            }
            case 6: 
            case 7: {
                str = this.strToTsWithTz(exprSQL[0]);
                break;
            }
            case 12: {
                str = "COALESCE(" + exprSQL[3] + "," + this.strToTsWithTz(exprSQL[1]) + ")";
                break;
            }
            default: {
                str = NULL_CONST;
            }
        }
        return str;
    }

    private String strToTsWithTz(String str) {
        return "COALESCE(TO_TIMESTAMP_TZ(" + str + "||" + DEFAULT_TIME_TZ + (this.eCtx.ctx.addDefaultNull ? DEFAULT_NULL_ON_CONVERSION_ERROR : "") + "," + DATETIME_TZ_FMT + "),TO_TIMESTAMP_TZ(" + str + "||" + DEFAULT_TZ + (this.eCtx.ctx.addDefaultNull ? DEFAULT_NULL_ON_CONVERSION_ERROR : "") + "," + DATETIME_TZ_FMT + "),TO_TIMESTAMP_TZ(" + str + (this.eCtx.ctx.addDefaultNull ? DEFAULT_NULL_ON_CONVERSION_ERROR : "") + "," + DATETIME_TZ_FMT + "),TO_TIMESTAMP_TZ(" + str + "||" + DEFAULT_TZ + (this.eCtx.ctx.addDefaultNull ? DEFAULT_NULL_ON_CONVERSION_ERROR : "") + "," + DATETIME_TZ_ALT_FMT + "),TO_TIMESTAMP_TZ(" + str + (this.eCtx.ctx.addDefaultNull ? DEFAULT_NULL_ON_CONVERSION_ERROR : "") + "," + DATETIME_TZ_ALT_FMT + "))";
    }

    private String getNumber(int typeFamily, String[] exprSQL) throws PgqlToSqlException {
        String sql = "";
        if (typeFamily == 4 || typeFamily == 5 || typeFamily == 3 || typeFamily == 0 || typeFamily == 1 || typeFamily == 2) {
            return exprSQL[0];
        }
        sql = typeFamily == 12 ? exprSQL[2] : NULL_CONST;
        return sql;
    }

    private String getDate(int typeFamily, String[] exprSQL) throws PgqlToSqlException {
        String sql = "";
        if (typeFamily == 9) {
            return exprSQL[0];
        }
        if (typeFamily == 8) {
            return this.castToTsWithTz(typeFamily, exprSQL);
        }
        sql = typeFamily == 12 ? exprSQL[3] : NULL_CONST;
        return sql;
    }

    private String getBooleanExpr(int typeFamily, String[] exprSQL, boolean negated) throws PgqlToSqlException {
        String sql = "";
        sql = typeFamily == 10 ? exprSQL[0] : "(" + this.getBoolConstantForRelExpr(typeFamily, exprSQL, true, negated) + " = n'" + UPPER_Y_CONST + "')";
        return sql;
    }

    private String getBoolConstantForRelExpr(int typeFamily, String[] exprSQL, boolean isLHS, boolean negated) throws PgqlToSqlException {
        return this.getBoolConstant(typeFamily, exprSQL, isLHS, negated, true);
    }

    private String projectBoolConstant(int typeFamily, String[] exprSQL) throws PgqlToSqlException {
        return this.getBoolConstant(typeFamily, exprSQL, false, false, false);
    }

    private String getBoolConstant(int typeFamily, String[] exprSQL, boolean isLHS, boolean negated, boolean forRelExpression) throws PgqlToSqlException {
        String sql = "";
        sql = typeFamily == 10 ? "(CASE WHEN " + exprSQL[0] + " THEN n'" + UPPER_Y_CONST + "'  WHEN NOT(" + exprSQL[0] + ") THEN n'" + UPPER_N_CONST + "' ELSE NULL END)" : (typeFamily == 11 ? exprSQL[0] : (typeFamily == 12 ? (forRelExpression && !negated && this.eCtx.transMode == 0 ? (isLHS ? exprSQL[0] + " = " + 6 + " AND UPPER(" + exprSQL[1] + ")" : "UPPER(" + exprSQL[1] + ") AND " + exprSQL[0] + " = " + 6) : "(CASE WHEN " + exprSQL[0] + " = " + 6 + " THEN UPPER(" + exprSQL[1] + ") ELSE NULL END)") : NULL_CONST));
        return sql;
    }

    private String[] getValueColsForExpr(int typeFamily, String[] exprSQL) throws PgqlToSqlException {
        String[] sql = new String[4];
        switch (typeFamily) {
            case 13: 
            case 14: {
                sql = new String[]{exprSQL[0], exprSQL[1]};
                break;
            }
            case 3: {
                sql[0] = Integer.toString(2);
                sql[1] = "to_nchar(" + exprSQL[0] + "," + DEFAULT_NUM_FMT + "," + NLS_NUM_CHAR_ARG + ")";
                sql[2] = exprSQL[0];
                sql[3] = "to_timestamp_tz(null)";
                break;
            }
            case 4: 
            case 5: {
                sql[0] = Integer.toString(7);
                sql[1] = "to_nchar(" + exprSQL[0] + "," + DEFAULT_NUM_FMT + "," + NLS_NUM_CHAR_ARG + ")";
                sql[2] = exprSQL[0];
                sql[3] = "to_timestamp_tz(null)";
                break;
            }
            case 1: 
            case 2: {
                sql[0] = Integer.toString(4);
                sql[1] = "to_nchar(" + exprSQL[0] + "," + DEFAULT_NUM_FMT + "," + NLS_NUM_CHAR_ARG + ")";
                sql[2] = exprSQL[0];
                sql[3] = "to_timestamp_tz(null)";
                break;
            }
            case 0: {
                sql[0] = Integer.toString(3);
                sql[1] = "to_nchar(" + exprSQL[0] + "," + DEFAULT_NUM_FMT + "," + NLS_NUM_CHAR_ARG + ")";
                sql[2] = exprSQL[0];
                sql[3] = "to_timestamp_tz(null)";
                break;
            }
            case 6: 
            case 7: {
                sql[0] = Integer.toString(1);
                sql[1] = "to_nchar(" + exprSQL[0] + ")";
                sql[2] = "to_number(null)";
                sql[3] = "to_timestamp_tz(null)";
                break;
            }
            case 10: {
                sql[0] = Integer.toString(6);
                sql[1] = "(CASE WHEN " + exprSQL[0] + " THEN n'" + UPPER_Y_CONST + "' WHEN NOT (" + exprSQL[0] + ") THEN n'" + UPPER_N_CONST + "' ELSE NULL END)";
                sql[2] = "to_number(null)";
                sql[3] = "to_timestamp_tz(null)";
                break;
            }
            case 11: {
                sql[0] = Integer.toString(6);
                sql[1] = exprSQL[0];
                sql[2] = "to_number(null)";
                sql[3] = "to_timestamp_tz(null)";
                break;
            }
            case 8: {
                sql[0] = Integer.toString(5);
                sql[1] = this.getStrFromTimestamp(exprSQL[0]);
                sql[2] = "to_number(null)";
                sql[3] = this.castToTsWithTz(8, exprSQL);
                break;
            }
            case 9: {
                sql[0] = Integer.toString(5);
                sql[1] = this.getStrFromTimestampTz(exprSQL[0]);
                sql[2] = "to_number(null)";
                sql[3] = exprSQL[0];
                break;
            }
            case 12: {
                sql[0] = exprSQL[0];
                sql[1] = exprSQL[1];
                sql[2] = exprSQL[2];
                sql[3] = exprSQL[3];
                break;
            }
            case 15: {
                sql[0] = "to_number(null)";
                sql[1] = "to_nchar(null)";
                sql[2] = "to_number(null)";
                sql[3] = "to_timestamp_tz(null)";
                break;
            }
            default: {
                throw new PgqlToSqlException("Unknown type family" + typeFamily);
            }
        }
        return sql;
    }

    private String[] getInfoForVar(String varName) {
        String[] vAlias = this.eCtx.tStruct.getVarAlias(varName);
        if (vAlias == null && this.eCtx.parentTStruct != null) {
            vAlias = this.eCtx.parentTStruct.getVarAlias(varName);
        }
        return vAlias;
    }

    private String getTabAliasForProperty(String var, String prop) {
        ValuePair vp = new ValuePair(var, prop);
        String propAlias = this.eCtx.tStruct.getPropAlias(vp);
        if (propAlias == null && this.eCtx.parentTStruct != null) {
            propAlias = this.eCtx.parentTStruct.getPropAlias(vp);
        }
        return propAlias;
    }

    private String[] getRootTrans(int typeFamily, String[] sql) throws PgqlToSqlException {
        String[] rootSQL = new String[1];
        if (this.eCtx.transMode == 0) {
            rootSQL = sql;
        } else if (this.eCtx.transMode == 3) {
            rootSQL = this.getValueColsForExpr(typeFamily, sql);
        } else if (this.eCtx.transMode == 2) {
            switch (typeFamily) {
                case 12: {
                    rootSQL = this.getValueColsForExpr(typeFamily, sql);
                    break;
                }
                case 10: {
                    String[] valueCols = this.getValueColsForExpr(typeFamily, sql);
                    rootSQL[0] = valueCols[1];
                    break;
                }
                case 13: 
                case 14: {
                    rootSQL[0] = sql[1];
                    break;
                }
                default: {
                    rootSQL = sql;
                    break;
                }
            }
        } else if (this.eCtx.transMode == 1) {
            String dirKey = this.getDirKeyword();
            if (typeFamily == 12) {
                rootSQL = new String[]{"(DECODE(" + sql[0] + "," + 1 + "," + 3 + "," + 2 + "," + 2 + "," + 7 + "," + 2 + "," + 3 + "," + 2 + "," + 4 + "," + 2 + "," + 5 + "," + 1 + "," + 6 + "," + 4 + ")) " + dirKey, sql[2] + " " + dirKey, sql[3] + " " + dirKey, "DECODE(" + sql[0] + "," + 6 + ",DECODE(" + sql[1] + ",n'" + UPPER_Y_CONST + "',n'0',n'" + LOWER_Y_CONST + "',n'0',n'" + UPPER_N_CONST + "',n'1',n'" + LOWER_N_CONST + "',n'1')," + sql[1] + ") " + dirKey};
            } else if (typeFamily == 10) {
                rootSQL[0] = "DECODE(" + this.getBoolConstantForRelExpr(typeFamily, sql, false, false) + ",n'" + UPPER_Y_CONST + "',n'1',n'" + LOWER_Y_CONST + "',n'1',n'" + UPPER_N_CONST + "',n'0',n'" + LOWER_N_CONST + "',n'0') " + dirKey;
            } else if (typeFamily == 13 || typeFamily == 14) {
                rootSQL[0] = sql[1] + " " + dirKey;
            } else {
                rootSQL[0] = sql[0];
                if (typeFamily == 5 || typeFamily == 2) {
                    rootSQL[0] = "n'" + sql[0] + "'";
                }
                rootSQL[0] = rootSQL[0] + " " + dirKey;
            }
        }
        return rootSQL;
    }

    private String[] getValueColumns(int typeFamily, String[] sql) throws PgqlToSqlException {
        String colSQL = "";
        switch (typeFamily) {
            case 12: {
                colSQL = sql + "." + "T" + "," + sql + "." + "V" + "," + sql + "." + "VN" + "," + sql + "." + "VT";
                break;
            }
            default: {
                throw new PgqlToSqlException("Unexpected type in getValueColumns: " + typeFamily);
            }
        }
        return new String[]{colSQL};
    }

    private String getVariableName(QueryExpression exp) throws PgqlToSqlException {
        if (exp.getExpType() == QueryExpression.ExpressionType.VARREF) {
            return ((QueryExpression.VarRef)exp).getVariable().getName();
        }
        if (exp.getExpType() == QueryExpression.ExpressionType.PROP_ACCESS) {
            return ((QueryExpression.PropertyAccess)exp).getVariable().getName();
        }
        throw new PgqlToSqlException("Expecting Variable or Property Access but encountered " + exp.getClass().toString());
    }

    private String getToTimestamp(String dtString) {
        return "TO_TIMESTAMP(" + DbmsUtils.escapeAndEnquoteLiteral(dtString) + ", " + DATETIME_FMT + ")";
    }

    private String getToTimestampTz(String dtString) {
        return "TO_TIMESTAMP_TZ(" + DbmsUtils.escapeAndEnquoteLiteral(dtString) + ", " + DATETIME_TZ_FMT + ")";
    }

    private String getStrFromTimestampTz(String timestampExpr) {
        return "TO_NCHAR(" + timestampExpr + " at time zone " + DEFAULT_TO_CHAR_TZ + "," + DATETIME_TZ_FMT + ")";
    }

    private String getStrFromTimestamp(String timestampExpr) {
        return "TO_NCHAR(" + timestampExpr + "," + DATETIME_FMT + ") || " + DEFAULT_TZ;
    }

    static int getTypeFamily(QueryExpression exp, QueryExpression.ExpressionType eType, String functionName, String castType) throws PgqlToSqlException {
        switch (eType) {
            case INTEGER: {
                return 5;
            }
            case AGGR_COUNT: 
            case MOD: {
                return 4;
            }
            case DECIMAL: {
                return 2;
            }
            case SUB: 
            case ADD: 
            case MUL: 
            case DIV: 
            case UMIN: 
            case AGGR_SUM: 
            case AGGR_AVG: {
                return 1;
            }
            case STRING: {
                return 7;
            }
            case TIMESTAMP: {
                return 8;
            }
            case DATE: 
            case TIMESTAMP_WITH_TIMEZONE: {
                return 9;
            }
            case BOOLEAN: {
                return 11;
            }
            case AND: 
            case OR: 
            case EQUAL: 
            case NOT_EQUAL: 
            case GREATER: 
            case GREATER_EQUAL: 
            case LESS: 
            case LESS_EQUAL: 
            case NOT: 
            case EXISTS: {
                return 10;
            }
            case PROP_ACCESS: 
            case AGGR_MIN: 
            case AGGR_MAX: {
                return 12;
            }
            case VARREF: {
                QueryVariable qv = ((QueryExpression.VarRef)exp).getVariable();
                if (qv.getVariableType() == QueryVariable.VariableType.EDGE) {
                    return 14;
                }
                if (qv.getVariableType() == QueryVariable.VariableType.VERTEX) {
                    return 13;
                }
                throw new PgqlToSqlException("Unexpected type of variable reference: " + qv.getVariableType());
            }
            case STAR: {
                return 16;
            }
            case CAST: {
                if ("INT".equals(castType)) {
                    return 4;
                }
                if ("LONG".equals(castType)) {
                    return 4;
                }
                if ("FLOAT".equals(castType)) {
                    return 1;
                }
                if ("DOUBLE".equals(castType)) {
                    return 1;
                }
                if ("STRING".equals(castType)) {
                    return 6;
                }
                if ("BOOLEAN".equals(castType)) {
                    return 11;
                }
                if ("DATE".equals(castType)) {
                    return 9;
                }
                if ("TIMESTAMP".equals(castType)) {
                    return 8;
                }
                if ("TIMESTAMP WITH TIMEZONE".equals(castType)) {
                    return 9;
                }
                throw new PgqlToSqlException("Unexpected target type for CAST function");
            }
            case FUNCTION_CALL: {
                if ("ID".equals(functionName)) {
                    return 4;
                }
                if ("LABEL".equals(functionName)) {
                    return 6;
                }
                if ("LABELS".equals(functionName)) {
                    return 6;
                }
                if ("HAS_LABEL".equals(functionName)) {
                    return 10;
                }
                if ("IN_DEGREE".equals(functionName)) {
                    return 4;
                }
                if ("OUT_DEGREE".equals(functionName)) {
                    return 4;
                }
                if ("JAVA_REGEXP_LIKE".equals(functionName)) {
                    return 10;
                }
                if ("HAS_PROP".equals(functionName)) {
                    return 10;
                }
                if ("ALL_DIFFERENT".equals(functionName)) {
                    return 10;
                }
                if ("CONTAINS".equals(functionName)) {
                    return 10;
                }
                throw new PgqlToSqlException("Unsupported function: " + functionName);
            }
        }
        throw new PgqlToSqlException("Unknown type encountered when determining type family");
    }

    static {
        try {
            dtzf = DateTimeFormatter.ofPattern(JAVA_DATETIME_TZ_FMT);
        }
        catch (IllegalArgumentException ex) {
            throw new RuntimeException(ex);
        }
        try {
            dtf = DateTimeFormatter.ofPattern(JAVA_DATETIME_FMT);
        }
        catch (IllegalArgumentException ex) {
            throw new RuntimeException(ex);
        }
    }
}

