/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.pgql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.List;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleStatement;
import oracle.pg.rdbms.pgql.PgqlColumnDescriptor;
import oracle.pg.rdbms.pgql.PgqlResultElement;
import oracle.pg.rdbms.pgql.PgqlResultElementImpl;
import oracle.pg.rdbms.pgql.PgqlToSqlException;
import oracle.pgql.lang.PgqlException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbmsUtils {
    private static Logger ms_log = LoggerFactory.getLogger(DbmsUtils.class);
    protected static final String NON_SIMPLE_GRAPH_NAME_ERROR = "PG schema graph names must be simple SQL names";
    private static final String VERTEX_NOT_SUPPORTED_ERROR = "OracleVertex objects cannot be returned through this interface";
    private static final String EDGE_NOT_SUPPORTED_ERROR = "OracleEdge objects cannot be returned through this interface";
    private static final String UNEXPECTED_COLUMN_TYPE_ERROR = "Encountered unexpected column type when constructing PGQL result";
    private static final String UNKNOWN_DAL_TYPE_ERROR = "readObjFromResultSet: unknown T col value: ";
    protected static final int DEFAULT_TIMEOUT = 0;
    protected static final int DEFAULT_PARALLEL = 0;
    protected static final int DEFAULT_DS = 2;
    protected static final int DEFAULT_PARALLEL_PTT = 1;
    protected static final int DEFAULT_MAX_RESULTS = -1;
    public static final int DB_18C = 18;
    public static final int DB_19C = 19;
    public static final int DB_20C = 20;
    public static final int DB_23C = 23;
    public static final double OPG_20_1 = 20.1;
    public static final double OPG_20_3 = 20.3;
    public static final double OPG_NOT_AVAILABLE = Double.MAX_VALUE;
    public static final double OPG_PATCH_NOT_INSTALLED = Double.MIN_VALUE;
    public static final int ORA_INVALID_ID = 904;
    public static final int ORA_LITERAL_TOO_LONG = 1704;
    protected static final String K_L_COL_EXTD_SIZE = "3100";
    protected static final String V_COL_EXTD_SIZE = "15000";
    protected static final String ALL_COLS_STD_SIZE = "2000";
    private static final int CHUNKS_LENGTH = 3500;
    private static final String END_SP_FUNCTION = "END shortest_path_function;";
    private static final int END_SP_FUNCTION_LENGTH = "END shortest_path_function;".length();
    public static final String END_TMP_WITH = "/* end_tmp_with_clause */";
    private static final int END_TMP_WITH_LENGTH = "/* end_tmp_with_clause */".length();

    public static void quietlyCloseResultSetAndStmt(ResultSet rs, Statement stmt) {
        try {
            if (rs != null) {
                rs.close();
            }
            if (ms_log.isDebugEnabled()) {
                ms_log.debug("quietlyCloseResultSetAndStmt: close result set");
            }
        }
        catch (SQLException sQLException) {
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                    if (ms_log.isDebugEnabled()) {
                        ms_log.debug("quietlyCloseResultSetAndStmt: done closing statement in final block");
                    }
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    public static PgqlResultElement getPgqlResultElement(ResultSet rs, PgqlColumnDescriptor colDesc) throws SQLException, PgqlException {
        Object o = "";
        int valueType = -1;
        switch (colDesc.getColType()) {
            case VERTEX: {
                throw new PgqlException(VERTEX_NOT_SUPPORTED_ERROR);
            }
            case EDGE: {
                throw new PgqlException(EDGE_NOT_SUPPORTED_ERROR);
            }
            case VALUE: {
                int objIdx = colDesc.getSqlOffset();
                valueType = rs.getInt(objIdx);
                if (ms_log.isDebugEnabled()) {
                    ms_log.debug("Populating a VALUE result element: valueType=[" + valueType + "]");
                }
                try {
                    o = DbmsUtils.readObjFromResultSet(rs, objIdx);
                    break;
                }
                catch (SQLException | PgqlException e) {
                    if (ms_log.isDebugEnabled()) {
                        ms_log.debug("Exception getting VALUE");
                    }
                    throw e;
                }
            }
            default: {
                if (ms_log.isDebugEnabled()) {
                    ms_log.debug("Encountered unexpected column type=[" + (Object)((Object)colDesc.getColType()) + "]");
                }
                throw new PgqlException(UNEXPECTED_COLUMN_TYPE_ERROR);
            }
        }
        PgqlResultElementImpl pre = new PgqlResultElementImpl(colDesc.getColType(), valueType, colDesc.getColName(), o);
        return pre;
    }

    public static Object readObjFromResultSet(ResultSet rs, int idxTypeCol) throws SQLException, PgqlException {
        int type = rs.getInt(idxTypeCol);
        Object val = null;
        if (type == 0) {
            if (ms_log.isDebugEnabled()) {
                ms_log.debug("readObjFromResultSet: TYPE_DT_EMPTY");
            }
        } else if (type == 1) {
            if (ms_log.isDebugEnabled()) {
                ms_log.debug("readObjFromResultSet: TYPE_DT_STRING");
            }
            val = rs.getString(idxTypeCol + 1);
        } else if (type == 3) {
            if (ms_log.isDebugEnabled()) {
                ms_log.debug("readObjFromResultSet: TYPE_DT_FLOAT");
            }
            if (((Float)(val = Float.valueOf(rs.getFloat(idxTypeCol + 2)))).floatValue() == 0.0f && rs.wasNull()) {
                val = null;
            }
        } else if (type == 2) {
            if (ms_log.isDebugEnabled()) {
                ms_log.debug("readObjFromResultSet: TYPE_DT_INTEGER");
            }
            if ((Integer)(val = Integer.valueOf(rs.getInt(idxTypeCol + 2))) == 0 && rs.wasNull()) {
                val = null;
            }
        } else if (type == 4) {
            if (ms_log.isDebugEnabled()) {
                ms_log.debug("readObjFromResultSet: TYPE_DT_DOUBLE");
            }
            if ((Double)(val = Double.valueOf(rs.getDouble(idxTypeCol + 2))) == 0.0 && rs.wasNull()) {
                val = null;
            }
        } else if (type == 7) {
            if (ms_log.isDebugEnabled()) {
                ms_log.debug("readObjFromResultSet: TYPE_DT_LONG");
            }
            if ((Long)(val = Long.valueOf(rs.getLong(idxTypeCol + 2))) == 0L && rs.wasNull()) {
                val = null;
            }
        } else if (type == 8) {
            if (ms_log.isDebugEnabled()) {
                ms_log.debug("readObjFromDoubleResultSet: TYPE_DT_SHORT");
            }
            if ((Short)(val = Short.valueOf(rs.getShort(idxTypeCol + 2))) == 0 && rs.wasNull()) {
                val = null;
            }
        } else if (type == 9) {
            if (ms_log.isDebugEnabled()) {
                ms_log.debug("readObjFromResultSet: TYPE_DT_BYTE");
            }
            if ((Byte)(val = Byte.valueOf(rs.getByte(idxTypeCol + 2))) == 0 && rs.wasNull()) {
                val = null;
            }
        } else if (type == 10) {
            if (ms_log.isDebugEnabled()) {
                ms_log.debug("readObjFromResultSet: TYPE_DT_CHAR");
            }
            String s = rs.getString(idxTypeCol + 1);
            val = Character.valueOf(s.charAt(0));
        } else if (type == 6) {
            String s;
            if (ms_log.isDebugEnabled()) {
                ms_log.debug("readObjFromResultSet: TYPE_DT_BOOL");
            }
            if ((s = rs.getString(idxTypeCol + 1)) != null) {
                val = "Y".equals(s) ? Boolean.TRUE : Boolean.FALSE;
            }
        } else if (type == 5) {
            if (ms_log.isDebugEnabled()) {
                ms_log.debug("readObjFromResultSet: TYPE_DT_DATE");
            }
            val = rs.getTimestamp(idxTypeCol + 3);
        } else if (type == 20 || type == 30 || type == 25 || type == 101) {
            if (ms_log.isDebugEnabled()) {
                ms_log.debug("readObjFromResultSet: TYPE_DT_SPATIAL, TYPE_DT_URI, or TYPE_DT_JSON");
            }
            val = rs.getString(idxTypeCol + 1);
        } else {
            if (ms_log.isDebugEnabled()) {
                ms_log.debug("readObjFromResultSet: UNKNOWN");
            }
            throw new PgqlException(UNKNOWN_DAL_TYPE_ERROR + Integer.toString(type));
        }
        return val;
    }

    static String getTzOffsetStr(Connection conn) throws SQLException {
        String tzOffsetStr = ((OracleConnection)conn).getSessionTimeZoneOffset();
        if (!tzOffsetStr.startsWith("+") && !tzOffsetStr.startsWith("-")) {
            tzOffsetStr = "+" + tzOffsetStr;
        }
        String sign = tzOffsetStr.substring(0, 1);
        String offset = tzOffsetStr.substring(1);
        if (offset.length() < 5) {
            offset = "0" + offset;
        }
        return sign + offset;
    }

    public static void setBindValues(PreparedStatement ps, List<Object> bindValues) throws SQLException {
        if (bindValues != null && bindValues.size() > 0) {
            if (ms_log.isDebugEnabled()) {
                ms_log.debug("Setting bind values: bind list size " + bindValues.size());
            }
            for (int idx = 0; idx < bindValues.size(); ++idx) {
                Object o = bindValues.get(idx);
                if (o instanceof String) {
                    ps.setNString(idx + 1, (String)o);
                    continue;
                }
                if (o instanceof Integer) {
                    ps.setInt(idx + 1, (Integer)o);
                    continue;
                }
                if (o instanceof Long) {
                    ps.setLong(idx + 1, (Long)o);
                    continue;
                }
                if (o instanceof Float) {
                    ps.setFloat(idx + 1, ((Float)o).floatValue());
                    continue;
                }
                if (o instanceof Double) {
                    ps.setDouble(idx + 1, (Double)o);
                    continue;
                }
                if (o instanceof Timestamp) {
                    ps.setTimestamp(idx + 1, (Timestamp)o);
                    continue;
                }
                throw new SQLException("Unrecognized bind value type: " + o.getClass().toString());
            }
        }
    }

    public static String escapeAndEnquoteLiteral(String str) throws PgqlToSqlException {
        return DbmsUtils.escapeAndEnquoteLiteral(str, true);
    }

    public static String escapeAndEnquoteLiteral(String str, boolean forNVarchar) throws PgqlToSqlException {
        String escStr = forNVarchar ? "n" : "";
        try {
            escStr = escStr + "'" + str.replace("'", "''") + "'";
        }
        catch (Exception ex) {
            throw new PgqlToSqlException("Invalid SQL literal " + str);
        }
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("escapeSingleQuotes input=[" + str + "] output=[" + escStr + "]");
        }
        return escStr;
    }

    public static String splitClobInChunks(String longString) {
        String result = "(";
        int idx = 0;
        while (idx + 3500 < longString.length()) {
            String chunk = longString.substring(idx, idx + 3500);
            chunk = DbmsUtils.escapeAndEnquoteLiteral(chunk, false);
            result = result + "to_clob(" + chunk + ") ||";
            idx += 3500;
        }
        result = result + "to_clob(" + DbmsUtils.escapeAndEnquoteLiteral(longString.substring(idx), false) + "))";
        return result;
    }

    public static String enquoteTableName(Connection conn, String tableName) throws SQLException {
        try (OracleStatement ostmt = null;){
            ostmt = (OracleStatement)conn.createStatement();
            String string = ostmt.enquoteIdentifier(tableName, true);
            return string;
        }
    }

    public static String sanitizeGraphName(Connection conn, String graphName) throws SQLException, PgqlToSqlException {
        try (OracleStatement ostmt = null;){
            ostmt = (OracleStatement)conn.createStatement();
            if (ostmt.isSimpleIdentifier(graphName)) {
                String string = ostmt.enquoteIdentifier(graphName, false);
                return string;
            }
            throw new PgqlToSqlException(NON_SIMPLE_GRAPH_NAME_ERROR);
        }
    }

    public static String sanitizeGraphOwner(Connection conn, String ownerName) throws SQLException {
        String clnGraphOwner = DbmsUtils.sanitizeIdentifier(conn, ownerName);
        if (!clnGraphOwner.startsWith("\"")) {
            clnGraphOwner = "\"" + clnGraphOwner + "\"";
        }
        return clnGraphOwner;
    }

    public static String sanitizeIdentifier(Connection conn, String identifier) throws SQLException {
        try (OracleStatement ostmt = (OracleStatement)conn.createStatement();){
            String string = ostmt.enquoteIdentifier(identifier, false);
            return string;
        }
    }

    public static StringBuffer getQueryWrapper(String query, int parallel, int dynamicSampling) {
        return DbmsUtils.getQueryWrapper(query, -1, parallel, dynamicSampling);
    }

    public static boolean hasWithClause(String query) {
        return query != null && (query.startsWith("WITH FUNCTION shortest_path_function") || query.startsWith("WITH tmp"));
    }

    public static StringBuffer getQueryWrapper(String query, int maxResults, int parallel, int dynamicSampling) {
        String hint = DbmsUtils.buildHintString(parallel, dynamicSampling, false, false);
        String where = "";
        if (maxResults >= 0) {
            where = "\nWHERE ROWNUM <= " + maxResults;
        }
        StringBuffer wQuery = new StringBuffer();
        if (!hint.equals("") || !where.equals("")) {
            String[] queryArr = new String[]{query};
            String withClause = DbmsUtils.removeWithClause(queryArr);
            wQuery.append(withClause).append("SELECT ").append(hint).append("* FROM(").append(queryArr[0]).append(")").append(where);
        } else {
            wQuery.append(query);
        }
        return wQuery;
    }

    public static String removeWithClause(String[] query) {
        String withClause = "";
        if (DbmsUtils.hasWithClause(query[0])) {
            int endIdx = query[0].indexOf(END_SP_FUNCTION);
            endIdx = endIdx == -1 ? query[0].indexOf(END_TMP_WITH) + END_TMP_WITH_LENGTH : (endIdx += END_SP_FUNCTION_LENGTH);
            withClause = query[0].substring(0, endIdx) + "\n";
            query[0] = query[0].replace(withClause, "");
        }
        return withClause;
    }

    protected static String buildHintString(int parallel, int dynamicSampling, boolean append, boolean nologging) {
        String hint = DbmsUtils.buildHint(parallel, dynamicSampling, append, nologging);
        if (!hint.equals("")) {
            hint = "/*+ " + hint + "*/ ";
        }
        return hint;
    }

    public static String buildHint(int parallel, int dynamicSampling, boolean append, boolean nologging) {
        String hint = "";
        if (nologging) {
            hint = hint + "nologging ";
        }
        if (parallel > 0) {
            hint = hint + "parallel(" + parallel + ") ";
        }
        if (append) {
            hint = hint + "append ";
        }
        if (dynamicSampling != 2 && dynamicSampling > -1) {
            hint = hint + "dynamic_sampling(" + dynamicSampling + ") ";
        }
        return hint;
    }

    protected static int getDatabaseMajorVersion(Connection conn) {
        int dbVersion;
        try {
            dbVersion = conn.getMetaData().getDatabaseMajorVersion();
        }
        catch (SQLException ex) {
            throw new PgqlToSqlException(ex);
        }
        return dbVersion;
    }

    protected static double getOpgVersion(Connection conn) {
        double opgVersion;
        try (Statement stmt = conn.createStatement();
             ResultSet rs = stmt.executeQuery("SELECT opg_apis.get_opg_version() from sys.dual");){
            rs.next();
            opgVersion = Double.parseDouble(rs.getString(1));
        }
        catch (SQLException ex) {
            if (ex.getErrorCode() == 904) {
                opgVersion = Double.MIN_VALUE;
            }
            throw new PgqlToSqlException(ex);
        }
        return opgVersion;
    }

    static boolean isMaxStringSizeExtended(Connection conn) {
        boolean isExtended = true;
        try (Statement stmt = conn.createStatement();){
            String createStmt = "DECLARE\n  str_column varchar2(4001) := '';\nBEGIN\n  for i in 1 .. 4001 loop\n    str_column := str_column || 'x';\n  end loop;\n  execute immediate  'select ''' || str_column || ''' as x from sys.dual';\nEND;";
            stmt.execute(createStmt);
        }
        catch (SQLException ex) {
            if (ex.getErrorCode() == 1704) {
                isExtended = false;
            }
            throw new PgqlToSqlException(ex);
        }
        return isExtended;
    }

    public static String getTableForSuffix(Connection conn, String graphSchema, String graphName, String suffix) throws SQLException {
        return DbmsUtils.sanitizeGraphOwner(conn, graphSchema) + "." + DbmsUtils.enquoteTableName(conn, graphName + suffix);
    }

    public static int getParallelSafeValueForPTT(int parallel, List<Object> bindValues) {
        if (bindValues != null && bindValues.size() > 0) {
            if (ms_log.isDebugEnabled()) {
                ms_log.debug("Parallel not safe for PTT, using [1] instead");
            }
            return 1;
        }
        return parallel;
    }
}

