/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.pgql.jdbc;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleDriver;
import oracle.pg.rdbms.pgql.jdbc.PgqlJdbcRdbmsConnection;

public class PgqlJdbcRdbmsDriver
extends OracleDriver {
    private static PgqlJdbcRdbmsDriver registerDriver;
    private static final String JDBC_URL_PREFIX = "jdbc:oracle:pgql:";

    public static void register() throws SQLException {
        if (PgqlJdbcRdbmsDriver.isRegisterd()) {
            throw new IllegalStateException("Driver is already registerd");
        }
        PgqlJdbcRdbmsDriver driver = new PgqlJdbcRdbmsDriver();
        DriverManager.registerDriver((Driver)((Object)driver));
        registerDriver = driver;
    }

    public static boolean isRegisterd() {
        return registerDriver != null;
    }

    public boolean acceptsURL(String url) throws SQLException {
        if (url == null) {
            throw new SQLException("null is not a valid url");
        }
        return url.split(":").length > 3 && url.startsWith(JDBC_URL_PREFIX);
    }

    public Connection connect(String url, Properties info) throws SQLException {
        String oracleJdbcUrl = url.replace(":pgql:@", ":thin:@");
        OracleConnection conn = (OracleConnection)DriverManager.getConnection(oracleJdbcUrl, info.getProperty("user"), info.getProperty("password"));
        return new PgqlJdbcRdbmsConnection(conn);
    }

    static {
        try {
            PgqlJdbcRdbmsDriver.register();
        }
        catch (SQLException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

