/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.imports.graph;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import oracle.pg.imports.db.ConnectionManager;
import oracle.pg.imports.parser.ReaderResult;
import oracle.pg.rdbms.pgql.PgqlConnection;
import oracle.pg.rdbms.pgql.PgqlStatement;
import oracle.pgql.lang.PgqlException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PropertyGraphWriter {
    private static final Logger LOG = LoggerFactory.getLogger(PropertyGraphWriter.class);
    protected final String graphType;
    private ConnectionManager connectionManager;
    private ReaderResult readerResult;
    private String graphName;
    private int parallelism;
    private int dynamicSampling;
    private String matchOptions;
    private String options;

    public PropertyGraphWriter(String graphType) {
        this.graphType = graphType;
        this.connectionManager = null;
        this.readerResult = null;
        this.graphName = null;
    }

    public String write() throws PgqlException, SQLException {
        LOG.info("Creating CPG statement...");
        StringBuilder cpgStatement = new StringBuilder("CREATE PROPERTY GRAPH ").append(this.graphName).append(" ").append((CharSequence)this.buildVertexTablesBlockInCpgStatement()).append(" ").append((CharSequence)this.buildEdgeTablesBlockInCpgStatement()).append(" ").append("OPTIONS ( ").append(this.graphType).append(" )");
        LOG.info("Executing CPG statement...");
        LOG.debug("CPG statement: {}", (Object)cpgStatement);
        try (Connection connection = this.connectionManager.getConnection();
             PgqlStatement pgqlStatement = PgqlConnection.getConnection((Connection)connection).createStatement();){
            connection.setAutoCommit(false);
            pgqlStatement.execute(cpgStatement.toString(), this.parallelism, this.dynamicSampling, this.matchOptions, this.options);
        }
        LOG.info("Returning CPG statement...");
        return cpgStatement.toString();
    }

    private StringBuilder buildVertexTablesBlockInCpgStatement() {
        String comma = "";
        StringBuilder vertexBlock = new StringBuilder("VERTEX TABLES (");
        for (String label : this.readerResult.getVertices().keySet()) {
            vertexBlock.append(comma).append(" ").append(label).append(" KEY (id) LABEL ").append(label).append(" PROPERTIES ARE ALL COLUMNS");
            comma = ",";
        }
        return vertexBlock.append(" )");
    }

    private StringBuilder buildEdgeTablesBlockInCpgStatement() {
        Map<Object, String> verticesIdsToLabels = this.readerResult.getVerticesLabels();
        String comma = "";
        StringBuilder edgeBlock = new StringBuilder("EDGE TABLES (");
        for (String label : this.readerResult.getEdges().keySet()) {
            Object sid = this.readerResult.getEdges().get(label).getData().get(0).get("sid");
            Object did = this.readerResult.getEdges().get(label).getData().get(0).get("did");
            String sourceVertexLabel = verticesIdsToLabels.get(sid);
            String destinationVertexLabel = verticesIdsToLabels.get(did);
            edgeBlock.append(comma).append(" ").append(label).append(" ").append("KEY (id) ").append("SOURCE KEY (sid) REFERENCES ").append(sourceVertexLabel).append(" (id) ").append("DESTINATION KEY (did) REFERENCES ").append(destinationVertexLabel).append(" (id) ").append("LABEL ").append(label).append(" PROPERTIES ARE ALL COLUMNS");
            comma = ",";
        }
        return edgeBlock.append(" )");
    }

    public PropertyGraphWriter setConnectionManager(ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
        return this;
    }

    public PropertyGraphWriter setReaderResult(ReaderResult readerResult) {
        this.readerResult = readerResult;
        return this;
    }

    public PropertyGraphWriter setGraphName(String graphName) {
        this.graphName = graphName;
        return this;
    }

    public PropertyGraphWriter setParallelism(int parallelism) {
        this.parallelism = parallelism;
        return this;
    }

    public PropertyGraphWriter setDynamicSampling(int dynamicSampling) {
        this.dynamicSampling = dynamicSampling;
        return this;
    }

    public PropertyGraphWriter setMatchOptions(String matchOptions) {
        this.matchOptions = matchOptions;
        return this;
    }

    public PropertyGraphWriter setOptions(String options) {
        this.options = options;
        return this;
    }

    public ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public ReaderResult getReaderResult() {
        return this.readerResult;
    }

    public String getGraphName() {
        return this.graphName;
    }

    public int getParallelism() {
        return this.parallelism;
    }

    public int getDynamicSampling() {
        return this.dynamicSampling;
    }

    public String getMatchOptions() {
        return this.matchOptions;
    }

    public String getOptions() {
        return this.options;
    }
}

