/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.gradle;

import com.oracle.coherence.gradle.CoherenceExtension;
import com.oracle.coherence.gradle.CoherenceTask;
import com.oracle.coherence.gradle.CoherenceTaskRegistrationAction;
import com.oracle.coherence.gradle.CoherenceTestTaskRegistrationAction;
import com.oracle.coherence.gradle.PluginUtils;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.compile.JavaCompile;

public class CoherencePlugin
implements Plugin<Project> {
    public static final String POF_TASK_NAME = "coherencePof";
    public static final String POF_TEST_TASK_NAME = "coherencePofTest";
    private static final int MINIMAL_SUPPORTED_GRADLE_VERSION = 8;

    public void apply(Project project) {
        project.getLogger().debug("Configuring the Coherence Gradle Plugin.");
        if (PluginUtils.getGradleMajorVersion(project) < 8) {
            throw new GradleException("The Coherence Gradle plugin requires Gradle version 8 or higher.");
        }
        if (!project.getPluginManager().hasPlugin("java")) {
            throw new GradleException("The Java Gradle plugin has not been applied.");
        }
        CoherenceExtension coherenceExtension = (CoherenceExtension)project.getExtensions().create(POF_TASK_NAME, CoherenceExtension.class, new Object[0]);
        JavaPluginExtension javaPluginExtension = (JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class);
        TaskContainer taskContainer = project.getTasks();
        JavaCompile javaCompileTask = (JavaCompile)project.getTasks().findByName("compileJava");
        SourceSet mainSourceSet = (SourceSet)javaPluginExtension.getSourceSets().getByName("main");
        FileCollection resourcesFolders = mainSourceSet.getResources().getSourceDirectories();
        CoherenceTaskRegistrationAction coherenceTaskRegistrationAction = new CoherenceTaskRegistrationAction(coherenceExtension, project, javaCompileTask, resourcesFolders);
        TaskProvider coherenceTaskProvider = taskContainer.register(POF_TASK_NAME, CoherenceTask.class, (Action)coherenceTaskRegistrationAction);
        JavaCompile javaTestCompileTask = (JavaCompile)project.getTasks().findByName("compileTestJava");
        SourceSet testSourceSet = (SourceSet)javaPluginExtension.getSourceSets().getByName("test");
        FileCollection testResourcesFolders = testSourceSet.getResources().getSourceDirectories();
        CoherenceTestTaskRegistrationAction coherenceTestTaskRegistrationAction = new CoherenceTestTaskRegistrationAction(coherenceExtension, project, javaTestCompileTask, testResourcesFolders);
        TaskProvider coherenceTestTaskProvider = taskContainer.register(POF_TEST_TASK_NAME, CoherenceTask.class, (Action)coherenceTestTaskRegistrationAction);
        project.afterEvaluate(evaluatedProject -> project.getPlugins().withType(JavaPlugin.class).forEach(javaPlugin -> {
            project.getTasks().getByName("compileJava").doLast(e -> {
                project.getLogger().info("Run coherencePof at the end of task {}.", (Object)e.getName());
                ((CoherenceTask)((Object)((Object)((Object)((Object)coherenceTaskProvider.get()))))).instrumentPofClasses();
            });
            if (((Boolean)coherenceExtension.getInstrumentTestClasses().getOrElse((Object)Boolean.FALSE)).booleanValue()) {
                project.getTasks().getByName("compileTestJava").doLast(e -> {
                    project.getLogger().info("Run coherencePofTest at the end of task {}.", (Object)e.getName());
                    ((CoherenceTask)((Object)((Object)((Object)((Object)coherenceTestTaskProvider.get()))))).instrumentPofClasses();
                });
            }
        }));
    }
}

