/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.gradle;

import com.oracle.coherence.common.base.Exceptions;
import com.oracle.coherence.common.schema.ClassFileSchemaSource;
import com.oracle.coherence.common.schema.Schema;
import com.oracle.coherence.common.schema.SchemaBuilder;
import com.oracle.coherence.common.schema.SchemaSource;
import com.oracle.coherence.common.schema.XmlSchemaSource;
import com.oracle.coherence.gradle.GradleLogger;
import com.tangosol.io.pof.PofIndexer;
import com.tangosol.io.pof.generator.PortableTypeGenerator;
import com.tangosol.io.pof.schema.annotation.PortableType;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.compile.JavaCompile;

abstract class CoherenceTask
extends DefaultTask {
    @Inject
    public CoherenceTask(Project project) {
    }

    @Input
    @Optional
    public abstract Property<Boolean> getDebug();

    @Input
    @Optional
    public abstract Property<String> getPofSchemaXmlPath();

    @Input
    @Optional
    public abstract Property<Boolean> getUsePofSchemaXml();

    @Input
    @Optional
    public abstract Property<Boolean> getIndexPofClasses();

    @Input
    @Optional
    public abstract SetProperty<String> getPofIndexPackages();

    @Input
    @Optional
    public abstract Property<FileCollection> getResourcesDirectories();

    @InputFiles
    public abstract DirectoryProperty getClassesDirectory();

    @OutputDirectory
    abstract DirectoryProperty getOutputDirectory();

    @TaskAction
    public void instrumentPofClasses() {
        boolean fDebug = (Boolean)this.getDebug().get();
        Logger logger = this.getLogger();
        if (!this.getClassesDirectory().isPresent()) {
            throw new IllegalStateException("The classesDirectory is not specified.");
        }
        File classesDirectory = ((Directory)this.getClassesDirectory().get()).getAsFile();
        Set resourcesDirectoriesAsFiles = this.getResourcesDirectories().isPresent() ? ((FileCollection)this.getResourcesDirectories().get()).getFiles() : null;
        if (!this.getOutputDirectory().isPresent()) {
            throw new IllegalStateException("The outputDirectory is not specified.");
        }
        File outputDirectory = ((Directory)this.getOutputDirectory().get()).getAsFile();
        String sPofSchemaXmlPath = this.getPofSchemaXmlPath().isPresent() ? (String)this.getPofSchemaXmlPath().get() : null;
        boolean usePofSchemaXmlPath = this.getUsePofSchemaXml().isPresent() ? (Boolean)this.getUsePofSchemaXml().get() : false;
        boolean indexPofClasses = (Boolean)this.getIndexPofClasses().getOrElse((Object)true);
        logger.info("The following configuration properties are configured:");
        logger.info("Property classesDirectory   = {}", (Object)classesDirectory.getAbsolutePath());
        if (resourcesDirectoriesAsFiles == null || resourcesDirectoriesAsFiles.isEmpty()) {
            logger.info("Property resourcesDirectory = {}", (Object)"N/A");
        } else {
            for (File resourceDirectory : resourcesDirectoriesAsFiles) {
                logger.info("Property resourcesDirectory = {}", (Object)resourceDirectory.getAbsolutePath());
            }
        }
        logger.info("Property outputDirectory    = {}", (Object)outputDirectory.getAbsolutePath());
        logger.info("Property sPofSchemaXmlPath  = {}", (Object)sPofSchemaXmlPath);
        logger.info("Property indexPofClasses  = {}", (Object)indexPofClasses);
        logger.info("Property debug              = {}", (Object)fDebug);
        if (!classesDirectory.equals(outputDirectory)) {
            logger.info("Copying all classes from '{}' to '{}'.", (Object)classesDirectory, (Object)outputDirectory);
            boolean didTheCopyOperationSucceed = this.getProject().copy(copy -> copy.from(new Object[]{classesDirectory}).into((Object)outputDirectory)).getDidWork();
            logger.debug("Copying of classes {}.", (Object)(didTheCopyOperationSucceed ? "completed" : "not completed"));
        }
        ClassFileSchemaSource classFileSchemaSource = new ClassFileSchemaSource();
        ArrayList<File> listInstrument = new ArrayList<File>();
        SchemaBuilder schemaBuilder = new SchemaBuilder();
        ArrayList<File> listClassesDirectories = new ArrayList<File>();
        if (usePofSchemaXmlPath && sPofSchemaXmlPath != null && resourcesDirectoriesAsFiles != null && !resourcesDirectoriesAsFiles.isEmpty()) {
            HashSet missingLocations = new HashSet();
            for (File resourceDirectory : resourcesDirectoriesAsFiles) {
                File schemaSourceXmlFile = new File(resourceDirectory, sPofSchemaXmlPath);
                if (schemaSourceXmlFile.exists()) {
                    if (schemaSourceXmlFile.isDirectory()) {
                        throw new IllegalStateException(String.format("Declared schemaSource XML file '%s' is a directory,", schemaSourceXmlFile));
                    }
                    this.addPofXmlSchema(schemaBuilder, schemaSourceXmlFile);
                    continue;
                }
                missingLocations.add(schemaSourceXmlFile);
            }
            if (missingLocations.size() == resourcesDirectoriesAsFiles.size()) {
                throw new IllegalStateException(String.format("The declared schemaSource XML file '%s' does not exist in the provided %s resource folder(s).", sPofSchemaXmlPath, resourcesDirectoriesAsFiles.size()));
            }
        }
        if (classesDirectory.exists()) {
            listClassesDirectories.add(outputDirectory);
        } else {
            logger.error("PortableTypeGenerator skipping classes directory as it does not exist.");
        }
        classFileSchemaSource.withTypeFilter(ClassFileSchemaSource.Filters.hasAnnotation(PortableType.class)).withMissingPropertiesAsObject();
        if (!listClassesDirectories.isEmpty()) {
            for (File classesDir : listClassesDirectories) {
                classFileSchemaSource.withClassesFromDirectory(classesDir);
                listInstrument.add(classesDir);
            }
        }
        ArrayList classesFromDirectory = new ArrayList();
        ArrayList classesFromJarFile = new ArrayList();
        if (!listInstrument.isEmpty()) {
            List<File> listDeps = this.resolveDependencies();
            ClassFileSchemaSource dependencies = new ClassFileSchemaSource().withTypeFilter(ClassFileSchemaSource.Filters.hasAnnotation(PortableType.class)).withPropertyFilter(fieldNode -> false);
            listDeps.stream().filter(File::isDirectory).peek(f -> logger.lifecycle("Adding classes from " + String.valueOf(f) + " to schema")).forEach(classesFromDirectory::add);
            classesFromDirectory.forEach(arg_0 -> ((ClassFileSchemaSource)dependencies).withClassesFromDirectory(arg_0));
            listDeps.stream().filter(f -> f.isFile() && f.getName().endsWith(".jar")).peek(f -> logger.lifecycle("Adding classes from " + String.valueOf(f) + " to schema")).forEach(classesFromJarFile::add);
            classesFromJarFile.forEach(arg_0 -> ((ClassFileSchemaSource)dependencies).withClassesFromJarFile(arg_0));
            Schema schema = schemaBuilder.addSchemaSource((SchemaSource)dependencies).addSchemaSource((SchemaSource)classFileSchemaSource).build();
            try {
                logger.warn("Running PortableTypeGenerator for classes in " + outputDirectory.getCanonicalPath());
                PortableTypeGenerator.instrumentClasses((File)outputDirectory, (Schema)schema, (boolean)fDebug, (PortableTypeGenerator.Logger)new GradleLogger(logger));
            }
            catch (IOException e) {
                throw Exceptions.ensureRuntimeException((Throwable)e);
            }
        }
        if (indexPofClasses) {
            try {
                logger.warn("Creating POF index in directory " + outputDirectory.getCanonicalPath());
                PofIndexer pofIndexer = new PofIndexer((PortableTypeGenerator.Logger)new GradleLogger(logger));
                pofIndexer.ignoreClasspath(true).withClassesFromDirectory(listInstrument).withClassesFromJarFile(classesFromJarFile);
                if (!((Set)this.getPofIndexPackages().getOrElse((Object)Collections.EMPTY_SET)).isEmpty()) {
                    pofIndexer.setPackagesToScan((Set)this.getPofIndexPackages().get());
                }
                pofIndexer.createIndexInDirectory(outputDirectory);
            }
            catch (IOException e) {
                throw Exceptions.ensureRuntimeException((Throwable)e);
            }
        }
    }

    private void addPofXmlSchema(SchemaBuilder builder, File schemaSourceXmlFile) {
        Logger logger = this.getLogger();
        if (!schemaSourceXmlFile.exists()) {
            throw new IllegalStateException(String.format("The specified POF XML Schema file does not exist at: '%s'.", schemaSourceXmlFile.getAbsolutePath()));
        }
        logger.lifecycle("Add XmlSchemaSource '{}'.", new Object[]{schemaSourceXmlFile.getAbsolutePath()});
        builder.addSchemaSource((SchemaSource)new XmlSchemaSource(schemaSourceXmlFile));
    }

    private List<File> resolveDependencies() {
        ArrayList<File> listArtifacts = new ArrayList<File>();
        JavaCompile javaCompileTask = (JavaCompile)this.getProject().getTasks().findByName("compileJava");
        Set dependencies = javaCompileTask.getClasspath().getFiles();
        for (File file : dependencies) {
            this.getLogger().info("Adding dependency '{}'.", (Object)file.getAbsolutePath());
            if (file.exists()) {
                listArtifacts.add(file);
                continue;
            }
            this.getLogger().info("Dependency '{}' does not exist.", (Object)file.getAbsolutePath());
        }
        this.getLogger().lifecycle("Resolved {} dependencies.", new Object[]{listArtifacts.size()});
        return listArtifacts;
    }
}

