/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.gradle;

import com.oracle.coherence.common.base.Exceptions;
import com.oracle.coherence.common.schema.ClassFileSchemaSource;
import com.oracle.coherence.common.schema.Schema;
import com.oracle.coherence.common.schema.SchemaBuilder;
import com.oracle.coherence.common.schema.SchemaSource;
import com.oracle.coherence.common.schema.XmlSchemaSource;
import com.oracle.coherence.gradle.GradleLogger;
import com.tangosol.io.pof.generator.PortableTypeGenerator;
import com.tangosol.io.pof.schema.annotation.PortableType;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileType;
import org.gradle.api.logging.Logger;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.work.ChangeType;
import org.gradle.work.FileChange;
import org.gradle.work.Incremental;
import org.gradle.work.InputChanges;

abstract class CoherenceTask
extends DefaultTask {
    @Inject
    public CoherenceTask(Project project) {
    }

    @Input
    @Optional
    public abstract Property<Boolean> getDebug();

    @Input
    @Optional
    public abstract Property<String> getPofSchemaXmlPath();

    @Input
    @Optional
    public abstract Property<Boolean> getUsePofSchemaXml();

    @Input
    @Optional
    public abstract Property<File> getResourcesDirectory();

    @InputFiles
    @Incremental
    public abstract DirectoryProperty getClassesDirectory();

    @OutputDirectory
    abstract DirectoryProperty getOutputDirectory();

    @TaskAction
    public void instrumentPofClasses(InputChanges inputChanges) {
        boolean fDebug = (Boolean)this.getDebug().get();
        Logger logger = this.getLogger();
        if (!this.getClassesDirectory().isPresent()) {
            throw new IllegalStateException("The classesDirectory is not specified.");
        }
        File classesDirectory = ((Directory)this.getClassesDirectory().get()).getAsFile();
        File resourcesDirectory = this.getResourcesDirectory().isPresent() ? (File)this.getResourcesDirectory().get() : null;
        if (!this.getOutputDirectory().isPresent()) {
            throw new IllegalStateException("The outputDirectory is not specified.");
        }
        File outputDirectory = ((Directory)this.getOutputDirectory().get()).getAsFile();
        String sPofSchemaXmlPath = this.getPofSchemaXmlPath().isPresent() ? (String)this.getPofSchemaXmlPath().get() : null;
        boolean usePofSchemaXmlPath = this.getUsePofSchemaXml().isPresent() ? (Boolean)this.getUsePofSchemaXml().get() : false;
        String executionType = inputChanges.isIncremental() ? "incrementally" : "non-incrementally";
        logger.lifecycle("Start executing Gradle task instrumentPofClasses..." + executionType);
        logger.info("The following configuration properties are configured:");
        logger.info("Property classesDirectory   = {}", (Object)classesDirectory.getAbsolutePath());
        logger.info("Property resourcesDirectory = {}", (Object)(resourcesDirectory != null ? resourcesDirectory.getAbsolutePath() : "N/A"));
        logger.info("Property outputDirectory    = {}", (Object)outputDirectory.getAbsolutePath());
        logger.info("Property sPofSchemaXmlPath  = {}", (Object)sPofSchemaXmlPath);
        logger.info("Property debug              = {}", (Object)fDebug);
        ArrayList<File> incrementallyChangedFiles = new ArrayList<File>();
        if (!inputChanges.isIncremental()) {
            logger.info("Copying all classes from '{}' to '{}'.", (Object)classesDirectory, (Object)outputDirectory);
            boolean didTheCopyOperationSucceed = this.getProject().copy(copy -> copy.from(new Object[]{classesDirectory}).into((Object)outputDirectory)).getDidWork();
            logger.debug("Copying of classes {}.", (Object)(didTheCopyOperationSucceed ? "completed" : "not completed"));
        } else {
            Iterable changes = inputChanges.getFileChanges((Provider)this.getClassesDirectory());
            for (FileChange fileChange : changes) {
                File sourceFile = fileChange.getFile();
                FileType fileType = fileChange.getFileType();
                ChangeType changeType = fileChange.getChangeType();
                String relativeFilePath = sourceFile.getAbsolutePath().substring(classesDirectory.getAbsolutePath().length());
                String targetBasePath = outputDirectory.getAbsolutePath();
                File targetFile = new File(targetBasePath + File.separator + relativeFilePath);
                logger.info("sourceFile: '{}'.", (Object)sourceFile.getAbsolutePath());
                logger.info("fileType: '{}'.", (Object)fileType.name());
                logger.info("changeType: {}.", (Object)changeType.name());
                logger.info("relativeFilePath: '{}'.", (Object)relativeFilePath);
                logger.info("targetBasePath: '{}'.", (Object)targetBasePath);
                logger.info("targetFile: '{}'.", (Object)targetFile.getAbsolutePath());
                switch (changeType) {
                    case ADDED: {
                        if (FileType.DIRECTORY.equals((Object)fileType)) {
                            targetFile.mkdirs();
                            break;
                        }
                        boolean didTheCopyOperationSucceed = this.getProject().copy(copy -> copy.from(new Object[]{sourceFile}).into((Object)targetFile.getParent())).getDidWork();
                        logger.info("Copy added file '{}' to '{}'. Success: '{}'.", new Object[]{sourceFile.getAbsolutePath(), outputDirectory, didTheCopyOperationSucceed});
                        incrementallyChangedFiles.add(targetFile);
                        break;
                    }
                    case MODIFIED: {
                        boolean didTheCopyOperationSucceed = this.getProject().copy(copy -> copy.from(new Object[]{sourceFile}).into((Object)outputDirectory)).getDidWork();
                        logger.info("Copy modified file '{}' to '{}'. Success: '{}'.", new Object[]{sourceFile.getAbsolutePath(), outputDirectory, didTheCopyOperationSucceed});
                        incrementallyChangedFiles.add(targetFile);
                        break;
                    }
                    case REMOVED: {
                        this.getProject().delete(delete -> {
                            logger.info("Delete file '{}'.", (Object)targetFile.getAbsolutePath());
                            delete.delete(new Object[]{targetFile});
                        });
                    }
                }
            }
        }
        ClassFileSchemaSource classFileSchemaSource = new ClassFileSchemaSource();
        ArrayList<File> listInstrument = new ArrayList<File>();
        SchemaBuilder schemaBuilder = new SchemaBuilder();
        ArrayList<File> listClassesDirectories = new ArrayList<File>();
        if (usePofSchemaXmlPath && sPofSchemaXmlPath != null) {
            Iterator schemaSourceXmlFile = new File((File)this.getResourcesDirectory().get(), sPofSchemaXmlPath);
            this.addPofXmlSchema(schemaBuilder, (File)((Object)schemaSourceXmlFile));
        }
        if (classesDirectory.exists()) {
            if (!inputChanges.isIncremental()) {
                listClassesDirectories.add(outputDirectory);
            }
        } else {
            logger.error("PortableTypeGenerator skipping classes directory as it does not exist.");
        }
        classFileSchemaSource.withTypeFilter(ClassFileSchemaSource.Filters.hasAnnotation(PortableType.class)).withMissingPropertiesAsObject();
        if (!incrementallyChangedFiles.isEmpty()) {
            for (File classFile : incrementallyChangedFiles) {
                classFileSchemaSource.withClassFile(classFile);
            }
        }
        if (!listClassesDirectories.isEmpty()) {
            for (File classesDir : listClassesDirectories) {
                classFileSchemaSource.withClassesFromDirectory(classesDir);
                listInstrument.add(classesDir);
            }
        }
        if (!listInstrument.isEmpty() || !incrementallyChangedFiles.isEmpty()) {
            List<File> listDeps = this.resolveDependencies();
            ClassFileSchemaSource dependencies = new ClassFileSchemaSource().withTypeFilter(ClassFileSchemaSource.Filters.hasAnnotation(PortableType.class)).withPropertyFilter(fieldNode -> false);
            listDeps.stream().filter(File::isDirectory).peek(f -> logger.lifecycle("Adding classes from " + String.valueOf(f) + " to schema")).forEach(arg_0 -> ((ClassFileSchemaSource)dependencies).withClassesFromDirectory(arg_0));
            listDeps.stream().filter(f -> f.isFile() && f.getName().endsWith(".jar")).peek(f -> logger.lifecycle("Adding classes from " + String.valueOf(f) + " to schema")).forEach(arg_0 -> ((ClassFileSchemaSource)dependencies).withClassesFromJarFile(arg_0));
            Schema schema = schemaBuilder.addSchemaSource((SchemaSource)dependencies).addSchemaSource((SchemaSource)classFileSchemaSource).build();
            try {
                logger.warn("Running PortableTypeGenerator for classes in " + outputDirectory.getCanonicalPath());
                PortableTypeGenerator.instrumentClasses((File)outputDirectory, (Schema)schema, (boolean)fDebug, (PortableTypeGenerator.Logger)new GradleLogger(logger));
            }
            catch (IOException e) {
                throw Exceptions.ensureRuntimeException((Throwable)e);
            }
        }
    }

    private void addPofXmlSchema(SchemaBuilder builder, File schemaSourceXmlFile) {
        Logger logger = this.getLogger();
        if (!schemaSourceXmlFile.exists()) {
            throw new IllegalStateException(String.format("The specified POF XML Schema file does not exist at: '%s'.", schemaSourceXmlFile.getAbsolutePath()));
        }
        logger.lifecycle("Add XmlSchemaSource '{}'.", new Object[]{schemaSourceXmlFile.getAbsolutePath()});
        builder.addSchemaSource((SchemaSource)new XmlSchemaSource(schemaSourceXmlFile));
    }

    private List<File> resolveDependencies() {
        ArrayList<File> listArtifacts = new ArrayList<File>();
        Configuration configuration = this.getProject().getConfigurations().getByName("runtimeClasspath");
        configuration.forEach(file -> {
            this.getLogger().info("Adding dependency '{}'.", (Object)file.getAbsolutePath());
            if (file.exists()) {
                listArtifacts.add((File)file);
            } else {
                this.getLogger().info("Dependency '{}' does not exist.", (Object)file.getAbsolutePath());
            }
        });
        this.getLogger().lifecycle("Resolved {} dependencies.", new Object[]{listArtifacts.size()});
        return listArtifacts;
    }
}

