/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.gradle;

import com.oracle.coherence.gradle.CoherenceExtension;
import com.oracle.coherence.gradle.CoherenceTask;
import com.oracle.coherence.gradle.CoherenceTaskRegistrationAction;
import com.oracle.coherence.gradle.CoherenceTestTaskRegistrationAction;
import com.oracle.coherence.gradle.PluginUtils;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.SortedSet;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetOutput;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.language.jvm.tasks.ProcessResources;

public class CoherencePlugin
implements Plugin<Project> {
    public static final String POF_TASK_NAME = "coherencePof";
    public static final String POF_TEST_TASK_NAME = "coherencePofTest";
    public static final String DEFAULT_POF_CLASSES_OUTPUT_DIRECTORY = "pof-instrumented-classes";
    public static final String DEFAULT_POF_TEST_CLASSES_OUTPUT_DIRECTORY = "pof-instrumented-test-classes";
    private static final int MINIMAL_SUPPORTED_GRADLE_VERSION = 8;

    public void apply(Project project) {
        project.getLogger().debug("Configuring the Coherence Gradle Plugin.");
        if (PluginUtils.getGradleMajorVersion(project) < 8) {
            throw new GradleException("The Coherence Gradle plugin requires Gradle version 8 or higher.");
        }
        if (!project.getPluginManager().hasPlugin("java")) {
            throw new GradleException("The Java Gradle plugin has not been applied.");
        }
        project.getExtensions().create(POF_TASK_NAME, CoherenceExtension.class, new Object[0]);
        CoherenceExtension coherenceExtension = (CoherenceExtension)project.getExtensions().getByType(CoherenceExtension.class);
        JavaPluginExtension javaPluginExtension = (JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class);
        TaskContainer taskContainer = project.getTasks();
        JavaCompile javaCompileTask = (JavaCompile)project.getTasks().findByName("compileJava");
        TaskProvider processResourcesTaskProvider = taskContainer.named("processResources", ProcessResources.class);
        Provider processResourcesDestinationDirProvider = processResourcesTaskProvider.map(processResources -> processResources.getDestinationDir());
        SourceSet mainSourceSet = (SourceSet)javaPluginExtension.getSourceSets().getByName("main");
        SourceSetOutput mainSourceSetOutput = mainSourceSet.getOutput();
        CoherenceTaskRegistrationAction coherenceTaskRegistrationAction = new CoherenceTaskRegistrationAction(coherenceExtension, project, javaCompileTask, (Provider<File>)processResourcesDestinationDirProvider);
        TaskProvider coherenceTaskProvider = taskContainer.register(POF_TASK_NAME, CoherenceTask.class, (Action)coherenceTaskRegistrationAction);
        JavaCompile javaTestCompileTask = (JavaCompile)project.getTasks().findByName("compileTestJava");
        TaskProvider processTestResourcesTaskProvider = taskContainer.named("processTestResources", ProcessResources.class);
        Provider processTestResourcesDestinationDirProvider = processTestResourcesTaskProvider.map(Copy::getDestinationDir);
        SourceSet testSourceSet = (SourceSet)javaPluginExtension.getSourceSets().getByName("test");
        SourceSetOutput testSourceSetOutput = testSourceSet.getOutput();
        CoherenceTestTaskRegistrationAction coherenceTestTaskRegistrationAction = new CoherenceTestTaskRegistrationAction(coherenceExtension, project, javaTestCompileTask, (Provider<File>)processTestResourcesDestinationDirProvider);
        TaskProvider coherenceTestTaskProvider = taskContainer.register(POF_TEST_TASK_NAME, CoherenceTask.class, (Action)coherenceTestTaskRegistrationAction);
        Directory oldJavaDestinationDirectory = (Directory)mainSourceSet.getJava().getDestinationDirectory().get();
        Provider newJavaDestinationDirectory = project.getLayout().getBuildDirectory().dir(DEFAULT_POF_CLASSES_OUTPUT_DIRECTORY);
        project.getLogger().info("Change Java Destination Directory for subsequent tasks from '{}' to '{}'.", (Object)oldJavaDestinationDirectory.getAsFile().getAbsolutePath(), (Object)((Directory)newJavaDestinationDirectory.get()).getAsFile().getAbsolutePath());
        project.getLogger().info("mainSourceSetOutput.getResourcesDir() '{}'", (Object)mainSourceSetOutput.getResourcesDir().getAbsolutePath());
        javaCompileTask.getDestinationDirectory().set((Object)oldJavaDestinationDirectory);
        mainSourceSet.getJava().getDestinationDirectory().set(newJavaDestinationDirectory);
        project.afterEvaluate(evaluatedProject -> {
            TaskContainer evaluatedTaskContainer = evaluatedProject.getTasks();
            SortedSet names = evaluatedTaskContainer.getNames();
            HashSet<String> nameFilter = new HashSet<String>();
            nameFilter.add(POF_TASK_NAME);
            nameFilter.add(POF_TEST_TASK_NAME);
            nameFilter.add("compileJava");
            nameFilter.add("compileTestJava");
            nameFilter.add("classes");
            List<String> filteredTaskNames = names.stream().filter(taskName -> !nameFilter.contains(taskName)).toList();
            for (String name : filteredTaskNames) {
                Task task = evaluatedTaskContainer.getByName(name);
                if (javaCompileTask != null) {
                    if (task.getTaskDependencies().getDependencies(task).stream().anyMatch(javaCompileTask::equals)) {
                        evaluatedProject.getLogger().info("'{}' will depend on '{}'.", (Object)task.getName(), (Object)coherenceTaskProvider.getName());
                        task.dependsOn(new Object[]{coherenceTaskProvider});
                    }
                }
                if (!Boolean.TRUE.equals(coherenceExtension.getInstrumentTestClasses().getOrElse((Object)false)) || javaTestCompileTask == null) continue;
                if (!task.getTaskDependencies().getDependencies(task).stream().anyMatch(javaTestCompileTask::equals)) continue;
                evaluatedProject.getLogger().info("'{}' will depend on '{}'.", (Object)task.getName(), (Object)coherenceTaskProvider.getName());
                task.dependsOn(new Object[]{coherenceTestTaskProvider});
            }
        });
    }
}

