/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.gradle;

import com.oracle.coherence.gradle.CoherenceExtension;
import com.oracle.coherence.gradle.CoherenceTask;
import java.io.File;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.compile.JavaCompile;

public abstract class AbstractCoherenceTaskRegistrationAction
implements Action<CoherenceTask> {
    protected final CoherenceExtension coherenceExtension;
    protected final Project project;
    protected final JavaCompile javaCompileTask;
    protected final Provider<File> processResourcesDestinationDirProvider;
    public static final String POF_XML_SCHEMA_DEFAULT_LOCATION = "META-INF/schema.xml";

    public AbstractCoherenceTaskRegistrationAction(CoherenceExtension coherenceExtension, Project project, JavaCompile javaCompileTask, Provider<File> processResourcesDestinationDirProvider) {
        this.coherenceExtension = coherenceExtension;
        this.project = project;
        this.javaCompileTask = javaCompileTask;
        this.processResourcesDestinationDirProvider = processResourcesDestinationDirProvider;
    }

    public void execute(CoherenceTask coherencePofTask) {
        coherencePofTask.getClassesDirectory().set((Provider)this.javaCompileTask.getDestinationDirectory());
        this.applyInitialConfig(this.project, coherencePofTask);
        if (((Boolean)this.coherenceExtension.getUsePofSchemaXml().getOrElse((Object)false)).booleanValue()) {
            coherencePofTask.getResourcesDirectory().set(this.processResourcesDestinationDirProvider);
            coherencePofTask.getUsePofSchemaXml().set(this.coherenceExtension.getUsePofSchemaXml());
        }
        if (this.coherenceExtension.getDebug().isPresent()) {
            coherencePofTask.getDebug().set(this.coherenceExtension.getDebug());
        }
        if (this.coherenceExtension.getPofSchemaXmlPath().isPresent()) {
            coherencePofTask.getPofSchemaXmlPath().set(this.coherenceExtension.getPofSchemaXmlPath());
        }
    }

    private void applyInitialConfig(Project project, CoherenceTask coherenceTask) {
        project.getLogger().info("Setting up Task property conventions.");
        coherenceTask.getDebug().convention((Object)false);
        coherenceTask.getPofSchemaXmlPath().convention((Object)POF_XML_SCHEMA_DEFAULT_LOCATION);
        coherenceTask.getUsePofSchemaXml().convention((Object)false);
    }
}

