/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.gradle;

import com.oracle.coherence.gradle.CoherenceExtension;
import com.oracle.coherence.gradle.CoherenceTask;
import com.oracle.coherence.gradle.PluginUtils;
import java.io.File;
import java.util.ArrayList;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.compile.JavaCompile;

public class CoherencePlugin
implements Plugin<Project> {
    private static final String POF_TASK_NAME = "coherencePof";
    private static final int MINIMAL_SUPPORTED_GRADLE_VERSION = 8;

    public void apply(Project project) {
        Task javaCompileTestTask;
        project.getLogger().debug("Configuring the Coherence Gradle Plugin.");
        if (PluginUtils.getGradleMajorVersion(project) < 8) {
            throw new GradleException("The Coherence Gradle plugin requires Gradle version 8 or higher.");
        }
        if (!project.getPluginManager().hasPlugin("java")) {
            throw new GradleException("The Java Gradle plugin has not been applied.");
        }
        project.getExtensions().create(POF_TASK_NAME, CoherenceExtension.class, new Object[0]);
        TaskProvider taskContainer = project.getTasks().register(POF_TASK_NAME, CoherenceTask.class, coherencePofTask -> {
            this.applyInitialConfig(project, (CoherenceTask)((Object)coherencePofTask));
            ArrayList<String> dependencies = new ArrayList<String>();
            dependencies.add("compileJava");
            dependencies.add("compileTestJava");
            coherencePofTask.dependsOn(new Object[]{dependencies});
            CoherenceExtension coherenceExtension = (CoherenceExtension)project.getExtensions().getByType(CoherenceExtension.class);
            if (coherenceExtension.getDebug().isPresent()) {
                coherencePofTask.getDebug().set((Object)((Boolean)coherenceExtension.getDebug().get()));
            }
            if (coherenceExtension.getMainClassesDirectory().isPresent()) {
                coherencePofTask.getMainClassesDirectory().set(coherenceExtension.getMainClassesDirectory().getAsFile());
            }
            if (coherenceExtension.getInstrumentTestClasses().isPresent()) {
                coherencePofTask.getInstrumentTestClasses().set(coherenceExtension.getInstrumentTestClasses());
            }
            if (coherenceExtension.getTestClassesDirectory().isPresent()) {
                coherencePofTask.getTestClassesDirectory().set(coherenceExtension.getTestClassesDirectory().getAsFile());
            }
        });
        JavaCompile javaCompileTask = (JavaCompile)project.getTasks().findByName("compileJava");
        if (javaCompileTask != null) {
            javaCompileTask.finalizedBy(new Object[]{POF_TASK_NAME});
        }
        if ((javaCompileTestTask = (Task)project.getTasks().findByName("compileTestJava")) != null) {
            javaCompileTestTask.finalizedBy(new Object[]{POF_TASK_NAME});
        }
    }

    private void applyInitialConfig(Project project, CoherenceTask coherenceTask) {
        File testResourcesOutputDir;
        project.getLogger().info("Setting up Task property conventions.");
        coherenceTask.getDebug().convention((Object)false);
        coherenceTask.getInstrumentTestClasses().convention((Object)false);
        Directory mainJavaOutputDir = PluginUtils.getMainJavaOutputDir(project);
        coherenceTask.getMainClassesDirectory().convention((Object)mainJavaOutputDir.getAsFile());
        Directory testJavaOutputDir = PluginUtils.getTestJavaOutputDir(project);
        coherenceTask.getTestClassesDirectory().convention((Object)testJavaOutputDir.getAsFile());
        File fileMainResourcesOutputDir = PluginUtils.getMainResourcesOutputDir(project);
        if (fileMainResourcesOutputDir != null) {
            coherenceTask.getSchemaSourceXmlFile().convention((Object)fileMainResourcesOutputDir);
        }
        if ((testResourcesOutputDir = PluginUtils.getTestResourcesOutputDir(project)) != null) {
            coherenceTask.getTestSchemaSourceXmlFile().convention((Object)testResourcesOutputDir);
        }
    }
}

