/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.rest.events;

import com.oracle.coherence.common.base.Logger;
import com.tangosol.coherence.rest.events.SimpleMapEvent;
import com.tangosol.net.NamedCache;
import com.tangosol.util.Filter;
import com.tangosol.util.InvocableMapHelper;
import com.tangosol.util.MapEvent;
import com.tangosol.util.MapListener;
import com.tangosol.util.WrapperCollections;
import com.tangosol.util.filter.MapEventFilter;
import jakarta.ws.rs.core.MediaType;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Map;
import org.glassfish.jersey.media.sse.EventOutput;
import org.glassfish.jersey.media.sse.OutboundEvent;

public class MapEventOutput<K, V>
extends EventOutput
implements MapListener<K, V> {
    private static final WrapperCollections.ConcurrentWrapperSet<MapEventOutput> REGISTRY = new WrapperCollections.ConcurrentWrapperSet(new HashSet());
    private static final byte[] SSE_EVENT_DELIMITER = "\n".getBytes(StandardCharsets.UTF_8);
    private NamedCache<K, V> m_cache;
    private MapEventFilter m_filter;
    private K m_key;
    private boolean m_fLite;
    private Type m_type = Type.CACHE;

    public MapEventOutput(NamedCache<K, V> cache, boolean fLite) {
        this.m_cache = cache;
        this.m_fLite = fLite;
    }

    public MapEventOutput setFilter(Filter filter) {
        if (this.m_type == Type.KEY) {
            throw new IllegalStateException("Only key or filter can be set, but not both");
        }
        this.m_filter = filter instanceof MapEventFilter ? (MapEventFilter)filter : new MapEventFilter(7, filter);
        this.m_type = Type.FILTER;
        return this;
    }

    public MapEventOutput setKey(K key) {
        if (this.m_type == Type.FILTER) {
            throw new IllegalStateException("Only key or filter can be set, but not both");
        }
        this.m_key = key;
        this.m_type = Type.KEY;
        return this;
    }

    public void close() throws IOException {
        this.unregister();
        super.close();
    }

    public void entryInserted(MapEvent<K, V> evt) {
        this.writeEvent("insert", evt);
    }

    public void entryUpdated(MapEvent<K, V> evt) {
        String sName = "update";
        if (this.m_type == Type.FILTER) {
            Filter filter = this.m_filter.getFilter();
            boolean fOld = InvocableMapHelper.evaluateEntry((Filter)filter, (Map.Entry)evt.getOldEntry());
            boolean fNew = InvocableMapHelper.evaluateEntry((Filter)filter, (Map.Entry)evt.getNewEntry());
            if (!fOld && fNew) {
                sName = "insert";
            } else if (fOld && !fNew) {
                sName = "delete";
            }
        }
        this.writeEvent(sName, evt);
    }

    public void entryDeleted(MapEvent<K, V> evt) {
        this.writeEvent("delete", evt);
    }

    public void register() {
        switch (this.m_type.ordinal()) {
            case 0: {
                this.m_cache.addMapListener((MapListener)this);
                break;
            }
            case 1: {
                this.m_cache.addMapListener((MapListener)this, (Filter)this.m_filter, this.m_fLite);
                break;
            }
            case 2: {
                this.m_cache.addMapListener((MapListener)this, this.m_key, this.m_fLite);
            }
        }
        REGISTRY.add((Object)this);
        if (Logger.isEnabled((int)7)) {
            Logger.finest((String)("Registered listener: " + String.valueOf((Object)this)));
        }
        MapEventOutput co = this;
        try {
            co.write(SSE_EVENT_DELIMITER);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void unregister() {
        switch (this.m_type.ordinal()) {
            case 0: {
                this.m_cache.removeMapListener((MapListener)this);
                break;
            }
            case 1: {
                this.m_cache.removeMapListener((MapListener)this, (Filter)this.m_filter);
                break;
            }
            case 2: {
                this.m_cache.removeMapListener((MapListener)this, this.m_key);
            }
        }
        REGISTRY.remove((Object)this);
        if (Logger.isEnabled((int)7)) {
            Logger.finest((String)("Unregistered listener: " + String.valueOf((Object)this)));
        }
    }

    protected void writeEvent(String sName, MapEvent<? extends K, ? extends V> evt) {
        try {
            this.write(this.createEvent(sName, evt));
        }
        catch (IOException e) {
            if (this.isClosed()) {
                this.unregister();
            }
            throw new RuntimeException(e);
        }
    }

    protected OutboundEvent createEvent(String sName, MapEvent<? extends K, ? extends V> evt) {
        return new OutboundEvent.Builder().name(sName).data(SimpleMapEvent.class, new SimpleMapEvent<K, V>(evt)).mediaType(MediaType.APPLICATION_JSON_TYPE).build();
    }

    public String toString() {
        return "MapEventOutput{cache=" + this.m_cache.getCacheName() + ", filter=" + String.valueOf(this.m_filter) + ", key=" + String.valueOf(this.m_key) + ", fLite=" + this.m_fLite + ", type=" + String.valueOf((Object)this.m_type) + "}";
    }

    private static enum Type {
        CACHE,
        FILTER,
        KEY;

    }
}

