/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.rest.config;

import com.oracle.coherence.common.base.Logger;
import com.tangosol.coherence.config.CacheMapping;
import com.tangosol.coherence.config.Config;
import com.tangosol.coherence.rest.config.AggregatorConfig;
import com.tangosol.coherence.rest.config.DirectQuery;
import com.tangosol.coherence.rest.config.NamedQuery;
import com.tangosol.coherence.rest.config.ProcessorConfig;
import com.tangosol.coherence.rest.config.QueryConfig;
import com.tangosol.coherence.rest.config.QueryEngineConfig;
import com.tangosol.coherence.rest.config.ResourceConfig;
import com.tangosol.coherence.rest.io.KeyConverterAdapter;
import com.tangosol.coherence.rest.io.Marshaller;
import com.tangosol.coherence.rest.io.MarshallerRegistry;
import com.tangosol.coherence.rest.query.QueryEngineRegistry;
import com.tangosol.coherence.rest.util.StaticContent;
import com.tangosol.coherence.rest.util.aggregator.AggregatorRegistry;
import com.tangosol.coherence.rest.util.processor.ProcessorRegistry;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.ConfigurableCacheFactory;
import com.tangosol.net.ExtensibleConfigurableCacheFactory;
import com.tangosol.net.Service;
import com.tangosol.run.xml.XmlDocument;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlHelper;
import com.tangosol.util.Base;
import jakarta.inject.Inject;
import jakarta.ws.rs.core.MediaType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public class RestConfig {
    public static final String DESCRIPTOR_NAME = "coherence-rest-config.xml";
    public static final String DESCRIPTOR_PROPERTY = "coherence.rest.config";
    private Map<String, ResourceConfig> m_mapResources = new HashMap<String, ResourceConfig>();
    @Inject
    private Service m_service;
    @Inject
    private AggregatorRegistry m_aggregatorRegistry;
    @Inject
    private ProcessorRegistry m_processorRegistry;
    @Inject
    private MarshallerRegistry m_marshallerRegistry;
    @Inject
    private QueryEngineRegistry m_queryEngineRegistry;

    public RestConfig(XmlElement xmlConfig) {
        this.configure(xmlConfig);
    }

    public static synchronized RestConfig create() {
        try {
            String sDescriptor = Config.getProperty((String)DESCRIPTOR_PROPERTY, (String)DESCRIPTOR_NAME);
            XmlDocument xml = XmlHelper.loadFileOrResource((String)sDescriptor, (String)"REST configuration");
            return new RestConfig((XmlElement)xml);
        }
        catch (Exception e) {
            Logger.warn((String)"Failed to load REST configuration file coherence-rest-config.xml", (Throwable)e);
            throw Base.ensureRuntimeException((Throwable)e);
        }
    }

    protected void configure(XmlElement xmlConfig) {
        if (xmlConfig == null || !xmlConfig.getRoot().getName().equals("rest") || xmlConfig.getAttribute("xsi:schemaLocation") == null) {
            throw new IllegalArgumentException("invalid REST configuration:\n" + String.valueOf(xmlConfig));
        }
        MarshallerRegistry marshallerRegistry = this.m_marshallerRegistry = new MarshallerRegistry();
        XmlElement xmlDefaults = xmlConfig.getSafeElement("defaults");
        XmlElement xmlMarshallers = xmlDefaults.getSafeElement("marshallers");
        marshallerRegistry.setDefaultMarshallers(this.createMarshallerMap(xmlMarshallers));
        XmlElement xmlResources = xmlConfig.getSafeElement("resources");
        Map<String, ResourceConfig> mapResources = this.createResourceMap(xmlResources);
        this.m_mapResources.putAll(mapResources);
        for (ResourceConfig resourceConfig : mapResources.values()) {
            marshallerRegistry.registerMarshaller(resourceConfig.getKeyClass(), MediaType.WILDCARD_TYPE, (Marshaller)new KeyConverterAdapter(resourceConfig.getKeyConverter()));
        }
        for (ResourceConfig resourceConfig : mapResources.values()) {
            Class clzValue = resourceConfig.getValueClass();
            for (Map.Entry<String, Class> entry : resourceConfig.getMarshallerMap().entrySet()) {
                marshallerRegistry.registerMarshaller(clzValue, entry.getKey(), entry.getValue());
            }
        }
        XmlElement xmlAggregators = xmlConfig.getSafeElement("aggregators");
        this.m_aggregatorRegistry = new AggregatorRegistry(this.createAggregatorMap(xmlAggregators));
        XmlElement xmlProcessors = xmlConfig.getSafeElement("processors");
        this.m_processorRegistry = new ProcessorRegistry(this.createProcessorMap(xmlProcessors));
        XmlElement xmlQueryEngines = xmlConfig.getSafeElement("query-engines");
        this.m_queryEngineRegistry = new QueryEngineRegistry(this.createQueryEngines(xmlQueryEngines));
    }

    protected Map<String, ResourceConfig> createResourceMap(XmlElement xml) {
        HashMap<String, ResourceConfig> mapResources = new HashMap<String, ResourceConfig>();
        Iterator iter = xml.getElements("resource");
        while (iter.hasNext()) {
            XmlElement xmlResource = (XmlElement)iter.next();
            String sCacheName = xmlResource.getSafeElement("cache-name").getString();
            String sAlias = xmlResource.getSafeElement("alias").getString(null);
            String sKeyClass = xmlResource.getSafeElement("key-class").getString(null);
            String sValueClass = xmlResource.getSafeElement("value-class").getString(null);
            String sKeyConverter = xmlResource.getSafeElement("key-converter").getString(null);
            String sResourceName = xmlResource.getSafeAttribute("name").getString();
            int cMaxResults = xmlResource.getSafeAttribute("max-results").getInt(-1);
            Map<String, Class> mapMarshaller = this.createMarshallerMap(xmlResource);
            QueryConfig queryConfig = this.createQueryConfig(xmlResource);
            try {
                ExtensibleConfigurableCacheFactory eccf;
                CacheMapping mapping;
                ConfigurableCacheFactory ccf = CacheFactory.getConfigurableCacheFactory();
                if (ccf instanceof ExtensibleConfigurableCacheFactory && (mapping = (eccf = (ExtensibleConfigurableCacheFactory)ccf).getCacheConfig().getMappingRegistry().findCacheMapping(sCacheName)) != null) {
                    if (sKeyClass == null) {
                        sKeyClass = mapping.getKeyClassName();
                    }
                    if (sValueClass == null) {
                        sValueClass = mapping.getValueClassName();
                    }
                }
                Class<String> clzKey = sKeyClass == null ? String.class : this.getContextClassLoader().loadClass(sKeyClass);
                Class<StaticContent> clzValue = sValueClass == null ? StaticContent.class : this.getContextClassLoader().loadClass(sValueClass);
                Class<?> clzKeyConverter = null;
                if (sKeyConverter != null) {
                    clzKeyConverter = this.getContextClassLoader().loadClass(sKeyConverter);
                }
                ResourceConfig cfgResource = new ResourceConfig();
                cfgResource.setCacheName(sCacheName);
                cfgResource.setKeyClass(clzKey);
                cfgResource.setValueClass(clzValue);
                cfgResource.setKeyConverterClass(clzKeyConverter);
                cfgResource.setMarshallerMap(mapMarshaller);
                cfgResource.setQueryConfig(queryConfig);
                cfgResource.setMaxResults(cMaxResults);
                if (sResourceName == null || sResourceName.isEmpty()) {
                    sResourceName = sAlias == null ? sCacheName : sAlias;
                }
                mapResources.put(sResourceName, cfgResource);
            }
            catch (ClassNotFoundException e) {
                throw Base.ensureRuntimeException((Throwable)e, (String)"class not found while initializing REST configuration");
            }
        }
        return mapResources;
    }

    protected Map<String, Class> createMarshallerMap(XmlElement xml) {
        HashMap<String, Class> mapMarshallers = new HashMap<String, Class>();
        Iterator iter = xml.getElements("marshaller");
        while (iter.hasNext()) {
            Class<?> clz;
            XmlElement xmlMarshaller = (XmlElement)iter.next();
            String sMediaType = xmlMarshaller.getSafeElement("media-type").getString();
            String sClass = xmlMarshaller.getSafeElement("class-name").getString();
            try {
                clz = this.getContextClassLoader().loadClass(sClass);
            }
            catch (ClassNotFoundException e) {
                throw Base.ensureRuntimeException((Throwable)e, (String)("class \"" + sClass + "\" not found while initializing REST configuration"));
            }
            if (Marshaller.class.isAssignableFrom(clz)) {
                mapMarshallers.put(sMediaType, clz);
                continue;
            }
            throw new IllegalArgumentException("class \"" + sClass + "\" does not implement the Marshaller interface");
        }
        return mapMarshallers;
    }

    protected QueryConfig createQueryConfig(XmlElement xml) {
        boolean fEnabled;
        QueryConfig config = new QueryConfig();
        Iterator iter = xml.getElements("query");
        while (iter.hasNext()) {
            XmlElement xmlQuery = (XmlElement)iter.next();
            int cMaxResults = xmlQuery.getSafeAttribute("max-results").getInt(-1);
            String sEngine = xmlQuery.getSafeAttribute("engine").getString();
            String sName = xmlQuery.getSafeElement("name").getString();
            String sExpression = xmlQuery.getSafeElement("expression").getString();
            config.addNamedQuery(new NamedQuery(sName, sExpression, sEngine, cMaxResults));
        }
        XmlElement xmlDirectQuery = xml.getElement("direct-query");
        if (xmlDirectQuery != null && (fEnabled = xmlDirectQuery.getSafeAttribute("enabled").getBoolean(false))) {
            String sEngine = xmlDirectQuery.getSafeAttribute("engine").getString();
            int cMaxResults = xmlDirectQuery.getSafeAttribute("max-results").getInt(-1);
            config.setDirectQuery(new DirectQuery(sEngine, cMaxResults));
        }
        return config;
    }

    protected Collection<AggregatorConfig> createAggregatorMap(XmlElement xml) {
        LinkedList<AggregatorConfig> colAggregators = new LinkedList<AggregatorConfig>();
        Iterator iter = xml.getElements("aggregator");
        while (iter.hasNext()) {
            Class<?> clz;
            XmlElement xmlAggregator = (XmlElement)iter.next();
            String sName = xmlAggregator.getSafeElement("name").getString();
            String sClass = xmlAggregator.getSafeElement("class-name").getString();
            try {
                clz = this.getContextClassLoader().loadClass(sClass);
            }
            catch (ClassNotFoundException e) {
                throw Base.ensureRuntimeException((Throwable)e, (String)("class \"" + sClass + "\" not found while initializing REST configuration"));
            }
            colAggregators.add(new AggregatorConfig(sName, clz));
        }
        return colAggregators;
    }

    protected Collection<ProcessorConfig> createProcessorMap(XmlElement xml) {
        LinkedList<ProcessorConfig> colProcessors = new LinkedList<ProcessorConfig>();
        Iterator iter = xml.getElements("processor");
        while (iter.hasNext()) {
            Class<?> clz;
            XmlElement xmlProcessor = (XmlElement)iter.next();
            String sName = xmlProcessor.getSafeElement("name").getString();
            String sClass = xmlProcessor.getSafeElement("class-name").getString();
            try {
                clz = this.getContextClassLoader().loadClass(sClass);
            }
            catch (ClassNotFoundException e) {
                throw Base.ensureRuntimeException((Throwable)e, (String)("class \"" + sClass + "\" not found while initializing REST configuration"));
            }
            colProcessors.add(new ProcessorConfig(sName, clz));
        }
        return colProcessors;
    }

    protected Collection<QueryEngineConfig> createQueryEngines(XmlElement xml) {
        ArrayList<QueryEngineConfig> colQueryEngines = new ArrayList<QueryEngineConfig>();
        Iterator iter = xml.getElements("engine");
        while (iter.hasNext()) {
            Class<?> clz;
            XmlElement xmlEngine = (XmlElement)iter.next();
            String sName = xmlEngine.getSafeElement("name").getString();
            String sClass = xmlEngine.getSafeElement("class-name").getString();
            try {
                clz = this.getContextClassLoader().loadClass(sClass);
            }
            catch (ClassNotFoundException e) {
                throw Base.ensureRuntimeException((Throwable)e, (String)("class \"" + sClass + "\" not found while initializing REST configuration"));
            }
            colQueryEngines.add(new QueryEngineConfig(sName, clz));
        }
        return colQueryEngines;
    }

    protected ClassLoader getContextClassLoader() {
        return this.m_service == null ? Base.getContextClassLoader((Object)this) : this.m_service.getContextClassLoader();
    }

    public Map<String, ResourceConfig> getResources() {
        return this.m_mapResources;
    }

    public AggregatorRegistry getAggregatorRegistry() {
        return this.m_aggregatorRegistry;
    }

    public ProcessorRegistry getProcessorRegistry() {
        return this.m_processorRegistry;
    }

    public MarshallerRegistry getMarshallerRegistry() {
        return this.m_marshallerRegistry;
    }

    public QueryEngineRegistry getQueryEngineRegistry() {
        return this.m_queryEngineRegistry;
    }
}

