/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.rest;

import com.tangosol.coherence.rest.events.MapEventOutput;
import com.tangosol.coherence.rest.io.Marshaller;
import com.tangosol.coherence.rest.io.MarshallerRegistry;
import com.tangosol.coherence.rest.util.PropertySet;
import com.tangosol.coherence.rest.util.processor.ProcessorRegistry;
import com.tangosol.net.NamedCache;
import com.tangosol.util.Base;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.Versionable;
import com.tangosol.util.processor.VersionedPut;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import javax.inject.Inject;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;

public class EntryResource {
    protected NamedCache m_cache;
    protected Object m_oKey;
    protected Class m_clzValue;
    @Inject
    protected MarshallerRegistry m_marshallerRegistry;
    @Inject
    protected ProcessorRegistry m_processorRegistry;

    public EntryResource(NamedCache cache, Object oKey, Class clzValue) {
        this.m_cache = cache;
        this.m_oKey = oKey;
        this.m_clzValue = clzValue;
    }

    @GET
    public Response get(@MatrixParam(value="p") PropertySet propertySet, @Context Request request) {
        Object oValue = this.getValue();
        if (oValue == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        Response.ResponseBuilder rb = null;
        EntityTag eTag = null;
        if (oValue instanceof Versionable && ((Versionable)oValue).isVersioningEnabled()) {
            String sVersion = ((Versionable)oValue).getVersionIndicator().toString();
            eTag = new EntityTag(sVersion);
            rb = request.evaluatePreconditions(eTag);
        }
        if (rb == null) {
            rb = Response.ok((Object)(propertySet == null ? oValue : propertySet.extract(oValue)));
            if (eTag != null) {
                rb.tag(eTag);
            }
        }
        return rb.build();
    }

    @PUT
    public Response put(@Context HttpHeaders headers, InputStream in) {
        try {
            MediaType mediaType = headers.getMediaType();
            if (mediaType == null || in == null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            Marshaller marshaller = this.m_marshallerRegistry.getMarshaller(this.m_clzValue, mediaType);
            if (marshaller == null) {
                return Response.status((Response.Status)Response.Status.UNSUPPORTED_MEDIA_TYPE).build();
            }
            return this.putInternal(marshaller.unmarshal(in, mediaType));
        }
        catch (IOException e) {
            throw Base.ensureRuntimeException((Throwable)e);
        }
    }

    @DELETE
    public Response delete() {
        Object oOldValue = this.remove();
        return oOldValue == null ? Response.status((Response.Status)Response.Status.NOT_FOUND).build() : Response.ok().build();
    }

    @POST
    @Path(value="{proc: \\s*(\\w(?:\\w|-)*)\\((.*)\\)}")
    @Produces(value={"application/json", "application/xml", "text/plain"})
    public Response process(@PathParam(value="proc") String sProc) {
        InvocableMap.EntryProcessor proc = this.m_processorRegistry.getProcessor(sProc);
        Object oResult = this.m_cache.invoke(this.m_oKey, proc);
        return Response.ok((Object)oResult).build();
    }

    @GET
    @Produces(value={"text/event-stream"})
    public MapEventOutput addListener(@QueryParam(value="lite") boolean fLite) {
        MapEventOutput eventOutput = new MapEventOutput(this.m_cache, fLite);
        eventOutput.setKey(this.m_oKey);
        eventOutput.register();
        return eventOutput;
    }

    protected Response putInternal(Object oValue) {
        Object oConflictingValue = this.setValue(oValue);
        return oConflictingValue == null ? Response.ok().build() : Response.status((Response.Status)Response.Status.CONFLICT).entity(oConflictingValue).build();
    }

    protected Object getValue() {
        return this.m_cache.get(this.m_oKey);
    }

    protected Object setValue(Object oValue) {
        if (oValue instanceof Versionable && ((Versionable)oValue).isVersioningEnabled()) {
            return this.m_cache.invoke(this.m_oKey, (InvocableMap.EntryProcessor)new VersionedPut((Versionable)oValue, true, true));
        }
        this.m_cache.putAll(Collections.singletonMap(this.m_oKey, oValue));
        return null;
    }

    protected Object remove() {
        return this.m_cache.remove(this.m_oKey);
    }

    protected boolean exists() {
        return this.m_cache.keySet().contains(this.m_oKey);
    }
}

