/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.rest;

import com.oracle.coherence.common.base.Logger;
import com.tangosol.coherence.rest.DefaultKeyConverter;
import com.tangosol.coherence.rest.EntryResource;
import com.tangosol.coherence.rest.EntrySetResource;
import com.tangosol.coherence.rest.KeyConverter;
import com.tangosol.coherence.rest.NamedQueryResource;
import com.tangosol.coherence.rest.config.DirectQuery;
import com.tangosol.coherence.rest.config.NamedQuery;
import com.tangosol.coherence.rest.config.QueryConfig;
import com.tangosol.coherence.rest.events.MapEventOutput;
import com.tangosol.coherence.rest.io.MarshallerRegistry;
import com.tangosol.coherence.rest.query.Query;
import com.tangosol.coherence.rest.query.QueryEngine;
import com.tangosol.coherence.rest.query.QueryEngineRegistry;
import com.tangosol.coherence.rest.query.QueryException;
import com.tangosol.coherence.rest.server.InjectionBinder;
import com.tangosol.coherence.rest.util.PropertySet;
import com.tangosol.coherence.rest.util.RestHelper;
import com.tangosol.coherence.rest.util.aggregator.AggregatorRegistry;
import com.tangosol.coherence.rest.util.processor.ProcessorRegistry;
import com.tangosol.net.NamedCache;
import com.tangosol.util.Filter;
import com.tangosol.util.FilterBuildingException;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.QueryHelper;
import com.tangosol.util.SimpleMapEntry;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.filter.AlwaysFilter;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jersey.media.sse.EventOutput;

public class CacheResource {
    static final String BAD_REQUEST_MSG = "An exception occurred while processing the request.";
    protected NamedCache m_cache;
    protected Class m_clzKey;
    protected Class m_clzValue;
    protected KeyConverter m_keyConverter;
    protected int m_cMaxResults;
    @Inject
    protected MarshallerRegistry m_marshallerRegistry;
    protected QueryConfig m_queryConfig;
    @Inject
    protected QueryEngineRegistry m_queryEngineRegistry;
    @Inject
    protected AggregatorRegistry m_aggregatorRegistry;
    @Inject
    protected ProcessorRegistry m_processorRegistry;
    @Inject
    protected ServiceLocator m_serviceLocator;

    public CacheResource(NamedCache cache, Class clzKey, Class clzValue, KeyConverter keyConverter, QueryConfig queryConfig, int cMaxResults) {
        this.m_cache = cache;
        this.m_clzKey = clzKey;
        this.m_clzValue = clzValue;
        this.m_keyConverter = keyConverter == null ? new DefaultKeyConverter(clzKey) : keyConverter;
        this.m_queryConfig = queryConfig;
        this.m_cMaxResults = cMaxResults;
    }

    @GET
    @Produces(value={"application/json", "application/xml"})
    public Response getValues(@MatrixParam(value="start") @DefaultValue(value="0") int nStart, @MatrixParam(value="count") @DefaultValue(value="-1") int cResults, @MatrixParam(value="sort") String sSort, @MatrixParam(value="p") PropertySet propertySet, @QueryParam(value="q") String sQuery) {
        boolean fDirectQuery;
        boolean bl = fDirectQuery = sQuery != null && sQuery.length() > 0;
        if (fDirectQuery && !this.m_queryConfig.isDirectQueryEnabled()) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)"Direct query is not allowed").build();
        }
        ValueExtractor extractor = Map.Entry::getValue;
        if (propertySet != null) {
            extractor = extractor.andThen((ValueExtractor)propertySet);
        }
        try {
            return Response.ok((Object)this.executeQuery(sQuery, extractor, nStart, cResults, sSort)).build();
        }
        catch (QueryException | FilterBuildingException | IllegalArgumentException e) {
            RestHelper.log((Exception)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)BAD_REQUEST_MSG).build();
        }
    }

    @GET
    @Path(value="entries")
    @Produces(value={"application/json", "application/xml", "text/plain"})
    public Response getEntries(@MatrixParam(value="start") @DefaultValue(value="0") int nStart, @MatrixParam(value="count") @DefaultValue(value="-1") int cResults, @MatrixParam(value="sort") String sSort, @MatrixParam(value="p") PropertySet propertySet, @QueryParam(value="q") String sQuery) {
        boolean fDirectQuery;
        boolean bl = fDirectQuery = sQuery != null && sQuery.length() > 0;
        if (fDirectQuery && !this.m_queryConfig.isDirectQueryEnabled()) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)"Direct query is not allowed").build();
        }
        ValueExtractor & Serializable extractor = propertySet == null ? ValueExtractor.identity() : (ValueExtractor & Serializable)entry -> new SimpleMapEntry(entry.getKey(), propertySet.extract(entry.getValue()));
        try {
            return Response.ok((Object)this.executeQuery(sQuery, extractor, nStart, cResults, sSort)).build();
        }
        catch (QueryException | FilterBuildingException | IllegalArgumentException e) {
            RestHelper.log((Exception)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)BAD_REQUEST_MSG).build();
        }
    }

    @GET
    @Path(value="keys")
    @Produces(value={"application/json", "application/xml", "text/plain"})
    public Response getKeys(@QueryParam(value="q") String sQuery) {
        boolean fDirectQuery;
        boolean bl = fDirectQuery = sQuery != null && sQuery.length() > 0;
        if (fDirectQuery && !this.m_queryConfig.isDirectQueryEnabled()) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)"Direct query is not allowed").build();
        }
        try {
            return Response.ok((Object)this.keys(sQuery)).build();
        }
        catch (QueryException | FilterBuildingException | IllegalArgumentException e) {
            RestHelper.log((Exception)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)BAD_REQUEST_MSG).build();
        }
    }

    @GET
    @Path(value="{aggr: \\s*(\\w(?:\\w|-)*)\\((.*)\\)}")
    @Produces(value={"application/json", "application/xml", "text/plain"})
    public Response aggregate(@PathParam(value="aggr") String sAggr, @QueryParam(value="q") String sQuery) {
        Object oResult;
        InvocableMap.EntryAggregator aggregator;
        boolean fDirectQuery;
        QueryConfig queryConfig = this.m_queryConfig;
        NamedCache cache = this.m_cache;
        boolean bl = fDirectQuery = sQuery != null && sQuery.length() > 0;
        if (fDirectQuery && !queryConfig.isDirectQueryEnabled()) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)"Direct query is not allowed").build();
        }
        try {
            aggregator = this.m_aggregatorRegistry.getAggregator(sAggr);
        }
        catch (IllegalArgumentException e) {
            RestHelper.log(e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)BAD_REQUEST_MSG).build();
        }
        if (fDirectQuery) {
            Set setKeys = this.keys(sQuery);
            oResult = cache.aggregate((Collection)setKeys, aggregator);
        } else {
            oResult = cache.aggregate((Filter)AlwaysFilter.INSTANCE, aggregator);
        }
        return Response.ok((Object)oResult).build();
    }

    @POST
    @Path(value="{proc: \\s*(\\w(?:\\w|-)*)\\((.*)\\)}")
    @Produces(value={"application/json", "application/xml"})
    public Response process(@PathParam(value="proc") String sProc, @QueryParam(value="q") String sQuery) {
        Map mapResult;
        InvocableMap.EntryProcessor processor;
        boolean fDirectQuery;
        QueryConfig queryConfig = this.m_queryConfig;
        NamedCache cache = this.m_cache;
        boolean bl = fDirectQuery = sQuery != null && sQuery.length() > 0;
        if (fDirectQuery && !queryConfig.isDirectQueryEnabled()) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)"Direct query is not allowed").build();
        }
        try {
            processor = this.m_processorRegistry.getProcessor(sProc);
        }
        catch (IllegalArgumentException e) {
            RestHelper.log(e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)BAD_REQUEST_MSG).build();
        }
        if (fDirectQuery) {
            Set setKeys = this.keys(sQuery);
            mapResult = cache.invokeAll((Collection)setKeys, processor);
        } else {
            mapResult = cache.invokeAll((Filter)AlwaysFilter.INSTANCE, processor);
        }
        return Response.ok((Object)mapResult).build();
    }

    @GET
    @Produces(value={"text/event-stream"})
    public EventOutput addListener(@MatrixParam(value="lite") boolean fLite, @QueryParam(value="q") String sQuery) {
        MapEventOutput eventOutput = new MapEventOutput(this.m_cache, fLite);
        if (sQuery != null) {
            eventOutput.setFilter(QueryHelper.createFilter((String)sQuery));
        }
        eventOutput.register();
        return eventOutput;
    }

    @Path(value="{key: [^/]+}")
    public Object getEntryOrQueryResource(@PathParam(value="key") String sKey) {
        Object oKey;
        QueryConfig config = this.m_queryConfig;
        if (config.containsNamedQuery(sKey)) {
            return InjectionBinder.inject(this.instantiateNamedQueryResource(this.m_cache, config.getNamedQuery(sKey), this.m_cMaxResults), this.m_serviceLocator);
        }
        try {
            oKey = this.m_keyConverter.fromString(sKey);
        }
        catch (Exception e) {
            Logger.warn((String)("Failed to convert the key \"" + sKey + "\" to a " + this.m_clzKey));
            throw new NotFoundException();
        }
        return InjectionBinder.inject(this.instantiateEntryResource(this.m_cache, oKey, this.m_clzValue), this.m_serviceLocator);
    }

    @Path(value="{keys: \\([^\\)]+\\)}")
    public EntrySetResource getEntrySetResource(@PathParam(value="keys") String sKeys) {
        sKeys = sKeys.substring(1, sKeys.length() - 1);
        KeyConverter converter = this.m_keyConverter;
        String[] asKeys = sKeys.split(",");
        HashSet<Object> setKeys = new HashSet<Object>(asKeys.length);
        for (String sKey : asKeys) {
            try {
                setKeys.add(converter.fromString(sKey.trim()));
            }
            catch (Exception e) {
                Logger.warn((String)("Failed to convert the key \"" + sKey + "\" to a " + this.m_clzKey));
            }
        }
        return InjectionBinder.inject(this.instantiateEntrySetResource(this.m_cache, setKeys, this.m_clzValue), this.m_serviceLocator);
    }

    protected Collection executeQuery(String sQuery, ValueExtractor<Map.Entry, ?> extractor, int nStart, int cResults, String sSort) {
        QueryConfig queryConfig = this.m_queryConfig;
        boolean fDirectQuery = sQuery != null && sQuery.length() > 0;
        DirectQuery directQuery = queryConfig.getDirectQuery();
        String sQueryEngine = directQuery == null ? null : directQuery.getQueryEngineName();
        QueryEngine queryEngine = this.m_queryEngineRegistry.getQueryEngine(sQueryEngine);
        int cQueryMaxResults = directQuery == null || !fDirectQuery ? -1 : directQuery.getMaxResults();
        int cMaxResults = RestHelper.resolveMaxResults(cResults, cQueryMaxResults, this.m_cMaxResults);
        Query query = queryEngine.prepareQuery(sQuery, null);
        return query.execute(this.m_cache, extractor, sSort, nStart, cMaxResults);
    }

    protected Set keys(String sQuery) {
        DirectQuery directQuery = this.m_queryConfig.getDirectQuery();
        String sQueryEngine = directQuery == null ? null : directQuery.getQueryEngineName();
        QueryEngine queryEngine = this.m_queryEngineRegistry.getQueryEngine(sQueryEngine);
        Query query = queryEngine.prepareQuery(sQuery, null);
        return query.keySet(this.m_cache);
    }

    protected EntryResource instantiateEntryResource(NamedCache cache, Object oKey, Class clzValue) {
        return new EntryResource(cache, oKey, clzValue);
    }

    protected EntrySetResource instantiateEntrySetResource(NamedCache cache, Set setKeys, Class clzValue) {
        return new EntrySetResource(cache, setKeys, clzValue);
    }

    public NamedQueryResource instantiateNamedQueryResource(NamedCache cache, NamedQuery query, int cMaxResults) {
        return new NamedQueryResource(cache, query, cMaxResults);
    }
}

