/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.rest.util.aggregator;

import com.tangosol.coherence.rest.config.AggregatorConfig;
import com.tangosol.coherence.rest.util.aggregator.AggregatorFactory;
import com.tangosol.coherence.rest.util.aggregator.DefaultAggregatorFactory;
import com.tangosol.util.Base;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.SafeHashMap;
import com.tangosol.util.aggregator.BigDecimalAverage;
import com.tangosol.util.aggregator.BigDecimalMax;
import com.tangosol.util.aggregator.BigDecimalMin;
import com.tangosol.util.aggregator.BigDecimalSum;
import com.tangosol.util.aggregator.ComparableMax;
import com.tangosol.util.aggregator.ComparableMin;
import com.tangosol.util.aggregator.Count;
import com.tangosol.util.aggregator.DistinctValues;
import com.tangosol.util.aggregator.DoubleAverage;
import com.tangosol.util.aggregator.DoubleMax;
import com.tangosol.util.aggregator.DoubleMin;
import com.tangosol.util.aggregator.DoubleSum;
import com.tangosol.util.aggregator.LongMax;
import com.tangosol.util.aggregator.LongMin;
import com.tangosol.util.aggregator.LongSum;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AggregatorRegistry {
    public static final String AGGREGATOR_REQUEST_REGEX = "\\s*(\\w(?:\\w|-)*)\\((.*)\\)";
    private static final Pattern AGGREGATOR_REQUEST_PATTERN = Pattern.compile("^\\s*(\\w(?:\\w|-)*)\\((.*)\\)");
    private final Map<String, AggregatorFactory> m_mapRegistry = new SafeHashMap();

    public AggregatorRegistry() {
        this.register("big-decimal-average", BigDecimalAverage.class);
        this.register("big-decimal-max", BigDecimalMax.class);
        this.register("big-decimal-min", BigDecimalMin.class);
        this.register("big-decimal-sum", BigDecimalSum.class);
        this.register("comparable-max", ComparableMax.class);
        this.register("comparable-min", ComparableMin.class);
        this.register("count", Count.class);
        this.register("distinct-values", DistinctValues.class);
        this.register("double-average", DoubleAverage.class);
        this.register("double-max", DoubleMax.class);
        this.register("double-min", DoubleMin.class);
        this.register("double-sum", DoubleSum.class);
        this.register("long-max", LongMax.class);
        this.register("long-min", LongMin.class);
        this.register("long-sum", LongSum.class);
    }

    public AggregatorRegistry(Collection<AggregatorConfig> colConfig) {
        this();
        this.register(colConfig);
    }

    public InvocableMap.EntryAggregator getAggregator(String sRequest) {
        Matcher m = AGGREGATOR_REQUEST_PATTERN.matcher(sRequest);
        if (!m.matches()) {
            throw new IllegalArgumentException("bad aggregator request syntax: " + sRequest);
        }
        String sName = m.group(1);
        String sArgs = m.group(2);
        AggregatorFactory factory = this.m_mapRegistry.get(sName);
        if (factory == null) {
            throw new IllegalArgumentException("missing factory for aggregator: " + sName);
        }
        String[] asArgs = new String[]{};
        if (sArgs != null && sArgs.length() > 0) {
            asArgs = sArgs.split(",");
            int c = asArgs.length;
            for (int i = 0; i < c; ++i) {
                asArgs[i] = asArgs[i].trim();
            }
        }
        return factory.getAggregator(asArgs);
    }

    public void register(String sName, AggregatorFactory factory) {
        this.m_mapRegistry.put(sName, factory);
    }

    public void register(String sName, Class clz) {
        try {
            AggregatorFactory factory;
            if (AggregatorFactory.class.isAssignableFrom(clz)) {
                factory = (AggregatorFactory)clz.newInstance();
            } else if (InvocableMap.EntryAggregator.class.isAssignableFrom(clz)) {
                factory = new DefaultAggregatorFactory(clz);
            } else {
                throw new IllegalArgumentException(clz.getName() + " is not an EntryAggregator nor AggregatorFactory");
            }
            this.register(sName, factory);
        }
        catch (Exception e) {
            throw Base.ensureRuntimeException((Throwable)e);
        }
    }

    public void register(Collection<AggregatorConfig> colConfig) {
        for (AggregatorConfig config : colConfig) {
            this.register(config.getAggregatorName(), config.getAggregatorClass());
        }
    }
}

