/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.rest.query;

import com.tangosol.coherence.rest.config.QueryEngineConfig;
import com.tangosol.coherence.rest.query.CoherenceQueryLanguageEngine;
import com.tangosol.coherence.rest.query.QueryEngine;
import com.tangosol.util.Base;
import com.tangosol.util.SafeHashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

public class QueryEngineRegistry {
    private static final String DEFAULT = "DEFAULT";
    protected Map<String, QueryEngine> m_mapQueryEngines = new SafeHashMap();

    public QueryEngineRegistry() {
        this(Collections.emptyList());
    }

    public QueryEngineRegistry(Collection<? extends QueryEngineConfig> colConfig) {
        this.registerQueryEngine(DEFAULT, new CoherenceQueryLanguageEngine());
        for (QueryEngineConfig queryEngineConfig : colConfig) {
            this.registerQueryEngine(queryEngineConfig.getQueryEngineName(), QueryEngineRegistry.createQueryEngine(queryEngineConfig.getQueryEngineClass()));
        }
    }

    public void registerQueryEngine(String sName, Class clzQueryEngine) {
        this.registerQueryEngine(sName, QueryEngineRegistry.createQueryEngine(clzQueryEngine));
    }

    public void registerQueryEngine(String sName, QueryEngine queryEngine) {
        this.m_mapQueryEngines.put(sName, queryEngine);
    }

    public QueryEngine getQueryEngine(String sName) {
        QueryEngine engine = this.m_mapQueryEngines.get(sName);
        if (engine == null) {
            engine = this.getDefaultQueryEngine();
        }
        return engine;
    }

    private QueryEngine getDefaultQueryEngine() {
        return this.m_mapQueryEngines.get(DEFAULT);
    }

    protected static QueryEngine createQueryEngine(Class clzQueryEngine) {
        if (clzQueryEngine == null || !QueryEngine.class.isAssignableFrom(clzQueryEngine)) {
            throw new IllegalArgumentException("invalid query engine class: " + String.valueOf(clzQueryEngine));
        }
        try {
            return (QueryEngine)clzQueryEngine.newInstance();
        }
        catch (Exception e) {
            throw Base.ensureRuntimeException((Throwable)e, (String)"error creating query engine");
        }
    }
}

