/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.rest.util;

import com.oracle.coherence.common.base.Logger;
import com.tangosol.coherence.mvel2.ParserContext;
import com.tangosol.util.Base;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;

public abstract class RestHelper {
    private static WeakHashMap<ClassLoader, ParserContext> s_mapParserContextByLoader = new WeakHashMap();

    public static Map<String, Object> getQueryParameters(UriInfo uriInfo) {
        MultivaluedMap mapQueryParams = uriInfo.getQueryParameters();
        HashMap<String, Object> mapParams = new HashMap<String, Object>(mapQueryParams.size());
        Iterator iterator = mapQueryParams.keySet().iterator();
        while (iterator.hasNext()) {
            String sKey;
            List listValues = (List)mapQueryParams.get((Object)(sKey = (String)iterator.next()));
            mapParams.put(sKey, listValues.size() == 1 ? listValues.get(0) : listValues);
        }
        return mapParams;
    }

    public static int resolveMaxResults(int cParamMax, int cQueryMax, int cResourceMax) {
        int cMax = cResourceMax;
        if (cQueryMax >= 0) {
            cMax = cQueryMax;
        }
        if (cParamMax >= 0) {
            cMax = cMax >= 0 ? Math.min(cParamMax, cMax) : cParamMax;
        }
        return cMax;
    }

    public static void log(Exception ex) {
        if (ex instanceof RuntimeException && ex.getMessage().contains("unknown user type")) {
            throw (RuntimeException)ex;
        }
        Logger.finer(() -> {
            Throwable exCause = ex.getCause();
            String sCause = exCause == null ? null : String.format(" Cause: " + exCause.getClass().getName() + " : " + exCause.getLocalizedMessage(), new Object[0]);
            return "Rest Server exception: " + ex.getClass().getName() + " : " + ex.getLocalizedMessage() + sCause;
        });
    }

    public static ParserContext getMvelParserContext() {
        ClassLoader contextLoader = Base.getContextClassLoader();
        return s_mapParserContextByLoader.computeIfAbsent(contextLoader, RestHelper::makeParserContext);
    }

    private static ParserContext makeParserContext(ClassLoader contextLoader) {
        ParserContext ctx = new ParserContext();
        ctx.addPackageImport("java.util");
        ctx.getParserConfiguration().setClassLoader(contextLoader);
        return ctx;
    }
}

