/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.mvel2.ast;

import com.tangosol.coherence.mvel2.MVEL;
import com.tangosol.coherence.mvel2.ParserContext;
import com.tangosol.coherence.mvel2.ast.ASTNode;
import com.tangosol.coherence.mvel2.compiler.ExecutableStatement;
import com.tangosol.coherence.mvel2.integration.VariableResolver;
import com.tangosol.coherence.mvel2.integration.VariableResolverFactory;
import com.tangosol.coherence.mvel2.math.MathProcessor;
import com.tangosol.coherence.mvel2.util.ParseTools;

public class IndexedOperativeAssign
extends ASTNode {
    private final int register;
    private ExecutableStatement statement;
    private final int operation;

    public IndexedOperativeAssign(char[] expr, int start, int offset, int operation, int register, int fields, ParserContext pCtx) {
        super(pCtx);
        this.operation = operation;
        this.expr = expr;
        this.start = start;
        this.offset = offset;
        this.register = register;
        if ((fields & 0x10) != 0) {
            this.statement = (ExecutableStatement)ParseTools.subCompileExpression(expr, start, offset, pCtx);
            this.egressType = this.statement.getKnownEgressType();
        }
    }

    @Override
    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        VariableResolver resolver = factory.getIndexedVariableResolver(this.register);
        ctx = MathProcessor.doOperations(resolver.getValue(), this.operation, this.statement.getValue(ctx, thisValue, factory));
        resolver.setValue(ctx);
        return ctx;
    }

    @Override
    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        VariableResolver resolver = factory.getIndexedVariableResolver(this.register);
        ctx = MathProcessor.doOperations(resolver.getValue(), this.operation, MVEL.eval(this.expr, this.start, this.offset, ctx, factory));
        resolver.setValue(ctx);
        return ctx;
    }
}

