/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.mvel2.ast;

import com.tangosol.coherence.mvel2.CompileException;
import com.tangosol.coherence.mvel2.MVEL;
import com.tangosol.coherence.mvel2.ParserContext;
import com.tangosol.coherence.mvel2.ast.ASTNode;
import com.tangosol.coherence.mvel2.compiler.ExecutableStatement;
import com.tangosol.coherence.mvel2.integration.VariableResolverFactory;
import com.tangosol.coherence.mvel2.util.ParseTools;

public class AssertNode
extends ASTNode {
    public ExecutableStatement assertion;
    public ExecutableStatement fail;

    public AssertNode(char[] expr, int start, int offset, int fields, ParserContext pCtx) {
        super(pCtx);
        this.expr = expr;
        this.start = start;
        this.offset = offset;
        if ((fields & 0x10) != 0) {
            this.assertion = (ExecutableStatement)ParseTools.subCompileExpression(expr, start, offset, pCtx);
        }
    }

    @Override
    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        try {
            if (!((Boolean)this.assertion.getValue(ctx, thisValue, factory)).booleanValue()) {
                throw new AssertionError((Object)("assertion failed in expression: " + new String(this.expr, this.start, this.offset)));
            }
            return true;
        }
        catch (ClassCastException e) {
            throw new CompileException("assertion does not contain a boolean statement", this.expr, this.start);
        }
    }

    @Override
    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        try {
            if (!((Boolean)MVEL.eval(this.expr, ctx, factory)).booleanValue()) {
                throw new AssertionError((Object)("assertion failed in expression: " + new String(this.expr, this.start, this.offset)));
            }
            return true;
        }
        catch (ClassCastException e) {
            throw new CompileException("assertion does not contain a boolean statement", this.expr, this.start);
        }
    }
}

