/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.mvel2.optimizers.impl.refl.nodes;

import com.tangosol.coherence.mvel2.DataConversion;
import com.tangosol.coherence.mvel2.compiler.AccessorNode;
import com.tangosol.coherence.mvel2.compiler.ExecutableStatement;
import com.tangosol.coherence.mvel2.integration.VariableResolverFactory;
import com.tangosol.coherence.mvel2.util.ParseTools;
import java.lang.reflect.Array;

public class ArrayAccessorNest
implements AccessorNode {
    private AccessorNode nextNode;
    private ExecutableStatement index;
    private Class baseComponentType;
    private boolean requireConversion;

    public ArrayAccessorNest() {
    }

    public ArrayAccessorNest(String index) {
        this.index = (ExecutableStatement)ParseTools.subCompileExpression(index.toCharArray());
    }

    public ArrayAccessorNest(ExecutableStatement stmt) {
        this.index = stmt;
    }

    @Override
    public Object getValue(Object ctx, Object elCtx, VariableResolverFactory vars) {
        if (this.nextNode != null) {
            return this.nextNode.getValue(((Object[])ctx)[(Integer)this.index.getValue(ctx, elCtx, vars)], elCtx, vars);
        }
        return ((Object[])ctx)[(Integer)this.index.getValue(ctx, elCtx, vars)];
    }

    @Override
    public Object setValue(Object ctx, Object elCtx, VariableResolverFactory vars, Object value) {
        if (this.nextNode != null) {
            return this.nextNode.setValue(((Object[])ctx)[(Integer)this.index.getValue(ctx, elCtx, vars)], elCtx, vars, value);
        }
        if (this.baseComponentType == null) {
            this.baseComponentType = ParseTools.getBaseComponentType(ctx.getClass());
            boolean bl = this.requireConversion = this.baseComponentType != value.getClass() && !this.baseComponentType.isAssignableFrom(value.getClass());
        }
        if (this.requireConversion) {
            Object o = DataConversion.convert(value, this.baseComponentType);
            Array.set(ctx, (Integer)this.index.getValue(ctx, elCtx, vars), o);
            return o;
        }
        Array.set(ctx, (Integer)this.index.getValue(ctx, elCtx, vars), value);
        return value;
    }

    public ExecutableStatement getIndex() {
        return this.index;
    }

    public void setIndex(ExecutableStatement index) {
        this.index = index;
    }

    @Override
    public AccessorNode getNextNode() {
        return this.nextNode;
    }

    @Override
    public AccessorNode setNextNode(AccessorNode nextNode) {
        this.nextNode = nextNode;
        return this.nextNode;
    }

    @Override
    public Class getKnownEgressType() {
        return this.baseComponentType;
    }

    public String toString() {
        return "Array Accessor -> [" + this.index + "]";
    }
}

