/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.mvel2.ast;

import com.tangosol.coherence.mvel2.CompileException;
import com.tangosol.coherence.mvel2.ParserContext;
import com.tangosol.coherence.mvel2.ast.ASTNode;
import com.tangosol.coherence.mvel2.ast.Assignment;
import com.tangosol.coherence.mvel2.compiler.ExecutableStatement;
import com.tangosol.coherence.mvel2.integration.VariableResolverFactory;
import com.tangosol.coherence.mvel2.util.ParseTools;

public class DeclTypedVarNode
extends ASTNode
implements Assignment {
    private String name;

    public DeclTypedVarNode(String name, char[] expr, int start, int offset, Class type, int fields, ParserContext pCtx) {
        super(pCtx);
        this.egressType = type;
        this.name = name;
        ParseTools.checkNameSafety(this.name);
        this.expr = expr;
        this.start = start;
        this.offset = offset;
        if ((fields & 0x10) != 0) {
            pCtx.addVariable(name, this.egressType, true);
        }
    }

    @Override
    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        if (factory.isResolveable(this.name)) {
            throw new CompileException("variable defined within scope: " + this.name, this.expr, this.start);
        }
        factory.createVariable(this.name, null, this.egressType);
        return null;
    }

    @Override
    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        if (factory.isResolveable(this.name)) {
            throw new CompileException("variable defined within scope: " + this.name, this.expr, this.start);
        }
        factory.createVariable(this.name, null, this.egressType);
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getAssignmentVar() {
        return this.name;
    }

    @Override
    public char[] getExpression() {
        return new char[0];
    }

    @Override
    public boolean isAssignment() {
        return true;
    }

    @Override
    public boolean isNewDeclaration() {
        return true;
    }

    @Override
    public void setValueStatement(ExecutableStatement stmt) {
        throw new RuntimeException("illegal operation");
    }

    @Override
    public String toString() {
        return "var:" + this.name;
    }
}

