/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.mvel2.ast;

import com.tangosol.coherence.mvel2.CompileException;
import com.tangosol.coherence.mvel2.MVEL;
import com.tangosol.coherence.mvel2.ParserContext;
import com.tangosol.coherence.mvel2.ast.ASTNode;
import com.tangosol.coherence.mvel2.compiler.ExecutableLiteral;
import com.tangosol.coherence.mvel2.compiler.ExecutableStatement;
import com.tangosol.coherence.mvel2.integration.VariableResolverFactory;
import com.tangosol.coherence.mvel2.util.ParseTools;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class RegExMatch
extends ASTNode {
    private ExecutableStatement stmt;
    private ExecutableStatement patternStmt;
    private int patternStart;
    private int patternOffset;
    private Pattern p;

    public RegExMatch(char[] expr, int start, int offset, int fields, int patternStart, int patternOffset, ParserContext pCtx) {
        super(pCtx);
        this.expr = expr;
        this.start = start;
        this.offset = offset;
        this.patternStart = patternStart;
        this.patternOffset = patternOffset;
        if ((fields & 0x10) != 0) {
            this.stmt = (ExecutableStatement)ParseTools.subCompileExpression(expr, start, offset, pCtx);
            this.patternStmt = (ExecutableStatement)ParseTools.subCompileExpression(expr, patternStart, patternOffset, pCtx);
            if (this.patternStmt instanceof ExecutableLiteral) {
                try {
                    this.p = Pattern.compile(String.valueOf(this.patternStmt.getValue(null, null)));
                }
                catch (PatternSyntaxException e) {
                    throw new CompileException("bad regular expression", expr, patternStart, e);
                }
            }
        }
    }

    @Override
    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        if (this.p == null) {
            return Pattern.compile(String.valueOf(this.patternStmt.getValue(ctx, thisValue, factory))).matcher(String.valueOf(this.stmt.getValue(ctx, thisValue, factory))).matches();
        }
        return this.p.matcher(String.valueOf(this.stmt.getValue(ctx, thisValue, factory))).matches();
    }

    @Override
    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        try {
            return Pattern.compile(String.valueOf(MVEL.eval(this.expr, this.patternStart, this.patternOffset, ctx, factory))).matcher(String.valueOf(MVEL.eval(this.expr, this.start, this.offset, ctx, factory))).matches();
        }
        catch (PatternSyntaxException e) {
            throw new CompileException("bad regular expression", this.expr, this.patternStart, e);
        }
    }

    @Override
    public Class getEgressType() {
        return Boolean.class;
    }

    public Pattern getPattern() {
        return this.p;
    }

    public ExecutableStatement getStatement() {
        return this.stmt;
    }

    public ExecutableStatement getPatternStatement() {
        return this.patternStmt;
    }
}

