/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.rag.loader.google.cloudstorage;

import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.Storage;
import com.oracle.coherence.rag.DocumentLoader;
import com.oracle.coherence.rag.parser.ParserSupplier;
import dev.langchain4j.data.document.Document;
import dev.langchain4j.data.document.DocumentParser;
import dev.langchain4j.data.document.DocumentSource;
import dev.langchain4j.data.document.Metadata;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.Collections;
import java.util.Map;

@Named(value="gcs")
@ApplicationScoped
public class GoogleCloudStorageDocumentLoader
implements DocumentLoader {
    private final Storage m_client;
    private final ParserSupplier m_parserSupplier;

    @Inject
    public GoogleCloudStorageDocumentLoader(Storage client, ParserSupplier parserSupplier) {
        this.m_client = client;
        this.m_parserSupplier = parserSupplier;
    }

    public Document load(final URI uri) {
        final String bucket = uri.getHost();
        final String object = uri.getPath().substring(1);
        BlobId blobId = BlobId.of((String)bucket, (String)object);
        final Blob blob = this.m_client.get(blobId);
        DocumentSource source = new DocumentSource(){

            public InputStream inputStream() throws IOException {
                return Channels.newInputStream((ReadableByteChannel)blob.reader(new Blob.BlobSourceOption[0]));
            }

            public Metadata metadata() {
                Map properties = blob.getMetadata() == null ? Collections.emptyMap() : blob.getMetadata();
                Metadata metadata = Metadata.from((Map)properties);
                metadata.put("url", uri.toString());
                metadata.put("bucket", bucket);
                metadata.put("object", object);
                metadata.put("content_length", blob.getSize().longValue());
                metadata.put("content_type", blob.getContentType());
                metadata.put("etag", blob.getEtag());
                return metadata;
            }
        };
        return dev.langchain4j.data.document.DocumentLoader.load((DocumentSource)source, (DocumentParser)this.m_parserSupplier.get());
    }
}

