/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.protobuf;

import com.google.protobuf.Message;
import com.oracle.coherence.common.base.Classes;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofSerializer;
import com.tangosol.io.pof.PofWriter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;

public class ProtobufPofSerializer
implements PofSerializer<Message> {
    public void serialize(PofWriter out, Message message) throws IOException {
        out.writeString(0, message.getClass().getName());
        out.writeByteArray(1, message.toByteArray());
        out.writeRemainder(null);
    }

    public Message deserialize(PofReader in) throws IOException {
        String sClass = in.readString(0);
        byte[] ab = in.readByteArray(1);
        try {
            Class<?> clz = Class.forName(sClass);
            return (Message)Classes.invoke(clz, null, (String)"parseFrom", (Object[])new Object[]{ab});
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Could find class " + sClass, e);
        }
        catch (NoSuchMethodException e) {
            throw new IOException("Could not deserialize an instance of " + sClass + " as it does not have a static parseFrom method", e);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IOException("Could not deserialize an instance of " + sClass, e);
        }
    }
}

