/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.mp.config;

import com.oracle.coherence.cdi.events.Activated;
import com.oracle.coherence.cdi.events.MapName;
import com.oracle.coherence.cdi.events.ScopeName;
import com.oracle.coherence.common.base.Classes;
import com.oracle.coherence.mp.config.ConfigPropertyChanged;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.partitionedService.PartitionedCache;
import com.tangosol.net.CacheService;
import com.tangosol.net.ConfigurableCacheFactory;
import com.tangosol.net.NamedMap;
import com.tangosol.net.events.EventDispatcher;
import com.tangosol.net.events.EventDispatcherAwareInterceptor;
import com.tangosol.net.events.EventInterceptor;
import com.tangosol.net.events.application.LifecycleEvent;
import com.tangosol.net.events.partition.cache.CacheLifecycleEvent;
import com.tangosol.net.events.partition.cache.CacheLifecycleEventDispatcher;
import com.tangosol.net.events.partition.cache.PartitionedCacheDispatcher;
import com.tangosol.util.MapEvent;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.event.Event;
import jakarta.enterprise.event.Observes;
import jakarta.inject.Inject;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.ConfigBuilder;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;
import org.eclipse.microprofile.config.spi.ConfigSource;

@ApplicationScoped
public class CoherenceConfigSource
implements ConfigSource,
EventDispatcherAwareInterceptor<CacheLifecycleEvent> {
    private static final String MAP_NAME = "sys$config";
    private static final int DEFAULT_ORDINAL = 500;
    public static final String ORDINAL_PROPERTY = "coherence.config.ordinal";
    private final int m_nOrdinal;
    private volatile NamedMap<String, String> m_configMap;
    @Inject
    private Event<ConfigPropertyChanged> m_propertyChanged;

    public CoherenceConfigSource() {
        ConfigProviderResolver resolver = ConfigProviderResolver.instance();
        ConfigBuilder builder = resolver.getBuilder();
        Config config = builder.addDefaultSources().build();
        this.m_nOrdinal = config.getOptionalValue(ORDINAL_PROPERTY, Integer.class).orElse(500);
    }

    public Map<String, String> getProperties() {
        return this.m_configMap == null ? Collections.emptyMap() : Collections.unmodifiableMap(this.m_configMap);
    }

    public Set<String> getPropertyNames() {
        return this.m_configMap == null ? Collections.emptySet() : Collections.unmodifiableSet(this.m_configMap.keySet());
    }

    public int getOrdinal() {
        return this.m_nOrdinal;
    }

    public String getValue(String key) {
        if (this.m_configMap == null) {
            return null;
        }
        CacheService service = this.m_configMap.getService();
        if (service instanceof PartitionedCache && ((PartitionedCache)service).isServiceThread(true)) {
            return null;
        }
        return (String)this.m_configMap.get((Object)key);
    }

    public String getName() {
        return "CoherenceConfigSource";
    }

    public String setValue(String sKey, String sValue) {
        if (this.m_configMap == null) {
            return null;
        }
        CacheService service = this.m_configMap.getService();
        if (service instanceof PartitionedCache && ((PartitionedCache)service).isServiceThread(true)) {
            return null;
        }
        return (String)this.m_configMap.put((Object)sKey, (Object)sValue);
    }

    void onPropertyChange(@Observes @ScopeName(value="$SYS") @MapName(value="sys$config") MapEvent<String, String> event) {
        ConfigPropertyChanged changed = new ConfigPropertyChanged(event);
        this.m_propertyChanged.fireAsync((Object)changed);
        this.m_propertyChanged.fire((Object)changed);
    }

    void onSystemScopeActivated(@Observes @ScopeName(value="$SYS") @Activated LifecycleEvent e) {
        ConfigurableCacheFactory ccf = e.getConfigurableCacheFactory();
        ccf.getInterceptorRegistry().registerEventInterceptor((EventInterceptor)this);
        CompletableFuture.runAsync(() -> ccf.ensureCache(MAP_NAME, null));
    }

    public void introduceEventDispatcher(String sIdentifier, EventDispatcher dispatcher) {
        if (dispatcher instanceof CacheLifecycleEventDispatcher && ((CacheLifecycleEventDispatcher)dispatcher).getCacheName().equals(MAP_NAME)) {
            dispatcher.addEventInterceptor("$SYS:Config", (EventInterceptor)this);
        }
    }

    public void onEvent(CacheLifecycleEvent event) {
        if (!event.getCacheName().equals(MAP_NAME)) {
            return;
        }
        if (event.getType() == CacheLifecycleEvent.Type.CREATED) {
            this.m_configMap = ((PartitionedCacheDispatcher)event.getEventDispatcher()).getBackingMapContext().getManagerContext().getCacheService().ensureCache(MAP_NAME, Classes.getContextClassLoader());
        }
    }

    public NamedMap<String, String> getConfigMap() {
        return this.m_configMap;
    }
}

