/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.mp.config;

import com.oracle.coherence.cdi.events.Activated;
import com.oracle.coherence.cdi.events.MapName;
import com.oracle.coherence.cdi.events.ScopeName;
import com.oracle.coherence.mp.config.ConfigPropertyChanged;
import com.tangosol.net.NamedMap;
import com.tangosol.net.events.application.LifecycleEvent;
import com.tangosol.util.MapEvent;
import java.util.Collections;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.ConfigBuilder;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;
import org.eclipse.microprofile.config.spi.ConfigSource;

@ApplicationScoped
public class CoherenceConfigSource
implements ConfigSource {
    private static final String MAP_NAME = "sys$config";
    private static final int DEFAULT_ORDINAL = 500;
    public static final String ORDINAL_PROPERTY = "coherence.config.ordinal";
    private final int m_nOrdinal;
    private volatile NamedMap<String, String> m_configMap;
    @Inject
    private Event<ConfigPropertyChanged> m_propertyChanged;

    public CoherenceConfigSource() {
        ConfigProviderResolver resolver = ConfigProviderResolver.instance();
        ConfigBuilder builder = resolver.getBuilder();
        Config config = builder.addDefaultSources().build();
        this.m_nOrdinal = config.getOptionalValue(ORDINAL_PROPERTY, Integer.class).orElse(500);
    }

    public Map<String, String> getProperties() {
        return this.m_configMap == null ? Collections.emptyMap() : Collections.unmodifiableMap(this.m_configMap);
    }

    public int getOrdinal() {
        return this.m_nOrdinal;
    }

    public String getValue(String key) {
        return this.m_configMap == null ? null : (String)this.m_configMap.get((Object)key);
    }

    public String getName() {
        return "CoherenceConfigSource";
    }

    public String setValue(String sKey, String sValue) {
        if (this.m_configMap != null) {
            return (String)this.m_configMap.put((Object)sKey, (Object)sValue);
        }
        return null;
    }

    void onPropertyChange(@Observes @ScopeName(value="SYS") @MapName(value="sys$config") MapEvent<String, String> event) {
        ConfigPropertyChanged changed = new ConfigPropertyChanged(event);
        this.m_propertyChanged.fireAsync((Object)changed);
        this.m_propertyChanged.fire((Object)changed);
    }

    void onSystemScopeActivated(@Observes @ScopeName(value="SYS") @Activated LifecycleEvent e) {
        this.m_configMap = e.getConfigurableCacheFactory().ensureCache(MAP_NAME, null);
    }

    NamedMap<String, String> getConfigMap() {
        return this.m_configMap;
    }
}

