/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.management;

import com.tangosol.coherence.config.Config;
import com.tangosol.coherence.management.internal.ClusterNameSupplier;
import com.tangosol.coherence.management.internal.DenySniffResponseFilter;
import com.tangosol.coherence.management.internal.ManagementRootResource;
import com.tangosol.coherence.management.internal.MapProvider;
import com.tangosol.coherence.management.internal.MetricsResource;
import com.tangosol.coherence.management.internal.MetricsWriter;
import com.tangosol.coherence.management.internal.VersionedRootResource;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.management.MBeanServerProxy;
import com.tangosol.net.management.WrapperMBeanServerProxy;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import javax.management.MBeanServer;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.message.GZipEncoder;
import org.glassfish.jersey.process.internal.RequestScoped;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.filter.EncodingFilter;

public final class RestManagement {
    private RestManagement() {
    }

    public static void configure(ResourceConfig resourceConfig) {
        RestManagement.configure(resourceConfig, MBeanServerProxyFactory.DEFAULT, null, false);
    }

    public static void configure(ResourceConfig resourceConfig, MBeanServerProxyFactory factory) {
        RestManagement.configure(resourceConfig, factory, null, false);
    }

    public static void configure(ResourceConfig resourceConfig, Supplier<MBeanServer> factory) {
        RestManagement.configure(resourceConfig, RestManagement.createMBeanServerProxyFactory(factory), null, false);
    }

    public static void configure(ResourceConfig resourceConfig, Supplier<MBeanServer> factory, Supplier<Set<String>> supplierClusters) {
        RestManagement.configure(resourceConfig, RestManagement.createMBeanServerProxyFactory(factory), supplierClusters, false);
    }

    public static void configureMetrics(ResourceConfig resourceConfig, Supplier<MBeanServer> factory, Supplier<Set<String>> supplierClusters) {
        RestManagement.configure(resourceConfig, RestManagement.createMBeanServerProxyFactory(factory), supplierClusters, true);
    }

    private static void configure(ResourceConfig resourceConfig, MBeanServerProxyFactory factory, Supplier<Set<String>> supplierClusters, boolean fMetrics) {
        Objects.requireNonNull(resourceConfig);
        resourceConfig.register(MapProvider.class);
        resourceConfig.register((Object)new MBeanServerProxyBinder(Objects.requireNonNull(factory)));
        resourceConfig.register(DenySniffResponseFilter.class);
        EncodingFilter.enableFor((ResourceConfig)resourceConfig, (Class[])new Class[]{GZipEncoder.class});
        if (fMetrics) {
            if (Config.getBoolean((String)"coherence.metrics.http.enabled", (boolean)false)) {
                resourceConfig.register(MetricsWriter.class);
                resourceConfig.register(MetricsResource.class);
            }
        } else if (supplierClusters == null) {
            resourceConfig.register(ManagementRootResource.class);
        } else {
            resourceConfig.register((Object)new ClusterNameSupplier.Binder(supplierClusters::get));
            resourceConfig.register(VersionedRootResource.class);
        }
    }

    private static MBeanServerProxyFactory createMBeanServerProxyFactory(Supplier<MBeanServer> supplier) {
        return () -> new WrapperMBeanServerProxy(Objects.requireNonNull(supplier));
    }

    @FunctionalInterface
    public static interface MBeanServerProxyFactory {
        public static final MBeanServerProxyFactory DEFAULT = () -> CacheFactory.getCluster().getManagement().getMBeanServerProxy();

        public MBeanServerProxy get();
    }

    private static class MBeanServerProxyBinder
    extends AbstractBinder {
        private final MBeanServerProxyFactory f_factory;

        private MBeanServerProxyBinder(MBeanServerProxyFactory factory) {
            this.f_factory = factory;
        }

        protected void configure() {
            this.bindFactory(new Supplier<MBeanServerProxy>(){

                @Override
                @RequestScoped
                public MBeanServerProxy get() {
                    return f_factory.get();
                }
            }).to(MBeanServerProxy.class);
        }
    }
}

