/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.management.internal;

import com.tangosol.internal.http.HttpMethod;
import com.tangosol.internal.http.HttpRequest;
import com.tangosol.internal.http.PathParameters;
import com.tangosol.internal.http.QueryParameters;
import com.tangosol.util.ResourceRegistry;
import com.tangosol.util.SimpleResourceRegistry;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.core.PathSegment;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.core.UriInfo;
import java.io.InputStream;
import java.net.URI;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class JaxRsRequest
implements HttpRequest {
    private final ContainerRequestContext f_request;
    private final QueryParameters f_queryParameters;
    private final ResourceRegistry f_resourceRegistry;
    private PathParameters m_pathParameters;
    private Map<String, Object> m_mapBody;

    public JaxRsRequest(ContainerRequestContext request) {
        this.f_request = request;
        this.f_queryParameters = new JaxRsQueryParameters(request.getUriInfo());
        this.f_resourceRegistry = new SimpleResourceRegistry();
        this.m_pathParameters = new JaxRsPathParameters(request.getUriInfo());
    }

    public HttpMethod getMethod() {
        return HttpMethod.valueOf((String)this.f_request.getMethod());
    }

    public String getHeaderString(String sName) {
        return this.f_request.getHeaderString(sName);
    }

    public URI getBaseURI() {
        return this.f_request.getUriInfo().getBaseUri();
    }

    public URI getRequestURI() {
        return this.f_request.getUriInfo().getRequestUri();
    }

    public QueryParameters getQueryParameters() {
        return this.f_queryParameters;
    }

    public PathParameters getPathParameters() {
        return this.m_pathParameters;
    }

    public void setPathParameters(PathParameters parameters) {
        this.m_pathParameters = parameters;
    }

    public InputStream getBody() {
        return this.f_request.getEntityStream();
    }

    public synchronized Map<String, Object> getJsonBody(Function<InputStream, Map<String, Object>> fnParser) {
        if (this.m_mapBody == null) {
            Map<String, Object> mapBody;
            this.m_mapBody = this.f_request.hasEntity() ? ((mapBody = fnParser.apply(this.getBody())) == null ? Collections.emptyMap() : mapBody) : new LinkedHashMap<String, Object>();
        }
        return this.m_mapBody;
    }

    public ResourceRegistry getResourceRegistry() {
        return this.f_resourceRegistry;
    }

    protected URI getParentUri(UriInfo uriInfo) {
        int count = this.getParentUriSegmentsCount(uriInfo);
        List pathSegments = uriInfo.getPathSegments();
        UriBuilder bldr = uriInfo.getBaseUriBuilder();
        for (int i = 0; i < count; ++i) {
            bldr.path(((PathSegment)pathSegments.get(i)).getPath());
        }
        return bldr.build(new Object[0]);
    }

    public int getParentUriSegmentsCount(UriInfo uriInfo) {
        int count;
        List pathSegments = uriInfo.getPathSegments();
        if (((PathSegment)pathSegments.get(count = pathSegments.size() - 1)).getPath().isEmpty()) {
            --count;
        }
        return count;
    }

    public static class JaxRsQueryParameters
    implements QueryParameters {
        private final UriInfo f_uriInfo;

        public JaxRsQueryParameters(UriInfo uriInfo) {
            this.f_uriInfo = uriInfo;
        }

        public String getFirst(String sKey) {
            return (String)this.f_uriInfo.getQueryParameters(true).getFirst((Object)sKey);
        }
    }

    public static class JaxRsPathParameters
    implements PathParameters {
        private final UriInfo f_uriInfo;

        public JaxRsPathParameters(UriInfo uriInfo) {
            this.f_uriInfo = uriInfo;
        }

        public String getFirst(String sKey) {
            return (String)this.f_uriInfo.getPathParameters(true).getFirst((Object)sKey);
        }
    }
}

