/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.management.internal;

import com.oracle.coherence.common.base.Logger;
import com.tangosol.coherence.management.internal.JaxRsRequest;
import com.tangosol.internal.http.HttpException;
import com.tangosol.internal.http.HttpRequest;
import com.tangosol.internal.management.ManagementRoutes;
import com.tangosol.net.management.MBeanServerProxy;
import com.tangosol.util.Filter;
import com.tangosol.util.ResourceRegistry;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.PathSegment;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.core.UriInfo;
import java.io.Serializable;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.glassfish.jersey.server.ContainerRequest;

public class BaseManagementResource {
    public static final String MEDIA_TYPE_JSON = "application/json";
    public static final String MEDIA_TYPES = "application/json";
    private final ManagementRoutes f_routes;
    @Context
    protected MBeanServerProxy m_mBeanServerProxy;
    @Context
    protected HttpHeaders m_requestHeaders;
    @Context
    protected UriInfo m_uriInfo;
    @Context
    protected ContainerRequestContext m_requestContext;
    private String m_sClusterName;

    public BaseManagementResource(ManagementRoutes routes) {
        this.f_routes = routes;
    }

    @GET
    public Response get(@Context ContainerRequest request) {
        return this.doGet(request);
    }

    @GET
    @Path(value="{any:.*}")
    public Response doGet(@Context ContainerRequest request) {
        return this.handle((ContainerRequestContext)request, this.f_routes);
    }

    @POST
    @Path(value="{any:.*}")
    public Response doPost(@Context ContainerRequest request) {
        return this.handle((ContainerRequestContext)request, this.f_routes);
    }

    @PUT
    @Path(value="{any:.*}")
    public Response doPut(@Context ContainerRequest request) {
        return this.handle((ContainerRequestContext)request, this.f_routes);
    }

    @DELETE
    @Path(value="{any:.*}")
    public Response doDelete(@Context ContainerRequest request) {
        return this.handle((ContainerRequestContext)request, this.f_routes);
    }

    protected Response handle(ContainerRequestContext containerRequest, ManagementRoutes router) {
        try {
            Filter<String> filterDomainPartition;
            JaxRsRequest request = this.createJaxRsRequest(containerRequest);
            ResourceRegistry registry = request.getResourceRegistry();
            String sClusterName = this.getClusterName();
            if (sClusterName != null) {
                registry.registerResource(String.class, "clusterName", (Object)sClusterName);
            }
            if ((filterDomainPartition = this.createDomainPartitionFilter(request)) != null) {
                registry.registerResource(Filter.class, "domainPartitionFilter", filterDomainPartition);
            }
            return BaseManagementResource.toJaxRsResponse(router.route((HttpRequest)request));
        }
        catch (HttpException e) {
            Response.ResponseBuilder builder = Response.status((int)e.getStatus());
            String sMsg = e.getMessage();
            if (sMsg != null) {
                builder.entity((Object)sMsg);
            }
            return builder.build();
        }
        catch (Throwable t) {
            Logger.err((Throwable)t);
            return Response.serverError().build();
        }
    }

    protected JaxRsRequest createJaxRsRequest(ContainerRequestContext containerRequest) {
        JaxRsRequest request = new JaxRsRequest(containerRequest);
        request.getResourceRegistry().registerResource(MBeanServerProxy.class, (Object)this.m_mBeanServerProxy);
        String sClusterName = this.getClusterName();
        if (sClusterName != null) {
            request.getResourceRegistry().registerResource(String.class, "clusterName", (Object)sClusterName);
        }
        return request;
    }

    private Filter<String> createDomainPartitionFilter(HttpRequest request) {
        String sDomainPartitionName = request.getQueryParameters().getFirst("domainPartition");
        return sDomainPartitionName == null ? null : (Filter & Serializable)s -> s.equals(sDomainPartitionName);
    }

    protected URI getCurrentUri() {
        return BaseManagementResource.getSubUri(this.m_uriInfo, new String[0]);
    }

    public static URI getSubUri(UriInfo uriInfo, String ... asSegments) {
        UriBuilder builder = uriInfo.getAbsolutePathBuilder();
        Arrays.stream(asSegments).forEach(xva$0 -> builder.segment(new String[]{xva$0}));
        return builder.build(new Object[0]);
    }

    public URI getParentUri() {
        return this.getParentUri(this.m_uriInfo);
    }

    public URI getParentUri(UriInfo uriInfo) {
        int count = this.getParentUriSegmentsCount(uriInfo);
        List pathSegments = uriInfo.getPathSegments();
        UriBuilder bldr = uriInfo.getBaseUriBuilder();
        for (int i = 0; i < count; ++i) {
            bldr.path(((PathSegment)pathSegments.get(i)).getPath());
        }
        return bldr.build(new Object[0]);
    }

    public int getParentUriSegmentsCount(UriInfo uriInfo) {
        int count;
        List pathSegments = uriInfo.getPathSegments();
        if (((PathSegment)pathSegments.get(count = pathSegments.size() - 1)).getPath().isEmpty()) {
            --count;
        }
        return count;
    }

    public String getClusterName() {
        return this.m_sClusterName;
    }

    public void setClusterName(String sClusterName) {
        this.m_sClusterName = sClusterName;
    }

    public static Response toJaxRsResponse(com.tangosol.internal.http.Response response) {
        Response.ResponseBuilder builder = Response.status((int)response.getStatus().getStatusCode());
        Object oEntity = response.getEntity();
        if (oEntity != null) {
            builder.entity(oEntity);
        }
        for (Map.Entry<String, List<String>> entry : response.getHeaders().entrySet()) {
            String sName = entry.getKey();
            for (String sValue : entry.getValue()) {
                builder.header(sName, (Object)sValue);
            }
        }
        return builder.build();
    }
}

