/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.management.internal;

import com.tangosol.coherence.management.internal.Message;
import com.tangosol.coherence.management.internal.ResourceLink;
import com.tangosol.util.Filter;
import com.tangosol.util.Filters;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.container.ContainerRequestContext;

public class MBeanResponse {
    public static final String LINK_REL_PARENT = "parent";
    public static final String LINK_REL_SELF = "self";
    public static final String LINK_REL_CANONICAL = "canonical";
    public static final String HEADER_SKIP_LINKS = "X-Skip-Resource-Links";
    public static final String PROP_LINKS = "links";
    public static final String PROP_MESSAGES = "messages";
    protected List<Message> m_listMessages = new ArrayList<Message>();
    protected boolean m_fIncludeResourceLinks = true;
    protected List<ResourceLink> m_listLinks = new ArrayList<ResourceLink>();
    protected Filter<String> m_filterLinks = null;

    public MBeanResponse() {
    }

    public MBeanResponse(ContainerRequestContext ctxRequest) {
        this(ctxRequest, (Filter<String>)((Filter)null));
    }

    public MBeanResponse(ContainerRequestContext requestContext, Filter<String> filterLinks) {
        boolean bl = this.m_fIncludeResourceLinks = Boolean.valueOf(requestContext.getHeaderString(HEADER_SKIP_LINKS)) == false;
        if (filterLinks == null) {
            filterLinks = Filters.always();
        }
        this.m_filterLinks = filterLinks;
    }

    public boolean hasFailures() {
        return this.m_listMessages.size() != 0 && this.m_listMessages.stream().filter(m -> m.f_sSeverity == Message.Severity.FAILURE).count() > 0L;
    }

    public void addFailure(String sMessage) {
        this.addMessage(Message.Severity.FAILURE, sMessage);
    }

    public void addFailure(String sField, String sMessage) {
        this.addMessage(Message.Severity.FAILURE, sField, sMessage);
    }

    public void addMessage(Message.Severity severity, String sField, String sMessage) {
        this.add(new Message(severity, sField, sMessage));
    }

    public void addMessage(Message.Severity severity, String sMessage) {
        this.add(new Message(severity, sMessage));
    }

    public void add(Message message) {
        this.m_listMessages.add(message);
    }

    public void addSelfResourceLinks(URI uri) {
        this.addResourceLink(LINK_REL_SELF, uri);
        this.addResourceLink(LINK_REL_CANONICAL, uri);
    }

    public void addParentResourceLink(URI uri) {
        this.addResourceLink(LINK_REL_PARENT, uri);
    }

    public void addResourceLink(String sRel, URI uri) {
        ResourceLink linkRes = new ResourceLink(sRel, uri);
        if (this.m_filterLinks.evaluate((Object)linkRes.getRelationship())) {
            this.m_listLinks.add(linkRes);
        }
    }

    public Map<String, Object> toJson() {
        LinkedHashMap<String, Object> mapResponse = new LinkedHashMap<String, Object>();
        this.populateJson(mapResponse);
        return mapResponse;
    }

    protected void populateJson(Map<String, Object> mapResponse) {
        List<Map<String, Object>> listLinks;
        List<Message> listMessages = this.m_listMessages;
        if (!listMessages.isEmpty()) {
            ArrayList<Map<String, Object>> listMessageStrings = new ArrayList<Map<String, Object>>();
            for (Message message : listMessages) {
                listMessageStrings.add(message.toJson());
            }
            mapResponse.put(PROP_MESSAGES, listMessageStrings);
        }
        if (this.m_fIncludeResourceLinks && (listLinks = this.getLinksJson()).size() > 0) {
            mapResponse.put(PROP_LINKS, listLinks);
        }
    }

    protected List<Map<String, Object>> getLinksJson() {
        ArrayList<Map<String, Object>> listLinks = new ArrayList<Map<String, Object>>();
        for (ResourceLink link : this.m_listLinks) {
            listLinks.add(link.toJson());
        }
        return listLinks;
    }
}

