/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.management.internal.resources;

import com.tangosol.coherence.management.internal.ClusterNameSupplier;
import com.tangosol.coherence.management.internal.EntityMBeanResponse;
import com.tangosol.coherence.management.internal.resources.AbstractManagementResource;
import com.tangosol.coherence.management.internal.resources.ClusterResource;
import com.tangosol.util.Filter;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

public class ClustersResource
extends AbstractManagementResource {
    private final ClusterNameSupplier f_supplierClusters;

    ClustersResource(AbstractManagementResource resource, ClusterNameSupplier supplierClusters) {
        super(resource);
        this.f_supplierClusters = supplierClusters;
        this.setDomainPartitionFilter(this.createDomainPartitionFilter());
    }

    @GET
    @Produces(value={"application/json"})
    public Response get() {
        return this.response(this.getClustersResponse());
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="search")
    public Response search(Map<String, Object> entity) {
        if (entity == null) {
            entity = Collections.emptyMap();
        }
        return this.response(this.getSearchResponse(entity));
    }

    @Path(value="{clusterName}")
    public Object getClusterResource(@PathParam(value="clusterName") String clusterName) {
        ClusterResource resource = new ClusterResource(this);
        resource.setClusterName(clusterName);
        return resource;
    }

    protected EntityMBeanResponse getClustersResponse() {
        Set<String> setCluster = this.getRunningCoherenceClusterNames();
        Filter<String> filter = this.getLinksFilter();
        EntityMBeanResponse response = new EntityMBeanResponse(this.getRequestContext(), filter);
        List<Map<String, Object>> list = setCluster.stream().map(this::getJson).collect(Collectors.toList());
        response.addParentResourceLink(this.getParentUri());
        response.addSelfResourceLinks(this.getCurrentUri());
        response.setEntities(list);
        return response;
    }

    private EntityMBeanResponse getSearchResponse(Map<String, Object> entity) {
        Filter<String> filter = this.getLinksFilter();
        EntityMBeanResponse response = new EntityMBeanResponse(this.getRequestContext(), filter);
        Set<String> setCluster = this.getRunningCoherenceClusterNames();
        ArrayList<Map<String, Object>> items = new ArrayList<Map<String, Object>>();
        for (String cluster : setCluster) {
            items.add(this.getSearchResponseObject(cluster, entity));
        }
        response.setEntities(items);
        return response;
    }

    private Set<String> getRunningCoherenceClusterNames() {
        return (Set)this.f_supplierClusters.get();
    }

    private Map<String, Object> getJson(String clusterName) {
        ClusterResource resource = new ClusterResource(this);
        resource.setClusterName(clusterName);
        return resource.getClusterResponseMap(this.getCurrentUri(), clusterName);
    }

    private Map<String, Object> getSearchResponseObject(String clusterName, Map<String, Object> entity) {
        ClusterResource resource = new ClusterResource(this);
        resource.setClusterName(clusterName);
        URI parentUri = this.getParentUri();
        return resource.getSearchResults(new LinkedHashMap<String, Object>(entity), parentUri, ClustersResource.getSubUri(parentUri, clusterName));
    }

    private Filter<String> createDomainPartitionFilter() {
        String sDomainPartitionName = (String)this.m_uriInfo.getQueryParameters().getFirst((Object)"domainPartition");
        return sDomainPartitionName == null ? null : (Filter & Serializable)s -> s.equals(sDomainPartitionName);
    }
}

