/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.management.internal.resources;

import com.tangosol.coherence.management.internal.EntityMBeanResponse;
import com.tangosol.coherence.management.internal.resources.AbstractManagementResource;
import com.tangosol.net.management.MBeanAccessor;
import java.net.URI;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

public class ServiceMemberResource
extends AbstractManagementResource {
    public static final String DISTRIBUTION_STATE = "distributionState";
    public static final String OWNERSHIP = "ownership";
    public static final String[] LINKS = new String[]{"proxy", "distributionState", "ownership"};

    public ServiceMemberResource(AbstractManagementResource resource) {
        super(resource);
    }

    @GET
    @Produces(value={"application/json"})
    public Response get(@PathParam(value="serviceName") String sServiceName, @PathParam(value="memberKey") String sMemberKey) {
        return this.response(this.getResponseEntityForMbean(this.getQuery(sServiceName, sMemberKey), LINKS));
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="proxy")
    public Response getProxy(@PathParam(value="serviceName") String sServiceName, @PathParam(value="memberKey") String sMemberKey) {
        MBeanAccessor.QueryBuilder bldrQuery = this.getConnectionManagerQuery(sServiceName, sMemberKey);
        return this.response(this.getResponseEntityForMbean(bldrQuery, "connections"));
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="proxy/connections")
    public Response getProxyConnections(@PathParam(value="serviceName") String sServiceName, @PathParam(value="memberKey") String sMemberKey) {
        MBeanAccessor.QueryBuilder bldrQuery = this.getConnectionsQuery(sServiceName, sMemberKey);
        return this.response(this.getResponseBodyForMBeanCollection(bldrQuery, null, this.getParentUri(), this.getCurrentUri()).toJson());
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="distributionState")
    public Response getDistributionState(@PathParam(value="serviceName") String sServiceName, @PathParam(value="memberKey") String sMemberKey, @QueryParam(value="verbose") Boolean verbose) {
        String[] asSignature = new String[]{Boolean.TYPE.getName()};
        Object[] aoArguments = new Object[]{verbose != null ? verbose : false};
        MBeanAccessor.QueryBuilder bldrQuery = this.getQuery(sServiceName, sMemberKey);
        return this.response(this.getResponseFromMBeanOperation(bldrQuery, DISTRIBUTION_STATE, "reportDistributionState", aoArguments, asSignature));
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="ownership")
    public Response getOwnership(@PathParam(value="serviceName") String sServiceName, @PathParam(value="memberKey") String sMemberKey, @QueryParam(value="verbose") Boolean fVerbose) {
        String[] asSignature = new String[]{Boolean.TYPE.getName()};
        Object[] aoArguments = new Object[]{fVerbose != null ? fVerbose : false};
        MBeanAccessor.QueryBuilder bldrQuery = this.getQuery(sServiceName, sMemberKey);
        return this.response(this.getResponseFromMBeanOperation(bldrQuery, OWNERSHIP, "reportOwnership", aoArguments, asSignature));
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="resetStatistics")
    public Response resetStatistics(@PathParam(value="serviceName") String sServiceName, @PathParam(value="memberKey") String sMemberKey) {
        return this.executeMBeanOperation(this.getQuery(sServiceName, sMemberKey), "resetStatistics", null, null);
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="{operationName:start|stop|shutdown}")
    public Response executeNoArgOperation(@PathParam(value="serviceName") String sServiceName, @PathParam(value="memberKey") String sMemberKey, @PathParam(value="operationName") String sOperationName) throws Exception {
        return this.executeMBeanOperation(this.getQuery(sServiceName, sMemberKey), sOperationName, null, null);
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response updateAttributes(@PathParam(value="serviceName") String sServiceName, @PathParam(value="memberKey") String sMemberKey, Map<String, Object> entity) {
        return this.update(entity, this.getQuery(sServiceName, sMemberKey));
    }

    @Override
    protected EntityMBeanResponse getQueryResult(Map mapQuery, Map<String, String> mapArguments, URI uriParent) {
        Object oChildren;
        String sMemberId = mapArguments.get("memberKey");
        String sServiceName = mapArguments.get("name");
        URI uriSelf = ServiceMemberResource.getSubUri(uriParent, sMemberId);
        EntityMBeanResponse response = this.getLinksOnlyResponseBody(uriParent, uriSelf, this.getLinksFilter(mapQuery), LINKS);
        Map<String, Object> mapResponse = response.getEntity();
        Object v0 = oChildren = mapQuery == null ? null : mapQuery.get("children");
        if (oChildren != null && oChildren instanceof Map) {
            MBeanAccessor.QueryBuilder bldrQuery = this.getConnectionManagerQuery(sServiceName, sMemberId);
            this.addChildMbeanQueryResult("proxy", bldrQuery, mapResponse, oChildren, "connections");
        }
        return response;
    }

    protected MBeanAccessor.QueryBuilder getQuery(String sServiceName, String sMemberKey) {
        return this.createQueryBuilder().withBaseQuery(":type=Service,name=" + sServiceName).withMember(sMemberKey);
    }

    protected MBeanAccessor.QueryBuilder getConnectionManagerQuery(String sServiceName, String sMemberKey) {
        return this.createQueryBuilder().withBaseQuery(":type=ConnectionManager,name=" + sServiceName).withMember(sMemberKey);
    }

    protected MBeanAccessor.QueryBuilder getConnectionsQuery(String sServiceName, String sMemberKey) {
        return this.createQueryBuilder().withBaseQuery(":type=Connection,name=" + sServiceName).withMember(sMemberKey);
    }
}

