/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.management.internal.resources;

import com.tangosol.coherence.management.internal.Converter;
import com.tangosol.coherence.management.internal.EntityMBeanResponse;
import com.tangosol.coherence.management.internal.resources.AbstractManagementResource;
import com.tangosol.coherence.management.internal.resources.CacheMembersResource;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.management.MBeanAccessor;
import com.tangosol.util.Filter;
import com.tangosol.util.filter.AlwaysFilter;
import java.net.URI;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;

public class CacheResource
extends AbstractManagementResource {
    public CacheResource(AbstractManagementResource resource) {
        super(resource);
    }

    @GET
    @Produces(value={"application/json"})
    public Response get(@PathParam(value="cacheName") String sCacheName, @QueryParam(value="role") String sRoleName, @QueryParam(value="collector") String sCollector) {
        Set setObjectNames = this.getMBeanAccessor().queryKeys(this.getQuery(sCacheName).build());
        if (setObjectNames == null || setObjectNames.isEmpty()) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        EntityMBeanResponse responseEntity = this.createResponse(this.getParentUri(), this.getCurrentUri(), this.getLinksFilter());
        this.addObjectNamesToResponse(setObjectNames, responseEntity);
        Map<String, Object> mapResponse = responseEntity.toJson();
        MBeanAccessor.QueryBuilder bldrQuery = this.createQueryBuilder().withBaseQuery(String.format(":type=StorageManager,cache=%s", sCacheName)).withService(this.getService());
        this.addAggregatedMetricsToResponseMap(sRoleName, sCollector, this.getQuery(sCacheName), mapResponse);
        this.addAggregatedMetricsToResponseMap(sRoleName, sCollector, bldrQuery, mapResponse);
        return this.response(mapResponse);
    }

    @Path(value="members")
    public Object getMembersResource() {
        return new CacheMembersResource(this);
    }

    @Override
    protected EntityMBeanResponse getQueryResult(Map mapQuery, Map<String, String> mapArguments, URI uriParent) {
        Object oChildren;
        String sCacheName = mapArguments.get("name");
        URI uriSelf = CacheResource.getSubUri(uriParent, sCacheName);
        Filter<String> filterLinks = this.getLinksFilter(mapQuery);
        MBeanAccessor.QueryBuilder bldrQuery = this.getQuery(sCacheName);
        Set setObjectNames = this.getMBeanAccessor().queryKeys(bldrQuery.build());
        if (setObjectNames == null || setObjectNames.isEmpty()) {
            return null;
        }
        EntityMBeanResponse responseEntity = this.createResponse(uriParent, uriSelf, filterLinks);
        this.addObjectNamesToResponse(setObjectNames, responseEntity);
        Map<String, Object> mapEntity = responseEntity.getEntity();
        MBeanAccessor.QueryBuilder bldrQueryStorage = this.createQueryBuilder().withBaseQuery(String.format(":type=StorageManager,cache=%s", sCacheName)).withService(this.getService());
        this.addAggregatedMetricsToResponseMap("*", null, bldrQuery, mapEntity);
        this.addAggregatedMetricsToResponseMap("*", null, bldrQueryStorage, mapEntity);
        Object v0 = oChildren = mapQuery == null ? null : mapQuery.get("children");
        if (oChildren != null && oChildren instanceof Map) {
            Map mapChildrenQuery = oChildren;
            this.addChildResourceQueryResult(new CacheMembersResource(this), "members", mapEntity, mapChildrenQuery, mapArguments, uriSelf);
        }
        return responseEntity;
    }

    protected MBeanAccessor.QueryBuilder getQuery(String sCacheName) {
        return this.createQueryBuilder().withBaseQuery(":type=Cache,name=" + sCacheName).withService(this.getService());
    }

    protected void addObjectNamesToResponse(Set<String> setObjectNames, EntityMBeanResponse responseEntity) {
        Filter<String> filterAttributes = this.getAttributesFilter();
        LinkedHashMap<String, Object> mapAttributes = new LinkedHashMap<String, Object>();
        if (filterAttributes instanceof AlwaysFilter) {
            filterAttributes = this.getAttributesFilter(String.join((CharSequence)",", "name", "service", "nodeId"), null);
        }
        for (String sName : setObjectNames) {
            try {
                ObjectName objectName = new ObjectName(sName);
                for (String sKey : objectName.getKeyPropertyList().keySet()) {
                    if (!filterAttributes.evaluate((Object)sKey)) continue;
                    Object oValue = Converter.convert(objectName.getKeyProperty(sKey));
                    Object oCurrent = mapAttributes.get(sKey);
                    if (oCurrent == null) {
                        mapAttributes.put(sKey, oValue);
                        continue;
                    }
                    if (oCurrent instanceof Set) {
                        ((Set)oCurrent).add(oValue);
                        continue;
                    }
                    if (Objects.equals(oCurrent, oValue)) continue;
                    HashSet<Object> values = new HashSet<Object>();
                    values.add(oCurrent);
                    values.add(oValue);
                    mapAttributes.put(sKey, values);
                }
            }
            catch (MalformedObjectNameException e) {
                CacheFactory.log((String)("Exception occurred while creating an ObjectName " + sName + "\n" + CacheFactory.getStackTrace((Throwable)e)));
            }
        }
        responseEntity.setEntity(mapAttributes);
        responseEntity.addResourceLink("members", CacheResource.getSubUri(this.getCurrentUri(), "members"));
    }
}

