/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.management.internal;

import com.oracle.coherence.common.base.Logger;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.IntSummaryStatistics;
import java.util.LinkedHashMap;
import java.util.LongSummaryStatistics;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularDataSupport;

public class Converter {
    public static final String ISO_8601_DATE_TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSXXX";
    public static final String TRANSFORM = "transform";
    protected static HashMap<String, Function<Object, Object>> s_mapConverters = new HashMap();

    public static Object convert(Object oObject) {
        if (Objects.isNull(oObject)) {
            return null;
        }
        Class<?> clzObject = oObject.getClass();
        if (clzObject.isArray()) {
            return Converter.convertArray(oObject);
        }
        if (oObject instanceof CompositeData) {
            return Converter.transformCompositeData((CompositeData)oObject);
        }
        if (oObject instanceof TabularDataSupport) {
            return Converter.transformTabularData((TabularDataSupport)oObject);
        }
        if (oObject instanceof Map) {
            return Converter.convertMap(oObject);
        }
        Function<Object, Object> converter = s_mapConverters.get(clzObject.getSimpleName());
        if (converter != null) {
            return converter.apply(oObject);
        }
        return oObject;
    }

    protected static Object convertMap(Object oMap) {
        Map map = (Map)oMap;
        LinkedHashMap json = new LinkedHashMap();
        for (Object key : map.keySet()) {
            json.put(key.toString(), map.get(key));
        }
        return json;
    }

    protected static Object convertArray(Object oArray) {
        ArrayList<Object> listObject = new ArrayList<Object>();
        for (int i = 0; i < Array.getLength(oArray); ++i) {
            listObject.add(Converter.convert(Array.get(oArray, i)));
        }
        return listObject;
    }

    protected static Object transformCompositeData(CompositeData dataComposite) {
        LinkedHashMap<String, Object> json = new LinkedHashMap<String, Object>();
        for (String key : dataComposite.getCompositeType().keySet()) {
            json.put(key, Converter.convert(dataComposite.get(key)));
        }
        return json;
    }

    public static Object transformTabularData(TabularDataSupport dataTabular) {
        CompositeType rowType = dataTabular.getTabularType().getRowType();
        if (rowType.containsKey("key") && rowType.containsKey("value") && rowType.getType("key") instanceof SimpleType) {
            LinkedHashMap<String, Object> json = new LinkedHashMap<String, Object>();
            for (Object objValue : dataTabular.values()) {
                String sKey = ((CompositeData)objValue).get("key").toString();
                Object oValue = Converter.convert(((CompositeData)objValue).get("value"));
                json.put(sKey, oValue);
            }
            return json;
        }
        return dataTabular;
    }

    protected static Object transformDate(Date date) {
        return new SimpleDateFormat(ISO_8601_DATE_TIME_FORMAT).format(date);
    }

    protected static Object transformIntSummaryStatistics(IntSummaryStatistics stats) {
        LinkedHashMap<String, Number> map = new LinkedHashMap<String, Number>();
        map.put("count", stats.getCount());
        map.put("average", stats.getAverage());
        map.put("min", stats.getMin());
        map.put("max", stats.getMax());
        map.put("sum", stats.getSum());
        return map;
    }

    protected static Object transformLongSummaryStatistics(LongSummaryStatistics stats) {
        LinkedHashMap<String, Number> map = new LinkedHashMap<String, Number>();
        map.put("count", stats.getCount());
        map.put("average", stats.getAverage());
        map.put("min", stats.getMin());
        map.put("max", stats.getMax());
        map.put("sum", stats.getSum());
        return map;
    }

    protected static Object getConverterFunction(Object oObject, Method method) {
        try {
            return method.invoke(null, oObject);
        }
        catch (Exception e) {
            Logger.err((String)("Exception occurred while converting object of class type " + oObject.getClass().getName() + '\n'), (Throwable)e);
            return oObject;
        }
    }

    static {
        for (Method method : Converter.class.getDeclaredMethods()) {
            String methodName = method.getName();
            if (!methodName.startsWith(TRANSFORM)) continue;
            s_mapConverters.put(method.getName().substring(TRANSFORM.length()), o -> Converter.getConverterFunction(o, method));
        }
    }
}

